/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESWrapperException;
import com.caucho.es.parser.BinaryExpr;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.LiteralExpr;
import java.io.IOException;

class BooleanBinaryExpr
extends BinaryExpr {
    static Expr create(Block block, Expr expr, Expr expr2, int n) throws ESException {
        boolean bl;
        if (!(expr instanceof LiteralExpr) || !(expr2 instanceof LiteralExpr)) {
            return new BooleanBinaryExpr(block, expr, expr2, n);
        }
        ESBase eSBase = ((LiteralExpr)expr).getLiteral();
        ESBase eSBase2 = ((LiteralExpr)expr2).getLiteral();
        try {
            switch (n) {
                case 60: {
                    bl = eSBase.lessThan(eSBase2, false);
                    break;
                }
                case 62: {
                    bl = eSBase2.lessThan(eSBase, false);
                    break;
                }
                case 272: {
                    bl = eSBase2.lessThan(eSBase, true);
                    break;
                }
                case 271: {
                    bl = eSBase.lessThan(eSBase2, true);
                    break;
                }
                case 273: {
                    bl = eSBase.ecmaEquals(eSBase2);
                    break;
                }
                case 274: {
                    bl = !eSBase.ecmaEquals(eSBase2);
                    break;
                }
                case 275: {
                    bl = eSBase.equals(eSBase2);
                    break;
                }
                case 276: {
                    bl = !eSBase.equals(eSBase2);
                    break;
                }
                default: {
                    throw new RuntimeException("foo");
                }
            }
        }
        catch (Exception exception) {
            throw new ESWrapperException(exception);
        }
        return new LiteralExpr(block, ESBoolean.create(bl));
    }

    int getType() {
        return 5;
    }

    void printBooleanImpl() throws IOException {
        switch (this.op) {
            case 60: {
                if (this.left.isNumeric() || this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("<");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".lessThan(");
                this.right.print();
                this.cl.print(", false)");
                break;
            }
            case 62: {
                if (this.left.isNumeric() || this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print(">");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".greaterThan(");
                this.right.print();
                this.cl.print(", false)");
                break;
            }
            case 272: {
                if (this.left.isNumeric() || this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("<=");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".greaterThan(");
                this.right.print();
                this.cl.print(", true)");
                break;
            }
            case 271: {
                if (this.left.isNumeric() || this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print(">=");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".lessThan(");
                this.right.print();
                this.cl.print(", true)");
                break;
            }
            case 273: {
                if (this.left.isNumeric() && this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("==");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".ecmaEquals(");
                this.right.print();
                this.cl.print(")");
                break;
            }
            case 274: {
                if (this.left.isNumeric() && this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("!=");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.cl.print("!");
                this.left.print();
                this.cl.print(".ecmaEquals(");
                this.right.print();
                this.cl.print(")");
                break;
            }
            case 275: {
                if (this.left.isNumeric() && this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("==");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.left.print();
                this.cl.print(".equals(");
                this.right.print();
                this.cl.print(")");
                break;
            }
            case 276: {
                if (this.left.isNumeric() && this.right.isNumeric()) {
                    this.cl.print("(");
                    this.left.printNum();
                    this.cl.print("!=");
                    this.right.printNum();
                    this.cl.print(")");
                    break;
                }
                this.cl.print("!");
                this.left.print();
                this.cl.print(".equals(");
                this.right.print();
                this.cl.print(")");
                break;
            }
            default: {
                throw new IOException("foo");
            }
        }
    }

    private BooleanBinaryExpr(Block block, Expr expr, Expr expr2, int n) {
        super(block, expr, expr2, n);
    }
}

