/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.IdExpr;
import com.caucho.es.parser.LiteralExpr;
import com.caucho.es.parser.Parser;
import com.caucho.es.parser.RegexpExpr;
import com.caucho.es.parser.SpecialExpr;
import com.caucho.es.parser.Variable;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import java.util.ArrayList;

class Block {
    private static FreeList freeList = new FreeList(16);
    Function function;
    private Block parent;
    private Expr lastExpr;
    boolean isDead;
    private boolean hasStatementValue;
    private Parser parser;
    private boolean isLoop;
    private boolean canExit;
    private boolean hasDefault;
    private int withDepth;
    private ESId id;
    private Expr mark;
    private Object switchTop;
    private Object top;
    private int topMark;

    Block create() throws ESException {
        this.evalExpr();
        Block block = Block.allocate();
        block.function = this.function;
        block.parent = this;
        block.lastExpr = null;
        block.isDead = false;
        block.hasStatementValue = this.hasStatementValue;
        block.parser = this.parser;
        block.isLoop = false;
        block.canExit = false;
        block.withDepth = this.withDepth;
        block.id = null;
        block.setTop();
        return block;
    }

    static Block create(Parser parser, Function function) {
        Block block = Block.allocate();
        block.function = function;
        block.parent = null;
        block.lastExpr = null;
        block.isDead = false;
        block.hasStatementValue = function.needsStatementResults();
        block.parser = parser;
        block.isLoop = false;
        block.canExit = false;
        block.withDepth = 0;
        block.id = null;
        block.top = null;
        block.topMark = 0;
        function.setVars();
        return block;
    }

    void setTop() {
        this.top = this.function.getTop();
        if (this.top instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)this.top;
            this.topMark = charBuffer.length();
        } else {
            this.topMark = 0;
        }
    }

    Block pop() {
        Block block = this.parent;
        this.function.setVars();
        freeList.free(this);
        return block;
    }

    boolean isGlobal() {
        return this.function.isGlobal();
    }

    int getDepth() {
        return this.withDepth;
    }

    boolean allowSpecial() {
        return this.parent == null;
    }

    String getFilename() {
        String string = this.parser.lexer.getLastFilename();
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(92)) > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    int getLine() {
        int n = this.parser.lexer.getLastLine();
        return n;
    }

    void setLine(int n) {
    }

    IdExpr newVar(ESId eSId) {
        if (this.withDepth > 0) {
            return new IdExpr(this, new Variable(this, eSId, false));
        }
        IdExpr idExpr = this.function.newVar(this, eSId);
        if (this.parent != null) {
            idExpr.getType();
        }
        return idExpr;
    }

    void defVar(ESId eSId) {
        this.function.addVariable(this, eSId);
    }

    Expr newLiteral(ESBase eSBase) throws ESException {
        return new LiteralExpr(this, eSBase);
    }

    Expr newRegexp(ESBase eSBase, String string) throws ESException {
        return new RegexpExpr(this, eSBase, string);
    }

    Expr newThis() {
        return new SpecialExpr(this, 116);
    }

    Expr newArray(Expr expr) {
        return new SpecialExpr(this, 97, expr);
    }

    Expr hasNext(String string) {
        return new SpecialExpr(this, 109, string);
    }

    void addExpr(Expr expr) throws ESException {
        if (this.isDead) {
            throw this.error("Statement is unreachable.");
        }
        if (this.lastExpr != null) {
            this.lastExpr.exprStatement(this.function);
        }
        if (this.hasStatementValue) {
            this.lastExpr = expr;
        } else {
            expr.exprStatement(this.function);
        }
    }

    Block startBlock() throws ESException {
        this.evalExpr();
        this.function.println("{");
        return this.create();
    }

    Block startBlock(ESId eSId) throws ESException {
        if (this.findBlock(eSId) != null) {
            throw this.error("duplicate label `" + eSId + "'");
        }
        this.evalExpr();
        Block block = this.create();
        block.id = eSId;
        this.function.println(eSId + ": {");
        block.setTop();
        return block;
    }

    Block finishBlock() throws ESException {
        this.evalExpr();
        this.function.println("}");
        this.id = null;
        Block block = this.pop();
        if (this.isDead && !this.canExit) {
            block.isDead = true;
        }
        return block;
    }

    void endBlock() throws ESException {
        this.evalExpr();
        this.function.println("}");
        this.id = null;
    }

    void startIf(Expr expr, boolean bl) throws ESException {
        this.evalExpr();
        if (bl) {
            this.function.print(" else ");
        }
        this.function.print("if (");
        this.function.addBoolean(expr);
        this.function.println(") {");
        this.setTop();
    }

    void startElse() throws ESException {
        this.evalExpr();
        this.function.println(" else {");
        this.setTop();
    }

    Block startWhile(ESId eSId, Expr expr) throws ESException {
        this.evalExpr();
        if (eSId != null) {
            this.function.println(eSId + ":");
        }
        this.function.print("while (");
        this.function.addBoolean(expr);
        this.function.println(") {");
        Block block = this.create();
        this.startLoop(eSId);
        if (!(expr instanceof LiteralExpr) || !((LiteralExpr)expr).getLiteral().toBoolean()) {
            this.canExit = true;
        }
        return block;
    }

    Block startFor(ESId eSId, Expr expr, Expr expr2) throws ESException {
        this.evalExpr();
        if (eSId != null) {
            this.function.println(eSId + ":");
        }
        this.function.print("for (;");
        if (expr != null) {
            this.function.addBoolean(expr);
        }
        this.function.print(";");
        if (expr2 != null) {
            this.function.addExpr(expr2);
        }
        this.function.println(") {");
        Block block = this.create();
        this.startLoop(eSId);
        if (expr == null) {
            this.canExit = false;
        } else if (!(expr instanceof LiteralExpr) || !((LiteralExpr)expr).getLiteral().toBoolean()) {
            this.canExit = true;
        }
        return block;
    }

    Block startDo(ESId eSId) throws ESException {
        this.evalExpr();
        if (eSId != null) {
            this.function.println(eSId + ":");
        }
        this.function.print("do {");
        Block block = this.create();
        this.startLoop(eSId);
        return block;
    }

    Block endDo(Expr expr) throws ESException {
        this.evalExpr();
        Block block = this.endLoop();
        if (!(expr instanceof LiteralExpr) || !((LiteralExpr)expr).getLiteral().toBoolean()) {
            block.canExit = true;
        }
        if (block.canExit) {
            block.isDead = false;
        }
        this.function.print("while (");
        this.function.addBoolean(expr);
        this.function.println(");");
        return block;
    }

    void startLoop(ESId eSId) {
        String string = this.function.getStatementVar();
        this.function.pushStatementLoop();
        String string2 = this.function.getStatementVar();
        if (string != null) {
            this.function.println(string2 + " = " + string + ";");
        }
        this.id = eSId;
        this.isLoop = true;
        this.canExit = false;
    }

    Block endLoop() throws ESException {
        this.evalExpr();
        String string = this.function.getStatementVar();
        this.function.popStatementLoop();
        String string2 = this.function.getStatementVar();
        if (string2 != null && !this.isDead) {
            this.function.println(string2 + " = " + string + ";");
        }
        this.function.println("}");
        Block block = this.pop();
        if (!block.canExit) {
            block.isDead = true;
        }
        return block;
    }

    Block startSwitch(Expr expr) throws ESException {
        ESId eSId = ESId.intern("_switchtemp");
        this.function.print("_switchtemp = ");
        this.function.addExpr(expr);
        this.function.println(";");
        Block block = this.create();
        block.switchTop = this.function.getSwitch();
        block.isLoop = true;
        block.hasDefault = false;
        this.function.println("switch (_switchcode) {");
        return block;
    }

    void doCase(int n) throws ESException {
        this.isDead = false;
        this.evalExpr();
        this.function.println("case " + n + ":");
    }

    void doDefault() throws ESException {
        this.isDead = false;
        this.hasDefault = true;
        this.evalExpr();
        this.function.println("default:");
    }

    Block fillSwitch(ArrayList arrayList) throws ESException {
        this.evalExpr();
        if (!this.hasDefault && !this.isDead) {
            this.function.println("default:");
            this.function.println("  break;");
        } else if (!this.isDead) {
            this.function.println("break;");
        }
        this.function.println("}");
        int n = this.function.mark();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            if (n2 != 0) {
                this.function.print("else ");
            }
            Expr expr = (Expr)arrayList.get(n2);
            this.function.print("if (_switchtemp.equals(");
            this.function.addExpr(expr);
            this.function.println(")) _switchcode = " + n2 + ";");
            ++n2;
        }
        if (arrayList.size() > 0) {
            this.function.print("else ");
        }
        this.function.println("_switchcode = -1;");
        this.function.moveChunk(this.switchTop, n);
        Block block = this.pop();
        if (this.isDead && !this.canExit && this.hasDefault) {
            block.isDead = true;
        }
        return block;
    }

    void doBreak(ESId eSId) throws ESException {
        Block block = this;
        while (block != null) {
            if (block.id == eSId) {
                block.canExit = true;
                break;
            }
            block = block.parent;
        }
        if (block == null) {
            throw this.error("break needs enclosing loop");
        }
        this.function.setVars();
        this.evalExpr();
        this.function.println("break " + eSId + ";");
        this.isDead = true;
    }

    void doBreak() throws ESException {
        Block block = this;
        while (block != null) {
            if (block.isLoop) {
                block.canExit = true;
                break;
            }
            block = block.parent;
        }
        if (block == null) {
            throw this.error("break needs enclosing loop");
        }
        this.function.setVars();
        this.evalExpr();
        this.function.println("break;");
        this.isDead = true;
    }

    void doContinue(ESId eSId) throws ESException {
        Block block = this;
        while (block != null) {
            if (block.id == eSId && block.isLoop) break;
            block = block.parent;
        }
        if (block == null) {
            throw this.error("continue needs enclosing loop");
        }
        this.function.setVars();
        this.evalExpr();
        this.function.println("continue " + eSId + ";");
        this.isDead = true;
    }

    void doContinue() throws ESException {
        if (this.findBlock(null) == null) {
            throw this.error("continue needs enclosing loop");
        }
        this.function.setVars();
        this.evalExpr();
        this.function.println("continue;");
        this.isDead = true;
    }

    private Block findBlock(ESId eSId) {
        Block block = this;
        while (block != null) {
            if (eSId != null && block.id == eSId) {
                return block;
            }
            if (eSId == null && block.isLoop) {
                return block;
            }
            block = block.parent;
        }
        return null;
    }

    Block startWith(Expr expr) throws ESException {
        this.function.setArguments();
        this.function.setUseAllVariables();
        this.evalExpr();
        ++this.withDepth;
        this.function.println("try {");
        this.function.print("_env.pushScope(");
        this.function.addExpr(expr);
        this.function.println(");");
        this.setTop();
        return this;
    }

    Block endWith() throws ESException {
        this.evalExpr();
        --this.withDepth;
        this.function.println("} finally {");
        this.function.println("_env.popScope();");
        this.function.println("}");
        return this;
    }

    Block startTry() throws ESException {
        this.function.setVars();
        this.evalExpr();
        this.function.println("try {");
        return this;
    }

    Block endTry() throws ESException {
        this.function.setVars();
        this.evalExpr();
        this.function.println("}");
        return this;
    }

    void doTry() throws ESException {
        this.evalExpr();
        int n = 0;
        while (n < this.function.data.size()) {
            Object e = this.function.data.get(n);
            if (e == this.top) {
                if (e instanceof CharBuffer) {
                    CharBuffer charBuffer = (CharBuffer)e;
                    charBuffer.insert(this.topMark, " try {");
                    break;
                }
                this.function.data.add(n + 1, new CharBuffer(" try {"));
                break;
            }
            ++n;
        }
        if (n >= this.function.data.size()) {
            if (this.function.tail != null && this.top == this.function.tail) {
                this.function.tail.insert(this.topMark, " try {");
            } else {
                this.function.data.add(0, new CharBuffer(" try {"));
            }
        }
        this.function.println("}");
    }

    Block startCatch(String string, Expr expr) throws ESException {
        this.evalExpr();
        String string2 = "_e" + this.function.getTemp();
        this.function.println("catch (" + string + " " + string2 + ") {");
        if (expr != null) {
            SpecialExpr specialExpr = new SpecialExpr(this, 101, string2);
            expr.assign(specialExpr).exprStatement(this.function);
        }
        this.isDead = false;
        this.setTop();
        return this;
    }

    Block endCatch() throws ESException {
        this.evalExpr();
        this.function.println("}");
        return this;
    }

    Block startFinally() throws ESException {
        this.evalExpr();
        Block block = this.create();
        this.function.println("finally {");
        this.function.pushStatementLoop();
        block.setTop();
        return block;
    }

    Block endFinally() throws ESException {
        this.evalExpr();
        this.function.println("}");
        this.function.popStatementLoop();
        return this.pop();
    }

    Block startSynchronized(Expr expr) throws ESException {
        this.evalExpr();
        this.function.print("synchronized (");
        this.function.addExpr(expr);
        this.function.println(".toJavaObject()) {");
        return this.create();
    }

    Block endSynchronized() throws ESException {
        this.evalExpr();
        this.function.println("}");
        Block block = this.pop();
        block.isDead = this.isDead;
        return block;
    }

    void doThrow(Expr expr) throws ESException {
        this.function.print("throw (Exception)");
        this.function.addExpr(expr);
        this.function.println(".toJavaObject();");
        this.isDead = true;
    }

    void doReturn(Expr expr) throws ESException {
        this.evalExpr();
        this.function.print("return ");
        this.function.addExpr(expr);
        this.function.println(";");
        this.isDead = true;
    }

    void doReturn() throws ESException {
        this.evalExpr();
        this.function.print("return ESBase.esUndefined;");
        this.isDead = true;
    }

    void finish() throws ESException {
        if (this.isDead) {
            return;
        }
        if (this.lastExpr != null) {
            this.function.print("  return ");
            this.function.addExpr(this.lastExpr);
            this.function.println(";");
            this.lastExpr = null;
        } else if (this.hasStatementValue) {
            this.function.println("  return _val0;");
        } else {
            this.function.println("  return ESBase.esUndefined;");
        }
    }

    String newIterator(ESId eSId, Expr expr) throws ESException {
        this.evalExpr();
        String string = "iter" + this.function.getIter();
        this.function.print("  " + string + " = ");
        this.function.addExpr(expr);
        this.function.println(".keys();");
        return string;
    }

    void evalExpr() throws ESException {
        if (this.lastExpr == null) {
            return;
        }
        this.function.print(this.function.getStatementVar() + " = ");
        this.function.addExpr(this.lastExpr);
        this.function.println(";");
        this.lastExpr = null;
    }

    private static Block allocate() {
        Block block = (Block)freeList.allocate();
        if (block == null) {
            block = new Block();
        }
        return block;
    }

    ESException error(String string) {
        return this.parser.lexer.error(string);
    }

    void free() {
        freeList.free(this);
    }

    private Block() {
    }
}

