/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESException;
import com.caucho.es.ESString;
import com.caucho.util.CharBuffer;

class Printf {
    private static final int ALT = 1;
    private static final int ZERO_FILL = 2;
    private static final int POS_PLUS = 4;
    private static final int POS_SPACE = 8;
    private static final int LALIGN = 16;
    private static final int BIG = 32;
    private static final int NO_TRAIL_ZERO = 64;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static char[] bigDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String sprintf(Call call, int n) throws Exception {
        if (n == 0) {
            return "";
        }
        CharBuffer charBuffer = new CharBuffer();
        Printf.printf(charBuffer, call.getArg(0).toStr(), call, n);
        return charBuffer.toString();
    }

    public static CharBuffer printf(CharBuffer charBuffer, ESString eSString, Call call, int n) throws Exception {
        int n2 = 1;
        int n3 = eSString.length();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4;
            char c = eSString.charAt(n4);
            if (c != '%') {
                charBuffer.append(c);
            } else {
                int n6 = 0;
                block19: while (++n4 < n3) {
                    c = eSString.charAt(n4);
                    switch (c) {
                        case '0': {
                            n6 |= 2;
                            break;
                        }
                        case '+': {
                            n6 |= 4;
                            break;
                        }
                        case ' ': {
                            n6 |= 8;
                            break;
                        }
                        case '#': {
                            n6 |= 1;
                            break;
                        }
                        case '-': {
                            n6 |= 0x10;
                            break;
                        }
                        default: {
                            break block19;
                        }
                    }
                }
                int n7 = 0;
                while (n4 < n3 && (c = eSString.charAt(n4)) >= '0' && c <= '9') {
                    n7 = 10 * n7 + c - 48;
                    ++n4;
                }
                if (n4 >= n3) {
                    Printf.fixBits(charBuffer, eSString, n5, n4);
                    break;
                }
                int n8 = 0;
                if (c == '.') {
                    while (++n4 < n3 && (c = eSString.charAt(n4)) >= '0' && c <= '9') {
                        n8 = 10 * n8 + c - 48;
                    }
                } else {
                    n8 = -1;
                }
                if (n4 >= n3) {
                    Printf.fixBits(charBuffer, eSString, n5, n4);
                    break;
                }
                switch (c) {
                    case '%': {
                        charBuffer.append('%');
                        break;
                    }
                    case 'd': {
                        if (n2 >= n) {
                            throw new ESException("missing printf argument");
                        }
                        Printf.formatInteger(charBuffer, call.getArg(n2++).toNum(), n7, n8, n6, 10);
                        break;
                    }
                    case 'o': {
                        if (n2 >= n) {
                            throw new ESException("missing printf argument");
                        }
                        Printf.formatInteger(charBuffer, call.getArg(n2++).toNum(), n7, n8, n6, 8);
                        break;
                    }
                    case 'X': {
                        n6 |= 0x20;
                    }
                    case 'x': {
                        if (n2 >= n) {
                            throw new ESException("missing printf argument");
                        }
                        Printf.formatInteger(charBuffer, call.getArg(n2++).toNum(), n7, n8, n6, 16);
                        break;
                    }
                    case 'E': 
                    case 'G': {
                        n6 |= 0x20;
                    }
                    case 'e': 
                    case 'f': 
                    case 'g': {
                        if (n2 >= n) {
                            throw new ESException("missing printf argument");
                        }
                        Printf.formatDouble(charBuffer, call.getArg(n2++).toNum(), n7, n8, n6, c);
                        break;
                    }
                    case 'c': {
                        if (n2 >= n) {
                            throw new ESException("missing printf argument");
                        }
                        Printf.formatChar(charBuffer, (int)call.getArg(n2++).toNum(), n7, n6);
                        break;
                    }
                    case 's': {
                        if (n2 >= n) {
                            throw new ESException("missing printf argument");
                        }
                        Printf.formatString(charBuffer, call.getArg(n2++).toStr(), n8, n7, n6);
                        break;
                    }
                    default: {
                        Printf.fixBits(charBuffer, eSString, n5, n4 + 1);
                        break;
                    }
                }
            }
            ++n4;
        }
        return charBuffer;
    }

    private static void formatDouble(CharBuffer charBuffer, double d, int n, int n2, int n3) {
        String string = Double.toString(d);
        int n4 = 0;
        int n5 = 0;
        CharBuffer charBuffer2 = new CharBuffer();
        char c = string.charAt(n5);
        boolean bl = false;
        while (n5 < string.length()) {
            c = string.charAt(n5);
            if (c == '.' || c == 'e' || c == 'E') break;
            if (bl || c != '0') {
                bl = true;
                charBuffer2.append(c);
                ++n4;
            }
            ++n5;
        }
        if (c == '.') {
            ++n5;
        }
        while (n5 < string.length()) {
            c = string.charAt(n5);
            if (!bl && c == '0') {
                --n4;
            } else if (c >= '0' && c <= '9') {
                charBuffer2.append(c);
                bl = true;
            } else {
                int n6 = 1;
                if ((c = string.charAt(++n5)) == '+') {
                    ++n5;
                } else if (c == '-') {
                    ++n5;
                    n6 = -1;
                }
                int n7 = 0;
                while (n5 < string.length() && (c = string.charAt(n5)) >= '0' && c <= '9') {
                    n7 = 10 * n7 + c - 48;
                    ++n5;
                }
                n4 += n6 * n7;
                break;
            }
            ++n5;
        }
        if (!bl) {
            n4 = 1;
        }
        while (charBuffer2.length() > 0 && charBuffer2.charAt(charBuffer2.length() - 1) == '0') {
            charBuffer2.setLength(charBuffer2.length() - 1);
        }
        if (n3 == 102) {
            if (Printf.roundDigits(charBuffer2, n4 + n)) {
                ++n4;
            }
            Printf.formatFixed(charBuffer, charBuffer2, n4, n, n2);
        } else if (n3 == 101 || n3 == 69) {
            if (Printf.roundDigits(charBuffer2, n + 1)) {
                ++n4;
            }
            Printf.formatExpt(charBuffer, charBuffer2, n4, n, n2);
        } else {
            if (Printf.roundDigits(charBuffer2, n)) {
                ++n4;
            }
            if (n4 < -3 || n4 > n) {
                Printf.formatExpt(charBuffer, charBuffer2, n4, n - 1, n2 | 0x40);
            } else {
                Printf.formatFixed(charBuffer, charBuffer2, n4, n - n4, n2 | 0x40);
            }
        }
    }

    private static void formatDouble(CharBuffer charBuffer, double d, int n, int n2, int n3, int n4) {
        if (n2 < 0) {
            n2 = 6;
        }
        int n5 = charBuffer.length();
        if ((n3 & 2) != 0 && (d < 0.0 || (n3 & 0xC) != 0)) {
            ++n5;
            --n;
        }
        if (d < 0.0) {
            charBuffer.append('-');
            d = -d;
        } else if ((n3 & 4) != 0) {
            charBuffer.append('+');
        } else if ((n3 & 8) != 0) {
            charBuffer.append(' ');
        }
        Printf.formatDouble(charBuffer, d, n2, n3, n4);
        n -= charBuffer.length() - n5;
        int n6 = 0;
        while (n6 < n) {
            if ((n3 & 0x10) != 0) {
                charBuffer.append(' ');
            } else {
                charBuffer.insert(n5, (n3 & 2) == 0 ? (char)' ' : '0');
            }
            ++n6;
        }
    }

    private static boolean roundDigits(CharBuffer charBuffer, int n) {
        if (n < 0 || charBuffer.length() <= n) {
            return false;
        }
        char c = charBuffer.charAt(n);
        if (c < '5') {
            return false;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            char c2 = charBuffer.charAt(n2);
            if (c2 != '9') {
                charBuffer.setCharAt(n2, (char)(c2 + '\u0001'));
                return false;
            }
            charBuffer.setCharAt(n2, '0');
            --n2;
        }
        charBuffer.insert(0, '1');
        return true;
    }

    private static void formatFixed(CharBuffer charBuffer, CharBuffer charBuffer2, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        while (n > 0) {
            if (n4 < charBuffer2.length()) {
                charBuffer.append(charBuffer2.charAt(n4++));
            } else {
                charBuffer.append('0');
            }
            --n;
        }
        if (n5 <= 0) {
            charBuffer.append('0');
        }
        if (n2 > 0 || (n3 & 1) != 0) {
            charBuffer.append('.');
        }
        while (n < 0 && n2 > 0) {
            charBuffer.append('0');
            --n2;
            ++n;
        }
        while (n2 > 0 && n4 < charBuffer2.length()) {
            charBuffer.append(charBuffer2.charAt(n4));
            --n2;
            ++n4;
        }
        while (n2 > 0 && (n3 & 0x41) != 64) {
            charBuffer.append('0');
            --n2;
        }
    }

    private static void formatExpt(CharBuffer charBuffer, CharBuffer charBuffer2, int n, int n2, int n3) {
        if (charBuffer2.length() == 0) {
            charBuffer.append('0');
        } else {
            charBuffer.append(charBuffer2.charAt(0));
        }
        if (n2 > 0 || (n3 & 1) != 0) {
            charBuffer.append('.');
        }
        int n4 = 1;
        while (n4 < charBuffer2.length()) {
            if (n2 > 0) {
                charBuffer.append(charBuffer2.charAt(n4));
            }
            --n2;
            ++n4;
        }
        while (n2 > 0 && (n3 & 0x41) != 64) {
            charBuffer.append('0');
            --n2;
        }
        if ((n3 & 0x20) != 0) {
            charBuffer.append('E');
        } else {
            charBuffer.append('e');
        }
        Printf.formatInteger(charBuffer, n - 1, 0, 2, 4, 10);
    }

    private static void formatInteger(CharBuffer charBuffer, double d, int n, int n2, int n3, int n4) {
        boolean bl = (n3 & 0x20) != 0;
        int n5 = charBuffer.length();
        long l = d > 0.0 ? (long)(d + 0.5) : (long)(d - 0.5);
        if (l < 0L && n4 == 10) {
            charBuffer.append('-');
            l = -l;
        } else if (l >= 0L && n4 == 10 && (n3 & 4) != 0) {
            charBuffer.append('+');
        } else if (l >= 0L && n4 == 10 && (n3 & 8) != 0) {
            charBuffer.append(' ');
        } else if (l < 0L) {
            l &= 0xFFFFFFFFL;
        } else if (n4 == 8 && (n3 & 1) != 0 && l != 0L) {
            charBuffer.append('0');
        } else if (n4 == 16 && (n3 & 1) != 0) {
            charBuffer.append((n3 & 0x20) == 0 ? "0x" : "0X");
        }
        if ((n3 & 2) != 0) {
            n -= charBuffer.length() - n5;
            n5 = charBuffer.length();
        }
        int n6 = charBuffer.length();
        int n7 = 0;
        while (l != 0L) {
            ++n7;
            charBuffer.insert(n6, (bl ? bigDigits : digits)[(int)(l % (long)n4)]);
            l /= (long)n4;
        }
        int n8 = 0;
        while (n8 < n2 - n7) {
            charBuffer.insert(n6, '0');
            ++n8;
        }
        if (n7 == 0 && n2 == 0) {
            charBuffer.insert(n6, '0');
        }
        n -= charBuffer.length() - n5;
        while (n > 0) {
            if ((n3 & 0x10) != 0) {
                charBuffer.append(' ');
            } else if ((n3 & 2) != 0 && n2 < 0) {
                charBuffer.insert(n5, '0');
            } else {
                charBuffer.insert(n5, ' ');
            }
            --n;
        }
        if (charBuffer.length() == n5) {
            charBuffer.append('0');
        }
    }

    private static void formatChar(CharBuffer charBuffer, int n, int n2, int n3) {
        int n4 = charBuffer.length();
        charBuffer.append((char)n);
        if ((n3 & 0x10) == 0) {
            int n5 = 0;
            while (n5 < n2 - 1) {
                charBuffer.insert(n4, ' ');
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n2 - 1) {
                charBuffer.append(' ');
                ++n6;
            }
        }
    }

    private static void formatString(CharBuffer charBuffer, ESString eSString, int n, int n2, int n3) {
        int n4 = charBuffer.length();
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        int n5 = 0;
        while (n5 < eSString.length() && n5 < n) {
            --n2;
            charBuffer.append(eSString.charAt(n5));
            ++n5;
        }
        if ((n3 & 0x10) == 0) {
            n5 = 0;
            while (n5 < n2) {
                charBuffer.insert(n4, ' ');
                ++n5;
            }
        } else {
            n5 = 0;
            while (n5 < n2) {
                charBuffer.append(' ');
                ++n5;
            }
        }
    }

    private static void fixBits(CharBuffer charBuffer, ESString eSString, int n, int n2) {
        while (n < n2) {
            charBuffer.append(eSString.charAt(n));
            ++n;
        }
    }

    private Printf() {
    }
}

