/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.Global;
import com.caucho.es.Native;
import java.util.Random;

class NativeMath
extends Native {
    static final int ABS = 1;
    static final int ACOS = 2;
    static final int ASIN = 3;
    static final int ATAN = 4;
    static final int ATAN2 = 5;
    static final int CEIL = 6;
    static final int COS = 7;
    static final int EXP = 8;
    static final int FLOOR = 9;
    static final int LOG = 10;
    static final int MAX = 11;
    static final int MIN = 12;
    static final int POW = 13;
    static final int RANDOM = 14;
    static final int ROUND = 15;
    static final int SET_SEED = 16;
    static final int SIN = 17;
    static final int SQRT = 18;
    static final int TAN = 19;
    Random random;

    static ESObject create(Global global) {
        ESObject eSObject = new ESObject("Math", null);
        NativeMath.put(eSObject, "abs", 1, 1);
        NativeMath.put(eSObject, "asin", 3, 1);
        NativeMath.put(eSObject, "acos", 2, 1);
        NativeMath.put(eSObject, "atan", 4, 1);
        NativeMath.put(eSObject, "atan2", 5, 2);
        NativeMath.put(eSObject, "ceil", 6, 1);
        NativeMath.put(eSObject, "cos", 7, 1);
        NativeMath.put(eSObject, "exp", 8, 1);
        NativeMath.put(eSObject, "floor", 9, 1);
        NativeMath.put(eSObject, "log", 10, 1);
        NativeMath.put(eSObject, "max", 11, 2);
        NativeMath.put(eSObject, "min", 12, 2);
        NativeMath.put(eSObject, "pow", 13, 2);
        NativeMath.put(eSObject, "round", 15, 1);
        NativeMath.put(eSObject, "sin", 17, 1);
        NativeMath.put(eSObject, "sqrt", 18, 1);
        NativeMath.put(eSObject, "tan", 19, 1);
        NativeMath.put(eSObject, "random", 14, 0);
        NativeMath.put(eSObject, "setSeed", 16, 1);
        int n = 7;
        eSObject.put("E", (ESBase)ESNumber.create(Math.E), n);
        eSObject.put("LN10", (ESBase)ESNumber.create(Math.log(10.0)), n);
        eSObject.put("LN2", (ESBase)ESNumber.create(Math.log(2.0)), n);
        eSObject.put("LOG2E", (ESBase)ESNumber.create(1.0 / Math.log(2.0)), n);
        eSObject.put("LOG10E", (ESBase)ESNumber.create(1.0 / Math.log(10.0)), n);
        eSObject.put("PI", (ESBase)ESNumber.create(Math.PI), n);
        eSObject.put("SQRT1_2", (ESBase)ESNumber.create(Math.sqrt(0.5)), n);
        eSObject.put("SQRT2", (ESBase)ESNumber.create(Math.sqrt(2.0)), n);
        Random random = new Random();
        try {
            ((NativeMath)eSObject.getProperty((String)"random")).random = random;
            ((NativeMath)eSObject.getProperty((String)"setSeed")).random = random;
        }
        catch (Exception exception) {
            // empty catch block
        }
        eSObject.setClean();
        return eSObject;
    }

    private static void put(ESObject eSObject, String string, int n, int n2) {
        eSObject.put(string, (ESBase)new NativeMath(string, n, n2), 4);
    }

    public ESBase call(Call call, int n) throws Exception {
        switch (this.n) {
            case 1: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                double d = call.getArg(0).toNum();
                return ESNumber.create(d == 0.0 ? 0.0 : (d < 0.0 ? -d : d));
            }
            case 2: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.acos(call.getArg(0).toNum()));
            }
            case 3: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.asin(call.getArg(0).toNum()));
            }
            case 4: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.atan(call.getArg(0).toNum()));
            }
            case 5: {
                if (n < 2) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.atan2(call.getArg(0).toNum(), call.getArg(1).toNum()));
            }
            case 6: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.ceil(call.getArg(0).toNum()));
            }
            case 7: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.cos(call.getArg(0).toNum()));
            }
            case 8: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.exp(call.getArg(0).toNum()));
            }
            case 9: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.floor(call.getArg(0).toNum()));
            }
            case 10: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.log(call.getArg(0).toNum()));
            }
            case 11: {
                double d = Double.NEGATIVE_INFINITY;
                int n2 = 0;
                while (n2 < n) {
                    double d2 = call.getArg(n2).toNum();
                    d = Math.max(d2, d);
                    ++n2;
                }
                return ESNumber.create(d);
            }
            case 12: {
                double d = Double.POSITIVE_INFINITY;
                int n3 = 0;
                while (n3 < n) {
                    double d3 = call.getArg(n3).toNum();
                    d = Math.min(d3, d);
                    ++n3;
                }
                return ESNumber.create(d);
            }
            case 13: {
                if (n < 2) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.pow(call.getArg(0).toNum(), call.getArg(1).toNum()));
            }
            case 14: {
                if (n > 1) {
                    int n4 = call.getArg(0).toInt32();
                    if (n4 > 0) {
                        return ESNumber.create((int)(this.random.nextDouble() * (double)n4));
                    }
                } else {
                    return ESNumber.create(this.random.nextDouble());
                }
            }
            case 15: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                double d = call.getArg(0).toNum();
                if (d >= -0.5 && d < 0.5) {
                    return ESNumber.create(Math.rint(d));
                }
                return ESNumber.create(Math.floor(d + 0.5));
            }
            case 16: {
                if (n != 0) {
                    this.random.setSeed((long)call.getArg(0).toNum());
                }
                return ESBase.esUndefined;
            }
            case 17: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.sin(call.getArg(0).toNum()));
            }
            case 18: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.sqrt(call.getArg(0).toNum()));
            }
            case 19: {
                if (n == 0) {
                    return ESBase.esUndefined;
                }
                return ESNumber.create(Math.tan(call.getArg(0).toNum()));
            }
        }
        throw new ESException("Undefined math function");
    }

    private NativeMath(String string, int n, int n2) {
        super(string, n2);
        this.n = n;
    }
}

