/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESArray;
import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;

class NativeArray
extends Native {
    static ESId LENGTH = ESId.intern("length");
    static final int NEW = 1;
    static final int JOIN = 2;
    static final int TO_STRING = 3;
    static final int REVERSE = 4;
    static final int SORT = 5;
    static final int CONCAT = 6;
    static final int POP = 7;
    static final int PUSH = 8;
    static final int SHIFT = 9;
    static final int UNSHIFT = 10;
    static final int SLICE = 11;
    static final int SPLICE = 12;

    static ESObject create(Global global) {
        NativeArray nativeArray = new NativeArray("Array", 1, 1);
        ESArray eSArray = new ESArray();
        eSArray.prototype = global.objProto;
        NativeWrapper nativeWrapper = new NativeWrapper(global, nativeArray, eSArray, 5);
        global.arrayProto = eSArray;
        NativeArray.put(eSArray, "join", 2, 1);
        NativeArray.put(eSArray, "toString", 3, 0);
        NativeArray.put(eSArray, "reverse", 4, 0);
        NativeArray.put(eSArray, "sort", 5, 0);
        NativeArray.put(eSArray, "concat", 6, 0);
        NativeArray.put(eSArray, "pop", 7, 0);
        NativeArray.put(eSArray, "push", 8, 0);
        NativeArray.put(eSArray, "shift", 9, 0);
        NativeArray.put(eSArray, "unshift", 10, 0);
        NativeArray.put(eSArray, "slice", 11, 2);
        NativeArray.put(eSArray, "splice", 12, 0);
        eSArray.setClean();
        nativeWrapper.setClean();
        return nativeWrapper;
    }

    private static void put(ESObject eSObject, String string, int n, int n2) {
        ESId eSId = ESId.intern(string);
        eSObject.put(eSId, (ESBase)new NativeArray(string, n, n2), 4);
    }

    public ESBase call(Call call, int n) throws Exception {
        switch (this.n) {
            case 1: {
                return this.create(call, n);
            }
            case 2: {
                if (n == 0) {
                    return this.toString(call, n);
                }
                return this.join(call, n);
            }
            case 3: {
                return this.toString(call, n);
            }
            case 4: {
                return this.reverse(call, n);
            }
            case 5: {
                return this.sort(call, n);
            }
            case 6: {
                return this.concat(call, n);
            }
            case 7: {
                return this.pop(call, n);
            }
            case 8: {
                return this.push(call, n);
            }
            case 9: {
                return this.shift(call, n);
            }
            case 10: {
                return this.unshift(call, n);
            }
            case 11: {
                return this.slice(call, n);
            }
            case 12: {
                return this.splice(call, n);
            }
        }
        throw new ESException("Unknown object function");
    }

    ESBase create(Call call, int n) throws Exception {
        ESArray eSArray = Global.getGlobalProto().createArray();
        if (n == 0) {
            return eSArray;
        }
        if (n == 1) {
            ESBase eSBase = call.getArg(0);
            if (eSBase instanceof ESNumber) {
                ((ESObject)eSArray).setProperty(LENGTH, (ESBase)ESNumber.create(eSBase.toInt32()));
            } else {
                ((ESBase)eSArray).setProperty(0, eSBase);
            }
            return eSArray;
        }
        int n2 = 0;
        while (n2 < n) {
            ((ESBase)eSArray).setProperty(n2, call.getArg(n2));
            ++n2;
        }
        return eSArray;
    }

    static ESBase join(ESObject eSObject, String string) throws Exception {
        if (eSObject.mark != 0) {
            return ESString.create("...");
        }
        eSObject.mark = -1;
        try {
            int n = eSObject.getProperty(LENGTH).toInt32();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                ESBase eSBase;
                if (n2 != 0) {
                    stringBuffer.append(string);
                }
                if ((eSBase = eSObject.hasProperty(n2)) != null && eSBase != ESBase.esNull && eSBase != ESBase.esUndefined) {
                    stringBuffer.append(eSBase.toString());
                }
                ++n2;
            }
            ESString eSString = ESString.create(stringBuffer.toString());
            Object var3_7 = null;
            eSObject.mark = 0;
            return eSString;
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            eSObject.mark = 0;
            throw throwable;
        }
    }

    ESBase join(Call call, int n) throws Exception {
        String string = n == 0 ? "," : call.getArg(0).toString();
        ESObject eSObject = call.getArg(-1).toObject();
        return NativeArray.join(eSObject, string);
    }

    static ESBase toString(ESObject eSObject) throws Exception {
        return NativeArray.join(eSObject, ",");
    }

    ESBase toString(Call call, int n) throws Exception {
        ESObject eSObject = call.getArg(-1).toObject();
        return NativeArray.toString(eSObject);
    }

    ESBase reverse(Call call, int n) throws Exception {
        ESObject eSObject = call.getArg(-1).toObject();
        int n2 = eSObject.getProperty(LENGTH).toInt32();
        int n3 = 0;
        while (n3 < n2 / 2) {
            int n4 = n3;
            int n5 = n2 - n3 - 1;
            ESBase eSBase = eSObject.hasProperty(n4);
            ESBase eSBase2 = eSObject.hasProperty(n5);
            if (eSBase == null) {
                eSObject.delete(n5);
            } else {
                eSObject.setProperty(n5, eSBase);
            }
            if (eSBase2 == null) {
                eSObject.delete(n4);
            } else {
                eSObject.setProperty(n4, eSBase2);
            }
            ++n3;
        }
        return eSObject;
    }

    ESBase sort(Call call, int n) throws Exception {
        ESObject eSObject = call.getArg(-1).toObject();
        ESBase eSBase = n == 0 ? null : call.getArg(0);
        int n2 = eSObject.getProperty(LENGTH).toInt32();
        ESBase[] eSBaseArray = new ESBase[n2];
        int n3 = 0;
        while (n3 < n2) {
            eSBaseArray[n3] = eSObject.getProperty("" + n3);
            ++n3;
        }
        this.qsort(eSBaseArray, 0, n2, eSBase);
        n3 = 0;
        while (n3 < n2) {
            if (eSBaseArray[n3] == ESBase.esUndefined) {
                eSObject.delete("" + n3);
            } else {
                eSObject.setProperty("" + n3, eSBaseArray[n3]);
            }
            ++n3;
        }
        return eSObject;
    }

    private void qsort(ESBase[] eSBaseArray, int n, int n2, ESBase eSBase) throws Exception {
        if (n2 == 2) {
            if (this.compare(eSBase, eSBaseArray[n], eSBaseArray[n + 1]) > 0) {
                ESBase eSBase2 = eSBaseArray[n];
                eSBaseArray[n] = eSBaseArray[n + 1];
                eSBaseArray[n + 1] = eSBase2;
            }
        } else if (n2 > 2) {
            int n3;
            int n4 = n + n2 / 2;
            ESBase eSBase3 = eSBaseArray[n4];
            int n5 = 0;
            int n6 = 0;
            int n7 = this.compare(eSBase, eSBaseArray[n], eSBase3);
            if (n7 > 0) {
                eSBase3 = eSBaseArray[n];
                eSBaseArray[n] = eSBaseArray[n4];
                eSBaseArray[n4] = eSBase3;
            } else if (n7 == 0) {
                ++n5;
            }
            n7 = this.compare(eSBase, eSBase3, eSBaseArray[n + n2 - 1]);
            if (n7 > 0) {
                eSBase3 = eSBaseArray[n + n2 - 1];
                eSBaseArray[n + n2 - 1] = eSBaseArray[n4];
                eSBaseArray[n4] = eSBase3;
                n5 = 0;
                n6 = 1;
                n7 = this.compare(eSBase, eSBaseArray[n], eSBase3);
                if (n7 > 0) {
                    eSBase3 = eSBaseArray[n];
                    eSBaseArray[n] = eSBaseArray[n4];
                    eSBaseArray[n4] = eSBase3;
                } else if (n7 == 0) {
                    ++n5;
                }
            } else if (n7 < 0) {
                n6 = 1;
            }
            if (n4 == n + 1) {
                n3 = 2 + n6;
                ++n5;
            } else {
                n3 = 1 + n6;
            }
            while (n3 < n2) {
                int n8 = n + n3 - n6;
                if (eSBaseArray[n8] == eSBase3) {
                    ++n5;
                } else {
                    ESBase eSBase4;
                    int n9 = this.compare(eSBase, eSBase3, eSBaseArray[n8]);
                    if (n9 > 0 && n5 != 0) {
                        eSBase4 = eSBaseArray[n8];
                        eSBaseArray[n8] = eSBaseArray[n8 - n5];
                        eSBaseArray[n8 - n5] = eSBase4;
                    } else if (n9 < 0) {
                        eSBase4 = eSBaseArray[n + n2 - n6 - 1];
                        eSBaseArray[n + n2 - n6 - 1] = eSBaseArray[n8];
                        eSBaseArray[n8] = eSBase4;
                        ++n6;
                    } else if (n9 == 0) {
                        ++n5;
                    }
                }
                ++n3;
            }
            if (n2 - n6 - n5 > 1) {
                this.qsort(eSBaseArray, n, n2 - n6 - n5, eSBase);
            }
            if (n6 > 1) {
                this.qsort(eSBaseArray, n + n2 - n6, n6, eSBase);
            }
        }
    }

    private int compare(ESBase eSBase, ESBase eSBase2, ESBase eSBase3) throws Exception {
        if (eSBase2 == eSBase3) {
            return 0;
        }
        if (eSBase2 == ESBase.esUndefined) {
            return 1;
        }
        if (eSBase3 == ESBase.esUndefined) {
            return -1;
        }
        if (eSBase2 == ESBase.esNull) {
            return 1;
        }
        if (eSBase3 == ESBase.esNull) {
            return -1;
        }
        if (eSBase != null) {
            Global global = Global.getGlobalProto();
            Call call = global.getCall();
            call.stack[0] = ESBase.esNull;
            call.stack[1] = eSBase2;
            call.stack[2] = eSBase3;
            call.top = 1;
            int n = eSBase.call(call, 2).toInt32();
            global.freeCall(call);
            return n;
        }
        String string = eSBase2.toString();
        String string2 = eSBase3.toString();
        return string.compareTo(string2);
    }

    ESBase concat(Call call, int n) throws Exception {
        ESArray eSArray = Global.getGlobalProto().createArray();
        int n2 = 0;
        int n3 = -1;
        while (n3 < n) {
            ESBase eSBase = call.getArg(n3);
            if (eSBase != ESBase.esNull && eSBase != ESBase.esUndefined && eSBase != ESBase.esEmpty) {
                ESBase eSBase2 = eSBase.hasProperty(LENGTH);
                if (eSBase2 == null) {
                    eSArray.setProperty(n2++, eSBase);
                } else {
                    int n4 = eSBase2.toInt32();
                    if (n4 < 0) {
                        eSArray.setProperty(n2++, eSBase);
                    } else {
                        int n5 = 0;
                        while (n5 < n4) {
                            ESBase eSBase3 = eSBase.hasProperty(n5);
                            if (eSBase3 != null) {
                                eSArray.setProperty(n2, eSBase3);
                            }
                            ++n2;
                            ++n5;
                        }
                    }
                }
            }
            ++n3;
        }
        eSArray.setProperty(LENGTH, (ESBase)ESNumber.create(n2));
        return eSArray;
    }

    ESBase pop(Call call, int n) throws Exception {
        int n2;
        ESObject eSObject = call.getArg(-1).toObject();
        ESBase eSBase = eSObject.hasProperty(LENGTH);
        if (eSBase == null || (n2 = eSBase.toInt32()) <= 0) {
            return ESBase.esUndefined;
        }
        ESBase eSBase2 = eSObject.getProperty(n2 - 1);
        eSObject.setProperty(LENGTH, (ESBase)ESNumber.create(n2 - 1));
        return eSBase2;
    }

    ESBase push(Call call, int n) throws Exception {
        ESObject eSObject = call.getArg(-1).toObject();
        ESBase eSBase = eSObject.getProperty(LENGTH);
        int n2 = eSBase.toInt32();
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = 0;
        while (n3 < n) {
            eSObject.setProperty(n2 + n3, call.getArg(n3));
            ++n3;
        }
        ESNumber eSNumber = ESNumber.create(n2 + n);
        eSObject.setProperty(LENGTH, (ESBase)eSNumber);
        return eSNumber;
    }

    ESBase shift(Call call, int n) throws Exception {
        int n2;
        ESObject eSObject = call.getArg(-1).toObject();
        ESBase eSBase = eSObject.hasProperty(LENGTH);
        if (eSBase == null || (n2 = eSBase.toInt32()) <= 0) {
            return ESBase.esUndefined;
        }
        ESBase eSBase2 = eSObject.getProperty(0);
        int n3 = 1;
        while (n3 < n2) {
            ESBase eSBase3 = eSObject.hasProperty(n3);
            if (eSBase3 == null) {
                eSObject.delete(ESString.create(n3 - 1));
            } else {
                eSObject.setProperty(n3 - 1, eSBase3);
            }
            ++n3;
        }
        eSObject.setProperty(LENGTH, (ESBase)ESNumber.create(n2 - 1));
        return eSBase2;
    }

    ESBase unshift(Call call, int n) throws Exception {
        ESBase eSBase;
        ESObject eSObject = call.getArg(-1).toObject();
        ESBase eSBase2 = eSObject.getProperty(LENGTH);
        int n2 = eSBase2.toInt32();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n == 0) {
            return ESNumber.create(0.0);
        }
        int n3 = n2 - 1;
        while (n3 >= 0) {
            eSBase = eSObject.getProperty(n3);
            if (eSBase == null) {
                eSObject.delete(ESString.create(n + n3));
            } else {
                eSObject.setProperty(n + n3, eSBase);
            }
            --n3;
        }
        n3 = 0;
        while (n3 < n) {
            eSBase = call.getArg(n3);
            if (eSBase == null) {
                eSObject.delete(ESString.create(n3));
            } else {
                eSObject.setProperty(n3, eSBase);
            }
            ++n3;
        }
        ESNumber eSNumber = ESNumber.create(n2 + n);
        eSObject.setProperty(LENGTH, (ESBase)eSNumber);
        return eSNumber;
    }

    ESBase slice(Call call, int n) throws Exception {
        ESObject eSObject = call.getArg(-1).toObject();
        ESBase eSBase = eSObject.getProperty(LENGTH);
        int n2 = eSBase.toInt32();
        ESArray eSArray = Global.getGlobalProto().createArray();
        if (n2 <= 0) {
            return eSArray;
        }
        int n3 = 0;
        if (n > 0) {
            n3 = call.getArg(0).toInt32();
        }
        if (n3 < 0) {
            n3 += n2;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > n2) {
            return eSArray;
        }
        int n4 = n2;
        if (n > 1) {
            n4 = call.getArg(1).toInt32();
        }
        if (n4 < 0) {
            n4 += n2;
        }
        if (n4 < 0) {
            return eSArray;
        }
        if (n4 > n2) {
            n4 = n2;
        }
        if (n3 >= n4) {
            return eSArray;
        }
        int n5 = 0;
        while (n5 < n4 - n3) {
            ESBase eSBase2 = eSObject.hasProperty(n3 + n5);
            if (eSBase2 != null) {
                eSArray.setProperty(n5, eSBase2);
            }
            ++n5;
        }
        eSArray.setProperty(LENGTH, (ESBase)ESNumber.create(n4 - n3));
        return eSArray;
    }

    ESBase splice(Call call, int n) throws Exception {
        ESBase eSBase;
        int n2;
        int n3;
        ESBase eSBase2;
        if (n < 2) {
            return ESBase.esUndefined;
        }
        ESObject eSObject = call.getArg(-1).toObject();
        int n4 = call.getArg(0).toInt32();
        int n5 = call.getArg(1).toInt32();
        boolean bl = n5 == 1;
        ESBase eSBase3 = eSObject.getProperty(LENGTH);
        int n6 = eSBase3.toInt32();
        if (n4 < 0) {
            n4 += n6;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 + n5 > n6) {
            n5 = n6 - n4;
        }
        if (n5 < 1) {
            eSBase2 = ESBase.esUndefined;
        } else {
            eSBase2 = Global.getGlobalProto().createArray();
            n3 = 0;
            while (n3 < n5) {
                eSBase2.setProperty(n3, eSObject.getProperty(n4 + n3));
                ++n3;
            }
        }
        n3 = n - 2 - n5;
        if (n3 < 0) {
            n2 = 0;
            while (n2 < n6 - n5) {
                eSBase = eSObject.getProperty(n2 + n4 + n5);
                if (eSBase == null) {
                    eSObject.delete(ESString.create(n2 + n4 + n5 + n3));
                } else {
                    eSObject.setProperty(n2 + n4 + n5 + n3, eSBase);
                }
                ++n2;
            }
        } else if (n3 > 0) {
            n2 = n6 - n5 - 1;
            while (n2 >= 0) {
                eSBase = eSObject.getProperty(n2 + n4 + n5);
                if (eSBase == null) {
                    eSObject.delete(ESString.create(n2 + n4 + n5 + n3));
                } else {
                    eSObject.setProperty(n2 + n4 + n5 + n3, eSBase);
                }
                --n2;
            }
        }
        n2 = 0;
        while (n2 < n - 2) {
            eSObject.setProperty(n2 + n4, call.getArg(n2 + 2));
            ++n2;
        }
        eSObject.setProperty(LENGTH, (ESBase)ESNumber.create(n6 - n5 + n - 2));
        return eSBase2;
    }

    private NativeArray(String string, int n, int n2) {
        super(string, n2);
        this.n = n;
    }
}

