/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;

public class ESString
extends ESBase {
    static ESId NULL;
    static ESId LENGTH;
    private static ESId[] ints;
    protected String string;
    protected int hashCode;

    public static ESString create(String string) {
        return string == null ? NULL : new ESString(string);
    }

    public static ESBase toStr(String string) {
        return string == null ? ESBase.esNull : new ESString(string);
    }

    public static ESString create(int n) {
        if (n >= 0 && n < ints.length) {
            return ints[n];
        }
        return new ESString(String.valueOf(n));
    }

    public static ESString createFromCharCode(char c) {
        return new ESString(String.valueOf(c));
    }

    public static ESString create(CharBuffer charBuffer) {
        return new ESString(charBuffer.toString());
    }

    public ESBase typeof() throws ESException {
        return ESString.create("string");
    }

    public double toNum() {
        return ESString.parseFloat(this, true);
    }

    public ESString toStr() {
        return this;
    }

    public boolean isString() {
        return true;
    }

    public ESString toSource(IntMap intMap, boolean bl) {
        if (bl) {
            return null;
        }
        return ESString.create("\"" + this.string + "\"");
    }

    public ESObject toObject() {
        ESWrapper eSWrapper = new ESWrapper("String", (ESBase)Global.getGlobalProto().stringProto, this);
        eSWrapper.put(LENGTH, (ESBase)ESNumber.create(this.string.length()), 7);
        return eSWrapper;
    }

    public Object toJavaObject() {
        return this.string;
    }

    public ESBase getProperty(ESString eSString) throws Exception {
        if (eSString.equals(LENGTH)) {
            return ESNumber.create(this.string.length());
        }
        return Global.getGlobalProto().stringProto.getProperty(eSString);
    }

    public boolean ecmaEquals(ESBase eSBase) throws Exception {
        if (eSBase == ESBase.esNull) {
            return false;
        }
        if (eSBase instanceof ESString) {
            return this.string.equals(((ESString)eSBase).string);
        }
        if (eSBase instanceof ESObject) {
            ESBase eSBase2 = eSBase.toPrimitive(0);
            if (eSBase2 instanceof ESString) {
                return this.equals(eSBase2);
            }
            return this.toNum() == eSBase2.toNum();
        }
        return this.toNum() == eSBase.toNum();
    }

    public ESBase plus(ESBase eSBase) throws Exception {
        ESBase eSBase2 = eSBase.toPrimitive(0);
        return ESString.create(this.string + eSBase2.toStr().toString());
    }

    char charAt(int n) {
        return this.string.charAt(n);
    }

    public char carefulCharAt(int n) {
        if (n >= this.string.length()) {
            return '\uffff';
        }
        return this.string.charAt(n);
    }

    int length() {
        return this.string.length();
    }

    boolean regionMatches(int n, String string, int n2, int n3) {
        return this.string.regionMatches(n, string, n2, n3);
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n != 0) {
            return n;
        }
        n = 1021;
        int n2 = this.string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = 65521 * n + (this.string.charAt(n3) + '\u0001') * 251;
            ++n3;
        }
        this.hashCode = n;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ESString) {
            return this.string.equals(((ESString)object).string);
        }
        return false;
    }

    int compareTo(ESString eSString) {
        return this.string.compareTo(eSString.string);
    }

    int indexOf(ESString eSString, int n) {
        return this.string.indexOf(eSString.string, n);
    }

    int lastIndexOf(ESString eSString, int n) {
        return this.string.lastIndexOf(eSString.string, n);
    }

    ESString substring(int n, int n2) {
        return ESString.create(this.string.substring(n, n2));
    }

    ESString substring(int n) {
        return this.substring(n, this.string.length());
    }

    ESString toLowerCase() {
        return ESString.create(this.string.toLowerCase());
    }

    ESString toUpperCase() {
        return ESString.create(this.string.toUpperCase());
    }

    ESBoolean contains(ESBase eSBase) throws Exception {
        ESString eSString = eSBase.toStr();
        if (eSString.string.length() == 0) {
            return ESBoolean.TRUE;
        }
        int n = this.string.length();
        int n2 = 0;
        while (n2 <= n) {
            if (this.string.regionMatches(n2, eSString.string, 0, eSString.length())) {
                return ESBoolean.TRUE;
            }
            ++n2;
        }
        return ESBoolean.FALSE;
    }

    ESBoolean startsWith(ESBase eSBase) throws Exception {
        ESString eSString = eSBase.toStr();
        return ESBoolean.create(this.string.startsWith(eSString.string));
    }

    ESBoolean endsWith(ESBase eSBase) throws Exception {
        ESString eSString = eSBase.toStr();
        return ESBoolean.create(this.string.endsWith(eSString.string));
    }

    public boolean toBoolean() {
        return this.string.length() != 0;
    }

    static boolean isWhitespace(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    static double checkTail(double d, ESString eSString, int n) {
        while (n < eSString.length()) {
            if (!ESString.isWhitespace(eSString.charAt(n))) {
                return Double.NaN;
            }
            ++n;
        }
        return d;
    }

    static double parseFloat(ESString eSString, boolean bl) {
        int n;
        int n2 = eSString.length();
        int n3 = 0;
        char c = '\u0000';
        while (n3 < n2 && ESString.isWhitespace(eSString.charAt(n3))) {
            ++n3;
        }
        if (n3 >= n2) {
            return bl ? 0.0 : Double.NaN;
        }
        int n4 = 10;
        if (bl && n3 + 1 < n2 && (c = eSString.charAt(n3)) == '0' && ((c = eSString.charAt(n3 + 1)) == 'x' || c == 'X')) {
            n3 += 2;
            n4 = 16;
        }
        int n5 = 1;
        if (n4 == 10 && n3 < n2 && (c = eSString.charAt(n3)) == '+') {
            ++n3;
        } else if (n4 == 10 && n3 < n2 && c == '-') {
            n5 = -1;
            ++n3;
        }
        if (n4 == 10 && eSString.regionMatches(n3, "Infinity", 0, 8)) {
            if (bl) {
                return ESString.checkTail((double)n5 * Double.POSITIVE_INFINITY, eSString, n3 + 8);
            }
            return (double)n5 * Double.POSITIVE_INFINITY;
        }
        double d = 0.0;
        boolean bl2 = false;
        while (n3 < n2) {
            c = eSString.charAt(n3);
            if ('0' <= c && c <= '9') {
                d = (double)n4 * d + (double)eSString.charAt(n3) - 48.0;
                bl2 = true;
            } else if (n4 > 10 && 'a' <= c && c <= 97 + n4 - 11) {
                d = (double)n4 * d + (double)eSString.charAt(n3) - 97.0 + 10.0;
                bl2 = true;
            } else {
                if (n4 <= 10 || 'A' > c || c > 65 + n4 - 11) break;
                d = (double)n4 * d + (double)eSString.charAt(n3) - 65.0 + 10.0;
                bl2 = true;
            }
            ++n3;
        }
        if (n4 == 16 && !bl2) {
            return Double.NaN;
        }
        if (n4 == 16) {
            return ESString.checkTail(d, eSString, n3);
        }
        int n6 = 0;
        if (n3 < n2 && eSString.charAt(n3) == '.') {
            ++n3;
            n = 1;
            while (n3 < n2 && (c = eSString.charAt(n3)) >= '0' && c <= '9') {
                if (c == '0') {
                    ++n;
                } else {
                    d = d * Math.pow(10.0, n) + (double)c - 48.0;
                    n6 -= n;
                    n = 1;
                }
                bl2 = true;
                ++n3;
            }
        }
        if (!bl2) {
            return Double.NaN;
        }
        if (n3 < n2 && ((c = eSString.charAt(n3)) == 'e' || c == 'E')) {
            n = 1;
            if (++n3 < n2 && (c = eSString.charAt(n3)) == '+') {
                ++n3;
            } else if (n3 < n2 && c == '-') {
                n = -1;
                ++n3;
            }
            bl2 = false;
            int n7 = 0;
            while (n3 < n2 && (c = eSString.charAt(n3)) >= '0' && c <= '9') {
                n7 = 10 * n7 + c - 48;
                bl2 = true;
                ++n3;
            }
            if (!bl2) {
                return Double.NaN;
            }
            n6 += n * n7;
        }
        d = n6 < 0 ? (double)n5 * d / Math.pow(10.0, -n6) : (double)n5 * d * Math.pow(10.0, n6);
        if (bl) {
            return ESString.checkTail(d, eSString, n3);
        }
        return d;
    }

    static double parseFloat(ESString eSString) {
        return ESString.parseFloat(eSString, false);
    }

    public String toString() {
        return this.string;
    }

    protected ESString(String string) {
        if (ints == null) {
            ints = new ESId[128];
            NULL = ESId.intern("");
            LENGTH = ESId.intern("length");
            int n = 0;
            while (n < ints.length) {
                ESString.ints[n] = ESId.intern(String.valueOf(n));
                ++n;
            }
        }
        this.prototype = ESBase.esNull;
        this.string = string;
    }
}

