/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.es.NativeRegexp;
import com.caucho.regexp.IllegalRegexpException;
import com.caucho.regexp.Regexp;
import com.caucho.util.IntMap;
import java.util.Iterator;

public class ESRegexp
extends ESObject {
    static ESId GLOBAL = ESId.intern("global");
    static ESId IGNORE_CASE = ESId.intern("ignoreCase");
    static ESId LAST_INDEX = ESId.intern("lastIndex");
    static ESId SOURCE = ESId.intern("source");
    ESString pattern;
    ESString flags;
    Regexp regexp;
    boolean hasSetProps;
    int lastIndex;
    ESString lastString;
    int lastStart;

    private static ESBase getPrototype() {
        Global global = Global.getGlobalProto();
        if (global == null) {
            return null;
        }
        return global.getRegexpProto();
    }

    private void setProps() {
        if (this.hasSetProps) {
            return;
        }
        int n = 3;
        this.hasSetProps = true;
        this.put(GLOBAL, (ESBase)ESBoolean.create(this.regexp.isGlobal()), n);
        this.put(IGNORE_CASE, (ESBase)ESBoolean.create(this.regexp.ignoreCase()), n);
        this.put(LAST_INDEX, (ESBase)ESNumber.create(this.lastIndex), 2);
        this.put(SOURCE, (ESBase)this.pattern, n);
    }

    int getLastIndex() throws Exception {
        if (!this.hasSetProps) {
            return this.lastIndex;
        }
        return this.getProperty(LAST_INDEX).toInt32();
    }

    void setLastIndex(int n) {
        this.lastIndex = n;
        this.hasSetProps = false;
    }

    public ESBase getProperty(ESString eSString) throws Exception {
        if (!this.hasSetProps) {
            this.setProps();
        }
        return super.getProperty(eSString);
    }

    public void setProperty(ESString eSString, ESBase eSBase) throws Exception {
        if (!this.hasSetProps) {
            this.setProps();
        }
        super.setProperty(eSString, eSBase);
    }

    public ESBase delete(ESString eSString) throws Exception {
        if (!this.hasSetProps) {
            this.setProps();
        }
        return super.delete(eSString);
    }

    public Iterator keys() throws ESException {
        if (!this.hasSetProps) {
            this.setProps();
        }
        return super.keys();
    }

    public ESString toSource(IntMap intMap, boolean bl) throws Exception {
        if (bl) {
            return null;
        }
        return this.toStr();
    }

    void compile(ESString eSString, ESString eSString2) throws ESException {
        if (!this.pattern.equals(eSString) || !this.flags.equals(eSString2)) {
            this.pattern = eSString;
            this.flags = eSString2;
            try {
                this.regexp = new Regexp(eSString.toString(), eSString2.toString());
            }
            catch (IllegalRegexpException illegalRegexpException) {
                throw new ESException("regexp: " + illegalRegexpException);
            }
        }
        this.lastIndex = 0;
        this.hasSetProps = false;
    }

    boolean exec(ESString eSString, boolean bl) throws Exception {
        this.lastString = eSString;
        this.lastStart = this.getLastIndex();
        if (!bl) {
            this.lastStart = 0;
            return this.regexp.exec(eSString.toString(), 0) != -1;
        }
        if (this.regexp.exec(eSString.toString(), this.lastStart) == -1) {
            this.hasSetProps = false;
            this.lastIndex = 0;
            return false;
        }
        this.hasSetProps = false;
        this.lastIndex = this.regexp.getEnd(0);
        if (this.regexp.getBegin(0) == this.lastIndex) {
            ++this.lastIndex;
        }
        return true;
    }

    public Object toJavaObject() {
        return this.regexp;
    }

    boolean exec(ESString eSString) throws Exception {
        return this.exec(eSString, this.regexp.isGlobal());
    }

    public ESBase call(Call call, int n) throws Exception {
        call.setThis(this);
        return NativeRegexp.exec(call, n);
    }

    protected ESObject dup() {
        return new ESRegexp();
    }

    protected void copy(Object object) {
        ESRegexp eSRegexp = (ESRegexp)object;
        super.copy(object);
        eSRegexp.pattern = this.pattern;
        eSRegexp.flags = this.flags;
        eSRegexp.lastString = this.lastString;
        try {
            eSRegexp.regexp = new Regexp(this.pattern.toString(), this.flags.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ESRegexp(ESString eSString, ESString eSString2) throws ESException {
        super("RegExp", ESRegexp.getPrototype());
        this.pattern = eSString;
        this.flags = eSString2;
        this.lastString = ESString.NULL;
        try {
            this.regexp = new Regexp(eSString.toString(), eSString2.toString());
        }
        catch (IllegalRegexpException illegalRegexpException) {
            throw new ESException("regexp: " + illegalRegexpException.getMessage());
        }
    }

    public ESRegexp(String string, String string2) throws ESException {
        super("RegExp", ESRegexp.getPrototype());
        this.pattern = new ESString(string);
        this.flags = new ESString(string2);
        this.lastString = ESString.NULL;
        try {
            this.regexp = new Regexp(string, string2);
        }
        catch (IllegalRegexpException illegalRegexpException) {
            throw new ESException("regexp: " + illegalRegexpException.getMessage());
        }
    }

    protected ESRegexp() {
    }
}

