/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.vfs.VfsWriteObject;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class ESNumber
extends ESBase
implements VfsWriteObject {
    public static ESNumber ZERO = new ESNumber(0.0);
    public static ESNumber ONE = new ESNumber(1.0);
    public static ESNumber NaN = new ESNumber(Double.NaN);
    static ESNumber[] ints = new ESNumber[128];
    private double value;

    public static ESNumber create(double d) {
        try {
            if (d >= 128.0 || d <= 0.0) {
                return new ESNumber(d);
            }
            int n = (int)d;
            if ((double)n == d) {
                return ints[n];
            }
            return new ESNumber(d);
        }
        catch (Exception exception) {
            return new ESNumber(d);
        }
    }

    public boolean toBoolean() {
        return !Double.isNaN(this.value) && this.value != 0.0;
    }

    public boolean isNum() {
        return true;
    }

    public double toNum() {
        return this.value;
    }

    public ESObject toObject() throws ESException {
        return new ESWrapper("Number", (ESBase)Global.getGlobalProto().numProto, this);
    }

    public Object toJavaObject() {
        return new Double(this.value);
    }

    public ESBase typeof() throws ESException {
        return ESString.create("number");
    }

    public ESBase getProperty(ESString eSString) throws Exception {
        return Global.getGlobalProto().numProto.getProperty(eSString);
    }

    public ESString toStr() {
        int n = (int)this.value;
        if ((double)n == this.value) {
            return ESString.create(n);
        }
        return ESString.create(this.toString());
    }

    public String toString() {
        int n = (int)this.value;
        if ((double)n == this.value) {
            return String.valueOf(n);
        }
        if ((double)((long)this.value) == this.value) {
            return String.valueOf((long)this.value);
        }
        if (Double.isNaN(this.value)) {
            return "NaN";
        }
        if (Double.isInfinite(this.value)) {
            return this.value < 0.0 ? "-Infinity" : "Infinity";
        }
        return String.valueOf(this.value).toLowerCase();
    }

    public void print(WriteStream writeStream) throws IOException {
        int n = (int)this.value;
        if ((double)n == this.value) {
            writeStream.print(n);
        } else if ((double)((long)this.value) == this.value) {
            writeStream.print((long)this.value);
        } else if (Double.isNaN(this.value)) {
            writeStream.print("NaN");
        } else if (Double.isInfinite(this.value)) {
            writeStream.print(this.value < 0.0 ? "-Infinity" : "Infinity");
        } else {
            writeStream.print(this.value);
        }
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)l + 65517 * (int)(l >> 32);
    }

    public boolean equals(Object object) {
        return object instanceof ESNumber && this.value == ((ESNumber)object).value;
    }

    public boolean ecmaEquals(ESBase eSBase) throws Exception {
        return eSBase != ESBase.esNull && this.value == eSBase.toNum();
    }

    public boolean lessThan(ESBase eSBase, boolean bl) throws Exception {
        double d = eSBase.toNum();
        if (Double.isNaN(this.value) || Double.isNaN(d)) {
            return false;
        }
        return this.value < d != bl;
    }

    public ESBase plus(ESBase eSBase) throws Exception {
        if (eSBase instanceof ESNumber) {
            return ESNumber.create(this.value + ((ESNumber)eSBase).value);
        }
        ESBase eSBase2 = eSBase.toPrimitive(0);
        if (eSBase2 instanceof ESString) {
            return ESString.create(this.toString() + eSBase2.toString());
        }
        return ESNumber.create(this.value + eSBase2.toNum());
    }

    private ESNumber(double d) {
        this.prototype = ESBase.esNull;
        this.value = d;
    }

    static {
        int n = 0;
        while (n < ints.length) {
            ESNumber.ints[n] = new ESNumber(n);
            ++n;
        }
    }
}

