/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESGlobal;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.es.Script;

public class ESClosure
extends ESObject {
    static ESString LENGTH = ESId.intern("length");
    static ESString CALLEE = ESId.intern("callee");
    static ESString ARGUMENTS = ESId.intern("arguments");
    static ESString OBJECT = ESId.intern("Object");
    static ESString PROTOTYPE = ESId.intern("prototype");
    static ESString CONSTRUCTOR = ESId.intern("constructor");
    public ESString name;
    private Script script;
    public int n;
    ESId[] formals;
    int nFormals;
    ESBase proto;
    ESGlobal global;
    int stackRequired;
    int scopeRequired;
    ESBase[] scope;
    int scopeLength;
    boolean hasFields;

    public void closure(Call call) {
        if (this.scope == null) {
            this.scope = new ESBase[16];
        }
        while (this.scopeLength < call.scopeLength) {
            this.scope[this.scopeLength] = call.scope[this.scopeLength];
            ++this.scopeLength;
        }
        if (this.scopeLength == 0) {
            this.scope[this.scopeLength++] = call.global;
        }
        this.global = (ESGlobal)this.scope[0];
    }

    void setScope(ESBase[] eSBaseArray, int n) {
        this.scope = eSBaseArray;
        this.scopeLength = n;
    }

    public ESBase hasProperty(ESString eSString) throws Exception {
        if (eSString.equals(PROTOTYPE)) {
            if (this.proto == null) {
                ESObject eSObject = Global.getGlobalProto().createObject();
                this.proto = eSObject;
                eSObject.put(CONSTRUCTOR, (ESBase)this, 4);
            }
            return this.proto;
        }
        if (eSString.equals(LENGTH)) {
            return ESNumber.create(this.nFormals);
        }
        if (this.hasFields) {
            return super.hasProperty(eSString);
        }
        if (this.prototype != null) {
            return this.prototype.hasProperty(eSString);
        }
        return ESBase.esEmpty;
    }

    public ESBase getProperty(ESString eSString) throws Exception {
        if (eSString.equals(PROTOTYPE)) {
            if (this.proto == null) {
                ESObject eSObject = Global.getGlobalProto().createObject();
                this.proto = eSObject;
                eSObject.put(CONSTRUCTOR, (ESBase)this, 4);
            }
            return this.proto;
        }
        if (eSString.equals(LENGTH)) {
            return ESNumber.create(this.nFormals);
        }
        if (this.hasFields) {
            return super.getProperty(eSString);
        }
        return this.prototype.getProperty(eSString);
    }

    public boolean canPut(ESString eSString) {
        if (eSString.equals(PROTOTYPE)) {
            return true;
        }
        if (eSString.equals(LENGTH)) {
            return false;
        }
        if (this.hasFields) {
            return super.canPut(eSString);
        }
        return true;
    }

    public void setProperty(ESString eSString, ESBase eSBase) throws Exception {
        if (eSString.equals(PROTOTYPE)) {
            this.proto = eSBase;
        } else if (!eSString.equals(LENGTH)) {
            if (this.hasFields) {
                super.setProperty(eSString, eSBase);
            } else {
                this.init(this.className, this.prototype);
                this.hasFields = true;
                super.setProperty(eSString, eSBase);
            }
        }
    }

    public void put(ESString eSString, ESBase eSBase, int n) {
        if (eSString.equals(PROTOTYPE)) {
            this.proto = eSBase;
        } else if (!eSString.equals(LENGTH)) {
            if (this.hasFields) {
                super.put(eSString, eSBase, n);
            } else {
                this.init(this.className, this.prototype);
                this.hasFields = true;
                super.put(eSString, eSBase, n);
            }
        }
    }

    public ESBase delete(ESString eSString) throws Exception {
        if (eSString.equals(PROTOTYPE)) {
            this.proto = ESBase.esEmpty;
            return ESBoolean.TRUE;
        }
        if (eSString.equals(LENGTH)) {
            return ESBoolean.FALSE;
        }
        if (this.hasFields) {
            return super.delete(eSString);
        }
        return ESBoolean.TRUE;
    }

    public ESString toStr() {
        return ESString.create(this.decompile());
    }

    String decompile() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("function ");
        if (this.name != null && !this.name.toString().startsWith("$lambda")) {
            stringBuffer.append(this.name);
        }
        stringBuffer.append("(");
        int n = 0;
        while (this.formals != null && n < this.nFormals) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.formals[n]);
            ++n;
        }
        stringBuffer.append(") ");
        stringBuffer.append("{ ");
        stringBuffer.append("[compiled code]");
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    protected ESBase dispatch() throws ESException {
        throw new ESException("dispatch not specialized");
    }

    public ESBase call(Call call, int n) throws Exception {
        if (this.global != null) {
            call.global = this.global;
        }
        if (this.script != null) {
            return this.script.call(this.n, call, n);
        }
        return ESBase.esUndefined;
    }

    public ESBase construct(Call call, int n) throws Exception {
        Global global = Global.getGlobalProto();
        ESObject eSObject = Global.getGlobalProto().createObject();
        ESBase eSBase = this.proto;
        if (!(eSBase instanceof ESObject)) {
            eSBase = global.object.getProperty(PROTOTYPE);
        }
        if (eSBase instanceof ESObject) {
            eSObject.prototype = eSBase;
        }
        call.setThis(eSObject);
        ESBase eSBase2 = this.call(call, n);
        return eSBase2 instanceof ESObject ? (ESObject)eSBase2 : eSObject;
    }

    public ESBase typeof() throws ESException {
        return ESString.create("function");
    }

    protected void copy(Object object) {
        ESClosure eSClosure = (ESClosure)object;
        super.copy(object);
        eSClosure.name = this.name;
        eSClosure.script = this.script;
        eSClosure.n = this.n;
        eSClosure.formals = this.formals;
        eSClosure.nFormals = this.nFormals;
        eSClosure.stackRequired = this.stackRequired;
        eSClosure.scopeRequired = this.scopeRequired;
        eSClosure.scopeLength = this.scopeLength;
        eSClosure.scope = new ESBase[this.scopeLength];
        eSClosure.hasFields = this.hasFields;
        int n = 0;
        while (n < this.scopeLength) {
            if (this.scope[n] != null) {
                eSClosure.scope[n] = this.scope[n];
            }
            ++n;
        }
        eSClosure.proto = this.proto;
    }

    public ESObject dup() {
        return new ESClosure();
    }

    ESObject resinCopy() {
        ESObject eSObject = this.dup();
        this.copy(eSObject);
        return eSObject;
    }

    ESObject getClassPrototype() throws Exception {
        ESBase eSBase = this.hasProperty(PROTOTYPE);
        return (ESObject)eSBase;
    }

    void setClassPrototype(ESObject eSObject) throws ESException {
        this.proto = eSObject;
        eSObject.put(CONSTRUCTOR, (ESBase)this, 4);
    }

    public ESClosure(ESString eSString, Script script, ESObject eSObject, int n, ESId[] eSIdArray, ESObject eSObject2) {
        this.className = "Function";
        this.prototype = Global.getGlobalProto().funProto;
        this.name = eSString;
        this.script = script;
        this.proto = eSObject;
        this.n = n;
        this.formals = eSIdArray;
        this.nFormals = eSIdArray.length;
        if (eSObject2 instanceof ESGlobal) {
            this.global = (ESGlobal)eSObject2;
        }
        if (eSObject2 != null) {
            this.scopeLength = 1;
            this.scope = new ESBase[1];
            this.scope[0] = eSObject2;
        }
    }

    protected ESClosure(ESBase[] eSBaseArray, int n) {
        super("Function", null);
        this.hasFields = true;
        this.scope = eSBaseArray;
        this.scopeLength = n;
    }

    protected ESClosure() {
    }
}

