/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;

public class ESBoolean
extends ESBase {
    public static final ESBoolean TRUE = new ESBoolean(true);
    public static final ESBoolean FALSE = new ESBoolean(false);
    boolean value;

    public ESBase typeof() throws ESException {
        return ESString.create("boolean");
    }

    public boolean isBoolean() {
        return true;
    }

    public boolean toBoolean() {
        return this.value;
    }

    public double toNum() {
        return this.value ? 1.0 : 0.0;
    }

    public ESBase getProperty(ESString eSString) throws Exception {
        return Global.getGlobalProto().boolProto.getProperty(eSString);
    }

    public ESString toStr() {
        return ESString.create(this.value ? "true" : "false");
    }

    public ESObject toObject() throws ESException {
        return new ESWrapper("Boolean", (ESBase)Global.getGlobalProto().boolProto, this);
    }

    public Object toJavaObject() {
        return new Boolean(this.value);
    }

    public boolean ecmaEquals(ESBase eSBase) throws Exception {
        if (eSBase == ESBase.esNull || eSBase == ESBase.esEmpty || eSBase == ESBase.esUndefined) {
            return false;
        }
        return this.toNum() == eSBase.toNum();
    }

    public static ESBoolean create(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    private ESBoolean(boolean bl) {
        super(null);
        this.value = bl;
    }
}

