/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESFactory;
import com.caucho.es.ESNull;
import com.caucho.es.ESNullException;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESUndefined;
import com.caucho.es.ESUndefinedException;
import com.caucho.util.IntMap;
import java.util.HashMap;
import java.util.Iterator;

public class ESBase {
    private static ESFactory factory;
    public static ESBase esBase;
    public static ESBase esNull;
    public static ESBase esUndefined;
    public static ESBase esEmpty;
    static final int NONE = 0;
    static final int STRING = 1;
    static final int NUMBER = 2;
    public static final int READ_ONLY = 1;
    public static final int DONT_DELETE = 2;
    public static final int DONT_ENUM = 4;
    static final int WATCH = 8;
    String className;
    ESBase prototype;

    static void init(ESFactory eSFactory) {
        if (esBase != null) {
            return;
        }
        ESBase.esBase.prototype = esBase = new ESBase(null);
        ESBase.esBase.className = "base";
        factory = eSFactory;
        if (eSFactory != null) {
            esNull = eSFactory.createNull();
            esUndefined = eSFactory.createUndefined();
            esEmpty = eSFactory.createUndefined();
        } else {
            esNull = new ESNull();
            esUndefined = new ESUndefined();
            esEmpty = new ESUndefined();
        }
    }

    public ESBase typeof() throws ESException {
        throw new ESException("no typeof");
    }

    public ESBase getProperty(ESString eSString) throws Exception {
        return esEmpty;
    }

    boolean canPut(ESString eSString) {
        return true;
    }

    public void setProperty(ESString eSString, ESBase eSBase) throws Exception {
    }

    public ESBase delete(ESString eSString) throws Exception {
        return ESBoolean.TRUE;
    }

    public ESBase toPrimitive(int n) throws Exception {
        return this;
    }

    public ESBase toPrimitive() throws Exception {
        return this.toPrimitive(0);
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean toBoolean() {
        return false;
    }

    public boolean isNum() {
        return false;
    }

    public double toNum() throws Exception {
        throw new ESException("no number");
    }

    public boolean isString() {
        return false;
    }

    public ESString toStr() throws Exception {
        throw new ESException("no string");
    }

    public ESBase valueOf() throws Exception {
        return this.toPrimitive(0);
    }

    public ESString toSource(IntMap intMap, boolean bl) throws Exception {
        if (bl) {
            return null;
        }
        return this.toStr();
    }

    public ESObject toObject() throws ESException {
        throw new ESNullException(this.className + " has no properties");
    }

    public Object toJavaObject() throws ESException {
        return null;
    }

    Object copy(HashMap hashMap) {
        return this;
    }

    public ESBase call(Call call, int n) throws Exception {
        throw new ESNullException(this.toStr() + " is not a function");
    }

    public ESBase call(Call call, int n, ESString eSString) throws Exception {
        ESBase eSBase = this.hasProperty(eSString);
        if (eSBase != null) {
            call.callee = eSBase;
            return eSBase.call(call, n);
        }
        if (this.prototype != null && this.prototype != this) {
            return this.prototype.call(call, n, eSString);
        }
        throw new ESUndefinedException("undefined call `" + eSString + "'");
    }

    public ESBase construct(Call call, int n) throws Exception {
        throw new ESNullException(this.toStr() + " is not a constructor");
    }

    public Iterator keys() throws Exception {
        return this.toObject().keys();
    }

    String getClassName() {
        return this.className;
    }

    public ESBase hasProperty(ESString eSString) throws Exception {
        ESBase eSBase = this.getProperty(eSString);
        return eSBase == esEmpty ? null : eSBase;
    }

    ESBase hasProperty(int n) throws Exception {
        return this.hasProperty(ESString.create(n));
    }

    public ESBase getProperty(String string) throws Exception {
        return this.getProperty(ESString.create(string));
    }

    ESBase getProperty(int n) throws Exception {
        return this.getProperty(ESString.create(n));
    }

    public void setProperty(String string, ESBase eSBase) throws Exception {
        this.setProperty(ESString.create(string), eSBase);
    }

    public void setProperty(int n, ESBase eSBase) throws Exception {
        this.setProperty(ESString.create(n), eSBase);
    }

    ESBase delete(String string) throws Exception {
        return this.delete(ESString.create(string));
    }

    ESBase delete(int n) throws Exception {
        return this.delete(ESString.create(n));
    }

    public ESBase plus(ESBase eSBase) throws Exception {
        ESBase eSBase2 = this.toPrimitive(0);
        ESBase eSBase3 = eSBase.toPrimitive(0);
        if (eSBase2 instanceof ESString || eSBase3 instanceof ESString) {
            return ESString.create(eSBase2.toStr().toString() + eSBase3.toStr().toString());
        }
        return ESNumber.create(eSBase2.toNum() + eSBase3.toNum());
    }

    public boolean lessThan(ESBase eSBase, boolean bl) throws Exception {
        ESBase eSBase2 = this.toPrimitive(0);
        ESBase eSBase3 = eSBase.toPrimitive(0);
        if (eSBase2 instanceof ESString && eSBase3 instanceof ESString) {
            return ((ESString)eSBase2).compareTo((ESString)eSBase3) < 0 != bl;
        }
        double d = eSBase2.toNum();
        double d2 = eSBase3.toNum();
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return false;
        }
        return d < d2 != bl;
    }

    public boolean greaterThan(ESBase eSBase, boolean bl) throws Exception {
        return eSBase.lessThan(this, bl);
    }

    public int toInt32() throws Exception {
        double d = this.toNum();
        if (Double.isInfinite(d)) {
            return 0;
        }
        return (int)((long)d & 0xFFFFFFFFL);
    }

    public String toString() {
        try {
            return this.toStr().toString();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace();
            return "";
        }
    }

    public String toJavaString() throws Exception {
        return this.toStr().toString();
    }

    public boolean ecmaEquals(ESBase eSBase) throws Exception {
        return this == eSBase;
    }

    ESBase() {
    }

    ESBase(ESBase eSBase) {
        if (eSBase == null) {
            eSBase = esBase;
        }
        this.prototype = eSBase;
    }
}

