/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESArrayWrap;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESJavaWrapper;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;

public class ESArrayWrapper {
    public static ESJavaWrapper wrapper(Global global, Class clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        String string = clazz2.getName();
        if (string.equals("boolean")) {
            return new BooleanArray(global);
        }
        if (string.equals("byte")) {
            return new ByteArray(global);
        }
        if (string.equals("short")) {
            return new ShortArray(global);
        }
        if (string.equals("char")) {
            return new CharArray(global);
        }
        if (string.equals("int")) {
            return new IntArray(global);
        }
        if (string.equals("long")) {
            return new LongArray(global);
        }
        if (string.equals("float")) {
            return new FloatArray(global);
        }
        if (string.equals("double")) {
            return new DoubleArray(global);
        }
        return new ObjArray(global);
    }

    static class ObjArray
    extends ESArrayWrap {
        protected ESObject dup() {
            ObjArray objArray = new ObjArray();
            objArray.value = this.value;
            return objArray;
        }

        protected int length() {
            return ((Object[])this.value).length;
        }

        public ESBase getProperty(int n) {
            Object[] objectArray = (Object[])this.value;
            if (n >= 0 && n < objectArray.length) {
                Global.getGlobalProto();
                return Global.wrap(objectArray[n]);
            }
            return ESBase.esEmpty;
        }

        public void setProperty(int n, ESBase eSBase) throws ESException {
            Object[] objectArray = (Object[])this.value;
            if (n >= 0 && n < objectArray.length) {
                objectArray[n] = eSBase.toJavaObject();
            }
        }

        public ESBase delete(int n) throws ESException {
            Object[] objectArray = (Object[])this.value;
            if (n >= 0 && n < objectArray.length) {
                objectArray[n] = null;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        protected ObjArray() {
        }

        ObjArray(Global global) {
            super(global.arrayProto, null);
        }
    }

    static class BooleanArray
    extends ESArrayWrap {
        protected ESObject dup() {
            BooleanArray booleanArray = new BooleanArray();
            booleanArray.value = this.value;
            return booleanArray;
        }

        protected int length() {
            return ((boolean[])this.value).length;
        }

        public ESBase getProperty(int n) {
            boolean[] blArray = (boolean[])this.value;
            if (n >= 0 && n < blArray.length) {
                return ESBoolean.create(blArray[n]);
            }
            return ESBase.esEmpty;
        }

        public void setProperty(int n, ESBase eSBase) throws ESException {
            boolean[] blArray = (boolean[])this.value;
            if (n >= 0 && n < blArray.length) {
                blArray[n] = eSBase.toBoolean();
            }
        }

        public ESBase delete(int n) throws ESException {
            boolean[] blArray = (boolean[])this.value;
            if (n >= 0 && n < blArray.length) {
                blArray[n] = false;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        protected BooleanArray() {
        }

        BooleanArray(Global global) {
            super(global.arrayProto, null);
        }
    }

    static class ByteArray
    extends ESArrayWrap {
        protected ESObject dup() {
            ByteArray byteArray = new ByteArray();
            byteArray.value = this.value;
            return byteArray;
        }

        protected int length() {
            return ((byte[])this.value).length;
        }

        public ESBase getProperty(int n) {
            byte[] byArray = (byte[])this.value;
            if (n >= 0 && n < byArray.length) {
                return ESNumber.create(byArray[n]);
            }
            return ESBase.esEmpty;
        }

        public void setProperty(int n, ESBase eSBase) throws Exception {
            byte[] byArray = (byte[])this.value;
            if (n >= 0 && n < byArray.length) {
                byArray[n] = (byte)eSBase.toInt32();
            }
        }

        public ESBase delete(int n) throws ESException {
            byte[] byArray = (byte[])this.value;
            if (n >= 0 && n < byArray.length) {
                byArray[n] = 0;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        protected ByteArray() {
        }

        ByteArray(Global global) {
            super(global.arrayProto, null);
        }
    }

    static class ShortArray
    extends ESArrayWrap {
        protected ESObject dup() {
            ShortArray shortArray = new ShortArray();
            shortArray.value = this.value;
            return shortArray;
        }

        protected int length() {
            return ((short[])this.value).length;
        }

        public ESBase getProperty(int n) {
            short[] sArray = (short[])this.value;
            if (n >= 0 && n < sArray.length) {
                return ESNumber.create(sArray[n]);
            }
            return ESBase.esEmpty;
        }

        public void setProperty(int n, ESBase eSBase) throws Exception {
            short[] sArray = (short[])this.value;
            if (n >= 0 && n < sArray.length) {
                sArray[n] = (short)eSBase.toInt32();
            }
        }

        public ESBase delete(int n) throws ESException {
            short[] sArray = (short[])this.value;
            if (n >= 0 && n < sArray.length) {
                sArray[n] = 0;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        protected ShortArray() {
        }

        ShortArray(Global global) {
            super(global.arrayProto, null);
        }
    }

    static class CharArray
    extends ESArrayWrap {
        protected ESObject dup() {
            CharArray charArray = new CharArray();
            charArray.value = this.value;
            return charArray;
        }

        protected int length() {
            return ((char[])this.value).length;
        }

        public ESBase getProperty(int n) {
            char[] cArray = (char[])this.value;
            if (n >= 0 && n < cArray.length) {
                return ESString.create("" + cArray[n]);
            }
            return ESBase.esEmpty;
        }

        public void setProperty(int n, ESBase eSBase) throws Exception {
            char[] cArray = (char[])this.value;
            if (n >= 0 && n < cArray.length) {
                ESString eSString = eSBase.toStr();
                cArray[n] = eSString.length() > 0 ? eSString.charAt(0) : (char)'\u0000';
            }
        }

        public ESBase delete(int n) throws ESException {
            char[] cArray = (char[])this.value;
            if (n >= 0 && n < cArray.length) {
                cArray[n] = '\u0000';
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        protected CharArray() {
        }

        CharArray(Global global) {
            super(global.arrayProto, null);
        }
    }

    static class IntArray
    extends ESArrayWrap {
        protected ESObject dup() {
            IntArray intArray = new IntArray();
            intArray.value = this.value;
            return intArray;
        }

        protected int length() {
            return ((int[])this.value).length;
        }

        public ESBase getProperty(int n) {
            int[] nArray = (int[])this.value;
            if (n >= 0 && n < nArray.length) {
                return ESNumber.create(nArray[n]);
            }
            return ESBase.esEmpty;
        }

        public void setProperty(int n, ESBase eSBase) throws Exception {
            int[] nArray = (int[])this.value;
            if (n >= 0 && n < nArray.length) {
                nArray[n] = eSBase.toInt32();
            }
        }

        public ESBase delete(int n) throws ESException {
            int[] nArray = (int[])this.value;
            if (n >= 0 && n < nArray.length) {
                nArray[n] = 0;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        protected IntArray() {
        }

        IntArray(Global global) {
            super(global.arrayProto, null);
        }
    }

    static class LongArray
    extends ESArrayWrap {
        protected ESObject dup() {
            LongArray longArray = new LongArray();
            longArray.value = this.value;
            return longArray;
        }

        protected int length() {
            return ((long[])this.value).length;
        }

        public ESBase getProperty(int n) {
            long[] lArray = (long[])this.value;
            if (n >= 0 && n < lArray.length) {
                return ESNumber.create(lArray[n]);
            }
            return ESBase.esEmpty;
        }

        public void setProperty(int n, ESBase eSBase) throws Exception {
            long[] lArray = (long[])this.value;
            if (n >= 0 && n < lArray.length) {
                lArray[n] = (long)eSBase.toNum();
            }
        }

        public ESBase delete(int n) throws ESException {
            long[] lArray = (long[])this.value;
            if (n >= 0 && n < lArray.length) {
                lArray[n] = 0L;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        protected LongArray() {
        }

        LongArray(Global global) {
            super(global.arrayProto, null);
        }
    }

    static class FloatArray
    extends ESArrayWrap {
        protected ESObject dup() {
            FloatArray floatArray = new FloatArray();
            floatArray.value = this.value;
            return floatArray;
        }

        protected int length() {
            return ((float[])this.value).length;
        }

        public ESBase getProperty(int n) {
            float[] fArray = (float[])this.value;
            if (n >= 0 && n < fArray.length) {
                return ESNumber.create(fArray[n]);
            }
            return ESBase.esEmpty;
        }

        public void setProperty(int n, ESBase eSBase) throws Exception {
            float[] fArray = (float[])this.value;
            if (n >= 0 && n < fArray.length) {
                fArray[n] = (float)eSBase.toNum();
            }
        }

        public ESBase delete(int n) throws ESException {
            float[] fArray = (float[])this.value;
            if (n >= 0 && n < fArray.length) {
                fArray[n] = 0.0f;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        protected FloatArray() {
        }

        FloatArray(Global global) {
            super(global.arrayProto, null);
        }
    }

    static class DoubleArray
    extends ESArrayWrap {
        protected ESObject dup() {
            DoubleArray doubleArray = new DoubleArray();
            doubleArray.value = this.value;
            return doubleArray;
        }

        protected int length() {
            return ((double[])this.value).length;
        }

        public ESBase getProperty(int n) {
            double[] dArray = (double[])this.value;
            if (n >= 0 && n < dArray.length) {
                return ESNumber.create(dArray[n]);
            }
            return ESBase.esEmpty;
        }

        public void setProperty(int n, ESBase eSBase) throws Exception {
            double[] dArray = (double[])this.value;
            if (n >= 0 && n < dArray.length) {
                dArray[n] = eSBase.toNum();
            }
        }

        public ESBase delete(int n) throws ESException {
            double[] dArray = (double[])this.value;
            if (n >= 0 && n < dArray.length) {
                dArray[n] = 0.0;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        protected DoubleArray() {
        }

        DoubleArray(Global global) {
            super(global.arrayProto, null);
        }
    }
}

