/*
 * @(#)PhoneServlet.java	1.37 97/05/22
 * 
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.0
 */

import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

/**
 * @author  Pavani Diwanji
 */
public
class PhoneServlet extends HttpServlet { 
    private Hashtable phones;

    public void init(ServletConfig conf) throws ServletException {
        int next;
        String name, number;

	super.init(conf);
        log("PhoneServlet.initialize: enter");

        String fileName = getInitParameter("phonelist");
	if (fileName == null) {
	    return;
	}

        log("PhoneServlet.initialize: filename = " + fileName);

	try {
	    FileInputStream fin = new FileInputStream(fileName);
	    phones = new Hashtable();
	    StreamTokenizer st = new StreamTokenizer(fin);
	    st.eolIsSignificant(true);
	    st.slashSlashComments(true);

	    while ((next = st.nextToken()) != StreamTokenizer.TT_EOF) {
		switch (next) {
		  case StreamTokenizer.TT_WORD:
		    name = st.sval;
		    next = st.nextToken();
		    if (next != StreamTokenizer.TT_WORD) {
			throw new IOException("No phone for name: " + name);
		    }
		    number = st.sval;
		    break;
		  default:
		    continue;
		}
		phones.put(name, number);        
	    }
	} catch (IOException e) {
	    phones = null;
	}
    }

    public void doGet (HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
    {
	/*
	 * If the query is for a specific person then return their
	 * extension, else dump the whole extensions list
	 */
	res.setContentType("text/html");
	ServletOutputStream out = res.getOutputStream();
	String name = req.getParameter("name");

	String title = "Phones";
        out.println
	    ("<HEAD><TITLE> Phone Servlet Output </TITLE></HEAD><BODY>");

	out.println("<h1> PhoneServlet output </h1>");
	out.println("<p>");
   
	if (phones == null) {
	    out.println("No Phone List!");
	} else if (name != null) {
	    String phone = (String) phones.get(name);
	    if (phone == null) phone = "Not listed";
	    out.println(name + ": " + phone);
	} else
	    out.println(phones.toString());

        out.println("</BODY>");
    }

    public String getServletInfo() {
	return "This servlet is useful for looking up phone extensions.";
    }
}
