/*
 * @(#)EchoServlet.java	1.5 97/11/13
 * 
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.0
 */

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;


/**
 * Echo servlet.  A variation on Snoop Servlet.  This servlet will echo the input content
 * body back out with no processing.
 * @version 	1.5, 11/13/97
 * @author 	Jim Driscoll
 */

public class EchoServlet extends HttpServlet {


    // Since entity bodies are only present in POST, we'll just use that.
    public void doPost (HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
    {


	int buffsize = 1024*8;

        //value chosen to limit denial of service - 1 MB, in this case
        if (req.getContentLength() > 1*1024*1024) {  
	    res.setContentType("text/html");
            ServletOutputStream out = res.getOutputStream();
	    out.println("<html><head><title>Too big</title></head>");
	    out.println("<body><h1>Error - content length &gt;8k not ");
	    out.println("</h1></body></html>");
        } else {
	    res.setContentType("text/html");
	    ServletOutputStream out = res.getOutputStream();
	    out.println("<html>");
	    out.println("<head><title>Echo Servlet</title></head>");
	    out.println("<body>");
    
	    Enumeration e = req.getHeaderNames();
	    if (e.hasMoreElements()) {
	        out.println("<h1>Request headers:</h1>");
	        out.println("<pre>");
	        while (e.hasMoreElements()) {
		    String name = (String)e.nextElement();
		    out.println(" " + name + ": " + req.getHeader(name));
	        }
	        out.println("</pre>");
	    }
    
	    out.flush();

            out.println("<h1>Content: </h1>");
	    out.println("<pre>");
	    ServletInputStream in = req.getInputStream();

	    int contentLength = req.getContentLength();
            byte[] b = new byte[contentLength];
	    int result;
	    int totalRead = 0;

	    try {
		result = in.readLine(b, 0, b.length);
		while (result != -1) {

		    totalRead += result;
		    result = in.readLine(b, totalRead, buffsize);
		}
	    } catch (IOException ioe) {
		// Ignore, it's probably from EOF
	    }

	    out.write(b, 0, totalRead);
	    out.flush();
            
	    out.println("</pre>");
    
	    out.println("</body></html>");
	    out.flush();
        }
    }
    
    public String getServletInfo() {
	return "A servlet that shows the request headers and body sent by the client";
    }
}
