<java type="import"> java.util.Enumeration</java>
<java type="import"> java.util.Hashtable</java>
<html>
<head>
<title>EnvDumpServlet</title>
</head>
<body bgcolor="#ffffff">
<h3>EnvDumpServlet</h3>
<h4>Headers available via HttpServletRequest.getHeader() </h4>
<table border="1">

<java>
    // print headers
    Enumeration headers = request.getHeaderNames();
    while ( headers.hasMoreElements()) {
        String hdr = headers.nextElement().toString();
        out.println("<TR><TD><B>"+hdr + "</B></TD><TD>"+request.getHeader(hdr)+"</TD></TR>");
    }
    out.println("<TR><TD><B>accept</B></TD><TD>image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png, */*</TD></TR>");
</java>

</table><P>
<h4>Attributes available via HttpServletRequest.getAttribute()</h4>
<table border="1">

<java>
    // print attributes
    String prefix = "org.apache.jserv.";
    Object attrsObj = request.getAttribute("org.apache.jserv.attribute_names");
    if ( attrsObj != null && attrsObj instanceof Enumeration ) {
        Enumeration attrs = (Enumeration) attrsObj;
        while ( attrs.hasMoreElements()) {
            String attr = attrs.nextElement().toString();
            if ( request.getAttribute(prefix + attr) != null ) {
	        out.println("<TR><TD><B>"+prefix + attr + "</B></TD><TD>"+request.getAttribute(prefix + attr).toString()+"</TD></TR>");
	    } else {
	        out.println("<TR><TD><B>"+prefix + attr + "</B></TD><TD></TD></TR>");
            }
        }
    }
</java>

</table><P>
<h4>Form Elements available from HttpUtils.parsePostData()</h4>
<table border="1">

<java>
    // Look for POST data
    String post = request.getMethod();
    if(post.equals("POST")) {
        Hashtable nvPairs = HttpUtils.parsePostData(request.getIntHeader("content-length"), request.getInputStream());
        Enumeration keys = nvPairs.keys();
        while (keys.hasMoreElements()) {
            String key = (String) keys.nextElement();
            out.print("<TR><TD><B>"+key+"</B></TD><TD>");
            String[] values = (String[]) nvPairs.get(key);
	    for(int i=0; i<values.length; i++) {
	        out.print(""+values[i]+"<BR>");
            }
	    out.print("</TD></TR>");
        }
    }
</java>

</table><P>
</body>
</html>
