      <%@ page import="java.net.URL" %>
      <%@ page import="java.net.HttpURLConnection" %>
      <%@ page import="java.lang.StringBuffer" %>
      <%@ page import="java.io.StringWriter" %>
      <%@ page import="java.io.PrintWriter" %>
      <%@ page import="java.io.FileNotFoundException" %>
      <%@ page import="java.io.IOException" %>
      <%@ page import="java.io.BufferedReader" %>
      <%@ page import="java.io.InputStreamReader" %>
      <%@ page import="java.util.Vector" %>
      <%@ page import="javax.servlet.http.HttpUtils" %>
      <%@ page import="javax.servlet.http.HttpServletResponse" %>
      <%@ page import="org.gjt.jsp.test.MsgBean" %>
      <%@ page session="false" %>

<!--
	GNUJSPTest - a GNUJsp test suite (Not yet a regression test but we should try ...)

	Copyright (C) 1999, Carsten Heyl <heyl@nads.de>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
-->


<html>
  <head>
    <title>GNUJSP Testsuite</title>
  </head>

  <body bgcolor=white>
<img src="poweredbygnujsp.png" align=right alt="Powered by GNU JSP">
    <h1>GNUJSP Testsuite</h1>

    <h4>Version: $Id: main.jsp,v 1.46 1999/10/17 22:16:54 wes Exp $ </h4>

This JSP-Page tests GNUJSP features according to the
JavaServer Pages Specification Version 1.0.
Additionally old bugs are listed here.

	    <p>The following chapters from the specification
	    are integrated in this test:
<ul>
<li>2.7.1 - 2.7.6
<li>2.8, 2.9, 2.10, 2.11, 2.12, 2.13.1, 2.13.2, 2.13.3, 2.13.4, 2.13.5
</ul>
<p>The following chapters are explicitly omitted because the features
	    are not supported in gnujsp 1.0 (yet):
<ul>
    <li>2.7.7 The taglib Directive
    <li>2.13.6 jsp:plugin
</ul>

In general:

<ol>
    <li>For each feature described in the spec there should be a test here.
    <li>For each case in the Parser/Code generator there should be a test here.
    <li>For each bug encountered there should be a test case here. (Check against unfixed version!)
</ol>

<p>Some stuff is still missing. Submissions are welcome! Send them
to gnujsp@gjt.org.</p>

Click for <a href="#summary">Summary</a>

<p>Note: <strong>If all tests fail with FileNotFoundException, please search for HACK
in main.jsp and follow the instructions!</strong>
</p>

The bugs encounterd are now classified according to their severity. The following
categories are used:

	  <dl>
	    <!-- one of (dd dt) -->
	    <dt><font color="#a00000">Fatal Error</font></dt>
	    <dd>The feature tested is vital for proper operation. Circumvention
	    is difficult or impossible. It's mostly a <em>missing feature</em> bug.</dd>
	    <dt><font color="#ff0000red">Error</font></dt>
	    <dd>This bug should be fixed but circumvention is possible.
	      It's mostly a <em>missing feature</em> bug.</dd>
	    <dt><font color="yellow">Warning</font></dt>
	    <dd>This bug should be fixed but can be easily avoided. Most checks for
	      illegal parameters which should be flagged as <em>fatal translation errors</em>
	      according to the spec fall in this category.
	    </dd>
	    <dt><font color="lightblue">Unknown</font></dt>
	    <dd>For some tests I don't know if it's a bug or how to interpret the spec, or how to
		test the feature, etc. Someone should
	      comment on these.
	    </dd>
	    <dt><font color="darkblue">Not categorized</font></dt>
	    <dd>For lazyness these tests are not categorized yet.
	    </dd>
	  </dl>
<%!
    static final private int SC_OK = HttpServletResponse.SC_OK;  
    static final private int SC_INTERNAL_SERVER_ERROR = HttpServletResponse.SC_INTERNAL_SERVER_ERROR;  
    static final private int SC_NOT_FOUND = 404;

    static final private int SEV_NOT_CAT = 0; // not categorized yet
    static final private int SEV_UNKNOWN = 1; // category not known
    static final private int SEV_WARNING = 2; // 
    static final private int SEV_ERROR = 3; // 
    static final private int SEV_FATAL = 4; // 

    public class JspTestCondition {
	// check if condition is met
	public boolean isMet(String s) { return false; }
	public boolean isMet(int HTTPCode) { return HTTPCode==SC_OK; }
    }
    public class JTCMsg
	extends JspTestCondition
    {
	private String pattern = null;
	public JTCMsg(int msgCode) {
	    pattern = MsgBean.getMsg(msgCode);
	}
	public boolean isMet(String s) { return s.indexOf(pattern) != -1; }
	public String toString() { return "message:\n"+pattern; }
    }
    public class JTCPattern
	extends JspTestCondition
    {
	private String pattern = null;
	public JTCPattern(String s) {
	    pattern = s;
	}
	public boolean isMet(String s) { return s.indexOf(pattern) != -1; }
	public String toString() { return "pattern:\n"+pattern; }
    }
    public class JTCHTTPCode
	extends JspTestCondition
    {
	private int code = SC_OK;
	public JTCHTTPCode(int pcode) {
	    code = pcode;
	}
	public boolean isMet(int pcode) { return pcode == code; }
	public String toString() { return "HTTPResultCode("+code+")"; }
    }
    public class JTCAnd 
    	extends JspTestCondition
    {
	private JspTestCondition jtc1 = null;
	private JspTestCondition jtc2 = null;
	public JTCAnd(JspTestCondition pjtc1, JspTestCondition pjtc2) {
	    jtc1 = pjtc1;
	    jtc2 = pjtc2;
	}
	public boolean isMet(String s) { return jtc1.isMet(s) && jtc2.isMet(s); }
	public boolean isMet(int i) { return jtc1.isMet(i) && jtc2.isMet(i); }
	public String toString() {
	    return jtc1.toString() + "\n\n and\n\n" + jtc2.toString();
	}
    }	
    public class JTCOr 
    	extends JspTestCondition
    {
	private JspTestCondition jtc1 = null;
	private JspTestCondition jtc2 = null;
	public JTCOr(JspTestCondition pjtc1, JspTestCondition pjtc2) {
	    jtc1 = pjtc1;
	    jtc2 = pjtc2;
	}
	public JTCOr(JspTestCondition pjtc1, JspTestCondition pjtc2, JspTestCondition pjtc3) {
	    jtc1 = pjtc1;
	    jtc2 = new JTCOr(pjtc2, pjtc3);
	}
	public boolean isMet(String s) { return jtc1.isMet(s) || jtc2.isMet(s); }
	public boolean isMet(int i) { return jtc1.isMet(i) || jtc2.isMet(i); }
	public String toString() { return jtc1.toString() + "\n\n or\n\n" + jtc2.toString(); }
    }	

    public class HttpException extends IOException {
	int responseCode = 0;
	String responseHeader = "";
	String text = "";
	HttpException(int responseCode, String responseHeader, String text) {
	    this.responseCode = responseCode;
	    this.responseHeader = responseHeader;
	    this.text = text;
	}
	public String toString() {
	    return "HttpException: "+responseCode+" "+responseHeader+" ,"
		+text;
	}
    }
    // get possibly localized message
    String getMsg(int msgno, String defaultMsg) {
	if(true /*msgBean != null */) {
	    String s = MsgBean.getMsg(msgno);
	    if(s.length() > 5) {
		return s;
	    }
	}
	return defaultMsg;
    }
    String encodeAllHTML(String s) {
	  StringBuffer sb = new StringBuffer(s.length() + 100);
	  int i = 0;
	  char c = 0;
	  while(i < s.length()) {
	      c = s.charAt(i);
	      if(c == '<') {
	          sb.append("&lt;");
	      } else if(c == '>') {
	          sb.append("&gt;");
	      } else if(c == '&') {
	          sb.append("&amp;");
	      } else {
	          sb.append(c);
	      }
	      i++;
	  }
	  return sb.toString();
    }

    String failed(String s) {
	  return "<font color=\"#ff0000\">"+s+"</font>";
    }
    String failed(int severity, String s) {
	switch(severity) {
	case SEV_FATAL:
	  return "<font color=\"#a00000\">"+s+"</font>";
	case SEV_ERROR:
	  return "<font color=\"#ff0000\">"+s+"</font>";
	case SEV_WARNING:
	  return "<font color=\"yellow\">"+s+"</font>";
	case SEV_UNKNOWN:
	  return "<font color=\"lightblue\">"+s+"</font>";
	default:
	  return "<font color=\"darkblue\">"+s+"</font>";
	}
    }
    String ok(String s) {
	  return "<font color=\"#00ff00\">"+s+"</font>";
    }
    String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
    // get first lines from url
    String easyGetURL(URL url) 
        throws IOException
    {
	StringBuffer sb = null;
	HttpURLConnection conn = (HttpURLConnection) url.openConnection();
	try {
	    BufferedReader r = new BufferedReader(new InputStreamReader(conn.getInputStream()));
	    
	    sb = new StringBuffer();
	    String s = null;
	    // read first i lines
	    int i = 10;
	    while(i>0 && (s = r.readLine()) != null) {
		sb.append(s);
		sb.append("\n");
		i--;
	    }
	} catch(IOException e) {
 	    throw new HttpException(conn.getResponseCode(),
				    conn.getHeaderField(0),
				    e.toString());
	}
	//              conn.disconnect();
	if(conn.getResponseCode() != SC_OK) {
	    if(sb != null) {
		throw new IOException(url.toString() + ": "
				      +" "+sb.toString());
	    } else {
		throw new IOException(url.toString() + ": "
				      +conn.getHeaderField(0));
	    }
	} else {
	    return sb.toString();
	}
    }
    class JspTest {
	private boolean ok = false;
	protected String chapter = null;
	protected String desc = null;
        protected int severity = SEV_NOT_CAT;

	public JspTest(String chapter, String desc) {
	    this.chapter = chapter;
	    this.desc = desc;
	}
	public JspTest(int sev, String chapter, String desc) {
	    this.severity = sev;
	    this.chapter = chapter;
	    this.desc = desc;
	}
	public void doTest(JspWriter out, URL me) 
            throws IOException
	{
	}
	public boolean isOK() { return ok; }
	protected void setOK(boolean b) { ok=b; }
	public String getChapter() { return chapter; }
	public String getDesc() { return desc; }
	public int getSeverity() { return severity; }
    }
    class JspHTTPTest extends JspTest {
        private String surl = null;
	private int errorCode = 0;
	public JspHTTPTest(String chapter, String desc, 
			String surl, int errorCode) {
	    super(chapter, desc);
	    this.surl = surl;	
	    this.errorCode = errorCode;
	}
	String doTestX(JspWriter out, URL me, String surl, int httpCode) {
	    String s = null;
	    try {
		URL url = new URL(me, surl);
		try {
		    if(out != null) {
			out.println("(<a href='"+url+"'>"+url+"</a>) ");
		    }
		    s = easyGetURL(url);
		} catch(HttpException e) {
		    if(e.responseCode != httpCode) {
			return failed(encodeAllHTML(e.responseHeader+" "+e.text));
		    } else {
			setOK( true );
			return ok("OK");
		    }
		}
		if(errorCode != SC_OK) {
		    return failed(encodeAllHTML("expected http error "+errorCode+", got 200 OK:" 
					    +s));
		} else {
		    setOK( true );
		    return ok("OK");
		}
	    } /* catch(FileNotFoundException e) {
		if(httpCode != SC_NOT_FOUND) {
		    return failed("<pre>"+encodeAllHTML(e.toString() + ": "+ getStackTrace(e))+"</pre>");
		} else {
		    setOK( true );
		    return ok("OK");
		}
	    } */ catch(Exception e) {
		return failed("<pre>"+encodeAllHTML(e.toString() + ": "+ getStackTrace(e))+"</pre>");
	    }
        }
	public void doTest(JspWriter out, URL me) 
            throws IOException
	{
            out.println(doTestX(out, me, surl, errorCode));
	}
    }
    class JspHTTPContentTypeTest extends JspTest {
        private String surl = null;
	private String contentType = null;

	public JspHTTPContentTypeTest(String chapter, String desc, 
			String surl, String contentType) {
	    super(chapter, desc);
	    this.surl = surl;	
	    this.contentType = contentType;
	}
	public JspHTTPContentTypeTest(int sev,
				      String chapter, String desc, 
			String surl, String contentType) {
	    super(sev, chapter, desc);
	    this.surl = surl;	
	    this.contentType = contentType;
	}
	/* get url and check content type */
	String doTestHTTPContentType(JspWriter out, URL me, String surl, String ct) {
	    try {
		URL url = new URL(me, surl);
		if(out != null) {
		    out.println("(<a href='"+url+"'>"+url+"</a>) ");
		}
		HttpURLConnection conn = 
		    (HttpURLConnection) url.openConnection();
		BufferedReader r = 
		    new BufferedReader(new InputStreamReader(conn.getInputStream()));
             
		StringBuffer sb = new StringBuffer();
		String s = null;
		// read first i lines
		int i = 7;
		while(i>0 && (s = r.readLine()) != null) {
		    sb.append(s);
		    i--;
		}
		String connCT = conn.getContentType();
		// remove the spaces per HTTP spec.
		StringBuffer ctBuff = new StringBuffer();
		for (int ii = 0; ii < connCT.length(); ii++) {
			char ch = connCT.charAt(ii);
			if (!Character.isWhitespace(ch)) {
				ctBuff.append(ch);
			}
		}
		if(!ctBuff.toString().equals(ct)) {
		    return failed(encodeAllHTML("expected content type '"
						+ct+"', got '"
						+conn.getContentType()+"'"));
		} else {
		    setOK(true);
		    return ok("OK");
		}
	    } catch(Exception e) {
		return failed("<pre>"
			      +encodeAllHTML(e.toString() 
					     + ": "+ getStackTrace(e))
			      +"</pre>");
	    }
	}
	public void doTest(JspWriter out, URL me) 
            throws IOException
	{
            out.println(doTestHTTPContentType(out, me, surl, contentType));
	}
    }
    /** 
     * The String expected must be contained in the result from 
     * gettin the url surl.
     * If error code is given, too, it is o.k. if that error
     * code is returned.
     **/

    class JspContainTest extends JspTest {
        private String surl = null;
	private String expected = null;
	// default is: no error
	private int errorCode = SC_OK;
	private JspTestCondition jtc = null;

	public JspContainTest(String chapter, String desc, 
			      String surl, String expected) {
	    super(chapter, desc);
	    this.surl = surl;
	    this.expected = expected;
	}
	public JspContainTest(String chapter, String desc, 
			      String surl, String expected,
			      int errorCode) {
	    super(chapter, desc);
	    this.surl = surl;
	    this.expected = expected;
	    this.errorCode = errorCode;
	}
	public JspContainTest(int sev, String chapter, String desc, 
			      String surl, String expected) {
	    super(sev, chapter, desc);
	    this.surl = surl;
	    this.expected = expected;
	}
	public JspContainTest(int sev, String chapter, String desc, 
			      String surl, String expected,
			      int errorCode) {
	    super(sev, chapter, desc);
	    this.surl = surl;
	    this.expected = expected;
	    this.errorCode = errorCode;
	}
	public JspContainTest(int sev, String chapter, String desc, 
			      String surl, JspTestCondition pjtc) {
	    super(sev, chapter, desc);
	    this.surl = surl;
	    this.jtc = pjtc;
	}
	public void doTest(JspWriter out, URL me) 
            throws IOException
	{
	    String s = "";
	    try {
		s =  doTestContains(out, new URL(me, surl), expected,
				    errorCode, jtc);
            } catch(java.net.MalformedURLException e) {
	        s = failed(encodeAllHTML(e.toString()));
	    }
	    out.println(s);
	}
	/* get url and compare results */
	String doTestContains(JspWriter out, 
			      URL url, String expected,
			      int errorCode,
			      JspTestCondition jtc
			      ) {
	    // if you expect encoded strings, encode them
	    // on test creation.
	    String s2 = expected;
	    try {
		if(out != null) {
		    out.println("(<a href='"+url+"'>"+url+"</a>) ");
		}
		
		String s1 = easyGetURL(url);
		
		// does s1 contain s2?
		if((jtc != null) ? jtc.isMet(s1) : (s1.indexOf(s2) != -1)) {
		    setOK( true );
		    return ok("OK");
		} else {
		    if(jtc != null)
			s2 = jtc.toString();

		    return failed("<br>---expected ---<br><pre>"
				  +encodeAllHTML(s2)
				  +"</pre>---output was---<pre>"
				  +encodeAllHTML(s1)
				  +"</pre>--------------------"); 
		}
	    } catch(HttpException e) {
		if((jtc != null) 
		   ? jtc.isMet(e.responseCode)
		   : (e.responseCode == errorCode)) {
		    setOK( true );
		    return ok("OK");
		} else {
		    if(jtc != null)
			s2 = jtc.toString();

		    return failed("<br>---expected ---<br><pre>"
				  +encodeAllHTML(s2)
				  +"</pre>---output was---<pre>"
				  +encodeAllHTML(e.toString())
				  +"</pre>--------------------"); 
		}
	    } catch(FileNotFoundException e) {
		if((jtc != null) 
		   ? jtc.isMet(SC_NOT_FOUND)
		   : (SC_NOT_FOUND == errorCode)) {
		    setOK( true );
		    return ok("OK");
		} else 
		    return failed(encodeAllHTML(e.toString()));
	    } catch(IOException e) {
		if((jtc != null) 
		   ? jtc.isMet(SC_NOT_FOUND)
		   : (SC_NOT_FOUND == errorCode)) {
		    setOK( true );
		    return ok("OK");
		} else 
		    return failed(encodeAllHTML(e.toString()));
	    } catch(Exception e) {
		return failed(encodeAllHTML(e.toString()));
	    }
        }
    }

    String getRequestURL(HttpServletRequest req) 
	throws IOException
    {

	// HACK
	// put the absolute URL of main.jsp here if 
	// all tests give "FileNotFoundException"

	//	if(true) {
	//return "http://127.0.0.1:8010/examples/testsuite/main.jsp";
	//}

	int port = req.getServerPort();
	String strPort = "";
	if(port != 80)
		strPort = ":" + port;

	String path = req.getPathInfo();
	if(path == null || path.equals(""))
	    path = req.getServletPath();

        if(path == null)	
		throw new IOException("could not re-construct URL!");
          
	return req.getScheme()+"://"+req.getServerName()
	    +strPort+path;        
    }
%>
<%! 
    public Vector setupTests() {
    Vector t = new Vector(40);

    // Note: jswdk 1.0 reference implementation prefers SC_INTERNAL_SERVER_ERROR 
    // for exceptions.
    // FIXME: gnujsp should return an errorCode in theses cases instead of SC_OK!

    t.addElement(new JspContainTest(SEV_FATAL,
				    "0 Parsing 1","Illegal Syntax",
				    "t0-1-parse.jsp",
        new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		  new JTCPattern("No quote after name"),
		  new JTCMsg(MsgBean.ERR_gnujsp_directive_value_missing_quotes)
		  )));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.3 Comments 1","HTML Comment 1",
				    "t2_3-1-comments.jsp","Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.3 Comments 2","HTML Comment 2",
				    "t2_3-2-comments.jsp","Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.3 Comments 3","HTML Comment 3",
				    "t2_3-3-comments.jsp","Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.3 Comments 4","HTML Comment 4",
				    "t2_3-4-comments.jsp","Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.3 Comments 5","HTML Comment 5",
				    "t2_3-5-comments.jsp","Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.4 Quoting 1",
				    "quoting in scriptlet",
				    "t2_4-1-quoting.jsp",
				    "Value: value1%"+">"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.4 Quoting 2",
				    "quoting in template text",
				    "t2_4-2-quoting.jsp", 
				    "Value: <"+"%value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.4 Quoting 3",
				    "quoting in attributes",
				    "t2_4-3-quoting.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.4 Quoting 4",
				    "quoting in attributes",
				    "t2_4-4-quoting.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.4 Quoting 5",
				    "quoting in attributes: %&gt;",
				    "t2_4-5-quoting.jsp","Value: set"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.4 Quoting 6",
				    "quoting in template text",
				    "t2_4-6-quoting.jsp",
				    "value=\"<"+"%"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.4 Quoting 7",
				    "quoting in attributes: &lt;%",
				    "t2_4-7-quoting.jsp","Value: set"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 1",
				    "unknown attribute",
				    "t2_7_1-1-page-unknown.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Page directive: Invalid attribute, myunknownattribute"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_invalid_attribute))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 2",
				    "unknown lang attribute value",
				    "t2_7_1-2-page-lang.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Page directive: No mapping for language: kisuaheli"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_no_mapping_for_language))));

    t.addElement(new JspContainTest("2.7.1 Page Directive 3",
				    "page extend - unknown super class",
				    "t2_7_1-3-page-extends.jsp",
				    "not found",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_UNKNOWN,
				    "2.7.1 Page Directive 4",
				    "page extend - using setProperty",
				    "t2_7_1-4-page-extends.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_UNKNOWN,
				    "2.7.1 Page Directive 5",
				    "page extend - using getProperty",
				    "t2_7_1-5-page-extends.jsp",
				    "Value: not-set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 6",
				    "page extend, call a method on the extended class",
				    "t2_7_1-6-page-extends.jsp",
				    "Value: value1"));
    
	// NOTE: Pass content type in w/o spaces, function will
	// strip spaces from the returned value.
    t.addElement(new JspHTTPContentTypeTest("2.7.1 Page Directive 7",
				  "page, set complete contenttype -- FIXME need to ignore whitespace after semicolon",
					  "t2_7_1-7-page-contenttype.jsp", 
					  "text/html;charset=koi8-r"));

    t.addElement(new JspContainTest("2.7.1 Page Directive 8","simple import",
				"t2_7_1-8-page-import.jsp", "Value: value1"));


    t.addElement(new JspContainTest("2.7.1 Page Directive 9",
				    "2 simple imports",
				    "t2_7_1-9-page-import.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest("2.7.1 Page Directive 10",
				    "2 simple imports",
				    "t2_7_1-10-page-import.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 11",
				    "duplicate attribute definition",
				    "t2_7_1-11-page-dupcontenttype.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Exception: multiple attribute definition detected: contentType"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_duplicate_attribute_contenttype))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 12",
				    "info definition",
				    "t2_7_1-12-page-info.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 13",
				    "lang directive after script",
				    "t2_7_1-13-page-lang.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Exception: non-java language attribute after scripting element"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_no_mapping_for_language))));

    t.addElement(new JspContainTest(SEV_UNKNOWN,
				    "2.7.1 Page Directive 14",
				    "import in supported lang (not important yet)",
				    "t2_7_1-14-page-lang-import.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Page directive: No mapping for language: supportedlang"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_no_mapping_for_language))));

    t.addElement(new JspContainTest("2.7.1 Page Directive 15",
				    "session=false means no session variable",
				    "t2_7_1-15-page-session.jsp", 
				    "Undefined variable: session",
				    SC_INTERNAL_SERVER_ERROR));

    // FIXME: check for cookie in response!
    t.addElement(new JspContainTest("2.7.1 Page Directive 16",
				    "default is session=true",
				    "t2_7_1-16-page-session.jsp", 
				    "Value: value1"));

    // FIXME: check for cookie in response!
    t.addElement(new JspContainTest("2.7.1 Page Directive 17",
				    "use session=true",
				    "t2_7_1-17-page-session.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 18",
				    "buffer - testing default buffer size",
				    "t2_7_1-18-page-buffer.jsp", 
				    "Reported buffersize is"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.7.1 Page Directive 19",
				    "buffer",
				    "t2_7_1-19-page-buffer.jsp", 
				    "Reported buffersize is: 12"));

    t.addElement(new JspContainTest(SEV_UNKNOWN,
				    "2.7.1 Page Directive 20",
				    "buffer=\"none\"",
				    "t2_7_1-20-page-buffer.jsp", 
				    getMsg(MsgBean.ERR_sp10_2_7_1_illegal_clear_after_write,
					   "JspWriter: illegal clear when some data was written"),
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.7.1 Page Directive 21",
				    "buffer=\"none\", illegal autoflush=\"false\"",
				    "t2_7_1-21-page-buffer.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("buffer=\"none\" and autoFlush=\"false\" not allowed"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_invalid_value_no_buffer_no_autoflush))));


    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 22",
				    "buffer=\"1kb\" autoFlush=\"false\"",
				    "t2_7_1-22-page-buffer.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("JspWriter: buffer size exceeded"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_exceeded_buffer_size))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 23",
				    "buffer, autoFlush=\"false\" (possible overflow)",
				    "t2_7_1-23-page-buffer.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("JspWriter: buffer size exceeded"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_exceeded_buffer_size))));

    t.addElement(new JspContainTest("2.7.1 Page Directive 24",
				    "isThreadSafe=false",
				    "t2_7_1-24-page-isThreadSafe.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest("2.7.1 Page Directive 25",
				    "isThreadSafe=true",
				    "t2_7_1-25-page-isThreadSafe.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 26",
				    "isThreadSafe=illegal",
				    "t2_7_1-26-page-isThreadSafe.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Page directive: invalid value for isThreadSafe"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_invalid_value_isthreadsafe))));

    t.addElement(new JspContainTest("2.7.1 Page Directive 27",
				    "isErrorPage=false",
				    "t2_7_1-27-page-isErrorPage.jsp", 
				    "Undefined variable: exception",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest("2.7.1 Page Directive 28",
				    "default is isErrorPage=false",
				    "t2_7_1-28-page-isErrorPage.jsp", 
				    "Undefined variable: exception",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest("2.7.1 Page Directive 29",
				    "isErrorPage=true",
				    "t2_7_1-29-page-isErrorPage.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 30",
				    "isErrorPage=illegal",
				    "t2_7_1-30-page-isErrorPage.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("illegal value for attribute 'isErrorPage'"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_invalid_value_iserrorpage))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 31",
				    "errorPage=valueerrorpage.jsp",
				    "t2_7_1-31-page-errorPage.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 32",
				    "errorPage=unknownerrorpage.jsp",
				    "t2_7_1-32-page-errorPage.jsp", 
       new JTCOr(new JTCHTTPCode(SC_NOT_FOUND),
		 new JTCPattern("Unable to forward exception"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_cannot_forward_to_error_page))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 33",
				    "errorPage=http://.../unknownerrorpage.jsp (illegal absolute url)",
				    "t2_7_1-33-page-errorPage.jsp", 
       new JTCOr(new JTCHTTPCode(SC_NOT_FOUND),
		 new JTCPattern("Unable to forward exception"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_cannot_forward_to_error_page))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 34",
				    "errorPage=htmlerrorpage.html",
				    "t2_7_1-34-page-errorPage.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 35",
				    "errorPage=/testsuite/valueerrorpage.jsp",
				    "t2_7_1-35-page-errorPage.jsp", 
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 36",
				    "provide reasonable default for errorPage",
				    "t2_7_1-36-page-errorPage.jsp", 
				    "Value: value1",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest("2.7.1 Page Directive 37",
				    "check exception forwarding",
				    "t2_7_1-37-page-errorPage.jsp", 
				    "Value: value1"));

    t.addElement(new JspHTTPContentTypeTest(SEV_UNKNOWN,
					    "2.7.1 Page Directive 38",
		    "page, check default contenttype (FIXME: add '; charset=ISO-8859-1check'?)",
					  "t2_7_1-38-page-contentType.jsp", 
					  "text/html"));

    t.addElement(new JspHTTPContentTypeTest("2.7.1 Page Directive 39",
				  "page, check different contenttype syntax)",
					  "t2_7_1-39-page-contentType.jsp", 
					  "text/html;charset=ISO-8859-1"));

    t.addElement(new JspHTTPContentTypeTest("2.7.1 Page Directive 40",
				  "page, check different contenttype syntax)",
					  "t2_7_1-40-page-contentType.jsp", 
					  "text/html"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 41",
				    "buffer=\"8192\" (illegal, does not end in 'kb')",
				    "t2_7_1-41-page-buffer.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Buffer size must be of format Nkb"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_invalid_value_buffersize))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.7.1 Page Directive 42",
				    "buffer=\"kb\" (illegal, no number)",
				    "t2_7_1-42-page-buffer.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Buffer size must be of format Nkb"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_invalid_value_buffersize))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 43",
				    "provide reasonable default for errorPage (2)",
				    "t2_7_1-43-page-errorPage.jsp", 
				    "Value: value1",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 44",
				    "page extend free class (3.2.4) - using setProperty",
				    "t2_7_1-44-page-extends.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 45",
				    "page extend free class (3.2.4) - using getProperty",
				    "t2_7_1-45-page-extends.jsp",
				    "Value: not-set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 46",
				    "page extend free class (3.2.4) , call a method on the extended class",
				    "t2_7_1-46-page-extends.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.7.1 Page Directive 47",
				    "autoflush=\"false\", illegal buffer=\"none\", ",
				    "t2_7_1-47-page-buffer.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("buffer=\"none\" and autoFlush=\"false\" not allowed"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_1_invalid_value_no_buffer_no_autoflush))));

    t.addElement(
	new JspContainTest(SEV_FATAL,
			   "2.7.6 Include Directive 1",
			   "missing file attribute",
			  "t2_7_6-1-include.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("include %&gt; directive must have a \"file\" attribute"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_6_missing_attr_file))));

    t.addElement(
	new JspContainTest(SEV_ERROR,
			   "2.7.6 Include Directive 2",
			   "illegal absolute file attribute",
			   "t2_7_6-2-include.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("directive must have a relative \"file\" attribute"),
		 new JTCMsg(MsgBean.ERR_sp10_2_7_6_illegal_attr_file_must_be_relative))));

    t.addElement(
	new JspContainTest(SEV_FATAL,
			   "2.7.6 Include Directive 3",
			   "legal relative file attribute",
			   "t2_7_6-3-include.jsp", 
			   "Value: value1"));

    t.addElement(
	new JspContainTest(SEV_ERROR,
			   "2.7.6 Include Directive 4",
			   "legal server relative file attribute (will fail if testsuite is not at /testsuite)",
			   "t2_7_6-4-include.jsp", 
			   "Value: value1"));

    t.addElement(
	new JspContainTest(SEV_FATAL,
				"2.7.6 Include Directive 6",
			   "including page containing jsp tags",
			   "t2_7_6-6-include.jsp", 
			   "[[Value: value1]]"));

    t.addElement(
	new JspContainTest(SEV_FATAL,
			   "2.7.6 Include Directive 7",
			   "legal relative file attribute containing dir",
			   "t2_7_6-7-include.jsp", 
			   "[[Value: value1]]"));


    t.addElement(
	new JspContainTest(SEV_FATAL,
				"2.7.6 Include Directive 8",	
			   "including page containing jsp tags, page path contains dir",
			   "t2_7_6-8-include.jsp", 
			   "[[Value: value1]]"));

    t.addElement(
	new JspContainTest(SEV_FATAL,
			   "2.7.6 Include Directive 9",
			   "2xlegal relative file attribute containing dir",
			   "t2_7_6-9-include.jsp", 
			   "[[Value: value1value1]]"));


    t.addElement(
	new JspContainTest(SEV_FATAL,
				"2.7.6 Include Directive 10",	
			   "2xincluding page containing jsp tags, page path contains dir",
			   "t2_7_6-10-include.jsp", 
			   "[[Value: value1value1]]"));

    t.addElement(
	new JspContainTest(SEV_FATAL,
				"2.7.6 Include Directive 11",	
			   "including page containing jsp tags and html, page path contains ..",
			   "dir1/t2_7_6-11-include.jsp", 
			   "[[Value: value1value1]]"));

    t.addElement(
	new JspContainTest(SEV_FATAL,
				"2.7.6 Include Directive 12",	
			   "including page containing jsp tags and html, page path contains ../dir1",
			   "dir1/t2_7_6-12-include.jsp", 
			   "[[Value: value1value1]]"));


    t.addElement(
	new JspContainTest(SEV_FATAL,
				"2.7.6 Include Directive 13",	
			   "including page containing jsp tags and html, page path contains ../dir2",
			   "dir2/t2_7_6-13-include.jsp", 
			   "[[Value: value1value1]]"));

    t.addElement(new JspContainTest("2.8 Implicit Objects 1","request",
				  "t2_8-1-implicit-request.jsp","Value: set"));

    t.addElement(new JspContainTest("2.8 Implicit Objects 2","response",
				  "t2_8-2-implicit-response.jsp","Value: set"));

    t.addElement(new JspContainTest("2.8 Implicit Objects 3","pageContext",
				  "t2_8-3-implicit-pagecontext.jsp","Value: set"));

    t.addElement(new JspContainTest("2.8 Implicit Objects 4","session",
				  "t2_8-4-implicit-session.jsp","Value: set"));

    t.addElement(new JspContainTest("2.8 Implicit Objects 5","application",
				  "t2_8-5-implicit-application.jsp","Value: set"));

    t.addElement(new JspContainTest("2.8 Implicit Objects 6","out",
				  "t2_8-6-implicit-out.jsp","Value: set"));

    t.addElement(new JspContainTest("2.8 Implicit Objects 7","config",
				  "t2_8-7-implicit-config.jsp","Value: set"));

    t.addElement(new JspContainTest("2.8 Implicit Objects 8","page",
				  "t2_8-8-implicit-page.jsp","Value: set"));

    t.addElement(new JspContainTest("2.8 Implicit Objects 9","exception",
				  "t2_8-9-implicit-exception.jsp","Value: not-set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.10 Scripting Elements 1","syntax",
				  "t2_10-1-syntax.jsp",
				    "Value: ds1ds2ds3ds4ds5ss1ss2ss3ss4ss5es1es2es3es4"));

    t.addElement(new JspContainTest("2.10.3 Expressions", "coercion to string",
				  "t2_10_3-1-expression.jsp",
				    "Value: 1java.lang.Exception: 2 3"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.12.1 Request Time Attribute Values 1", 
				    "setProperty: value in double quotes",
				    "t2_12_1-1-reqtimeattr.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.1 Request Time Attribute Values 2", 
				    "setProperty: value in single quotes",
				    "t2_12_1-2-reqtimeattr.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.12.1 Request Time Attribute Values 3", 
				    "setProperty/useBean: name/beanName in double quotes",
				    "t2_12_1-3-reqtimeattr.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.1 Request Time Attribute Values 4", 
				    "setProperty/useBean: name/beanName in single quotes",
				    "t2_12_1-4-reqtimeattr.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.12.1 Request Time Attribute Values 5", 
				    "useBean: beanName: illegal leading space",
				    "t2_12_1-5-reqtimeattr.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("attribute: multiple expressions and mixing of expressions and string constants not permitted"),
		 new JTCMsg(MsgBean.ERR_sp10_2_12_1_invalid_value_expression_and_string))));


    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.12.1 Request Time Attribute Values 6", 
				    "setProperty: name: illegal leading space",
				    "t2_12_1-6-reqtimeattr.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("attribute: multiple expressions and mixing of expressions and string constants not permitted"),
		 new JTCMsg(MsgBean.ERR_sp10_2_12_1_invalid_value_expression_and_string))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.12.1 Request Time Attribute Values 7", 
				    "useBean: beanName: illegal trailing space",
				    "t2_12_1-7-reqtimeattr.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("attribute: multiple expressions and mixing of expressions and string constants not permitted"),
		 new JTCMsg(MsgBean.ERR_sp10_2_12_1_invalid_value_expression_and_string))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.12.1 Request Time Attribute Values 8", 
				    "setProperty: name: illegal trailing space",
				    "t2_12_1-8-reqtimeattr.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("attribute: multiple expressions and mixing of expressions and string constants not permitted"),
		 new JTCMsg(MsgBean.ERR_sp10_2_12_1_invalid_value_expression_and_string))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.12.1 Request Time Attribute Values 9", 
				    "useBean: beanName: illegal leading/trailing space",
				    "t2_12_1-9-reqtimeattr.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("attribute: multiple expressions and mixing of expressions and string constants not permitted"),
		 new JTCMsg(MsgBean.ERR_sp10_2_12_1_invalid_value_expression_and_string))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.12.1 Request Time Attribute Values 10", 
				    "setProperty: name: illegal leading/trailing space",
				    "t2_12_1-10-reqtimeattr.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("attribute: multiple expressions and mixing of expressions and string constants not permitted"),
		 new JTCMsg(MsgBean.ERR_sp10_2_12_1_invalid_value_expression_and_string))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.12.1 Request Time Attribute Values 11", 
				    "setProperty: illegal multiple expressions",
				    "t2_12_1-11-reqtimeattr.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("attribute: multiple expressions and mixing of expressions and string constants not permitted"),
		 new JTCMsg(MsgBean.ERR_sp10_2_12_1_invalid_value_expression_and_string))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.1 Request Time Attribute Values 12", 
				    "setProperty: double value in double quotes",
				    "t2_12_1-12-reqtimeattr.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.1 Request Time Attribute Values 13", 
				    "setProperty: float value in double quotes",
				    "t2_12_1-13-reqtimeattr.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.12.1 Request Time Attribute Values 14", 
				    "jsp:include: page",
				    "t2_12_1-14-reqtimeattr.jsp",
				    "Value: [[value1]]"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.1 Request Time Attribute Values 15", 
				    "jsp:include: page",
				    "t2_12_1-15-reqtimeattr.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.2 The id Attribute 1", 
	    "duplicate id's: fatal translation error (parse time or code generation time!)",
				    "t2_12_2-1-id-attribute.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("jsp:useBean: duplicated id"),
		 new JTCMsg(MsgBean.ERR_sp10_2_12_2_duplicate_id))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.2 The id Attribute 2", 
				    "id in page context",
				    "t2_12_2-2-id-attribute.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.2 The id Attribute 3", 
				    "bean in nested context, id in page context",
				    "t2_12_2-3-id-attribute.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.3 The scope Attribute 1", 
				    "page scope in PageContext",
				    "t2_12_3-1-scope-page.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.3 The scope Attribute 2", 
				    "request scope in ServletRequest",
				    "t2_12_3-2-scope-request.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.3 The scope Attribute 3", 
				    "session scope in HttpSession (FIXME: add session tracking to suite!)",
				    "t2_12_3-3-scope-session.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.3 The scope Attribute 4", 
				    "session scope in HttpSession (FIXME: add session tracking to suite!)",
				    "t2_12_3-4-scope-session.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.3 The scope Attribute 5", 
				    "application scope in ServletContext",
				    "t2_12_3-5-scope-application.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.3 The scope Attribute 6", 
				    "application scope in ServletContext (depends on test 5)",
				    "t2_12_3-6-scope-application.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.12.3 The scope Attribute 7", 
				    "application scope in ServletContext (depends on test 6)",
				    "t2_12_3-6-scope-application.jsp",
				    "Value: valuet2_12_3-6"));

    t.addElement(new JspContainTest("2.13.1 jsp:useBean 1",
				    "useBean: id,class",
				    "t2_13_1-1-jspusebean-args.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest("2.13.1 jsp:useBean 2",
				    "useBean: id,class,type",
				    "t2_13_1-2-jspusebean-args.jsp",
				    "Value: subvalue1value1"));

    t.addElement(new JspContainTest("2.13.1 jsp:useBean 3",
				    "useBean: id,type,class",
				    "t2_13_1-3-jspusebean-args.jsp",
				    "Value: subvalue1value1"));

    t.addElement(new JspContainTest("2.13.1 jsp:useBean 4",
				    "useBean: id,beanName,type",
				    "t2_13_1-4-jspusebean-args.jsp",
				    "Value: subvalue1value1"));

    t.addElement(new JspContainTest("2.13.1 jsp:useBean 5",
				    "useBean: id,type,beanName",
				    "t2_13_1-5-jspusebean-args.jsp",
				    "Value: subvalue1value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.1 jsp:useBean 6",
				    "useBean: id,type - try to instantiate undefined object",
				    "t2_13_1-6-jspusebean-args.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("java.lang.InstantiationException: jsp:useBean: could not instantiate bean"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_1_could_not_instantiate_bean))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.1 jsp:useBean 7",
				    "useBean: id,type - instantiate defined object (may fail if called as single test)",
				    "t2_13_1-7-jspusebean-args.jsp",
				    "Value: valuet2_12_3-6:value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.1 jsp:useBean 8",
				    "useBean: id, no type or class",
				    "t2_13_1-8-jspusebean-args.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("jsp:useBean: Missing type or class"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_1_missing_attr_type_or_class))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.1 jsp:useBean 9",
				    "useBean: id, class and beanName (illegal)",
				    "t2_13_1-9-jspusebean-args.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("jsp:useBean: Missing type or class"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_1_illegal_attr_class_and_beanname))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.1 jsp:useBean 10",
				    "useBean: id, class and type are incompatible",
				    "t2_13_1-10-jspusebean-args.jsp",
				    "Incompatible type",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.1 jsp:useBean 11",
				    "useBean: id, type, unknown bean in beanName",
				    "t2_13_1-11-jspusebean-args.jsp",
				    "java.lang.InstantiationException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.1 jsp:useBean 12",
				    "useBean: id,beanName,type - beanName as request-time attribute",
				    "t2_13_1-12-jspusebean-args.jsp",
				    "Value: subvalue1value1"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.1 jsp:useBean 13",
				    "useBean: id,beanName,type - ignore jsp:useBean body if object is found",
				    "t2_13_1-13-jspusebean-args.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.1 jsp:useBean 14",
				    "useBean: id,type - class has no no-args constructor (FIXME: I don't think following the spec here is needed. Your opinion?)",
				    "t2_13_1-14-jspusebean-args.jsp",
				    "InstantiationException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.1 jsp:useBean 15",
				    "useBean: id,class - process jsp:useBean body",
				    "t2_13_1-15-jspusebean-args.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.1 jsp:useBean 16",
				    "useBean: id,type - try to instantiate undefined object, don't process body (FIXME: RuntimeException is very hard and is not handled my servlet code: check reference implementation!)",
				    "t2_13_1-16-jspusebean-args.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("java.lang.InstantiationException: jsp:useBean: could not instantiate bean"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_1_could_not_instantiate_bean))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.1 jsp:useBean 17",
				    "useBean: id,type/class - incompatible classes at run time",
				    "t2_13_1-17-jspusebean-args.jsp",
				    "ClassCastException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.1 jsp:useBean 18",
				    "useBean: class only, id is missing",
				    "t2_13_1-18-jspusebean-args.jsp", 
				    getMsg(MsgBean.ERR_sp10_2_13_1_missing_attr_id,
					   "You must specify the id of the bean in a jsp:useBean tag."),
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.1 jsp:useBean 19",
				    "useBean: type only, id is missing",
				    "t2_13_1-19-jspusebean-args.jsp", 
				    getMsg(MsgBean.ERR_sp10_2_13_1_missing_attr_id,
					   "You must specify the id of the bean in a jsp:useBean tag."),
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.1 jsp:useBean 20",
				    "useBean: id,class - default scope is page",
				    "t2_13_1-20-jspusebean-args.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.1 jsp:useBean 21",
	"&lt;jsp:useBean> without a corresponding &lt;/jsp:useBean>",
				    "t2_13_1-21-jspusebean-args.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("missing closing tag"),
		 new JTCMsg(MsgBean.ERR_gnujsp_missing_closing_tag))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.1 jsp:useBean 22",
"&lt;/jsp:useBean> without a corresponding &lt;jsp:useBean>",
				    "t2_13_1-22-jspusebean-args.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("&lt;/jsp:useBean&gt; without a corresponding &lt;jsp:useBean&gt;"),
		 new JTCMsg(MsgBean.ERR_gnujsp_parse_close_tag_does_not_match_open_tag))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.1 jsp:useBean 23",
				    "useBean: id,class,scope=session and session=false (illegal)",
				    "t2_13_1-23-jspusebean-args.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("jsp:useBean: cannot specify session if session=false"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_1_illegal_session_scope))));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.1 jsp:useBean 24",
				    "useBean: id,beanName,type - ignore jsp:useBean body if object is found",
				    "t2_13_1-24-jspusebean-args.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 1",
				    "name, boolean",
				    "t2_13_2-1-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 2",
				    "name, Boolean",
				    "t2_13_2-2-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 3",
				    "name, (non)boolean",
				    "t2_13_2-3-jspsetprop.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 4",
				    "name, (non)Boolean",
				    "t2_13_2-4-jspsetprop.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 5",
				    "name, byte",
				    "t2_13_2-5-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 6",
				    "name, Byte",
				    "t2_13_2-6-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 7",
				    "name, non-byte",
				    "t2_13_2-7-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 8",
				    "name, non-Byte",
				    "t2_13_2-8-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 9",
				    "name, char",
				    "t2_13_2-9-jspsetprop.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 10",
				    "name, Char",
				    "t2_13_2-10-jspsetprop.jsp",
				    "Value: set"));

    t.addElement(new JspContainTest(SEV_UNKNOWN,
				    "2.13.2 jsp:setProperty 11 [Behavior not specified]",
				    "name, non-char",
				    "t2_13_2-11-jspsetprop.jsp",
				    "???java.lang.NumberFormatException???"));

    t.addElement(new JspContainTest(SEV_UNKNOWN,
				    "2.13.2 jsp:setProperty 12 [Behavior not specified]",
				    "name, non-Char",
				    "t2_13_2-12-jspsetprop.jsp",
				    "???java.lang.NumberFormatException???"));


    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 13",
				    "name, double",
				    "t2_13_2-13-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 14",
				    "name, Double",
				    "t2_13_2-14-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 15",
				    "name, non-double",
				    "t2_13_2-15-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 16",
				    "name, non-Double",
				    "t2_13_2-16-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));


    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 17",
				    "name, int",
				    "t2_13_2-17-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 18",
				    "name, Integer",
				    "t2_13_2-18-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 19",
				    "name, (non)int",
				    "t2_13_2-19-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 20",
				    "name, (non)Integer",
				    "t2_13_2-20-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 21",
				    "name, float",
				    "t2_13_2-21-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 22",
				    "name, Float",
				    "t2_13_2-22-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 23",
				    "name, (non)float",
				    "t2_13_2-23-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 24",
				    "name, (non)Float",
				    "t2_13_2-24-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 25",
				    "name, long",
				    "t2_13_2-25-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 jsp:setProperty 26",
				    "name, Long",
				    "t2_13_2-26-jspsetprop.jsp",
				    "Value: set:set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 27",
				    "name, (non)long",
				    "t2_13_2-27-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 28",
				    "name, (non)Long",
				    "t2_13_2-28-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 29",
				    "name, property, array value",
				    "t2_13_2-29-jspsetprop.jsp",
				    "Value: not-setvalue1value2"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 30",
				    "name, property, non array value to array",
				    "t2_13_2-30-jspsetprop.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("conversion from string not possible"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_2_impossible_string_conversion))));


    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 31",
				    "name, property, non array value to array",
				    "t2_13_2-31-jspsetprop.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("conversion from string not possible"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_2_impossible_string_conversion))));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 SetProperty 32",
				    "name, string property",
				    "t2_13_2-32-jspsetprop.jsp",
				    "Value: value1"));

    // Warning only, because its not in the Spec (1.0, 1.1)
    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.2 jsp:setProperty 33",
				    "name, short",
				    "t2_13_2-33-jspsetprop.jsp",
				    "Value: set:set"));

    // Warning only, because its not in the Spec (1.0, 1.1)
    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.2 jsp:setProperty 34",
				    "name, Short",
				    "t2_13_2-34-jspsetprop.jsp",
				    "Value: set:set"));

    // Warning only, because its not in the Spec (1.0, 1.1)
    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.2 jsp:setProperty 35",
				    "name, (non)short",
				    "t2_13_2-35-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    // Warning only, because its not in the Spec (1.0, 1.1)
    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.2 jsp:setProperty 36",
				    "name, (non)Short",
				    "t2_13_2-36-jspsetprop.jsp",
				    "java.lang.NumberFormatException",
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 SetProperty 37",
				    "name, property=*",
				    "t2_13_2-37-jspsetprop.jsp?s=value1",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 SetProperty 38",
				    "name, property=s, param=nots",
				    "t2_13_2-38-jspsetprop.jsp?nots=value1",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 39",
				    "name, int runtime attribute, double quotes",
				    "t2_13_2-39-jspsetprop.jsp",
				    "Value: 123"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 40",
				    "name, int runtime attribute, single quotes",
				    "t2_13_2-40-jspsetprop.jsp",
				    "Value: 123"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 41",
				    "name, property=s",
				    "t2_13_2-41-jspsetprop.jsp?s=value1",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 42",
				    "name, property=s, empty param",
				    "t2_13_2-42-jspsetprop.jsp?s=&t=x",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 43",
				    "name, property=s, no param",
				    "t2_13_2-42-jspsetprop.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 44",
				    "name, missing property",
				    "t2_13_2-44-jspsetprop.jsp",
				    getMsg(MsgBean.ERR_sp10_2_13_2_missing_attr_property,
					   "jsp:setProperty: missing property attribute"),
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.2 SetProperty 45",
				    "property, value, missing name",
				    "t2_13_2-45-jspsetprop.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("jsp:setProperty: using undefined bean instance"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_2_undefined_bean_instance))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 46",
				    "name, property=*, empty value",
				    "t2_13_2-46-jspsetprop.jsp",
				    "Value: not-set"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 SetProperty 47",
				    "name, property=*, empty value",
				    "t2_13_2-46-jspsetprop.jsp?s=&t=x",
				    "Value: not-set"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.2 SetProperty 48",
				    "property, value and param (illegal)",
				    "t2_13_2-48-jspsetprop.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("jsp:setProperty: illegal combination of param and value"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_2_illegal_attr_param_and_value))));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.2 SetProperty 49",
				    "name, runtime attr string property",
				    "t2_13_2-49-jspsetprop.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.2 jsp:setProperty 50",
				    "name, long - 2 setter methods available (FIXME: what SHOULD happen?)",
				    "t2_13_2-50-jspsetprop.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Exception"))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.2 jsp:setProperty 51",
				    "only jsp:useBean may define beans used in jsp:setProperty",
				    "t2_13_2-51-jspsetprop.jsp",
				    getMsg(MsgBean.ERR_sp10_2_13_2_undefined_bean_instance,
					"jsp:setProperty: using undefined bean instance"),
				    SC_INTERNAL_SERVER_ERROR));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.3 jsp:getProperty 1",
				    "missing property attribute",
				    "t2_13_3-1-jspgetprop.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Missing property attribute in a jsp:getProperty tag"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_3_missing_attr_property))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.3 jsp:getProperty 2",
				    "missing name attribute",
				    "t2_13_3-2-jspgetprop.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Missing name attribute in a jsp:getProperty tag"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_3_missing_attr_name))));
	
    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.3 jsp:getProperty 3",
				    "name, property",
				    "t2_13_3-3-jspgetprop.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.3 jsp:getProperty 4",
				    "trying to get unknown property",
				    "t2_13_3-4-jspgetprop.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("property not found"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_3_property_not_found))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.3 jsp:getProperty 5",
				    "trying to access undefined bean",
				    "t2_13_3-5-jspgetprop.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("jsp:getProperty: bean is null:"),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_3_bean_is_null))));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.3 jsp:getProperty 6",
				    "name, Integer property",
				    "t2_13_3-6-jspgetprop.jsp",
				    "Value: 1"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.4 jsp:include 1",
				    "page=\"value.html\", current dir",
				    "t2_13_4-1-jspinclude.jsp",
				    "[[Value: value1]]"));


    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.4 jsp:include 2",
				    "2x page=\"dir1/value.html\", sub dir",
				    "t2_13_4-2-jspinclude.jsp",
				    "[[Value: value1value1]]"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.4 jsp:include 3",
				    "2x page=\"/testsuite/value.html\", server absolute path",
				    "t2_13_4-3-jspinclude.jsp",
				    "[[Value: value1value1]]"));


    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.4 jsp:include 4",
				    "page=\"jspvalue2.jsp\", current dir",
				    "t2_13_4-4-jspinclude.jsp",
				    "[[Value: value1]]"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.4 jsp:include 5",
				    "2xpage=\"dir1/jspvalue2.jsp\", sub dir",
				    "t2_13_4-5-jspinclude.jsp",
				    "[[Value: value1value1]]"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.4 jsp:include 6",
				    "2xpage=\"/testsuite/jspvalue2.jsp\", server path",
				    "t2_13_4-6-jspinclude.jsp",
				    "[[Value: value1value1]]"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.4 jsp:include 7",
				    "2xpage=\"dir1/jspincvalue2.jsp\", sub dir and multi level include",
				    "t2_13_4-7-jspinclude.jsp",
				    "[[Value: value1value1value1value1]]"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.4 jsp:include 8",
				    "no args",
				    "t2_13_4-8-jspinclude.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Missing page attribute in a jsp:include tag."),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_4_missing_attr_page))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.4 jsp:include 9",
				    "page, no flush",
				    "t2_13_4-9-jspinclude.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Missing flush attribute in a jsp:include tag."),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_4_missing_attr_flush))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.4 jsp:include 10",
				    "page, illegal flush value",
				    "t2_13_4-10-jspinclude.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Attribute flush must be 'true' in a jsp:include tag."),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_4_illegal_value_flush_not_true))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.4 jsp:include 11",
				    "page, unknown page: (reference implementation checked)",
				    "t2_13_4-11-jspinclude.jsp", 
		 new JTCPattern("FileNotFoundException")));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.4 jsp:include 12",
				    "page, empty name",
				    "t2_13_4-12-jspinclude.jsp",
	new JTCOr(new JTCPattern("FileNotFoundException"),
		  new JTCPattern("Directory"))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.4 jsp:include 13",
				    "Unterminated &lt;jsp:include tag",
				    "t2_13_4-13-jspinclude.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("missing closing tag"),
		 new JTCMsg(MsgBean.ERR_gnujsp_missing_closing_tag))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.4 jsp:include 14",
				    "request time attribute",
				    "t2_13_4-14-jspinclude.jsp",
				    "[[Value: value1value1value1]]"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.4 jsp:include 15",
				    "page=\"dir1/jspincvalue3.jsp\", sub dir, include contains ..",
				    "t2_13_4-15-jspinclude.jsp",
				    "[[Value: value1value1]]"));

    t.addElement(new JspContainTest(SEV_FATAL,
				    "2.13.4 jsp:include 16",
				    "page=\"../jspvalue2.jsp\", sub dir, include contains ..",
				    "dir1/t2_13_4-16-jspinclude.jsp",
				    "[[Value: value1value1]]"));

	// FIXME: calculate zone from url of main.jsp
    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.4 jsp:include 17",
				    "page=\"/&lt;zone>/...GNUJSPTestServlet\", calling a servlet!",
				    "t2_13_4-17-jspinclude.jsp?zone=/alph",
				    "[[Value: GNUJSPTestServlet:zone:set:Value1]]"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 1",
				    "page=fullvalue.html, current dir",
				    "t2_13_5-1-jspforward.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 2",
				    "page=dir1/fullvalue.html, sub dir",
				    "t2_13_5-2-jspforward.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 3",
				    "page=/testsuite/fullvalue.html, server absolute path",
				    "t2_13_5-3-jspforward.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 4",
				    "page=fullvalue.html, request time attribute",
				    "t2_13_5-4-jspforward.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 5",
				    "page=dir1/fullvalue.html, request time attribute",
				    "t2_13_5-5-jspforward.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 6",
				    "page=jspvalue.jsp, current dir",
				    "t2_13_5-6-jspforward.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 7",
				    "forward with attribute passing",
				    "t2_13_5-7-jspforward.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 8",
				    "page=dir1/jspvalue.jsp, sub dir",
				    "t2_13_5-8-jspforward.jsp",
				    "Value: value1"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 9",
				    "page=/testsuite/jspvalue.jsp, server absolute path",
				    "t2_13_5-9-jspforward.jsp",
				    "Value: value1"));


    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 10",
				    "no args",
				    "t2_13_5-10-jspforward.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Missing page attribute in a jsp:forward tag."),
		 new JTCMsg(MsgBean.ERR_sp10_2_13_5_missing_attr_page))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.5 jsp:forward 11",
				    "page, unknown page",
				    "t2_13_5-11-jspforward.jsp", 
       new JTCOr(new JTCHTTPCode(SC_NOT_FOUND),
		 new JTCPattern("Not Found"))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.5 jsp:forward 12",
				    "page, empty name",
				    "t2_13_5-12-jspforward.jsp",
       new JTCOr(new JTCHTTPCode(SC_NOT_FOUND),
		 new JTCPattern("Directory"))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.5 jsp:forward 13",
				    "forward without closing",
				    "t2_13_5-13-jspforward.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("missing closing tag"),
		 new JTCMsg(MsgBean.ERR_gnujsp_missing_closing_tag))));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "2.13.5 jsp:forward 14",
				    "page=jspvalue.jsp, unbuffered page",
				    "t2_13_5-14-jspforward.jsp",
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("IllegalStateException"))));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 15",
				    "page=dir1/jspvalue.jsp, sub dir, destination uses include with ..",
				    "t2_13_5-15-jspforward.jsp",
				    "[[Value: value1value1]]"));

	// FIXME: calculate zone from url of main.jsp
    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.5 jsp:forward 16",
				    "page=\"/&lt;zone>/...GNUJSPTestServlet\", calling a servlet!",
				    "t2_13_5-16-jspforward.jsp?zone=/alph",
				    "[[Value: GNUJSPTestServlet:zone:set:Value1]]"));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.7 jsp:plugin",
				    "all parameters (FIXME: exact match will most probably fail on gnujsp)",
				    "t2_13_7-1-plugin.jsp",
					// FIXME: can now be described with Or/And 
				    encodeAllHTML("<OBJECT classid=\"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93\" width=\"width\"  height=\"height\"  hspace=\"hspace\"  vspace=\"vspace\"  align=\"alignment\"  codebase=\"ieplugin\">"
						  +"\n<PARAM name=\"java_code\" value=\"Molecule.class\">"
						  +"\n<PARAM name=\"java_codebase\" value=\"/html\">"
						  +"\n<PARAM name=\"java_archive\" value=\"archiveList\">"
						  +"\n<PARAM name=\"type\" value=\"application/x-java-applet;version=jreversion\">"
						  +"\n<PARAM name=\"molecule\" value=\"molecules/benzene.mol\">"
						  +"\n<COMMENT>"
						  +"\n<EMBED type=\"application/x-java-applet;version=jreversion\"  width=\"width\"  height=\"height\"  hspace=\"hspace\"  vspace=\"vspace\"  align=\"alignment\" pluginspage=\"nsplugin\" java_code=\"Molecule.class\" java_codebase=\"/html\" java_archive=\"archiveList\" molecule=\"molecules/benzene.mol\" ><NOEMBED>"
						  +"\n</COMMENT>"
						  +"\nunable to start plugin"
						  +"\n</NOEMBED></EMBED>"
						  +"\n</OBJECT>")));

    t.addElement(new JspContainTest(SEV_ERROR,
				    "2.13.7 jsp:plugin",
				    "default parameters (FIXME: exact match will most probably fail on gnujsp)",
				    "t2_13_7-1-plugin.jsp",
				    encodeAllHTML("<OBJECT classid=\"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93\" width=\"200\"  height=\"100\"  hspace=\"100\"  vspace=\"50\"  align=\"alignment\"  codebase=\"http://java.sun.com/products/plugin/1.2.2/jinstall-1_2_2-win.cab#Version=1,2,2,0\">"
						  +"\n<PARAM name=\"java_code\" value=\"Molecule.class\">"
						  +"\n<PARAM name=\"java_codebase\" value=\"/html\">"
						  +"\n<PARAM name=\"java_archive\" value=\"archiveList\">"
						  +"\n<PARAM name=\"type\" value=\"application/x-java-applet;\">"
						  +"\n<PARAM name=\"molecule\" value=\"molecules/benzene.mol\">"
						  +"\n<COMMENT>"
						  +"\n<EMBED type=\"application/x-java-applet;\"  width=\"200\"  height=\"100\"  hspace=\"100\"  vspace=\"50\"  align=\"alignment\" pluginspage=\"http://java.sun.com/products/plugin/\" java_code=\"Molecule.class\" java_codebase=\"/html\" java_archive=\"archiveList\" molecule=\"molecules/benzene.mol\" ><NOEMBED>"
						  +"\n</COMMENT>"
						  +"\nunable to start plugin"
						  +"\n</NOEMBED></EMBED>"
						  +"\n</OBJECT>")));

    t.addElement(new JspContainTest("Java 1","defining local class",
				    "java1.jsp","Value: value1"));

    t.addElement(new JspContainTest("Java 2","defining local class",
				  "java2.jsp","Value: value1"));

    t.addElement(new JspHTTPTest("Parse","Class Level 1",
				"parsecl1.jsp", SC_OK));

    t.addElement(new JspContainTest("Parse",
				  "JSP Comment 1, legal jsp tags inside",
				  "parsejc1.jsp","Value: value1"));

    t.addElement(new JspContainTest("Parse",
				  "JSP Comment 2, jsp comments do not nest",
 				  "parsejc2.jsp", 
				  "--%"+">"));

    t.addElement(new JspContainTest(SEV_WARNING,
				    "Parse","setProperty 1",
				    "parsesp1.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Error"),
		new JTCPattern("Fehler")
		)));

    t.addElement(new JspContainTest("Parse","check for complete file 1",
				  "parsecf1.jsp","first line is present"));

    t.addElement(new JspContainTest("Parse","check for complete file 2",
				  "parsecf1.jsp","last line is present"));

    
    t.addElement(
	new JspHTTPTest("Meta 1","file does not exist",
		"not-exist.jsp", SC_NOT_FOUND));

    t.addElement(
	 new JspContainTest(SEV_WARNING,
				"Runtime 1", 
			   "cannot access class which is not public",
			   "runtime1.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Runtime exception, see server log for details."))));

    t.addElement(
	 new JspContainTest(SEV_WARNING,
			"Exception 1", 
			   "test if exception message is properly HTML encoded",
			   "ex1.jsp", 
       new JTCOr(new JTCHTTPCode(SC_INTERNAL_SERVER_ERROR),
		 new JTCPattern("Send an E-Mail to Carsten Heyl &lt;alph@gjt.org&gt;"))));

    return t;
    }
%>

	<% // the main function

// this would include path to call servlet
//	  String sme = (HttpUtils.getRequestURL(request)).toString();

    String sme = getRequestURL(request);

    URL me = new URL(sme);


    out.println("<h2>Environment</h2>");

    out.println("context.getServerInfo() = "+application.getServerInfo());
    out.println("<br>me = "+sme);
    out.println("<br>me as url: = "+me.toString());
    out.println("<br>ServerPort = "+request.getServerPort());
    out.println("<br>PathInfo = '"+request.getPathInfo()+"'");
    out.println("<br>ServletPath = '"+request.getServletPath()+"'");

    // the tests 
    Vector t = setupTests();


    out.println("<h2>Tests</h2>");

    int stats[] = new int[SEV_FATAL+1];
    Vector links[] = new Vector [SEV_FATAL+1];

    for(int i = 0; i <= SEV_FATAL; i++) {
        stats[i] = 0;
        links[i] = new Vector(10);
    }
    int ok = 0;
    int num_tests = t.size();

    out.println("<dl>");
    for(int i=0; i < num_tests; i++) { 
	JspTest test = (JspTest) t.elementAt(i);

	out.println("<dt><a href=\"#details\" name=\"t"+(i+1)+"\">Test "+(i+1)
		    +"</a> - " +test.getChapter()+" - "+test.getDesc()+":"
		    +"</dt><dd>");

	try {
	    test.doTest(out, me);
	    if(!test.isOK()) {
		int sev = test.getSeverity(); 
	        stats[sev]++;
		links[sev].addElement(new Integer(i+1));
	    } else {
		ok++;
	    }
        } catch(Exception e) {
            out.println("Exception: "+encodeAllHTML(e.toString()));
        }
	out.println("</dd>");
    }
    out.println("</dl>");

    out.println("<h2><a name=\"summary\">Summary</a></h2>");
%>
    <table>
    <tr><td></td><td># of tests</td><td align="right"><%= num_tests %></td></tr>
    <tr><td><%= ok("xxxxxx") %></td><td># of succeeded tests</td><td align="right"><%= ok %></td></tr>
    <tr><td><%= failed(SEV_FATAL, "xxxxxx") %></td><td># of fatal errors   </td>
	<td align="right"><%= stats[SEV_FATAL] %></td></tr>
    <tr><td><%= failed(SEV_ERROR, "xxxxxx") %></td><td># of errors         </td>
	<td align="right"><%= stats[SEV_ERROR] %></td></tr>
    <tr><td><%= failed(SEV_WARNING, "xxxxxx")%></td><td># of warnings       </td>
	<td align="right"><%= stats[SEV_WARNING] %></td></tr>
    <tr><td><%= failed(SEV_UNKNOWN, "xxxxxx")%></td><td># of failed test (unknown category)</td>
	<td align="right"><%= stats[SEV_UNKNOWN] %></td></tr>
    <tr><td><%= failed(SEV_NOT_CAT, "xxxxxx")%></td><td># of failed test (not categorized)</td>
	<td align="right"><%= stats[SEV_NOT_CAT] %></td></tr>
    </table>
	
    <h2><a name="details">Details</a></h2>
<%
    for(int i = SEV_FATAL; i >= 0; i--) {
	out.print(failed(i, "errors: "));
	if(stats[i] != 0) {
	    Vector v = links[i];
	    for(int x = 0 ; x < v.size(); x++) {
		Integer io = (Integer) v.elementAt(x);
		out.print(" <a href=\"#t"+io+"\">"+io+"</a>");
	    }
	} else { 
	    out.println("none");
	}
	out.println("<br>");
    }

%>
<h2>Environments</h2>
<dl>
<dt>Carsten Heyl (alph) <alph@gjt.org></dt>
<dd>SuSE GNU Linux 6.2, JDK 1.1.7, Apache 1.3.6, JServ 1.0 + servlet.jar from
JSWDK 1.0
</dd>
<dt>Wes Biggs (wes) <wes@gjt.org></dt>
<dd>Redhat Linux 6.0, Blackdown JDK 1.2pre2, Apache 1.3.9 + JServ 1.0, Jigsaw 2.x, classpathx-servlet
</dd>
</dl>
<h2>History</h2>
<dl>
<dt>Sat Oct  9 PDT 1999</dt>
<dd>wes: 229/217/4/2/2 (Linux/JDK 1.2pre2/Jigsaw 2.1.0/GNUJSP)</dd>
<dd>n.b.: Jigsaw has a bug with RequestDispatcher.include()</dd>
<dd>wes: 229/223/0/1/1 (Linux/JDK 1.2pre2/Apache 1.3.9/JServ 1.0/GNUJSP)</dd>
<dt>Mon Oct  4 22:04:58 MEST 1999</dt>
<dd>alph: 229/223/0/1/1 (Linux/Apache/JDK 1.1.7/Jserv 1.0/GNUJSP)<br>
    alph: 229/220/0/2/3 (Linux/JDK 1.1.7/vqserver 1.9.17/GNUJSP)<br>
    alph: 229/200/6/5/13 (Linux/JDK 1.1.1/jswdk 1.0)
    </dd>
<dt>Sat Oct  2 22:59:29 PDT 1999</dt>
<dd>wes: 228/221/0/1/2 (Apache/Jserv 1.0/GNUJSP)</dd>
<dt>Mon Sep 27 13:37:11 MEST 1999</dt>
<dd>alph: 222/210/0/4/6 (Apache/Jserv 1.0/GNUJSP)</dd>
<dt>Thu Sep 23 20:15:59 MEST 1999 </dt>
<dd>alph: 221/195/1/17/6 (Apache/Jserv 1.0/GNUJSP)</dd>
<dt>Wed Sep 22 22:05:19 MEST 1999</dt>
    <dd>alph: 218/185/0/20/8 (Apache/Jserv 1.0/GNUJSP)<br>
    alph: 218/176/6/21/10 (vqserver 1.9.17/GNUJSP) (Note: Needed to set heap size to 100 MB!)
</dd>
<dt>Wed Sep 22 08:56:43 MEST 1999 </dt>
     <dd>alph: 205/169/0/23/8 (Apache/Jserv 1.0/GNUJSP)</dd>
<dt>Tue Sep 21 22:37:35 MEST 1999</dt>
    <dd>alph: 205/166/2/24/8 (Apache/Jserv 1.0/GNUJSP)</dd>
</dd>
<dt>Sat Sep 18 15:18:15 PDT 1999</dt>
<dd>
wes: 154/131/0/11/3 (Jigsaw 2.0.3)<BR>
wes: 154/131/0/12/3 (JServ 1.0)
</dd>
<dt>Fri Sep 17 19:23:43 MEST 1999</dt>
<dd>
alph: 131/104/2/9/7 (Apache/Jserv 1.0/GNUJSP)<BR>
alph: 131/108/2/3/10 (JSWDK 1.0)
</dd>
<dt>Thu Sep 16 22:54:35 MEST 1999</dt>
<dd>alph: 128/99/2/9/7 (Apache/Jserv 1.0/GNUJSP)</dd>
</dl>

    <hr>
    <address><a href="mailto:heyl@nads.de">Carsten Heyl</a></address>
<!-- Created: Tue Aug 31 21:30:15 MEST 1999 -->
<!-- hhmts start -->
Last modified: Wed Sep 15 14:35:56 MEST 1999
<!-- hhmts end -->
  </body>
</html>
