/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript;

import com.netscape.javascript.Context;
import com.netscape.javascript.LineBuffer;
import com.netscape.javascript.ScriptRuntime;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public class TokenStream {
    public static final int TSF_ERROR = 1;
    public static final int TSF_NEWLINES = 4;
    public static final int TSF_FUNCTION = 8;
    public static final int TSF_RETURN_EXPR = 16;
    public static final int TSF_RETURN_VOID = 32;
    public static final int TSF_REGEXP = 512;
    private static final int EOF_CHAR = -1;
    public static final int ERROR = -1;
    public static final int EOF = 0;
    public static final int EOL = 1;
    public static final int POPV = 2;
    public static final int ENTERWITH = 3;
    public static final int LEAVEWITH = 4;
    public static final int RETURN = 5;
    public static final int GOTO = 6;
    public static final int IFEQ = 7;
    public static final int IFNE = 8;
    public static final int DUP = 9;
    public static final int SETNAME = 10;
    public static final int BITOR = 11;
    public static final int BITXOR = 12;
    public static final int BITAND = 13;
    public static final int EQ = 14;
    public static final int NE = 15;
    public static final int LT = 16;
    public static final int LE = 17;
    public static final int GT = 18;
    public static final int GE = 19;
    public static final int LSH = 20;
    public static final int RSH = 21;
    public static final int URSH = 22;
    public static final int ADD = 23;
    public static final int SUB = 24;
    public static final int MUL = 25;
    public static final int DIV = 26;
    public static final int MOD = 27;
    public static final int BITNOT = 28;
    public static final int NEG = 29;
    public static final int NEW = 30;
    public static final int DELPROP = 31;
    public static final int TYPEOF = 32;
    public static final int NAMEINC = 33;
    public static final int PROPINC = 34;
    public static final int ELEMINC = 35;
    public static final int NAMEDEC = 36;
    public static final int PROPDEC = 37;
    public static final int ELEMDEC = 38;
    public static final int GETPROP = 39;
    public static final int SETPROP = 40;
    public static final int GETELEM = 41;
    public static final int SETELEM = 42;
    public static final int CALL = 43;
    public static final int NAME = 44;
    public static final int NUMBER = 45;
    public static final int STRING = 46;
    public static final int ZERO = 47;
    public static final int ONE = 48;
    public static final int NULL = 49;
    public static final int THIS = 50;
    public static final int FALSE = 51;
    public static final int TRUE = 52;
    public static final int SHEQ = 53;
    public static final int SHNE = 54;
    public static final int CLOSURE = 55;
    public static final int OBJECT = 56;
    public static final int POP = 57;
    public static final int POS = 58;
    public static final int VARINC = 59;
    public static final int VARDEC = 60;
    public static final int BINDNAME = 61;
    public static final int THROW = 62;
    public static final int IN = 63;
    public static final int INSTANCEOF = 64;
    public static final int GOSUB = 65;
    public static final int RETSUB = 66;
    public static final int CALLSPECIAL = 67;
    public static final int GETTHIS = 68;
    public static final int NEWTEMP = 69;
    public static final int USETEMP = 70;
    public static final int GETBASE = 71;
    public static final int GETVAR = 72;
    public static final int SETVAR = 73;
    public static final int UNDEFINED = 74;
    public static final int TRY = 75;
    public static final int ENDTRY = 76;
    public static final int NEWSCOPE = 77;
    public static final int TYPEOFNAME = 78;
    public static final int ENUMINIT = 79;
    public static final int ENUMNEXT = 80;
    public static final int GETPROTO = 81;
    public static final int GETPARENT = 82;
    public static final int SETPROTO = 83;
    public static final int SETPARENT = 84;
    public static final int SCOPE = 85;
    public static final int GETSCOPEPARENT = 86;
    public static final int JTHROW = 87;
    public static final int SEMI = 88;
    public static final int LB = 89;
    public static final int RB = 90;
    public static final int LC = 91;
    public static final int RC = 92;
    public static final int LP = 93;
    public static final int RP = 94;
    public static final int COMMA = 95;
    public static final int ASSIGN = 96;
    public static final int HOOK = 97;
    public static final int COLON = 98;
    public static final int OR = 99;
    public static final int AND = 100;
    public static final int EQOP = 101;
    public static final int RELOP = 102;
    public static final int SHOP = 103;
    public static final int UNARYOP = 104;
    public static final int INC = 105;
    public static final int DEC = 106;
    public static final int DOT = 107;
    public static final int PRIMARY = 108;
    public static final int FUNCTION = 109;
    public static final int EXPORT = 110;
    public static final int IMPORT = 111;
    public static final int IF = 112;
    public static final int ELSE = 113;
    public static final int SWITCH = 114;
    public static final int CASE = 115;
    public static final int DEFAULT = 116;
    public static final int WHILE = 117;
    public static final int DO = 118;
    public static final int FOR = 119;
    public static final int BREAK = 120;
    public static final int CONTINUE = 121;
    public static final int VAR = 122;
    public static final int WITH = 123;
    public static final int CATCH = 124;
    public static final int FINALLY = 125;
    public static final int RESERVED = 126;
    public static final int NOP = 127;
    public static final int NOT = 128;
    public static final int PRE = 129;
    public static final int POST = 130;
    public static final int VOID = 131;
    public static final int BLOCK = 132;
    public static final int ARRAYLIT = 133;
    public static final int OBJLIT = 134;
    public static final int LABEL = 135;
    public static final int TARGET = 136;
    public static final int LOOP = 137;
    public static final int ENUMDONE = 138;
    public static final int EXPRSTMT = 139;
    public static final int PARENT = 140;
    public static final int CONVERT = 141;
    public static final int JSR = 142;
    public static final int NEWLOCAL = 143;
    public static final int USELOCAL = 144;
    public static final int SCRIPT = 145;
    private static String[] names;
    private static Hashtable keywords;
    private LineBuffer in;
    public int flags;
    public String regExpFlags;
    private String sourceName;
    private String line;
    private int pushbackToken;
    private int tokenno;
    private int op;
    private String string = "";
    private Number number;

    static boolean isJSSpace(int n) {
        return n == 9 || n == 11 || n == 12 || n == 32;
    }

    public Number getNumber() {
        return this.number;
    }

    private static void checkNames() {
    }

    public boolean matchToken(int n) throws IOException {
        int n2 = this.getToken();
        if (n2 == n) {
            return true;
        }
        this.tokenno += -1;
        this.pushbackToken = n2;
        return false;
    }

    public int getToken() throws IOException {
        int n;
        ++this.tokenno;
        if ((this.flags & 1) != 0) {
            return -1;
        }
        if (this.pushbackToken != 0) {
            int n2 = this.pushbackToken;
            this.pushbackToken = 0;
            return n2;
        }
        while (!((n = this.in.read()) == 10 && (this.flags & 4) != 0 || !TokenStream.isJSSpace(n) && n != 10)) {
        }
        if (n == -1) {
            return 0;
        }
        if (TokenStream.isJSIdentifierStart(n)) {
            this.in.startString();
            while (TokenStream.isJSIdentifierPart(n = this.in.read())) {
            }
            this.in.unread();
            String string = this.in.getString();
            int n3 = this.stringToKeyword(string);
            if (n3 != 0) {
                return n3;
            }
            this.string = string;
            return 44;
        }
        if (TokenStream.isDigit(n) || n == 46 && TokenStream.isDigit(this.in.peek())) {
            Object[] objectArray;
            int n4 = 10;
            this.in.startString();
            double d = ScriptRuntime.NaN;
            long l = 0L;
            boolean bl = true;
            if (n == 48) {
                n = this.in.read();
                if (n == 120 || n == 88) {
                    n = this.in.read();
                    n4 = 16;
                    this.in.startString();
                } else if (TokenStream.isDigit(n)) {
                    if (n < 56) {
                        n4 = 8;
                        this.in.startString();
                    } else {
                        objectArray = new Object[]{String.valueOf((char)n)};
                        Context.reportWarning(Context.getMessage("msg.bad.octal.literal", objectArray), this.getSourceName(), this.in.getLineno(), this.getLine(), this.getOffset());
                    }
                }
            }
            while (TokenStream.isXDigit(n)) {
                if (n4 < 16 && (TokenStream.isAlpha(n) || n4 == 8 && n >= 56)) break;
                n = this.in.read();
            }
            if (n4 == 10 && (n == 46 || n == 101 || n == 69)) {
                bl = false;
                if (n == 46) {
                    while (TokenStream.isDigit(n = this.in.read())) {
                    }
                }
                if (n == 101 || n == 69) {
                    n = this.in.read();
                    if (n == 43 || n == 45) {
                        n = this.in.read();
                    }
                    if (!TokenStream.isDigit(n)) {
                        this.in.getString();
                        this.reportError("msg.missing.exponent", null);
                        return -1;
                    }
                    while (TokenStream.isDigit(n = this.in.read())) {
                    }
                }
            }
            this.in.unread();
            objectArray = this.in.getString();
            if (n4 == 10 && !bl) {
                try {
                    d = Double.valueOf((String)objectArray);
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] objectArray2 = new Object[]{numberFormatException.getMessage()};
                    this.reportError("msg.caught.nfe", objectArray2);
                    return -1;
                }
            } else {
                d = ScriptRuntime.stringToNumber((String)objectArray, 0, n4);
                l = (long)d;
                if ((double)l != d) {
                    bl = false;
                }
            }
            this.number = !bl ? (Number)new Double(d) : (Number)(-128L <= l && l <= 127L ? (Number)new Byte((byte)l) : (Number)(-32768L <= l && l <= 32767L ? (Number)new Short((short)l) : (Number)(Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE ? (Number)new Integer((int)l) : (Number)new Double(l))));
            return 45;
        }
        if (n == 34 || n == 39) {
            StringBuffer stringBuffer = null;
            int n5 = n;
            int n6 = 0;
            n = this.in.read();
            this.in.startString();
            while (n != n5) {
                if (n == 10 || n == -1) {
                    this.in.unread();
                    this.in.getString();
                    this.reportError("msg.unterminated.string.lit", null);
                    return -1;
                }
                if (n == 92) {
                    if (stringBuffer == null) {
                        this.in.unread();
                        stringBuffer = new StringBuffer(this.in.getString());
                        this.in.read();
                    }
                    n = this.in.read();
                    switch (n) {
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 118: {
                            n = 11;
                            break;
                        }
                        default: {
                            int n7;
                            int n8;
                            if (TokenStream.isDigit(n) && n < 56) {
                                n6 = n - 48;
                                n = this.in.read();
                                if (TokenStream.isDigit(n) && n < 56) {
                                    n6 = 8 * n6 + n - 48;
                                    n = this.in.read();
                                    if (TokenStream.isDigit(n) && n < 56) {
                                        n6 = 8 * n6 + n - 48;
                                        n = this.in.read();
                                    }
                                }
                                this.in.unread();
                                if (n6 > 255) {
                                    this.reportError("msg.oct.esc.too.large", null);
                                    return -1;
                                }
                                n = n6;
                                break;
                            }
                            if (n == 117) {
                                n8 = this.in.read();
                                if (!TokenStream.isXDigit(n8)) {
                                    this.in.unread();
                                    n = 117;
                                    break;
                                }
                                n6 = Character.digit((char)n8, 16);
                                n7 = this.in.read();
                                if (!TokenStream.isXDigit(n7)) {
                                    this.in.unread();
                                    stringBuffer.append('u');
                                    n = n8;
                                    break;
                                }
                                n6 = 16 * n6 + Character.digit((char)n7, 16);
                                int n9 = this.in.read();
                                if (!TokenStream.isXDigit(n9)) {
                                    this.in.unread();
                                    stringBuffer.append('u');
                                    stringBuffer.append((char)n8);
                                    n = n7;
                                    break;
                                }
                                n6 = 16 * n6 + Character.digit((char)n9, 16);
                                int n10 = this.in.read();
                                if (!TokenStream.isXDigit(n10)) {
                                    this.in.unread();
                                    stringBuffer.append('u');
                                    stringBuffer.append((char)n8);
                                    stringBuffer.append((char)n7);
                                    n = n9;
                                    break;
                                }
                                n = n6 = 16 * n6 + Character.digit((char)n10, 16);
                                break;
                            }
                            if (n != 120) break;
                            n8 = this.in.read();
                            if (!TokenStream.isXDigit(n8)) {
                                this.in.unread();
                                n = 120;
                                break;
                            }
                            n6 = Character.digit((char)n8, 16);
                            n7 = this.in.read();
                            if (!TokenStream.isXDigit(n7)) {
                                this.in.unread();
                                stringBuffer.append('x');
                                n = n8;
                                break;
                            }
                            n = n6 = 16 * n6 + Character.digit((char)n7, 16);
                        }
                    }
                }
                if (stringBuffer != null) {
                    stringBuffer.append((char)n);
                }
                n = this.in.read();
            }
            if (stringBuffer != null) {
                this.string = stringBuffer.toString();
            } else {
                this.in.unread();
                this.string = this.in.getString();
                this.in.read();
            }
            return 46;
        }
        switch (n) {
            case 10: {
                return 1;
            }
            case 59: {
                return 88;
            }
            case 91: {
                return 89;
            }
            case 93: {
                return 90;
            }
            case 123: {
                return 91;
            }
            case 125: {
                return 92;
            }
            case 40: {
                return 93;
            }
            case 41: {
                return 94;
            }
            case 44: {
                return 95;
            }
            case 63: {
                return 97;
            }
            case 58: {
                return 98;
            }
            case 46: {
                return 107;
            }
            case 124: {
                if (this.in.match('|')) {
                    return 99;
                }
                if (this.in.match('=')) {
                    this.op = 11;
                    return 96;
                }
                return 11;
            }
            case 94: {
                if (this.in.match('=')) {
                    this.op = 12;
                    return 96;
                }
                return 12;
            }
            case 38: {
                if (this.in.match('&')) {
                    return 100;
                }
                if (this.in.match('=')) {
                    this.op = 13;
                    return 96;
                }
                return 13;
            }
            case 61: {
                if (this.in.match('=')) {
                    this.op = this.in.match('=') ? 53 : 14;
                    return 101;
                }
                this.op = 127;
                return 96;
            }
            case 33: {
                if (this.in.match('=')) {
                    this.op = this.in.match('=') ? 54 : 15;
                    return 101;
                }
                this.op = 128;
                return 104;
            }
            case 60: {
                if (this.in.match('!')) {
                    if (this.in.match('-')) {
                        if (this.in.match('-')) {
                            while ((n = this.in.read()) != -1 && n != 10) {
                            }
                            this.in.unread();
                            return this.getToken();
                        }
                        this.in.unread();
                    }
                    this.in.unread();
                }
                if (this.in.match('<')) {
                    if (this.in.match('=')) {
                        this.op = 20;
                        return 96;
                    }
                    this.op = 20;
                    return 103;
                }
                if (this.in.match('=')) {
                    this.op = 17;
                    return 102;
                }
                this.op = 16;
                return 102;
            }
            case 62: {
                if (this.in.match('>')) {
                    if (this.in.match('>')) {
                        if (this.in.match('=')) {
                            this.op = 22;
                            return 96;
                        }
                        this.op = 22;
                        return 103;
                    }
                    if (this.in.match('=')) {
                        this.op = 21;
                        return 96;
                    }
                    this.op = 21;
                    return 103;
                }
                if (this.in.match('=')) {
                    this.op = 19;
                    return 102;
                }
                this.op = 18;
                return 102;
            }
            case 42: {
                if (this.in.match('=')) {
                    this.op = 25;
                    return 96;
                }
                return 25;
            }
            case 47: {
                if (this.in.match('/')) {
                    while ((n = this.in.read()) != -1 && n != 10) {
                    }
                    this.in.unread();
                    return this.getToken();
                }
                if (this.in.match('*')) {
                    while (!((n = this.in.read()) == -1 || n == 42 && this.in.match('/'))) {
                        if (n == 10 || n != 47 || !this.in.match('*')) continue;
                        if (this.in.match('/')) {
                            return this.getToken();
                        }
                        this.reportError("msg.nested.comment", null);
                        return -1;
                    }
                    if (n == -1) {
                        this.reportError("msg.unterminated.comment", null);
                        return -1;
                    }
                    return this.getToken();
                }
                if ((this.flags & 0x200) != 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n = this.in.read()) != 47) {
                        if (n == 10 || n == -1) {
                            this.in.unread();
                            this.reportError("msg.unterminated.re.lit", null);
                            return -1;
                        }
                        if (n == 92) {
                            stringBuffer.append((char)n);
                            n = this.in.read();
                        }
                        stringBuffer.append((char)n);
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    while (true) {
                        if (this.in.match('g')) {
                            stringBuffer2.append('g');
                            continue;
                        }
                        if (!this.in.match('i')) break;
                        stringBuffer2.append('i');
                    }
                    if (TokenStream.isAlpha(this.in.peek())) {
                        this.reportError("msg.invalid.re.flag", null);
                        return -1;
                    }
                    this.string = stringBuffer.toString();
                    this.regExpFlags = stringBuffer2.toString();
                    return 56;
                }
                if (this.in.match('=')) {
                    this.op = 26;
                    return 96;
                }
                return 26;
            }
            case 37: {
                this.op = 27;
                if (this.in.match('=')) {
                    return 96;
                }
                return 27;
            }
            case 126: {
                this.op = 28;
                return 104;
            }
            case 43: 
            case 45: {
                if (this.in.match('=')) {
                    if (n == 43) {
                        this.op = 23;
                        return 96;
                    }
                    this.op = 24;
                    return 96;
                }
                if (this.in.match((char)n)) {
                    if (n == 43) {
                        return 105;
                    }
                    return 106;
                }
                if (n == 45) {
                    return 24;
                }
                return 23;
            }
        }
        this.reportError("msg.illegal.character", null);
        return -1;
    }

    public String getLine() {
        return this.in.getLine();
    }

    public String tokenToString(int n) {
        return "";
    }

    public TokenStream(Reader reader, String string, int n) {
        this.in = new LineBuffer(reader, n);
        this.pushbackToken = 0;
        this.sourceName = string;
        this.flags = 0;
    }

    public int peekToken() throws IOException {
        int n;
        this.pushbackToken = n = this.getToken();
        this.tokenno += -1;
        return n;
    }

    public int peekTokenSameLine() throws IOException {
        this.flags |= 4;
        int n = this.peekToken();
        this.flags &= 0xFFFFFFFB;
        if (this.pushbackToken == 1) {
            this.pushbackToken = 0;
        }
        return n;
    }

    static boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    static boolean isXDigit(int n) {
        return n >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70;
    }

    public String getString() {
        return this.string;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    private int stringToKeyword(String string) {
        Integer n = (Integer)keywords.get(string);
        if (n == null) {
            return 0;
        }
        int n2 = n;
        this.op = n2 >> 8;
        return n2 & 0xFF;
    }

    public int getOp() {
        return this.op;
    }

    public boolean eof() {
        return this.in.eof();
    }

    public static String tokenToName(int n) {
        TokenStream.checkNames();
        if (names == null) {
            return "";
        }
        return names[n + 1];
    }

    public int getLineno() {
        return this.in.getLineno();
    }

    public int getTokenno() {
        return this.tokenno;
    }

    private void reportError(String string, Object[] objectArray) {
        this.flags |= 1;
        String string2 = Context.getMessage(string, objectArray);
        Context.reportError(string2, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    static {
        String[] stringArray = new String[]{"break", "case", "continue", "default", "delete", "do", "else", "export", "false", "for", "function", "if", "in", "new", "null", "return", "switch", "this", "true", "typeof", "var", "void", "while", "with", "abstract", "boolean", "byte", "catch", "char", "class", "const", "debugger", "double", "enum", "extends", "final", "finally", "float", "goto", "implements", "import", "instanceof", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "super", "synchronized", "throw", "throws", "transient", "try", "volatile"};
        int[] nArray = new int[]{120, 115, 121, 116, 31, 118, 113, 110, 13164, 119, 109, 112, 16230, 30, 12652, 5, 114, 12908, 13420, 8296, 122, 33640, 117, 123, 126, 126, 126, 124, 126, 126, 126, 126, 126, 126, 126, 126, 125, 126, 126, 126, 111, 16486, 126, 126, 126, 126, 126, 126, 126, 126, 126, 126, 32620, 126, 62, 126, 126, 75, 126};
        keywords = new Hashtable(stringArray.length);
        Integer n = new Integer(126);
        int n2 = 0;
        while (n2 < stringArray.length) {
            keywords.put(stringArray[n2], nArray[n2] == 126 ? n : new Integer(nArray[n2]));
            ++n2;
        }
    }

    protected static boolean isJSIdentifierStart(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95 || n == 36;
    }

    protected static boolean isJSIdentifier(String string) {
        int n = string.length();
        if (n == 0 || !TokenStream.isJSIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            if (!TokenStream.isJSIdentifierPart(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void clearPushback() {
        this.pushbackToken = 0;
    }

    public void ungetToken(int n) {
        if (this.pushbackToken != 0 && n != -1) {
            Object[] objectArray = new Object[]{this.tokenToString(n), this.tokenToString(this.pushbackToken)};
            String string = Context.getMessage("msg.token.replaces.pushback", objectArray);
            throw new RuntimeException(string);
        }
        this.pushbackToken = n;
        this.tokenno += -1;
    }

    public int getOffset() {
        return this.in.getOffset();
    }

    protected static boolean isJSIdentifierPart(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 95 || n == 36;
    }

    private static boolean isAlpha(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }
}

