/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript;

import com.netscape.javascript.CompilerState;
import com.netscape.javascript.Context;
import com.netscape.javascript.Function;
import com.netscape.javascript.MatchState;
import com.netscape.javascript.NativeFunction;
import com.netscape.javascript.NativeRegExpCtor;
import com.netscape.javascript.PropertyException;
import com.netscape.javascript.RENode;
import com.netscape.javascript.RegExpStatics;
import com.netscape.javascript.RescopeableObject;
import com.netscape.javascript.ScriptRuntime;
import com.netscape.javascript.Scriptable;
import com.netscape.javascript.ScriptableObject;
import com.netscape.javascript.SubString;

public class NativeRegExp
extends RescopeableObject
implements Function {
    public static final int GLOB = 1;
    public static final int FOLD = 2;
    private static final boolean debug = false;
    private static final int CCLASS_CHARSET_SIZE = 256;
    private static final int PR_BITS_PER_BYTE = 8;
    private static final byte REOP_EMPTY = 0;
    private static final byte REOP_ALT = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_QUANT = 6;
    private static final byte REOP_STAR = 7;
    private static final byte REOP_PLUS = 8;
    private static final byte REOP_OPT = 9;
    private static final byte REOP_LPAREN = 10;
    private static final byte REOP_RPAREN = 11;
    private static final byte REOP_DOT = 12;
    private static final byte REOP_CCLASS = 13;
    private static final byte REOP_DIGIT = 14;
    private static final byte REOP_NONDIGIT = 15;
    private static final byte REOP_ALNUM = 16;
    private static final byte REOP_NONALNUM = 17;
    private static final byte REOP_SPACE = 18;
    private static final byte REOP_NONSPACE = 19;
    private static final byte REOP_BACKREF = 20;
    private static final byte REOP_FLAT = 21;
    private static final byte REOP_FLAT1 = 22;
    private static final byte REOP_JUMP = 23;
    private static final byte REOP_DOTSTAR = 24;
    private static final byte REOP_ANCHOR = 25;
    private static final byte REOP_EOLONLY = 26;
    private static final byte REOP_UCFLAT = 27;
    private static final byte REOP_UCFLAT1 = 28;
    private static final byte REOP_UCCLASS = 29;
    private static final byte REOP_NUCCLASS = 30;
    private static final byte REOP_BACKREFi = 31;
    private static final byte REOP_FLATi = 32;
    private static final byte REOP_FLAT1i = 33;
    private static final byte REOP_UCFLATi = 34;
    private static final byte REOP_UCFLAT1i = 35;
    private static final byte REOP_ANCHOR1 = 36;
    private static final byte REOP_END = 37;
    private static final byte[] reopsize;
    private static final int REOP_FLATLEN_MAX = 255;
    private static int level;
    private static final String[] reopname;
    static final String metachars = "|^${*+?().[\\";
    static final String closurechars = "{*+?";
    private String source;
    private int lastIndex;
    private int parenCount;
    private byte flags;
    private byte[] program;
    private static /* synthetic */ Class class$com$netscape$javascript$NativeRegExp;

    public boolean getIgnoreCase() {
        return (this.flags & 2) != 0;
    }

    public static Object test(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object = NativeRegExp.execSub(context, scriptable, objectArray, function, true, function);
        if (object == null || !object.equals(Boolean.TRUE)) {
            object = Boolean.FALSE;
        }
        return object;
    }

    public static Object exec(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return NativeRegExp.execSub(context, scriptable, objectArray, function, false, function);
    }

    RENode parseQuantAtom(CompilerState compilerState) {
        RENode rENode = this.parseAtom(compilerState);
        if (rENode == null) {
            return null;
        }
        char[] cArray = compilerState.source;
        int n = compilerState.index;
        block6: while (n < cArray.length) {
            switch (cArray[n]) {
                case '{': {
                    int n2;
                    char c;
                    if (++n == cArray.length || !NativeRegExp.isDigit(c = cArray[n])) {
                        this.reportError("msg.bad.quant", String.valueOf(cArray[compilerState.index]));
                        return null;
                    }
                    int n3 = NativeRegExp.unDigit(c);
                    while (++n < cArray.length && NativeRegExp.isDigit(c = cArray[n])) {
                        if ((n3 = 10 * n3 + NativeRegExp.unDigit(c)) >> 16 == 0) continue;
                        this.reportError("msg.overlarge.max", this.tail(cArray, n));
                        return null;
                    }
                    if (cArray[n] == ',') {
                        int n4 = ++n;
                        if (NativeRegExp.isDigit(cArray[n])) {
                            n2 = NativeRegExp.unDigit(cArray[n]);
                            while (NativeRegExp.isDigit(c = cArray[++n])) {
                                if ((n2 = 10 * n2 + NativeRegExp.unDigit(c)) >> 16 == 0) continue;
                                this.reportError("msg.overlarge.max", String.valueOf(cArray[n4]));
                                return null;
                            }
                            if (n2 == 0) {
                                this.reportError("msg.zero.quant", this.tail(cArray, compilerState.index));
                                return null;
                            }
                            if (n3 > n2) {
                                this.reportError("msg.max.lt.min", this.tail(cArray, n4));
                                return null;
                            }
                        } else {
                            n2 = 0;
                        }
                    } else {
                        if (n3 == 0) {
                            this.reportError("msg.zero.quant", this.tail(cArray, compilerState.index));
                            return null;
                        }
                        n2 = n3;
                    }
                    if (cArray[n] != '}') {
                        this.reportError("msg.unterm.quant", String.valueOf(cArray[compilerState.index]));
                        return null;
                    }
                    ++n;
                    RENode rENode2 = new RENode(compilerState, 6, rENode);
                    if (n3 > 0 && (rENode.flags & 4) != 0) {
                        rENode2.flags = (byte)(rENode2.flags | 4);
                    }
                    rENode2.min = (short)n3;
                    rENode2.max = (short)n2;
                    rENode = rENode2;
                    continue block6;
                }
                case '*': {
                    if ((rENode.flags & 4) == 0) {
                        this.reportError("msg.re.empty", "*");
                        return null;
                    }
                    ++n;
                    rENode = new RENode(compilerState, 7, rENode);
                    continue block6;
                }
                case '+': {
                    if ((rENode.flags & 4) == 0) {
                        this.reportError("msg.re.empty", "+");
                        return null;
                    }
                    ++n;
                    RENode rENode2 = new RENode(compilerState, 8, rENode);
                    if ((rENode.flags & 4) != 0) {
                        rENode2.flags = (byte)(rENode2.flags | 4);
                    }
                    rENode = rENode2;
                    continue block6;
                }
                case '?': {
                    ++n;
                    rENode = new RENode(compilerState, 9, rENode);
                    continue block6;
                }
            }
        }
        compilerState.index = n;
        return rENode;
    }

    void matchBit(char c, int n, int n2) {
        int n3 = c >> 3;
        byte by = (byte)(c & 7);
        by = (byte)(1 << by);
        if (n != 0) {
            int n4 = n2 + n3;
            this.program[n4] = (byte)(this.program[n4] & ~by);
            return;
        }
        int n5 = n2 + n3;
        this.program[n5] = (byte)(this.program[n5] | by);
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private boolean anchorRegExp(CompilerState compilerState, RENode rENode) {
        int n = 0;
        char[] cArray = null;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        RENode rENode2 = rENode;
        while (rENode2.op == 10) {
            rENode2 = (RENode)rENode2.kid;
        }
        switch (rENode2.op) {
            case 1: {
                n = this.countFirstChars(rENode2);
                if (n <= 0) {
                    bl2 = true;
                    break;
                }
                cArray = new char[n];
                if ((n = this.storeFirstChars(compilerState, rENode2, cArray, 0)) == 1) {
                    n2 = 22;
                } else if (n == 2 && cArray[0] == '\\') {
                    switch (cArray[1]) {
                        case '-': 
                        case '\\': {
                            ++n3;
                            n2 = 22;
                            break;
                        }
                        case 'd': {
                            n2 = 14;
                            break;
                        }
                        case 'D': {
                            n2 = 15;
                            break;
                        }
                        case 'w': {
                            n2 = 16;
                            break;
                        }
                        case 'W': {
                            n2 = 17;
                            break;
                        }
                        case 's': {
                            n2 = 18;
                            break;
                        }
                        case 'S': {
                            n2 = 19;
                            break;
                        }
                        default: {
                            n2 = 13;
                            break;
                        }
                    }
                } else {
                    n2 = 13;
                }
                if (cArray.length != n) {
                    char[] cArray2 = new char[n - n3];
                    System.arraycopy(cArray, n3, cArray2, 0, n - n3);
                    cArray = cArray2;
                }
                bl = true;
                break;
            }
            case 21: {
                n3 = (Integer)rENode2.kid;
                cArray = new char[]{(rENode2.s != null ? rENode2.s : compilerState.source)[n3]};
                n2 = 22;
                bl = true;
                break;
            }
            case 22: {
                cArray = new char[]{rENode2.chr};
                n2 = 22;
                bl = true;
                break;
            }
            default: {
                bl2 = true;
            }
            case 24: 
        }
        if (bl) {
            RENode rENode3 = new RENode(compilerState, (byte)n2, new Integer(0));
            rENode3.s = cArray;
            rENode3.flags = (byte)6;
            if (n2 == 22) {
                rENode3.chr = cArray[0];
            } else if (n2 == 13) {
                rENode3.kid2 = n;
            }
            rENode2 = new RENode(compilerState, rENode.op, rENode.kid);
            rENode2.flags = (byte)(rENode.flags | 8);
            rENode2.next = rENode.next;
            rENode2.kid2 = rENode.kid2;
            rENode2.num = rENode.num;
            rENode2.chr = rENode.chr;
            rENode2.min = rENode.min;
            rENode2.max = rENode.max;
            rENode.op = (byte)36;
            rENode.flags = (byte)16;
            rENode.next = rENode2;
            rENode.kid = rENode3;
            rENode.kid2 = 0;
        }
        if (bl2) {
            if (rENode2.op == 25 || (rENode2.flags & 8) != 0) {
                throw new RuntimeException();
            }
            if ((rENode2.flags & 5) == 4) {
                rENode2 = new RENode(compilerState, rENode.op, rENode.kid);
                rENode2.flags = (byte)(rENode.flags | 8);
                rENode2.next = rENode.next;
                rENode2.kid2 = rENode.kid2;
                rENode2.num = rENode.num;
                rENode2.chr = rENode.chr;
                rENode2.min = rENode.min;
                rENode2.max = rENode.max;
                rENode.op = (byte)25;
                rENode.flags = (byte)16;
                rENode.next = rENode2;
                rENode.kid = null;
                rENode.kid2 = 0;
            }
        }
        return true;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void optimizeRegExp(CompilerState var1_1, RENode var2_2) {
        var6_3 = null;
        var9_4 = 0;
        var10_5 = var1_1.source;
        var11_6 = false;
        var12_7 = null;
        block15: do {
            cfr_temp_0 = 0;
            block16: do {
                block0 : switch (cfr_temp_0 == 0 ? var2_2.op : cfr_temp_0) {
                    case 7: {
                        var3_8 = (RENode)var2_2.kid;
                        if ((var3_8.flags & 2) != 0) break;
                        var2_2.op = 1;
                        var6_3 = var2_2.next;
                        var4_9 = new RENode(var1_1, 23, null);
                        this.fixNext(var1_1, var3_8, var4_9, var6_3);
                        var4_9.next = var2_2;
                        if ((var2_2.flags & 8) != 0) {
                            var2_2.flags = (byte)(var2_2.flags | 32);
                        }
                        this.closeTail(var1_1, var2_2, var6_3);
                        break;
                    }
                    case 8: {
                        var3_8 = (RENode)var2_2.kid;
                        if ((var3_8.flags & 2) != 0) break;
                        var6_3 = var2_2.next;
                        var7_11 = var2_2.flags & 16;
                        var2_2.copy(var3_8);
                        var4_9 = new RENode(var1_1, 23, null);
                        var5_10 = new RENode(var1_1, 1, var4_9);
                        this.fixNext(var1_1, var2_2, var5_10, var6_3);
                        var5_10.flags = (byte)(var5_10.flags | var7_11);
                        var4_9.next = var2_2;
                        if ((var2_2.flags & 8) != 0) {
                            var2_2.flags = (byte)(var2_2.flags | 32);
                        }
                        this.closeTail(var1_1, var5_10, var6_3);
                        break;
                    }
                    case 9: {
                        var3_8 = (RENode)var2_2.kid;
                        if ((var3_8.flags & 2) != 0) break;
                        var2_2.op = 1;
                        var6_3 = var2_2.next;
                        var4_9 = new RENode(var1_1, 23, null);
                        this.fixNext(var1_1, var3_8, var4_9, var6_3);
                        var4_9.next = var6_3;
                        this.closeTail(var1_1, var2_2, var6_3);
                        var6_3.flags = (byte)(var6_3.flags | 32);
                        break;
                    }
                    case 22: {
                        var6_3 = var2_2.next;
                        if (var6_3 != null && (var6_3.flags & 32) == 0 && (var6_3.op == 21 || var6_3.op == 22)) {
                            var12_7 = new StringBuffer();
                            var12_7.append(var2_2.chr);
                            if (var6_3.op == 21) {
                                var13_13 = (Integer)var6_3.kid;
                                var9_4 = var6_3.kid2 - var13_13;
                                var12_7.append(var10_5, var13_13, var9_4);
                            } else {
                                var12_7.append(var6_3.chr);
                                var9_4 = 1;
                            }
                            ++var9_4;
                            var2_2.op = (byte)21;
                            var2_2.flags = (byte)(var2_2.flags | 64);
                            var11_6 = true;
                            cfr_temp_0 = 21;
                            continue block16;
                        }
                        var11_6 = false;
                        break;
                    }
                    default: {
                        break;
                    }
                    while (true) {
                        if (!var11_6) {
                            var12_7 = new StringBuffer();
                            var13_13 = (Integer)var2_2.kid;
                            var9_4 = var2_2.kid2 - var13_13;
                            var12_7.append(var2_2.s != null ? var2_2.s : var10_5, var13_13, var9_4);
                            if (var6_3.op == 21) {
                                var14_14 = (Integer)var6_3.kid;
                                var8_12 = var6_3.kid2 - var14_14;
                                var12_7.append(var10_5, var14_14, var8_12);
                            } else {
                                var8_12 = 1;
                                var12_7.append(var6_3.chr);
                            }
                            if (var9_4 + var8_12 > 255) break block0;
                            var9_4 += var8_12;
                        }
                        var11_6 = false;
                        var2_2.kid = new Integer(0);
                        if ((var2_2.flags & 16) == 0) {
                            throw new RuntimeException();
                        }
                        if ((var6_3.flags & 16) == 0) {
                            var2_2.flags = (byte)(var2_2.flags & -17);
                        }
                        var2_2.kid2 = var9_4;
                        var2_2.next = var6_3.next;
                        var2_2.s = var12_7.toString().toCharArray();
                        cfr_temp_0 = 21;
                        var6_3.op = 0;
                        break;
                    }
                    case 21: {
                        if (var11_6 || (var6_3 = var2_2.next) != null && (var6_3.flags & 32) == 0 && (var6_3.op == 21 || var6_3.op == 22)) ** continue;
                    }
                }
                break;
            } while (true);
            var2_2.offset = (short)var1_1.progLength;
            var1_1.progLength += NativeRegExp.reopsize[var2_2.op];
            cfr_temp_1 = 0;
            do {
                block7 : switch (cfr_temp_1 == 0 ? var2_2.op : cfr_temp_1) {
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 36: {
                        this.optimizeRegExp(var1_1, (RENode)var2_2.kid);
                        break;
                    }
                    case 13: {
                        var13_13 = (Integer)var2_2.kid;
                        var14_14 = var2_2.kid2;
                        var9_4 = var14_14 - var13_13;
                        var15_15 = 0;
                        v0 = var16_16 = var2_2.s != null ? var2_2.s : var1_1.source;
                        while (true) {
                            if (var13_13 >= var14_14) {
                                if (var15_15 < 256) break block7;
                                var2_2.op = (byte)29;
                                var17_17 = (var15_15 + 8) / 8;
                                var2_2.kidlen = (short)var9_4;
                                var2_2.bmsize = (short)var17_17;
                                var1_1.progLength -= NativeRegExp.reopsize[13];
                                var1_1.progLength += NativeRegExp.reopsize[29] + var17_17;
                                break block7;
                            }
                            if ((var17_17 = var16_16[var13_13++]) == 92) {
                                if (var13_13 + 5 > var14_14 || var16_16[var13_13] != 'u' || !NativeRegExp.isHex(var16_16[var13_13 + 1]) || !NativeRegExp.isHex(var16_16[var13_13 + 2]) || !NativeRegExp.isHex(var16_16[var13_13 + 3]) || !NativeRegExp.isHex(var16_16[var13_13 + 4])) continue;
                                var18_18 = (((NativeRegExp.unHex(var16_16[var13_13]) << 4) + NativeRegExp.unHex(var16_16[var13_13 + 1]) << 4) + NativeRegExp.unHex(var16_16[var13_13 + 2]) << 4) + NativeRegExp.unHex(var16_16[var13_13 + 3]);
                                var17_17 = (char)var18_18;
                                var13_13 += 5;
                            }
                            if ((var1_1.flags & 2) != 0) {
                                var18_18 = Character.toUpperCase((char)var17_17);
                                if (var18_18 > var15_15) {
                                    var15_15 = var18_18;
                                }
                                if ((var18_18 = Character.toLowerCase((char)var18_18)) > var15_15) {
                                    var15_15 = var18_18;
                                }
                            }
                            if (var17_17 <= var15_15) continue;
                            var15_15 = var17_17;
                        }
                    }
                    case 21: {
                        var13_13 = (Integer)var2_2.kid;
                        var14_14 = var2_2.kid2;
                        var9_4 = var14_14 - var13_13;
                        while (var13_13 < var14_14) {
                            if ((var15_15 = var10_5[var13_13++]) >>> 8 == 0) continue;
                            var2_2.op = (byte)27;
                            var9_4 *= 2;
                            break;
                        }
                        var1_1.progLength += var9_4;
                        break;
                    }
                    case 22: {
                        var13_13 = var2_2.chr;
                        if (var13_13 >>> 8 == 0) break;
                        var2_2.op = (byte)28;
                        ++var1_1.progLength;
                        break;
                    }
                    case 37: {
                        return;
                    }
                    default: {
                        break;
                    }
                    while (true) {
                        cfr_temp_1 = 23;
                        var2_2.next = var6_3.next;
                        break;
                    }
                    case 23: {
                        if ((var6_3 = var2_2.next) != null && var6_3.op == 23) ** continue;
                        break;
                    }
                }
                continue block15;
            } while (true);
        } while ((var2_2.flags & 16) != 0 && (var2_2 = var2_2.next) != null);
    }

    private void setNext(CompilerState compilerState, RENode rENode, RENode rENode2) {
        this.fixNext(compilerState, rENode, rENode2, null);
    }

    private int matchRegExp(MatchState matchState, byte[] byArray, int n, char[] cArray, int n2) {
        boolean bl = false;
        int n3 = 0;
        Context context = Context.getContext();
        RegExpStatics regExpStatics = context.getRegExpStatics();
        int[] nArray = new int[1];
        int n4 = matchState.pcend;
        int n5 = matchState.cpbegin;
        int n6 = matchState.cpend;
        block25: while (n < n4) {
            byte by = byArray[n];
            int n7 = reopsize[by];
            block0 : switch (by) {
                case 0: {
                    n += n7;
                    continue block25;
                }
                case 1: {
                    int n8 = this.readShort(byArray, n);
                    int n9 = n + n7;
                    if (n + n8 >= byArray.length || byArray[n + n8] != 1) {
                        n = n9;
                        continue block25;
                    }
                    int n10 = this.matchRegExp(matchState, byArray, n9, cArray, n2);
                    if (n10 != -1) {
                        return n10;
                    }
                    n += n8;
                    continue block25;
                }
                case 2: {
                    int n11;
                    int n10;
                    boolean bl2 = bl = n2 == n5;
                    if (regExpStatics.multiline) {
                        if (matchState.anchoring) {
                            if (!bl) {
                                bl = cArray[n2 - 1] == '\n';
                            }
                        } else {
                            matchState.anchoring = true;
                            n10 = n2;
                            while (n10 < n6) {
                                if ((n10 == n5 || cArray[n10 - 1] == '\n') && (n11 = this.matchRegExp(matchState, byArray, n, cArray, n10)) != -1) {
                                    matchState.skipped = n10 - n2;
                                    matchState.anchoring = false;
                                    return n11;
                                }
                                ++n10;
                            }
                            matchState.anchoring = false;
                        }
                    }
                    n3 = 0;
                    break;
                }
                case 3: 
                case 26: {
                    int n11;
                    int n10;
                    boolean bl3 = bl = n2 == n6;
                    if (by == 3 || matchState.anchoring) {
                        if (!bl && regExpStatics.multiline) {
                            bl = cArray[n2] == '\n';
                        }
                    } else {
                        matchState.anchoring = true;
                        n10 = n2;
                        while (n10 <= n6) {
                            if ((n10 == n6 || cArray[n10] == '\n') && (n11 = this.matchRegExp(matchState, byArray, n, cArray, n10)) != -1) {
                                matchState.anchoring = false;
                                matchState.skipped = n10 - n2;
                                return n11;
                            }
                            ++n10;
                        }
                        matchState.anchoring = false;
                    }
                    n3 = 0;
                    break;
                }
                case 4: {
                    bl = (n2 == n5 || !NativeRegExp.isWord(cArray[n2 - 1])) ^ (n2 >= cArray.length || !NativeRegExp.isWord(cArray[n2]));
                    n3 = 0;
                    break;
                }
                case 5: {
                    bl = (n2 == n5 || !NativeRegExp.isWord(cArray[n2 - 1])) ^ (n2 < cArray.length && NativeRegExp.isWord(cArray[n2]));
                    n3 = 0;
                    break;
                }
                case 6: {
                    int n10;
                    int n9 = n;
                    n7 = this.readShort(this.program, n9);
                    int n8 = this.readShort(this.program, n9 += 2);
                    char c2 = this.readShort(this.program, n9 += 2);
                    n9 += 3;
                    matchState.pcend = n + n7;
                    int n12 = 0;
                    while (n12 < n8) {
                        if ((n2 = this.matchRegExp(matchState, this.program, n9, cArray, n2)) == -1) {
                            matchState.pcend = n4;
                            return -1;
                        }
                        ++n12;
                    }
                    while (c2 == '\u0000' || n12 < c2) {
                        n10 = this.matchRegExp(matchState, this.program, n9, cArray, n2);
                        if (n10 == -1) break;
                        n2 = n10;
                        ++n12;
                    }
                    matchState.pcend = n4;
                    bl = n8 <= n12 && (c2 == '\u0000' || n12 <= c2);
                    n3 = 0;
                    break;
                }
                case 10: {
                    int n10;
                    int n12 = this.readShort(this.program, n);
                    SubString subString = matchState.maybeParens[n12];
                    if (subString == null) {
                        subString = matchState.maybeParens[n12] = new SubString();
                    }
                    int n8 = subString.index;
                    subString.charArray = cArray;
                    subString.index = n2;
                    int n11 = this.matchRegExp(matchState, this.program, n += n7, cArray, n2);
                    if (n11 == -1) {
                        subString.index = n8;
                        return -1;
                    }
                    subString = matchState.parens[n12];
                    if (subString == null) {
                        subString = matchState.parens[n12] = new SubString();
                    }
                    if (subString.index == 0) {
                        subString.charArray = cArray;
                        n10 = n5 + matchState.start + matchState.skipped;
                        if (n2 < n10) {
                            subString.index = n10;
                            subString.length -= n10 - n2;
                        } else {
                            subString.index = n2;
                        }
                    }
                    return n11;
                }
                case 11: {
                    int n9;
                    int n12 = this.readShort(this.program, n);
                    SubString subString = matchState.maybeParens[n12];
                    if (subString == null) {
                        subString = matchState.maybeParens[n12] = new SubString();
                    }
                    subString.length = n9 = n2 - subString.index;
                    if ((n2 = this.matchRegExp(matchState, this.program, n += n7, cArray, n2)) != -1) {
                        subString = matchState.parens[n12];
                        if (subString == null) {
                            subString = matchState.parens[n12] = new SubString();
                        }
                        if (subString.index == 0) {
                            subString.length = n9;
                        }
                        if (n12 >= matchState.parenCount) {
                            matchState.parenCount = n12 + 1;
                        }
                    }
                    return n2;
                }
                case 20: {
                    int n12 = this.program[n + 1];
                    SubString subString = matchState.maybeParens[n12];
                    if (subString == null) {
                        subString = matchState.maybeParens[n12] = new SubString();
                    }
                    boolean bl4 = bl = n6 - n2 >= (n3 = subString.length);
                    if (!bl) break;
                    char c2 = '\u0000';
                    while (c2 < n3) {
                        if (cArray[n2 + c2] != subString.charArray[subString.index + c2]) {
                            bl = false;
                            break block0;
                        }
                        ++c2;
                    }
                    break;
                }
                case 31: {
                    char c;
                    int n12 = this.program[n + 1];
                    SubString subString = matchState.maybeParens[n12];
                    if (subString == null) {
                        subString = matchState.maybeParens[n12] = new SubString();
                    }
                    boolean bl5 = bl = n6 - n2 >= (n3 = subString.length);
                    if (!bl) break;
                    char c2 = '\u0000';
                    while (c2 < n3) {
                        c = cArray[n2 + c2];
                        char c3 = subString.charArray[subString.index + c2];
                        boolean bl6 = bl = c == c3 || this.matchCharsIgnoringCase(c, c3);
                        if (!bl) break block0;
                        ++c2;
                    }
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 22: 
                case 28: 
                case 29: 
                case 30: 
                case 33: 
                case 35: {
                    nArray[0] = n7;
                    bl = this.matchSingleCases(by, cArray, n2, n6, this.program, n, nArray);
                    n7 = nArray[0];
                    n3 = 1;
                    break;
                }
                case 7: {
                    int n11;
                    by = this.program[++n];
                    n7 = reopsize[by];
                    int n10 = n2;
                    while (n2 < n6) {
                        nArray[0] = n7;
                        bl = this.matchSingleCases(by, cArray, n2, n6, this.program, n, nArray);
                        n7 = nArray[0];
                        n3 = 1;
                        if (!bl) break;
                        ++n2;
                    }
                    n += n7;
                    do {
                        if ((n11 = this.matchRegExp(matchState, this.program, n, cArray, n2)) == -1) continue;
                        return n11;
                    } while (--n2 >= n10);
                    return -1;
                }
                case 8: {
                    int n11;
                    by = this.program[++n];
                    n7 = reopsize[by];
                    int n10 = n2;
                    while (n2 < n6) {
                        nArray[0] = n7;
                        bl = this.matchSingleCases(by, cArray, n2, n6, this.program, n, nArray);
                        n7 = nArray[0];
                        n3 = 1;
                        if (!bl) break;
                        ++n2;
                    }
                    if (n2 == n10) {
                        return -1;
                    }
                    ++n10;
                    n += n7;
                    do {
                        if ((n11 = this.matchRegExp(matchState, this.program, n, cArray, n2)) == -1) continue;
                        return n11;
                    } while (--n2 >= n10);
                    return -1;
                }
                case 9: {
                    int n10;
                    by = this.program[++n];
                    nArray[0] = reopsize[by];
                    bl = this.matchSingleCases(by, cArray, n2, n6, this.program, n, nArray);
                    n7 = nArray[0];
                    n3 = 1;
                    if (!bl || (n10 = this.matchRegExp(matchState, this.program, n += n7, cArray, n2 + 1)) == -1) continue block25;
                    return n10;
                }
                case 21: {
                    n3 = this.program[n + 1];
                    n7 += n3;
                    boolean bl7 = bl = n2 + n3 <= n6;
                    if (!bl) break;
                    int n8 = 0;
                    while (n8 < n3) {
                        if (cArray[n2 + n8] != (char)(this.program[n + 2 + n8] & 0xFF)) {
                            bl = false;
                            break block0;
                        }
                        ++n8;
                    }
                    break;
                }
                case 32: {
                    char c;
                    char c2;
                    n3 = this.program[n + 1];
                    n7 += n3;
                    boolean bl8 = bl = n2 + n3 <= n6;
                    if (!bl) break;
                    int n8 = 0;
                    while (n8 < n3) {
                        c2 = cArray[n2 + n8];
                        c = (char)(this.program[n + 2 + n8] & 0xFF);
                        boolean bl9 = bl = c2 == c || this.matchCharsIgnoringCase(c2, c);
                        if (!bl) break block0;
                        ++n8;
                    }
                    break;
                }
                case 27: {
                    char c;
                    char c2;
                    n3 = this.program[n + 1];
                    n7 += 2 * n3;
                    boolean bl10 = bl = n2 + n3 <= n6;
                    if (!bl) break;
                    int n9 = n + 2;
                    int n8 = 0;
                    while (n8 < n3) {
                        c2 = cArray[n2 + n8];
                        c = (char)(this.program[n9++] << 8);
                        boolean bl11 = bl = c2 == (c = (char)(c | this.program[n9++] & 0xFF));
                        if (!bl) break block0;
                        ++n8;
                    }
                    break;
                }
                case 34: {
                    char c;
                    char c2;
                    n3 = this.program[n + 1];
                    n7 += 2 * n3;
                    boolean bl12 = bl = n2 + n3 <= n6;
                    if (!bl) break;
                    int n9 = n + 2;
                    int n8 = 0;
                    while (n8 < n3) {
                        c2 = cArray[n2 + n8];
                        c = (char)(this.program[n9++] << 8);
                        boolean bl13 = bl = c2 == (c = (char)(c | this.program[n9++] & 0xFF)) || this.matchCharsIgnoringCase(c2, c);
                        if (!bl) break block0;
                        ++n8;
                    }
                    break;
                }
                case 23: {
                    n7 = this.readShort(this.program, n);
                    n += n7;
                    continue block25;
                }
                case 24: {
                    int n11;
                    int n10 = n2;
                    while (n10 < n6) {
                        if (cArray[n10] == '\n') break;
                        ++n10;
                    }
                    int n9 = n + n7;
                    while (n10 >= n2) {
                        n11 = this.matchRegExp(matchState, this.program, n9, cArray, n10);
                        if (n11 != -1) {
                            return n11;
                        }
                        --n10;
                    }
                    return -1;
                }
                case 25: {
                    int n11;
                    int n9 = n + n7;
                    if (n9 == n4) break;
                    int n10 = n2;
                    while (n10 < n6) {
                        n11 = this.matchRegExp(matchState, this.program, n9, cArray, n10);
                        if (n11 != -1) {
                            matchState.skipped = n10 - n2;
                            return n11;
                        }
                        ++n10;
                    }
                    return -1;
                }
                case 36: {
                    int n11;
                    int n9;
                    by = this.program[++n];
                    int n10 = n2;
                    while (n2 < n6) {
                        nArray[0] = n7 = reopsize[by];
                        bl = this.matchSingleCases(by, cArray, n2, n6, this.program, n, nArray);
                        if (bl) {
                            n7 = nArray[0];
                            n9 = n + n7;
                            if (n9 >= n4) {
                                throw new RuntimeException();
                            }
                            n11 = this.matchRegExp(matchState, this.program, n9, cArray, n2);
                            if (n11 != -1) {
                                matchState.skipped = n2 - n10;
                                return n11;
                            }
                        }
                        ++n2;
                    }
                    return -1;
                }
                default: {
                    throw new RuntimeException("Unexpected op");
                }
            }
            if (!bl) {
                return -1;
            }
            n += n7;
            if (n3 == 0 || (n2 += n3) <= n6) continue;
            n2 = n6;
        }
        return n2;
    }

    Object executeRegExp(Scriptable scriptable, String string, int[] nArray, boolean bl) {
        Object object;
        Scriptable scriptable2;
        Object object2;
        int n;
        NativeRegExp nativeRegExp = this;
        Context context = Context.getContext();
        RegExpStatics regExpStatics = context.getRegExpStatics();
        MatchState matchState = new MatchState();
        matchState.anchoring = false;
        matchState.pcend = this.program.length;
        int n2 = nArray[0];
        char[] cArray = string.toCharArray();
        if (n2 > cArray.length) {
            n2 = cArray.length;
        }
        int n3 = n2;
        matchState.cpbegin = 0;
        matchState.cpend = cArray.length;
        matchState.start = n2;
        matchState.skipped = 0;
        matchState.parenCount = 0;
        matchState.maybeParens = new SubString[nativeRegExp.parenCount];
        matchState.parens = new SubString[nativeRegExp.parenCount];
        if ((n3 = this.matchRegExp(matchState, this.program, 0, cArray, n3)) == -1) {
            return null;
        }
        nArray[0] = n = n3 - matchState.cpbegin;
        int n4 = n - (n2 + matchState.skipped);
        int n5 = n3;
        n3 -= n4;
        if (bl) {
            object2 = Boolean.TRUE;
            scriptable2 = null;
        } else {
            object = ScriptableObject.getTopLevelScope(scriptable);
            object2 = ScriptRuntime.newObject(context, (Scriptable)object, "Array", null);
            scriptable2 = (Scriptable)object2;
            String string2 = new String(cArray, n3, n4);
            scriptable2.put(0, scriptable2, (Object)string2);
        }
        if (matchState.parenCount > nativeRegExp.parenCount) {
            throw new RuntimeException();
        }
        if (matchState.parenCount == 0) {
            regExpStatics.parens.setSize(0);
            regExpStatics.lastParen = SubString.emptySubString;
        } else {
            object = null;
            regExpStatics.parens.setSize(matchState.parenCount);
            int n6 = 0;
            while (n6 < matchState.parenCount) {
                object = matchState.parens[n6];
                regExpStatics.parens.setElementAt(object, n6);
                if (!bl) {
                    String string3 = object == null ? "" : ((SubString)object).toString();
                    scriptable2.put(n6 + 1, scriptable2, (Object)string3);
                }
                ++n6;
            }
            regExpStatics.lastParen = object;
        }
        if (!bl) {
            scriptable2.put("index", scriptable2, (Object)new Integer(n2 + matchState.skipped));
            scriptable2.put("input", scriptable2, (Object)string);
        }
        if (regExpStatics.lastMatch == null) {
            regExpStatics.lastMatch = new SubString();
            regExpStatics.leftContext = new SubString();
            regExpStatics.rightContext = new SubString();
        }
        regExpStatics.lastMatch.charArray = cArray;
        regExpStatics.lastMatch.index = n3;
        regExpStatics.lastMatch.length = n4;
        regExpStatics.leftContext.charArray = cArray;
        if (context.getLanguageVersion() == 120) {
            regExpStatics.leftContext.index = n2;
            regExpStatics.leftContext.length = matchState.skipped;
        } else {
            regExpStatics.leftContext.index = 0;
            regExpStatics.leftContext.length = n2 + matchState.skipped;
        }
        regExpStatics.rightContext.charArray = cArray;
        regExpStatics.rightContext.index = n5;
        regExpStatics.rightContext.length = matchState.cpend - n5;
        return object2;
    }

    private boolean matchCharsIgnoringCase(char c, char c2) {
        return (c = Character.toUpperCase(c)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    private void write(int n, char c) {
        this.program[n + 1] = (byte)(c >>> 8 & 0xFF);
        this.program[n + 2] = (byte)(c & 0xFF);
    }

    private static Object execSub(Context context, Scriptable scriptable, Object[] objectArray, Scriptable scriptable2, boolean bl, Function function) {
        String string;
        if (!(scriptable instanceof NativeRegExp)) {
            Object[] objectArray2 = new Object[]{((NativeFunction)function).names[0]};
            throw Context.reportRuntimeError(Context.getMessage("msg.incompat.call", objectArray2));
        }
        NativeRegExp nativeRegExp = (NativeRegExp)scriptable;
        if (objectArray.length == 0) {
            string = context.getRegExpStatics().input;
            if (string == null) {
                Object[] objectArray3 = new Object[]{nativeRegExp.toString()};
                throw Context.reportRuntimeError(Context.getMessage("msg.no.re.input.for", objectArray3));
            }
        } else {
            string = ScriptRuntime.toString(objectArray[0]);
        }
        int n = (nativeRegExp.flags & 1) != 0 ? nativeRegExp.lastIndex : 0;
        int[] nArray = new int[]{n};
        Object object = nativeRegExp.executeRegExp(scriptable2, string, nArray, bl);
        if ((nativeRegExp.flags & 1) != 0) {
            nativeRegExp.lastIndex = object == null ? 0 : nArray[0];
        }
        return object;
    }

    private void write(int n, short s) {
        this.program[n + 1] = (byte)(s >>> 8 & 0xFF);
        this.program[n + 2] = (byte)(s & 0xFF);
    }

    private void reportError(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        String string3 = Context.getMessage(string, objectArray);
        Context.reportRuntimeError(string3);
    }

    private RENode parseAltern(CompilerState compilerState) {
        char c;
        RENode rENode = this.parseItem(compilerState);
        if (rENode == null) {
            return null;
        }
        RENode rENode2 = rENode;
        int n = 0;
        char[] cArray = compilerState.source;
        int n2 = compilerState.index;
        while (n2 != cArray.length && (c = cArray[n2]) != '|' && c != ')') {
            RENode rENode3 = this.parseItem(compilerState);
            if (rENode3 == null) {
                return null;
            }
            this.setNext(compilerState, rENode2, rENode3);
            n |= rENode3.flags;
            rENode2 = rENode3;
            n2 = compilerState.index;
        }
        rENode.flags = (byte)(rENode.flags | n & 4);
        return rENode;
    }

    private int storeChar(char[] cArray, int n, char c, boolean bl) {
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == '\\') {
                ++n2;
            }
            if (cArray[n2] == c && (!bl || n2 > 0 && cArray[n2 - 1] == '\\')) {
                return n;
            }
            ++n2;
        }
        if (bl || c == '\\' || c == '-') {
            cArray[n++] = 92;
        }
        cArray[n++] = c;
        return n;
    }

    private boolean matchSingleCases(int n, char[] cArray, int n2, int n3, byte[] byArray, int n4, int[] nArray) {
        if (n2 >= cArray.length) {
            return false;
        }
        char c = cArray[n2];
        switch (n) {
            case 12: {
                return n2 != n3 && c != '\n';
            }
            case 13: {
                int n5 = c >> 3;
                int n6 = c & 7;
                n6 = 1 << n6;
                return (byArray[n4 + 1 + n5] & n6) != 0;
            }
            case 14: {
                return NativeRegExp.isDigit(c);
            }
            case 15: {
                return !NativeRegExp.isDigit(c);
            }
            case 16: {
                return NativeRegExp.isWord(c);
            }
            case 17: {
                return !NativeRegExp.isWord(c);
            }
            case 18: {
                return Character.isWhitespace(c);
            }
            case 19: {
                return !Character.isWhitespace(c);
            }
            case 22: {
                return c == (char)(byArray[n4 + 1] & 0xFF);
            }
            case 33: {
                char c2 = (char)(byArray[n4 + 1] & 0xFF);
                return c == c2 || this.matchCharsIgnoringCase(c, c2);
            }
            case 28: {
                return c == (char)(byArray[n4 + 1] << 8 | byArray[n4 + 2] & 0xFF);
            }
            case 35: {
                char c3 = (char)(byArray[n4 + 1] << 8 | byArray[n4 + 2] & 0xFF);
                return c == c3 || this.matchCharsIgnoringCase(c, c3);
            }
            case 29: 
            case 30: {
                int n7 = byArray[n4 + 1] << 8 | byArray[n4 + 2] & 0xFF;
                nArray[0] = nArray[0] + n7;
                int n8 = c >>> 3;
                if (n8 >= n7) {
                    return n == 30;
                }
                int n9 = c & 7;
                return (byArray[n4 + 3 + n8] & (n9 = 1 << n9)) != 0;
            }
        }
        throw new RuntimeException("Unexpected op");
    }

    RENode parseAtom(CompilerState compilerState) {
        int n;
        RENode rENode = null;
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = compilerState.source;
        int n2 = n = compilerState.index;
        if (n == cArray.length) {
            compilerState.index = n;
            return new RENode(compilerState, 0, null);
        }
        switch (cArray[n]) {
            case '(': {
                int n3 = compilerState.parenCount++;
                compilerState.index = n + 1;
                RENode rENode2 = this.parseRegExp(compilerState);
                if (rENode2 == null) {
                    return null;
                }
                n = compilerState.index;
                if (n >= cArray.length || cArray[n] != ')') {
                    this.reportError("msg.unterm.paren", this.tail(cArray, n2));
                    return null;
                }
                ++n;
                rENode = new RENode(compilerState, 10, rENode2);
                rENode.flags = (byte)(rENode2.flags & 5);
                rENode.num = n3;
                rENode2 = new RENode(compilerState, 11, null);
                this.setNext(compilerState, rENode, rENode2);
                rENode2.num = n3;
                break;
            }
            case '.': {
                char c;
                if (++n < cArray.length && (c = cArray[n]) == '*') {
                    ++n;
                    rENode = new RENode(compilerState, 24, null);
                } else {
                    rENode = new RENode(compilerState, 12, null);
                }
                if (rENode.op != 12) break;
                rENode.flags = (byte)6;
                break;
            }
            case '[': {
                if (++n == cArray.length) {
                    this.reportError("msg.unterm.class", this.tail(cArray, n2));
                    return null;
                }
                char c = cArray[n];
                rENode = new RENode(compilerState, 13, new Integer(n));
                if (c == '^' && ++n == cArray.length) {
                    this.reportError("msg.unterm.class", this.tail(cArray, n2));
                    return null;
                }
                while (true) {
                    if (++n == cArray.length) {
                        this.reportError("msg.unterm.paren", this.tail(cArray, n2));
                        return null;
                    }
                    c = cArray[n];
                    if (c == ']') break;
                    if (c != '\\' || n + 1 == cArray.length) continue;
                    ++n;
                }
                rENode.kid2 = n++;
                rENode.flags = (byte)6;
                break;
            }
            case '\\': {
                if (++n == cArray.length) {
                    Context.reportError(Context.getMessage("msg.trail.backslash", null));
                    return null;
                }
                char c = cArray[n];
                switch (c) {
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'v': {
                        c = this.getEscape(c);
                        rENode = new RENode(compilerState, 22, null);
                        break;
                    }
                    case 'd': {
                        rENode = new RENode(compilerState, 14, null);
                        break;
                    }
                    case 'D': {
                        rENode = new RENode(compilerState, 15, null);
                        break;
                    }
                    case 'w': {
                        rENode = new RENode(compilerState, 16, null);
                        break;
                    }
                    case 'W': {
                        rENode = new RENode(compilerState, 17, null);
                        break;
                    }
                    case 's': {
                        rENode = new RENode(compilerState, 18, null);
                        break;
                    }
                    case 'S': {
                        rENode = new RENode(compilerState, 19, null);
                        break;
                    }
                    case '0': {
                        compilerState.index = n;
                        int n4 = this.doOctal(compilerState);
                        n = compilerState.index;
                        rENode = new RENode(compilerState, 22, null);
                        c = (char)n4;
                        break;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int n4 = NativeRegExp.unDigit(c);
                        while (++n < cArray.length && NativeRegExp.isDigit(c = cArray[n])) {
                            n4 = 10 * n4 - NativeRegExp.unDigit(c);
                        }
                        if (n4 > 9 || n4 > compilerState.parenCount) {
                            compilerState.index = n2;
                            n4 = this.doOctal(compilerState);
                            n = compilerState.index;
                            rENode = new RENode(compilerState, 22, null);
                            c = (char)n4;
                            break;
                        }
                        --n;
                        rENode = new RENode(compilerState, 20, null);
                        rENode.num = n4 - 1;
                        rENode.flags = (byte)4;
                        bl = true;
                        break;
                    }
                    case 'x': {
                        int n4;
                        n2 = n++;
                        if (n < cArray.length && NativeRegExp.isHex(c = cArray[n])) {
                            n4 = NativeRegExp.unHex(c);
                            if (++n < cArray.length && NativeRegExp.isHex(c = cArray[n])) {
                                n4 <<= 4;
                                n4 += NativeRegExp.unHex(c);
                            } else {
                                --n;
                            }
                        } else {
                            n = n2;
                            n4 = 120;
                        }
                        rENode = new RENode(compilerState, 22, null);
                        c = (char)n4;
                        break;
                    }
                    case 'c': {
                        c = cArray[++n];
                        if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z')) {
                            n2 = n -= 2;
                            bl2 = true;
                            bl = true;
                            break;
                        }
                        c = Character.toUpperCase(c);
                        c = (char)(c ^ 0x40);
                        rENode = new RENode(compilerState, 22, null);
                        break;
                    }
                    case 'u': {
                        int n4;
                        if (n + 4 < cArray.length && NativeRegExp.isHex(cArray[n + 1]) && NativeRegExp.isHex(cArray[n + 2]) && NativeRegExp.isHex(cArray[n + 3]) && NativeRegExp.isHex(cArray[n + 4])) {
                            n4 = (((NativeRegExp.unHex(cArray[n + 1]) << 4) + NativeRegExp.unHex(cArray[n + 2]) << 4) + NativeRegExp.unHex(cArray[n + 3]) << 4) + NativeRegExp.unHex(cArray[n + 4]);
                            c = (char)n4;
                            n += 4;
                            rENode = new RENode(compilerState, 22, null);
                            break;
                        }
                        n2 = n;
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    default: {
                        n2 = n;
                        bl2 = true;
                        bl = true;
                    }
                }
                if (rENode != null && !bl) {
                    rENode.chr = c;
                    rENode.flags = (byte)6;
                }
                bl = false;
                if (!bl2) {
                    ++n;
                    break;
                }
                bl2 = false;
            }
            default: {
                while (++n != cArray.length && metachars.indexOf(cArray[n]) == -1) {
                }
                int n5 = n - n2;
                if (n != cArray.length && n5 > 1 && closurechars.indexOf(cArray[n]) != -1) {
                    --n;
                    --n5;
                }
                if (n5 > 255) {
                    n5 = 255;
                    n = n2 + n5;
                }
                rENode = new RENode(compilerState, n5 == 1 ? (byte)22 : 21, new Integer(n2));
                rENode.flags = (byte)4;
                if (n5 > 1) {
                    rENode.kid2 = n;
                    break;
                }
                rENode.flags = (byte)(rENode.flags | 2);
                rENode.chr = cArray[n2];
            }
        }
        compilerState.index = n;
        return rENode;
    }

    RENode parseItem(CompilerState compilerState) {
        int n = compilerState.index;
        char[] cArray = compilerState.source;
        switch (n < cArray.length ? cArray[n] : 0) {
            case 94: {
                compilerState.index = n + 1;
                RENode rENode = new RENode(compilerState, 2, null);
                rENode.flags = (byte)(rENode.flags | 1);
                return rENode;
            }
            case 36: {
                compilerState.index = n + 1;
                return new RENode(compilerState, (byte)(n == compilerState.indexBegin || (cArray[n - 1] == '(' || cArray[n - 1] == '|') && (n - 1 == compilerState.indexBegin || cArray[n - 2] != '\\') ? 26 : 3), null);
            }
            case 92: {
                byte by;
                switch (++n < cArray.length ? cArray[n] : 0) {
                    case 98: {
                        by = 4;
                        break;
                    }
                    case 66: {
                        by = 5;
                        break;
                    }
                    default: {
                        return this.parseQuantAtom(compilerState);
                    }
                }
                compilerState.index = n + 1;
                RENode rENode = new RENode(compilerState, by, null);
                rENode.flags = (byte)(rENode.flags | 4);
                return rENode;
            }
        }
        return this.parseQuantAtom(compilerState);
    }

    private int countFirstChars(RENode rENode) {
        int n = 0;
        do {
            RENode rENode2 = (RENode)rENode.kid;
            while (rENode2.op == 10) {
                rENode2 = (RENode)rENode2.kid;
            }
            switch (rENode2.op) {
                case 6: {
                    if (rENode2.min == 0) {
                        return -1;
                    }
                }
                case 1: 
                case 8: {
                    int n2 = this.countFirstChars(rENode2);
                    if (n2 < 0) {
                        return n2;
                    }
                    n += n2;
                    break;
                }
                case 21: {
                    char c = this.source.charAt((Integer)rENode2.kid);
                    if (c == '\\' || c == '-') {
                        n += 2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 22: {
                    char c = rENode2.chr;
                    if (c == '\\' || c == '-') {
                        n += 2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 13: {
                    int n3 = (Integer)rENode2.kid;
                    if (this.source.charAt(n3) == '^') {
                        return -1;
                    }
                    int n4 = rENode2.kid2;
                    n += n4 - n3;
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    n += 2;
                    break;
                }
                default: {
                    return -1;
                }
            }
        } while (rENode.op == 1 && (rENode = rENode.next) != null && rENode.op == 1);
        return n;
    }

    public boolean getGlobal() {
        return (this.flags & 1) != 0;
    }

    static int unHex(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return 10 + Character.toLowerCase(c) - 97;
    }

    public String getSource() {
        return this.source;
    }

    private char getEscape(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
        }
        throw new RuntimeException();
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        return (Scriptable)this.call(context, scriptable, null, objectArray);
    }

    private int doOctal(CompilerState compilerState) {
        char c;
        char[] cArray = compilerState.source;
        int n = compilerState.index;
        int n2 = 0;
        while (++n < cArray.length && '0' <= (c = cArray[n]) && c <= '7') {
            if ((n2 = 8 * n2 + (c - 48)) <= 255) continue;
            this.reportError("msg.overlarge.octal", this.tail(cArray, compilerState.index));
            n2 = 0;
            break;
        }
        compilerState.index = --n;
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/');
        stringBuffer.append(this.source);
        stringBuffer.append('/');
        if ((this.flags & 1) != 0) {
            stringBuffer.append('g');
        }
        if ((this.flags & 2) != 0) {
            stringBuffer.append('i');
        }
        return stringBuffer.toString();
    }

    public NativeRegExp(Scriptable scriptable, String string, String string2) {
        this.init(scriptable, string, string2);
    }

    public NativeRegExp() {
    }

    private void dumpRegExp(CompilerState compilerState, RENode rENode) {
    }

    private RENode parseRegExp(CompilerState compilerState) {
        RENode rENode = this.parseAltern(compilerState);
        if (rENode == null) {
            return null;
        }
        int n = compilerState.index;
        char[] cArray = compilerState.source;
        if (n < cArray.length && cArray[n] == '|') {
            RENode rENode2 = rENode;
            if ((rENode = new RENode(compilerState, 1, rENode2)) == null) {
                return null;
            }
            rENode.flags = (byte)(rENode2.flags & 5);
            RENode rENode3 = rENode;
            do {
                compilerState.index = ++n;
                if (n < cArray.length && (cArray[n] == '|' || cArray[n] == ')')) {
                    rENode2 = new RENode(compilerState, 0, null);
                } else {
                    rENode2 = this.parseAltern(compilerState);
                    n = compilerState.index;
                }
                if (rENode2 == null) {
                    return null;
                }
                RENode rENode4 = new RENode(compilerState, 1, rENode2);
                if (rENode4 == null) {
                    return null;
                }
                rENode3.next = rENode4;
                rENode3.flags = (byte)(rENode3.flags | 0x10);
                rENode4.flags = (byte)(rENode2.flags & 5 | 8);
                rENode3 = rENode4;
            } while (n < cArray.length && cArray[n] == '|');
        }
        return rENode;
    }

    public static Scriptable compile(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        NativeRegExp nativeRegExp = (NativeRegExp)scriptable;
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        String string2 = objectArray.length > 1 ? ScriptRuntime.toString(objectArray[1]) : null;
        nativeRegExp.init(function, string, string2);
        return nativeRegExp;
    }

    private short readShort(byte[] byArray, int n) {
        return (short)(byArray[n + 1] << 8 | byArray[n + 2] & 0xFF);
    }

    static boolean isWord(char c) {
        return Character.isLetter(c) || NativeRegExp.isDigit(c) || c == '_';
    }

    private void checkRange(char c, int n, int n2) {
        this.matchBit(c, n, n2);
        this.matchBit('-', n, n2);
    }

    static int unDigit(char c) {
        return c - 48;
    }

    private RENode closeTail(CompilerState compilerState, RENode rENode, RENode rENode2) {
        RENode rENode3;
        RENode rENode4 = new RENode(compilerState, 0, null);
        rENode.next = rENode3 = new RENode(compilerState, 1, rENode4);
        rENode3.next = rENode4.next = rENode2;
        if ((rENode.flags & 0x10) != 0) {
            rENode3.flags = (byte)(rENode3.flags | 0x10);
        } else {
            rENode.flags = (byte)(rENode.flags | 0x10);
        }
        rENode3.flags = (byte)(rENode3.flags | 8);
        return rENode3;
    }

    private String tail(char[] cArray, int n) {
        return new String(cArray, n, cArray.length - n);
    }

    String getPrintableString(String string) {
        return "";
    }

    static {
        byte[] byArray = new byte[38];
        byArray[0] = 1;
        byArray[1] = 3;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 7;
        byArray[7] = 1;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[10] = 3;
        byArray[11] = 3;
        byArray[12] = 1;
        byArray[13] = 33;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[16] = 1;
        byArray[17] = 1;
        byArray[18] = 1;
        byArray[19] = 1;
        byArray[20] = 2;
        byArray[21] = 2;
        byArray[22] = 2;
        byArray[23] = 3;
        byArray[24] = 1;
        byArray[25] = 1;
        byArray[26] = 1;
        byArray[27] = 2;
        byArray[28] = 3;
        byArray[29] = 3;
        byArray[30] = 3;
        byArray[31] = 2;
        byArray[32] = 2;
        byArray[33] = 2;
        byArray[34] = 2;
        byArray[35] = 3;
        byArray[36] = 1;
        reopsize = byArray;
        reopname = new String[]{"empty", "alt", "bol", "eol", "wbdry", "wnonbdry", "quant", "star", "plus", "opt", "lparen", "rparen", "dot", "cclass", "digit", "nondigit", "alnum", "nonalnum", "space", "nonspace", "backref", "flat", "flat1", "jump", "dotstar", "anchor", "eolonly", "ucflat", "ucflat1", "ucclass", "nucclass", "backrefi", "flati", "flat1i", "ucflati", "ucflat1i", "anchor1", "end"};
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public void setLastIndex(int n) {
        this.lastIndex = n;
    }

    private void fixNext(CompilerState compilerState, RENode rENode, RENode rENode2, RENode rENode3) {
        RENode rENode4;
        boolean bl = rENode2 != null && (rENode2.flags & 8) == 0;
        while ((rENode4 = rENode.next) != null && rENode4 != rENode3) {
            if (rENode.op == 1) {
                RENode rENode5 = (RENode)rENode.kid;
                if (rENode5.op != 23) {
                    RENode rENode6 = rENode5;
                    while (rENode6.next != null) {
                        if (rENode6.op == 1) {
                            throw new RuntimeException("REOP_ALT not expected");
                        }
                        rENode6 = rENode6.next;
                    }
                    rENode6.next = new RENode(compilerState, 23, null);
                    rENode6.next.flags = (byte)(rENode6.next.flags | 8);
                    rENode6.flags = (byte)(rENode6.flags | 0x10);
                    this.fixNext(compilerState, rENode5, rENode2, rENode3);
                }
            }
            rENode = rENode4;
        }
        if (rENode2 != null) {
            rENode2.flags = (rENode2.flags & 8) == 0 ? (byte)(rENode2.flags | 8) : (byte)(rENode2.flags | 0x20);
        }
        rENode.next = rENode2;
        if (bl) {
            rENode.flags = (byte)(rENode.flags | 0x10);
        }
        switch (rENode.op) {
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.fixNext(compilerState, (RENode)rENode.kid, rENode2, rENode3);
                return;
            }
        }
    }

    static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return NativeRegExp.execSub(context, this, objectArray, scriptable, false, this);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private int storeFirstChars(CompilerState compilerState, RENode rENode, char[] cArray, int n) {
        block13: do {
            RENode rENode2 = (RENode)rENode.kid;
            while (rENode2.op == 10) {
                rENode2 = (RENode)rENode2.kid;
            }
            switch (rENode2.op) {
                case 6: {
                    if (rENode2.min == 0) {
                        throw new RuntimeException();
                    }
                }
                case 1: 
                case 8: {
                    n = this.storeFirstChars(compilerState, rENode2, cArray, n);
                    break;
                }
                case 21: {
                    char[] cArray2 = rENode2.s != null ? rENode2.s : compilerState.source;
                    n = this.storeChar(cArray, n, cArray2[(Integer)rENode2.kid], false);
                    break;
                }
                case 22: {
                    n = this.storeChar(cArray, n, rENode2.chr, false);
                    break;
                }
                case 13: {
                    int n2 = rENode2.kid2;
                    char[] cArray2 = rENode2.s != null ? rENode2.s : compilerState.source;
                    int n3 = (Integer)rENode2.kid;
                    while (n3 < n2) {
                        cArray[n++] = cArray2[n3];
                        ++n3;
                    }
                    continue block13;
                }
                case 14: {
                    n = this.storeChar(cArray, n, 'd', true);
                    break;
                }
                case 15: {
                    n = this.storeChar(cArray, n, 'D', true);
                    break;
                }
                case 16: {
                    n = this.storeChar(cArray, n, 'w', true);
                    break;
                }
                case 17: {
                    n = this.storeChar(cArray, n, 'W', true);
                    break;
                }
                case 18: {
                    n = this.storeChar(cArray, n, 's', true);
                    break;
                }
                case 19: {
                    n = this.storeChar(cArray, n, 'S', true);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        } while (rENode.op == 1 && (rENode = rENode.next) != null && rENode.op == 1);
        return n;
    }

    public static void init(Scriptable scriptable) throws PropertyException {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.setParentScope(scriptable);
        nativeRegExp.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        String[] stringArray = new String[]{"compile", "toString", "exec", "test"};
        nativeRegExp.defineFunctionProperties(stringArray, class$com$netscape$javascript$NativeRegExp != null ? class$com$netscape$javascript$NativeRegExp : (class$com$netscape$javascript$NativeRegExp = NativeRegExp.class$("com.netscape.javascript.NativeRegExp")), 2);
        String[] stringArray2 = new String[]{"lastIndex", "source", "global", "ignoreCase"};
        int[] nArray = new int[]{4, 5, 5, 5};
        int n = 0;
        while (n < stringArray2.length) {
            nativeRegExp.defineProperty(stringArray2[n], class$com$netscape$javascript$NativeRegExp != null ? class$com$netscape$javascript$NativeRegExp : NativeRegExp.class$("com.netscape.javascript.NativeRegExp"), nArray[n]);
            ++n;
        }
        Scriptable scriptable2 = NativeRegExpCtor.init(scriptable);
        scriptable2.put("prototype", scriptable2, (Object)nativeRegExp);
    }

    public void init(Scriptable scriptable, String string, String string2) {
        CompilerState compilerState;
        RENode rENode;
        this.source = string;
        this.flags = 0;
        if (string2 != null) {
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (c == 'g') {
                    this.flags = (byte)(this.flags | 1);
                } else if (c == 'i') {
                    this.flags = (byte)(this.flags | 2);
                } else {
                    Object[] objectArray = new Object[]{new Character(c)};
                    throw Context.reportRuntimeError(Context.getMessage("msg.invalid.re.flag", objectArray));
                }
                ++n;
            }
        }
        if ((rENode = this.parseRegExp(compilerState = new CompilerState(string, this.flags))) == null) {
            return;
        }
        RENode rENode2 = new RENode(compilerState, 37, null);
        this.setNext(compilerState, rENode, rENode2);
        this.anchorRegExp(compilerState, rENode);
        this.optimizeRegExp(compilerState, rENode);
        this.program = new byte[compilerState.progLength];
        this.lastIndex = 0;
        this.parenCount = compilerState.parenCount;
        this.flags = this.flags;
        compilerState.progLength = 0;
        this.emitRegExp(compilerState, rENode);
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        this.setPrototype(ScriptableObject.getClassPrototype(scriptable, "RegExp"));
        this.setParentScope(scriptable);
    }

    /*
     * Unable to fully structure code
     */
    private void emitRegExp(CompilerState var1_1, RENode var2_2) {
        var12_3 = this;
        block26: do {
            if ((var17_17 = var2_2.op) == 37) {
                return;
            }
            var18_18 = var1_1.progLength;
            var1_1.progLength += NativeRegExp.reopsize[var2_2.op];
            var12_3.program[var18_18] = var2_2.op;
            var4_5 = var2_2.next;
            var19_19 = var2_2.s != null ? var2_2.s : var1_1.source;
            switch (var17_17) {
                case 1: {
                    var5_6 = var4_5.offset - var2_2.offset;
                    this.write(var18_18, (short)var5_6);
                    this.emitRegExp(var1_1, (RENode)var2_2.kid);
                    break;
                }
                case 6: {
                    var5_6 = var4_5.offset - var2_2.offset;
                    this.write(var18_18, (short)var5_6);
                    this.write(var18_18 += 2, var2_2.min);
                    this.write(var18_18 += 2, var2_2.max);
                    this.emitRegExp(var1_1, (RENode)var2_2.kid);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 36: {
                    this.emitRegExp(var1_1, (RENode)var2_2.kid);
                    break;
                }
                case 10: {
                    this.write(var18_18, (short)var2_2.num);
                    this.emitRegExp(var1_1, (RENode)var2_2.kid);
                    break;
                }
                case 11: {
                    this.write(var18_18, (short)var2_2.num);
                    break;
                }
                case 13: 
                case 29: {
                    var6_7 = (Integer)var2_2.kid;
                    if (var19_19[var6_7] == '^') {
                        if (var17_17 == 29) {
                            this.program[var18_18] = 30;
                        }
                        var3_4 = -1;
                        ++var6_7;
                    } else {
                        var3_4 = 0;
                    }
                    ++var18_18;
                    if (var17_17 == 13) {
                        var7_8 = var2_2.kid2;
                        var9_10 = 0;
                        do {
                            this.program[var18_18 + var9_10] = var3_4;
                        } while (++var9_10 < 32);
                        var16_16 = 256;
                    } else {
                        var7_8 = var6_7 + var2_2.kidlen;
                        var10_11 = var2_2.bmsize;
                        this.program[var18_18++] = (byte)(var10_11 >>> 8);
                        this.program[var18_18++] = (byte)var10_11;
                        var1_1.progLength += var10_11;
                        var9_10 = 0;
                        while (var9_10 < var10_11) {
                            this.program[var18_18 + var9_10] = var3_4;
                            ++var9_10;
                        }
                        var16_16 = var10_11 * 8;
                    }
                    var14_14 = (char)var16_16;
                    var11_12 = false;
                    block29: while (var6_7 < var7_8) {
                        if ((var13_13 = var19_19[var6_7++]) != '\\') ** GOTO lbl-1000
                        var13_13 = var19_19[var6_7++];
                        switch (var13_13) {
                            case 'b': 
                            case 'f': 
                            case 'n': 
                            case 'r': 
                            case 't': 
                            case 'v': {
                                var13_13 = this.getEscape(var13_13);
                                ** GOTO lbl177
                            }
                            case 'd': {
                                if (var11_12) {
                                    this.checkRange(var14_14, var3_4, var18_18);
                                }
                                var14_14 = (char)var16_16;
                                var13_13 = '0';
                                while (var13_13 <= '9') {
                                    this.matchBit(var13_13, var3_4, var18_18);
                                    var13_13 = (char)(var13_13 + '\u0001');
                                }
                                continue block29;
                            }
                            case 'D': {
                                if (var11_12) {
                                    this.checkRange(var14_14, var3_4, var18_18);
                                }
                                var14_14 = (char)var16_16;
                                var13_13 = '\u0000';
                                while (var13_13 < '0') {
                                    this.matchBit(var13_13, var3_4, var18_18);
                                    var13_13 = (char)(var13_13 + '\u0001');
                                }
                                var13_13 = ':';
                                while (var13_13 < var16_16) {
                                    this.matchBit(var13_13, var3_4, var18_18);
                                    var13_13 = (char)(var13_13 + '\u0001');
                                }
                                continue block29;
                            }
                            case 'w': {
                                if (var11_12) {
                                    this.checkRange(var14_14, var3_4, var18_18);
                                }
                                var14_14 = (char)var16_16;
                                var13_13 = '\u0000';
                                while (var13_13 < var16_16) {
                                    if (NativeRegExp.isWord(var13_13)) {
                                        this.matchBit(var13_13, var3_4, var18_18);
                                    }
                                    var13_13 = (char)(var13_13 + '\u0001');
                                }
                                continue block29;
                            }
                            case 'W': {
                                if (var11_12) {
                                    this.checkRange(var14_14, var3_4, var18_18);
                                }
                                var14_14 = (char)var16_16;
                                var13_13 = '\u0000';
                                while (var13_13 < var16_16) {
                                    if (!NativeRegExp.isWord(var13_13)) {
                                        this.matchBit(var13_13, var3_4, var18_18);
                                    }
                                    var13_13 = (char)(var13_13 + '\u0001');
                                }
                                continue block29;
                            }
                            case 's': {
                                if (var11_12) {
                                    this.checkRange(var14_14, var3_4, var18_18);
                                }
                                var14_14 = (char)var16_16;
                                var13_13 = '\u0000';
                                while (var13_13 < var16_16) {
                                    if (Character.isWhitespace(var13_13)) {
                                        this.matchBit(var13_13, var3_4, var18_18);
                                    }
                                    var13_13 = (char)(var13_13 + '\u0001');
                                }
                                continue block29;
                            }
                            case 'S': {
                                if (var11_12) {
                                    this.checkRange(var14_14, var3_4, var18_18);
                                }
                                var14_14 = (char)var16_16;
                                var13_13 = '\u0000';
                                while (var13_13 < var16_16) {
                                    if (!Character.isWhitespace(var13_13)) {
                                        this.matchBit(var13_13, var3_4, var18_18);
                                    }
                                    var13_13 = (char)(var13_13 + '\u0001');
                                }
                                continue block29;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': {
                                var10_11 = NativeRegExp.unDigit(var13_13);
                                var8_9 = var6_7 - 2;
                                var13_13 = var19_19[var6_7];
                                if ('0' <= var13_13 && var13_13 <= '7') {
                                    var10_11 = 8 * var10_11 + NativeRegExp.unDigit(var13_13);
                                    if ('0' <= (var13_13 = var19_19[++var6_7]) && var13_13 <= '7') {
                                        ++var6_7;
                                        var9_10 = 8 * var10_11 + NativeRegExp.unDigit(var13_13);
                                        if (var9_10 <= 255) {
                                            var10_11 = var9_10;
                                        } else {
                                            --var6_7;
                                        }
                                    }
                                }
                                var13_13 = (char)var10_11;
                                ** GOTO lbl177
                            }
                            case 'x': {
                                var8_9 = var6_7;
                                if (var6_7 < var19_19.length && NativeRegExp.isHex(var13_13 = var19_19[var6_7++])) {
                                    var10_11 = NativeRegExp.unHex(var13_13);
                                    if (var6_7 < var19_19.length && NativeRegExp.isHex(var13_13 = var19_19[var6_7++])) {
                                        var10_11 <<= 4;
                                        var10_11 += NativeRegExp.unHex(var13_13);
                                    }
                                } else {
                                    var6_7 = var8_9;
                                    var10_11 = 120;
                                }
                                var13_13 = (char)var10_11;
                                ** GOTO lbl177
                            }
                            case 'u': {
                                if (var19_19.length > var6_7 + 3 && NativeRegExp.isHex(var19_19[var6_7]) && NativeRegExp.isHex(var19_19[var6_7 + 1]) && NativeRegExp.isHex(var19_19[var6_7 + 2]) && NativeRegExp.isHex(var19_19[var6_7 + 3])) {
                                    var10_11 = (((NativeRegExp.unHex(var19_19[var6_7]) << 4) + NativeRegExp.unHex(var19_19[var6_7 + 1]) << 4) + NativeRegExp.unHex(var19_19[var6_7 + 2]) << 4) + NativeRegExp.unHex(var19_19[var6_7 + 3]);
                                    var13_13 = (char)var10_11;
                                    var6_7 += 4;
                                }
                                ** GOTO lbl177
                            }
                            case 'c': {
                                var13_13 = var19_19[var6_7++];
                                var13_13 = Character.toUpperCase(var13_13);
                                var13_13 = (char)(var13_13 ^ 64);
                            }
lbl177:
                            // 6 sources

                            default: lbl-1000:
                            // 2 sources

                            {
                                if (!var11_12) ** GOTO lbl183
                                if (var14_14 > var13_13) {
                                    throw Context.reportRuntimeError(Context.getMessage("msg.bad.range", null));
                                }
                                var11_12 = false;
                                ** GOTO lbl195
lbl183:
                                // 1 sources

                                var14_14 = var13_13;
                                if (var6_7 + 1 >= var7_8 || var19_19[var6_7] != '-' || var19_19[var6_7 + 1] == ']') ** GOTO lbl195
                                ++var6_7;
                                var11_12 = true;
                                break;
lbl-1000:
                                // 1 sources

                                {
                                    this.matchBit(var14_14, var3_4, var18_18);
                                    if ((var1_1.flags & 2) != 0) {
                                        var15_15 = Character.toUpperCase(var14_14);
                                        this.matchBit(var15_15, var3_4, var18_18);
                                        var15_15 = Character.toLowerCase(var15_15);
                                        this.matchBit(var15_15, var3_4, var18_18);
                                    }
                                    var14_14 = (char)(var14_14 + '\u0001');
lbl195:
                                    // 3 sources

                                    ** while (var14_14 <= var13_13)
                                }
lbl196:
                                // 1 sources

                                var14_14 = var13_13;
                            }
                        }
                    }
                    continue block26;
                }
                case 20: {
                    if ((var1_1.flags & 2) != 0) {
                        this.program[var18_18] = 31;
                    }
                    this.program[var18_18 + 1] = (byte)var2_2.num;
                    break;
                }
                case 21: 
                case 27: {
                    if ((var1_1.flags & 2) != 0) {
                        this.program[var18_18] = var17_17 == 21 ? 32 : 34;
                    }
                    var6_7 = (Integer)var2_2.kid;
                    var5_6 = var2_2.kid2 - var6_7;
                    this.program[var18_18 + 1] = (byte)var5_6;
                    var18_18 += 2;
                    var1_1.progLength += var5_6;
                    if (var17_17 == 27) {
                        var1_1.progLength += var5_6;
                    }
                    var20_20 = 0;
                    var9_10 = 0;
                    while (var9_10 < var5_6) {
                        var13_13 = var19_19[var6_7 + var9_10];
                        if (var17_17 == 27) {
                            this.program[var18_18 + var20_20] = (byte)(var13_13 >> 8);
                            this.program[var18_18 + ++var20_20] = (byte)var13_13;
                        } else {
                            this.program[var18_18 + var20_20] = (byte)var13_13;
                        }
                        ++var9_10;
                        ++var20_20;
                    }
                    continue block26;
                }
                case 22: {
                    if ((var1_1.flags & 2) != 0) {
                        this.program[var18_18] = 33;
                    }
                    this.program[var18_18 + 1] = (byte)var2_2.chr;
                    break;
                }
                case 28: {
                    if ((var1_1.flags & 2) != 0) {
                        this.program[var18_18] = 35;
                    }
                    var13_13 = var2_2.chr;
                    this.program[var18_18 + 1] = (byte)(var13_13 >> 8);
                    this.program[var18_18 + 2] = (byte)var13_13;
                    break;
                }
                case 23: {
                    var5_6 = var4_5.offset - var2_2.offset;
                    this.write(var18_18, (short)var5_6);
                }
            }
        } while ((var2_2.flags & 16) != 0 && (var2_2 = var4_5) != null);
    }

    public byte getFlags() {
        return this.flags;
    }

    public String getClassName() {
        return "RegExp";
    }
}

