/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript;

import com.netscape.javascript.NativeJavaObject;
import com.netscape.javascript.ScriptRuntime;
import com.netscape.javascript.Scriptable;
import com.netscape.javascript.Undefined;
import com.netscape.javascript.Wrapper;
import java.lang.reflect.Array;

public class NativeJavaArray
extends NativeJavaObject {
    Object array;
    int length;
    Class cls;

    public boolean hasInstance(Scriptable scriptable) {
        if (!(scriptable instanceof NativeJavaObject)) {
            return false;
        }
        Object object = ((NativeJavaObject)scriptable).unwrap();
        return this.cls.isInstance(object);
    }

    public static NativeJavaArray wrap(Scriptable scriptable, Object object) {
        return new NativeJavaArray(scriptable, object);
    }

    public Object get(String string, Scriptable scriptable) {
        if (string.equals("length")) {
            return new Integer(this.length);
        }
        return super.get(string, scriptable);
    }

    public Object get(int n, Scriptable scriptable) {
        if (n >= 0 && n < this.length) {
            return NativeJavaObject.wrap(this, Array.get(this.array, n), this.cls);
        }
        return Undefined.instance;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (!string.equals("length")) {
            super.put(string, scriptable, object);
        }
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (n >= 0 && n < this.length) {
            if (object instanceof Wrapper) {
                object = ((Wrapper)object).unwrap();
            }
            Array.set(this.array, n, NativeJavaObject.coerceType(this.cls, object));
            return;
        }
        super.put(n, scriptable, object);
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.array.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public NativeJavaArray(Scriptable scriptable, Object object) {
        super(scriptable, null, ScriptRuntime.ObjectClass);
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new RuntimeException("Array expected");
        }
        this.array = object;
        this.length = Array.getLength(object);
        this.cls = clazz.getComponentType();
    }

    public Object unwrap() {
        return this.array;
    }

    public boolean has(String string, Scriptable scriptable) {
        return string.equals("length") || super.has(string, scriptable);
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0 && n < this.length;
    }

    public Object[] getIds() {
        Object[] objectArray = new Object[this.length];
        int n = this.length;
        while (--n >= 0) {
            objectArray[n] = new Integer(n);
        }
        return objectArray;
    }

    public String getClassName() {
        return "JavaArray";
    }
}

