/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript;

import com.netscape.javascript.Context;
import com.netscape.javascript.EvaluatorException;
import com.netscape.javascript.Function;
import com.netscape.javascript.InterpretedScript;
import com.netscape.javascript.JavaScriptException;
import com.netscape.javascript.PropertyException;
import com.netscape.javascript.Script;
import com.netscape.javascript.ScriptRuntime;
import com.netscape.javascript.Scriptable;
import com.netscape.javascript.ScriptableObject;
import com.netscape.javascript.TokenStream;
import com.netscape.javascript.Undefined;
import java.io.IOException;
import java.io.StringReader;

public class NativeGlobal {
    private static int URL_XALPHAS = 1;
    private static int URL_XPALPHAS = 2;
    private static int URL_PATH = 4;
    private static /* synthetic */ Class class$com$netscape$javascript$NativeGlobal;

    public static Object isNaN(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            return Boolean.TRUE;
        }
        double d = ScriptRuntime.toNumber(objectArray[0]);
        if (d != d) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Object parseInt(String string, int n) {
        char c;
        int n2 = string.length();
        if (n2 == 0) {
            return ScriptRuntime.NaNobj;
        }
        boolean bl = false;
        int n3 = 0;
        while (Character.isWhitespace(c = string.charAt(n3)) && ++n3 < n2) {
        }
        if (c == '+' || (bl = c == '-')) {
            ++n3;
        }
        int n4 = -1;
        if (n == 0) {
            n = -1;
        } else {
            if (n < 2 || n > 36) {
                return ScriptRuntime.NaNobj;
            }
            if (n == 16 && n2 - n3 > 1 && string.charAt(n3) == '0' && ((c = string.charAt(n3 + 1)) == 'x' || c == 'X')) {
                n3 += 2;
            }
        }
        if (n == -1) {
            n = 10;
            if (n2 - n3 > 1 && string.charAt(n3) == '0') {
                c = string.charAt(n3 + 1);
                if (c == 'x' || c == 'X') {
                    n = 16;
                    n3 += 2;
                } else {
                    n = 8;
                    ++n3;
                }
            }
        }
        double d = ScriptRuntime.stringToNumber(string, n3, n);
        return new Double(bl ? -d : d);
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parseFloat(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        char c;
        if (objectArray.length < 1) {
            return ScriptRuntime.NaNobj;
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        int n = string.length();
        if (n == 0) {
            return ScriptRuntime.NaNobj;
        }
        int n2 = 0;
        while (TokenStream.isJSSpace(c = string.charAt(n2)) && n2 + 1 < n) {
            ++n2;
        }
        int n3 = n2;
        if (c == '+' || c == '-') {
            c = string.charAt(++n2);
        }
        if (c == 'I') {
            if (n2 + 8 > n) return ScriptRuntime.NaNobj;
            if (!string.substring(n2, n2 + 8).equals("Infinity")) return ScriptRuntime.NaNobj;
            double d = string.charAt(n3) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            return new Double(d);
        }
        int n4 = -1;
        int n5 = -1;
        block9: while (n2 < n) {
            char c2 = '\u0000';
            block10: do {
                switch (c2 == '\u0000' ? string.charAt(n2) : c2) {
                    case '.': {
                        if (n4 != -1) break block9;
                        n4 = n2;
                        c2 = '0';
                        continue block10;
                    }
                    case 'E': 
                    case 'e': {
                        if (n5 != -1) break block9;
                        n5 = n2;
                        c2 = '0';
                        continue block10;
                    }
                    case '+': 
                    case '-': {
                        if (n5 != n2 - 1) break block9;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ++n2;
                        continue block9;
                    }
                }
                break block9;
            } while (true);
        }
        string = string.substring(n3, n2);
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return ScriptRuntime.NaNobj;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Object unescape(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            block10: {
                char c = string.charAt(n);
                if (c != '%' || n == string.length() - 1) {
                    stringBuffer.append(c);
                } else {
                    int n2;
                    int n3;
                    if (string.charAt(n + 1) == 'u') {
                        n3 = n + 2;
                        n2 = n + 6;
                    } else {
                        n3 = n + 1;
                        n2 = n + 3;
                    }
                    if (n2 > string.length()) {
                        stringBuffer.append('%');
                    } else {
                        String string2 = string.substring(n3, n2);
                        int n4 = 0;
                        while (n4 < string2.length()) {
                            if (!TokenStream.isXDigit(string2.charAt(n4))) {
                                stringBuffer.append('%');
                                break block10;
                            }
                            ++n4;
                        }
                        n = n2 - 1;
                        stringBuffer.append(new Character((char)Integer.valueOf(string2, 16).intValue()));
                    }
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void init(Scriptable scriptable) throws PropertyException {
        String[] stringArray = new String[]{"eval", "parseInt", "parseFloat", "escape", "unescape", "isNaN", "isFinite"};
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineFunctionProperties(stringArray, class$com$netscape$javascript$NativeGlobal != null ? class$com$netscape$javascript$NativeGlobal : (class$com$netscape$javascript$NativeGlobal = NativeGlobal.class$("com.netscape.javascript.NativeGlobal")), 2);
        scriptableObject.defineProperty("NaN", ScriptRuntime.NaNobj, 2);
        scriptableObject.defineProperty("Infinity", new Double(Double.POSITIVE_INFINITY), 2);
        scriptableObject.defineProperty("undefined", Undefined.instance, 2);
    }

    public static Object isFinite(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            return Boolean.FALSE;
        }
        double d = ScriptRuntime.toNumber(objectArray[0]);
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Object eval(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        Object[] objectArray2 = new Object[]{"eval"};
        throw Context.reportRuntimeError(Context.getMessage("msg.cant.call.indirect", objectArray2));
    }

    public static Object evalSpecial(Context context, Scriptable scriptable, Object object, Object[] objectArray, String string, int n) throws JavaScriptException {
        if (objectArray.length < 1) {
            return Undefined.instance;
        }
        Object object2 = objectArray[0];
        if (!(object2 instanceof String)) {
            String string2 = Context.getMessage("msg.eval.nonstring", null);
            Context.reportWarning(string2);
            return object2;
        }
        int[] nArray = new int[]{n};
        if (string == null && (string = Context.getSourcePositionFromStack(nArray)) == null) {
            string = "<eval'ed string>";
            nArray[0] = 1;
        }
        try {
            StringReader stringReader = new StringReader((String)object2);
            Object object3 = context.getSecurityDomainForStackDepth(3);
            int n2 = context.getOptimizationLevel();
            context.setOptimizationLevel(-1);
            Script script = context.compileReader(null, stringReader, string, nArray[0], object3);
            context.setOptimizationLevel(n2);
            if (script == null) {
                String string3 = Context.getMessage("msg.syntax", null);
                throw new EvaluatorException(string3);
            }
            InterpretedScript interpretedScript = (InterpretedScript)script;
            Object object4 = interpretedScript.call(context, scriptable, (Scriptable)object, null);
            return object4;
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected io exception");
        }
    }

    public static Object escape(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        int n = URL_XALPHAS | URL_XPALPHAS | URL_PATH;
        if (objectArray.length > 1 && ((d = ScriptRuntime.toNumber(objectArray[1])) != d || (double)(n = (int)d) != d || (n & ~(URL_XALPHAS | URL_XPALPHAS | URL_PATH)) != 0)) {
            String string2 = Context.getMessage("msg.bad.esc.mask", null);
            Context.reportError(string2);
            n = URL_XALPHAS | URL_XPALPHAS | URL_PATH;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (n != 0 && (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '@' || c == '*' || c == '_' || c == '-' || c == '.' || (c == '/' || c == '+') && n > 3)) {
                stringBuffer.append(c);
            } else if (c < '\u0100') {
                if (c == ' ' && n == URL_XPALPHAS) {
                    stringBuffer.append('+');
                } else {
                    stringBuffer.append('%');
                    stringBuffer.append(cArray[c >> 4]);
                    stringBuffer.append(cArray[c & 0xF]);
                }
            } else {
                stringBuffer.append('%');
                stringBuffer.append('u');
                stringBuffer.append(cArray[c >> 12]);
                stringBuffer.append(cArray[(c & 0xF00) >> 8]);
                stringBuffer.append(cArray[(c & 0xF0) >> 4]);
                stringBuffer.append(cArray[c & 0xF]);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

