/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript;

import java.io.IOException;
import java.io.Reader;

final class LineBuffer {
    static final int BUFLEN = 256;
    private Reader in;
    private char[] otherBuffer = null;
    private char[] buffer = null;
    private int offset = 0;
    private int end = 0;
    private int otherEnd;
    private int lineno;
    private int lineStart = 0;
    private int otherStart = 0;
    private int prevStart = 0;
    private boolean lastWasCR = false;
    private boolean hitEOF = false;
    private int stringStart = -1;
    private StringBuffer stringSoFar = null;

    String getLine() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.lineStart;
        if (n >= this.offset) {
            if (this.otherStart < this.otherEnd) {
                stringBuffer.append(this.otherBuffer, this.otherStart, this.otherEnd - this.otherStart);
            }
            n = 0;
        }
        stringBuffer.append(this.buffer, n, this.offset - n);
        int n2 = this.offset;
        while (true) {
            if (n2 == this.buffer.length) {
                char[] cArray = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
                this.buffer = cArray;
                int n3 = 0;
                try {
                    n3 = this.in.read(this.buffer, this.end, this.buffer.length - this.end);
                }
                catch (IOException iOException) {}
                if (n3 < 0) break;
                this.end += n3;
            }
            if (this.buffer[n2] == '\r' || this.buffer[n2] == '\n') break;
            ++n2;
        }
        stringBuffer.append(this.buffer, this.offset, n2 - this.offset);
        return stringBuffer.toString();
    }

    void unread() {
        if (this.offset == 0) {
            return;
        }
        this.offset += -1;
        if ((this.buffer[this.offset] & 0xFFF0) == 0 && (this.buffer[this.offset] == '\r' || this.buffer[this.offset] == '\n')) {
            this.lineStart = this.prevStart;
            this.lineno += -1;
        }
    }

    LineBuffer(Reader reader, int n) {
        this.in = reader;
        this.lineno = n;
    }

    int read() throws IOException {
        if (this.end == this.offset && !this.fill()) {
            return -1;
        }
        if ((this.buffer[this.offset] & 0xFFF0) == 0) {
            if (this.buffer[this.offset] == '\r') {
                if (this.offset + 1 < this.end) {
                    if (this.buffer[this.offset + 1] == '\n') {
                        ++this.offset;
                    }
                } else {
                    this.lastWasCR = true;
                }
            } else if (this.buffer[this.offset] != '\n') {
                return this.buffer[this.offset++];
            }
            ++this.offset;
            this.prevStart = this.lineStart;
            this.lineStart = this.offset;
            ++this.lineno;
            return 10;
        }
        return this.buffer[this.offset++];
    }

    int peek() throws IOException {
        if (this.end == this.offset && !this.fill()) {
            return -1;
        }
        if (this.buffer[this.offset] == '\r') {
            return 10;
        }
        return this.buffer[this.offset];
    }

    void startString() {
        if (this.offset == 0) {
            if (this.buffer == null || this.otherBuffer == null) {
                throw new RuntimeException("startString called before any read");
            }
            this.stringSoFar = new StringBuffer();
            this.stringSoFar.append(this.otherBuffer, this.otherEnd - 1, 1);
            this.stringStart = -1;
            return;
        }
        this.stringSoFar = null;
        this.stringStart = this.offset - 1;
    }

    String getString() {
        String string;
        int n;
        if (this.buffer == null) {
            throw new RuntimeException("very confused");
        }
        int n2 = n = this.offset > 0 && this.buffer[this.offset] == '\n' && this.buffer[this.offset - 1] == '\r' ? 1 : 0;
        if (this.stringStart != -1) {
            if (this.stringSoFar != null) {
                throw new RuntimeException("getString called inconsistently");
            }
            string = new String(this.buffer, this.stringStart, this.offset - this.stringStart - n);
        } else {
            if (this.stringSoFar == null) {
                throw new RuntimeException("getString called at a funny time");
            }
            string = this.stringSoFar.append(this.buffer, 0, this.offset - n).toString();
        }
        this.stringStart = -1;
        this.stringSoFar = null;
        return string;
    }

    boolean fill() throws IOException {
        int n;
        if (this.end - this.offset != 0) {
            throw new IOException("fill of non-empty buffer");
        }
        int n2 = n = this.offset > 0 && this.lastWasCR ? 1 : 0;
        if (this.stringStart != -1) {
            if (this.stringSoFar != null || this.buffer == null) {
                throw new RuntimeException("as usual, I'm confused");
            }
            this.stringSoFar = new StringBuffer();
            this.stringSoFar.append(this.buffer, this.stringStart, this.end - this.stringStart - n);
            this.stringStart = -1;
        } else if (this.stringSoFar != null) {
            this.stringSoFar.append(this.buffer, 0, this.end - n);
        }
        char[] cArray = this.buffer;
        this.buffer = this.otherBuffer;
        this.otherBuffer = cArray;
        if (this.buffer == null) {
            this.buffer = new char[256];
        }
        this.otherStart = this.lineStart;
        this.otherEnd = this.end;
        this.lineStart = this.otherBuffer == null ? 0 : this.buffer.length + 1;
        this.prevStart = this.lineStart;
        this.offset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            this.hitEOF = true;
            return false;
        }
        if (this.lastWasCR) {
            if (this.buffer[0] == '\n') {
                ++this.offset;
                if (this.end == 1) {
                    return this.fill();
                }
            }
            this.lineStart = this.offset;
            this.lastWasCR = false;
        }
        return true;
    }

    boolean eof() {
        return this.hitEOF;
    }

    boolean match(char c) throws IOException {
        if (this.end == this.offset && !this.fill()) {
            return false;
        }
        if (this.buffer[this.offset] == c) {
            ++this.offset;
            return true;
        }
        return false;
    }

    int getLineno() {
        return this.lineno;
    }

    int getOffset() {
        if (this.lineStart >= this.offset) {
            return this.offset + (this.otherEnd - this.otherStart);
        }
        return this.offset - this.lineStart;
    }
}

