/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript;

import com.netscape.javascript.Context;
import com.netscape.javascript.FieldAndMethods;
import com.netscape.javascript.NativeJavaMethod;
import com.netscape.javascript.NativeJavaObject;
import com.netscape.javascript.Scriptable;
import com.netscape.javascript.ScriptableObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;

class JavaMembers {
    private static Hashtable classTable = new Hashtable();
    private Class cl;
    private Hashtable members = new Hashtable(23);
    private Hashtable fieldAndMethods;
    private Hashtable staticMembers = new Hashtable(7);
    private Hashtable staticFieldAndMethods;
    private Constructor[] ctors;

    Object get(Scriptable scriptable, String string, Object object, boolean bl) {
        Object object2;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object v = hashtable.get(string);
        if (v == null) {
            throw this.reportMemberNotFound(string);
        }
        if (v instanceof Scriptable) {
            return v;
        }
        Field field = (Field)v;
        try {
            object2 = field.get(bl ? null : object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
        }
        Class<?> clazz = field.getType();
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return NativeJavaObject.wrap(scriptable, object2, clazz);
    }

    public void put(String string, Object object, Object object2, boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object object3 = hashtable.get(string);
        if (object3 == null) {
            throw this.reportMemberNotFound(string);
        }
        if (object3 instanceof FieldAndMethods) {
            object3 = ((FieldAndMethods)hashtable.get(string)).getField();
        }
        Field field = null;
        try {
            field = (Field)object3;
            field.set(object, NativeJavaObject.coerceType(field.getType(), object2));
            return;
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new Object[]{string};
            throw Context.reportRuntimeError(Context.getMessage("msg.java.method.assign", objectArray));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[]{object2.getClass().getName(), field, object.getClass().getName()};
            throw Context.reportRuntimeError(Context.getMessage("msg.java.internal.field.type", objectArray));
        }
    }

    Constructor[] getConstructors() {
        return this.ctors;
    }

    JavaMembers(Scriptable scriptable, Class clazz) {
        this.cl = clazz;
        this.reflect(scriptable, clazz);
    }

    RuntimeException reportMemberNotFound(String string) {
        Object[] objectArray = new Object[]{this.cl.getName(), string};
        return Context.reportRuntimeError(Context.getMessage("msg.java.member.not.found", objectArray));
    }

    static JavaMembers lookupClass(Scriptable scriptable, Class clazz, Class clazz2) {
        Class clazz3 = clazz;
        JavaMembers javaMembers = (JavaMembers)classTable.get(clazz3);
        if (javaMembers != null) {
            return javaMembers;
        }
        if (clazz2 != null && clazz2 != clazz && !Modifier.isPublic(clazz.getModifiers()) && Modifier.isPublic(clazz2.getModifiers())) {
            clazz3 = clazz2;
        }
        Hashtable hashtable = classTable;
        synchronized (hashtable) {
            javaMembers = (JavaMembers)classTable.get(clazz3);
            if (javaMembers != null) {
                JavaMembers javaMembers2 = javaMembers;
                Object var6_8 = null;
                return javaMembers2;
            }
            javaMembers = new JavaMembers(scriptable, clazz3);
            classTable.put(clazz3, javaMembers);
            JavaMembers javaMembers3 = javaMembers;
            Object var6_9 = null;
            return javaMembers3;
        }
    }

    Hashtable getFieldAndMethodsObjects(Object object, boolean bl) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (hashtable == null) {
            return null;
        }
        int n = hashtable.size();
        Hashtable<String, FieldAndMethods> hashtable3 = new Hashtable<String, FieldAndMethods>(n);
        Enumeration enumeration = hashtable.elements();
        while (n-- > 0) {
            FieldAndMethods fieldAndMethods = (FieldAndMethods)enumeration.nextElement();
            fieldAndMethods = (FieldAndMethods)fieldAndMethods.clone();
            fieldAndMethods.setJavaObject(object);
            hashtable3.put(fieldAndMethods.getName(), fieldAndMethods);
        }
        return hashtable3;
    }

    void reflect(Scriptable scriptable, Class clazz) {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            this.reflectMethod(scriptable, methodArray[n]);
            ++n;
        }
        Field[] fieldArray = clazz.getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            this.reflectField(fieldArray[n2]);
            ++n2;
        }
        this.ctors = clazz.getConstructors();
    }

    void reflectMethod(Scriptable scriptable, Method method) {
        String string;
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            return;
        }
        boolean bl = Modifier.isStatic(n);
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)hashtable.get(string = method.getName());
        if (nativeJavaMethod == null) {
            nativeJavaMethod = new NativeJavaMethod();
            nativeJavaMethod.setParentScope(scriptable);
            nativeJavaMethod.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
            hashtable.put(string, nativeJavaMethod);
            nativeJavaMethod.add(method);
            return;
        }
        nativeJavaMethod.add(method);
    }

    boolean has(String string, boolean bl) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.staticMembers : this.members;
        return hashtable.get(string) != null;
    }

    Object[] getIds(boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        int n = hashtable.size();
        Object[] objectArray = new Object[n];
        Enumeration enumeration = hashtable.keys();
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = enumeration.nextElement();
            ++n2;
        }
        return objectArray;
    }

    Class getReflectedClass() {
        return this.cl;
    }

    void reflectField(Field field) {
        String string;
        int n = field.getModifiers();
        if (!Modifier.isPublic(n)) {
            return;
        }
        boolean bl = Modifier.isStatic(n);
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object v = hashtable.get(string = field.getName());
        if (v != null) {
            if (v instanceof NativeJavaMethod) {
                Hashtable<String, FieldAndMethods> hashtable2;
                NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)v;
                Hashtable<String, FieldAndMethods> hashtable3 = hashtable2 = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
                if (hashtable2 == null) {
                    hashtable2 = new Hashtable<String, FieldAndMethods>(11);
                    if (bl) {
                        this.staticFieldAndMethods = hashtable2;
                    } else {
                        this.fieldAndMethods = hashtable2;
                    }
                }
                FieldAndMethods fieldAndMethods = new FieldAndMethods(nativeJavaMethod.getMethods(), field);
                hashtable2.put(string, fieldAndMethods);
                hashtable.put(string, fieldAndMethods);
                return;
            }
            if (v instanceof Field) {
                throw new RuntimeException("cannot have multiple Java fields with same name");
            }
            throw new RuntimeException("unknown member type");
        }
        hashtable.put(string, field);
    }
}

