/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript;

import com.netscape.javascript.ClassDefinitionException;
import com.netscape.javascript.ClassNameHelper;
import com.netscape.javascript.DeepBytecodeHook;
import com.netscape.javascript.DeepCallHook;
import com.netscape.javascript.DeepErrorReporterHook;
import com.netscape.javascript.DeepExecuteHook;
import com.netscape.javascript.DeepNewObjectHook;
import com.netscape.javascript.DeepScriptHook;
import com.netscape.javascript.DefaultErrorReporter;
import com.netscape.javascript.ErrorReporter;
import com.netscape.javascript.EvaluatorException;
import com.netscape.javascript.Function;
import com.netscape.javascript.IRFactory;
import com.netscape.javascript.Interpreter;
import com.netscape.javascript.JavaScriptException;
import com.netscape.javascript.LazilyLoadedConstructor;
import com.netscape.javascript.NativeArray;
import com.netscape.javascript.NativeCall;
import com.netscape.javascript.NativeFunction;
import com.netscape.javascript.NativeJavaPackage;
import com.netscape.javascript.NativeObject;
import com.netscape.javascript.NativeScript;
import com.netscape.javascript.Node;
import com.netscape.javascript.NotAFunctionException;
import com.netscape.javascript.Parser;
import com.netscape.javascript.PropertyException;
import com.netscape.javascript.RegExpStatics;
import com.netscape.javascript.Script;
import com.netscape.javascript.ScriptRuntime;
import com.netscape.javascript.Scriptable;
import com.netscape.javascript.ScriptableObject;
import com.netscape.javascript.SecuritySupport;
import com.netscape.javascript.SourceTextManager;
import com.netscape.javascript.ThreadLinkException;
import com.netscape.javascript.TokenStream;
import com.netscape.javascript.Undefined;
import com.netscape.javascript.WrappedException;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Context {
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    static final String defaultResource = "com.netscape.javascript.resources.Messages";
    static final boolean printTrees = false;
    private static Class codegenClass;
    private static boolean requireSecurityDomain;
    static final boolean useJSObject = false;
    NativeCall currentActivation;
    Hashtable iterating;
    Object interpreterSecurityDomain;
    int version;
    int errorCount;
    private SecuritySupport securitySupport;
    private ErrorReporter errorReporter;
    private Thread currentThread;
    private static Hashtable threadContexts;
    private static ClassNameHelper nameHelper;
    private RegExpStatics regExpStatics;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingSource = true;
    private int optimizationLevel;
    private SourceTextManager debug_stm;
    private DeepScriptHook debug_scriptHook;
    private DeepCallHook debug_callHook;
    private DeepExecuteHook debug_executeHook;
    private DeepNewObjectHook debug_newObjectHook;
    private DeepBytecodeHook debug_bytecodeHook;
    private DeepErrorReporterHook debug_errorReporterHook;
    private byte debugLevel;
    private static /* synthetic */ Class class$com$netscape$javascript$NativeFunction;
    private static /* synthetic */ Class class$com$netscape$javascript$NativeObject;
    private static /* synthetic */ Class class$com$netscape$javascript$NativeGlobal;
    private static /* synthetic */ Class class$com$netscape$javascript$Interpreter;

    public synchronized void enter() throws ThreadLinkException, InterruptedException {
        Thread thread = Thread.currentThread();
        while (this.currentThread != null) {
            if (thread == this.currentThread) {
                throw new ThreadLinkException("Context already associated with a Thread");
            }
            this.wait();
        }
        this.currentThread = thread;
        Hashtable hashtable = threadContexts;
        synchronized (hashtable) {
            Context context = (Context)threadContexts.get(thread);
            if (context != null) {
                this.currentThread = null;
                throw new ThreadLinkException("Thread already associated with a Context");
            }
            threadContexts.put(thread, this);
            Object var4_4 = null;
            return;
        }
    }

    public String getTargetPackage() {
        if (nameHelper == null) {
            return null;
        }
        return nameHelper.getTargetPackage();
    }

    public void setTargetPackage(String string) {
        if (nameHelper != null) {
            nameHelper.setTargetPackage(string);
        }
    }

    public static boolean toBoolean(Object object) {
        return ScriptRuntime.toBoolean(object);
    }

    public String getTargetClassFileName() {
        if (nameHelper == null) {
            return null;
        }
        return nameHelper.getTargetClassFileName();
    }

    public void setTargetClassFileName(String string) {
        if (nameHelper != null) {
            nameHelper.setTargetClassFileName(string);
        }
    }

    public Function compileFunction(Scriptable scriptable, String string, String string2, int n, Object object) {
        StringReader stringReader = new StringReader(string);
        try {
            return (Function)this.compile(scriptable, stringReader, string2, n, object, true);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public String decompileScript(Script script, Scriptable scriptable, int n) {
        NativeScript nativeScript = (NativeScript)script;
        nativeScript.initScript(scriptable);
        return nativeScript.decompile(n, true, false);
    }

    public Scriptable newObject(Scriptable scriptable) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scriptable, "Object", null);
    }

    public Scriptable newObject(Scriptable scriptable, String string) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scriptable, string, null);
    }

    public Scriptable newObject(Scriptable scriptable, String string, Object[] objectArray) throws PropertyException, NotAFunctionException, JavaScriptException {
        Object object = scriptable.get(string, scriptable);
        if (object == Scriptable.NOT_FOUND) {
            Object[] objectArray2 = new Object[]{string};
            String string2 = Context.getMessage("msg.ctor.not.found", objectArray2);
            throw new PropertyException(string2);
        }
        if (!(object instanceof Function)) {
            Object[] objectArray3 = new Object[]{string};
            String string3 = Context.getMessage("msg.not.ctor", objectArray3);
            throw new NotAFunctionException(string3);
        }
        Function function = (Function)object;
        return function.construct(this, function.getParentScope(), objectArray == null ? ScriptRuntime.emptyArgs : objectArray);
    }

    public void setGeneratingSource(boolean bl) {
        this.generatingSource = bl;
    }

    public Object getInterpreterSecurityDomain() {
        return this.interpreterSecurityDomain;
    }

    public DeepScriptHook getScriptHook() {
        return this.debug_scriptHook;
    }

    public static void reportError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            ++context.errorCount;
            context.getErrorReporter().error(string, string2, n, string3, n2);
            return;
        }
        throw new EvaluatorException(string);
    }

    public static void reportError(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportError(string, string2, nArray[0], null, 0);
    }

    public boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public DeepScriptHook setScriptHook(DeepScriptHook deepScriptHook) {
        DeepScriptHook deepScriptHook2 = this.debug_scriptHook;
        this.debug_scriptHook = deepScriptHook;
        return deepScriptHook2;
    }

    static String getMessage(String string, Object[] objectArray) {
        String string2;
        Context context = Context.getCurrentContext();
        Locale locale = context != null ? context.getLocale() : Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(defaultResource, locale);
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("no message resource found for message property " + string);
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray);
    }

    Object getSecurityDomainForStackDepth(int n) {
        Object object = null;
        if (this.securitySupport != null) {
            Class[] classArray = this.securitySupport.getClassContext();
            int n2 = n + 1;
            if (n2 >= 0 && n2 < classArray.length) {
                object = this.getSecurityDomainFromClass(classArray[n2]);
            }
        }
        if (object != null) {
            return object;
        }
        if (requireSecurityDomain) {
            throw new SecurityException("Required security context not found");
        }
        return null;
    }

    public Scriptable initStandardObjects(ScriptableObject scriptableObject) {
        try {
            if (scriptableObject == null) {
                scriptableObject = new NativeObject();
            }
            ScriptableObject.defineClass(scriptableObject, class$com$netscape$javascript$NativeFunction != null ? class$com$netscape$javascript$NativeFunction : (class$com$netscape$javascript$NativeFunction = Context.class$("com.netscape.javascript.NativeFunction")));
            ScriptableObject.defineClass(scriptableObject, class$com$netscape$javascript$NativeObject != null ? class$com$netscape$javascript$NativeObject : (class$com$netscape$javascript$NativeObject = Context.class$("com.netscape.javascript.NativeObject")));
            Scriptable scriptable = ScriptableObject.getObjectPrototype(scriptableObject);
            Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptableObject);
            scriptable2.setPrototype(scriptable);
            if (scriptableObject.getPrototype() == null) {
                scriptableObject.setPrototype(scriptable);
            }
            ScriptableObject.defineClass(scriptableObject, class$com$netscape$javascript$NativeGlobal != null ? class$com$netscape$javascript$NativeGlobal : (class$com$netscape$javascript$NativeGlobal = Context.class$("com.netscape.javascript.NativeGlobal")));
            String[] stringArray = new String[]{"Array", "String", "Boolean", "Number", "Date", "Math", "Call", "Closure", "With", "RegExp", "Script"};
            int n = 0;
            while (n < stringArray.length) {
                String string = "com.netscape.javascript.Native" + stringArray[n];
                new LazilyLoadedConstructor(scriptableObject, stringArray[n], string, 2);
                ++n;
            }
            NativeJavaPackage.init(scriptableObject);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapException(invocationTargetException);
        }
        catch (ClassDefinitionException classDefinitionException) {
            throw WrappedException.wrapException(classDefinitionException);
        }
        catch (PropertyException propertyException) {
            throw WrappedException.wrapException(propertyException);
        }
        return scriptableObject;
    }

    public Scriptable newArray(Scriptable scriptable, int n) {
        NativeArray nativeArray = new NativeArray(n);
        this.newArrayHelper(scriptable, nativeArray);
        return nativeArray;
    }

    public Scriptable newArray(Scriptable scriptable, Object[] objectArray) {
        NativeArray nativeArray = new NativeArray(objectArray);
        this.newArrayHelper(scriptable, nativeArray);
        return nativeArray;
    }

    public static void reportWarning(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getContext();
        context.getErrorReporter().warning(string, string2, n, string3, n2);
    }

    public static void reportWarning(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportWarning(string, string2, nArray[0], null, 0);
    }

    public Object evaluateString(Scriptable scriptable, String string, String string2, int n, Object object) throws JavaScriptException {
        try {
            StringReader stringReader = new StringReader(string);
            return this.evaluateReader(scriptable, stringReader, string2, n, object);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    SecuritySupport getSecuritySupport() {
        return this.securitySupport;
    }

    public synchronized void exit() throws ThreadLinkException {
        Thread thread = Thread.currentThread();
        if (thread != this.currentThread) {
            throw new ThreadLinkException("Context is not associated with the current Thread");
        }
        threadContexts.remove(thread);
        this.currentThread = null;
        this.notify();
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public static String toString(Object object) {
        return ScriptRuntime.toString(object);
    }

    RegExpStatics getRegExpStatics() {
        if (this.regExpStatics == null) {
            this.regExpStatics = new RegExpStatics();
        }
        return this.regExpStatics;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public Locale setLocale(Locale locale) {
        Locale locale2 = this.locale;
        this.locale = locale;
        return locale2;
    }

    private Object compile(Scriptable scriptable, Reader reader, String string, int n, Object object, boolean bl) throws IOException {
        TokenStream tokenStream = new TokenStream(reader, string, n);
        return this.compile(scriptable, tokenStream, object, bl);
    }

    private Object compile(Scriptable scriptable, TokenStream tokenStream, Object object, boolean bl) throws IOException {
        Interpreter interpreter = null;
        if (this.optimizationLevel == -1 || codegenClass == null) {
            interpreter = new Interpreter();
        } else {
            try {
                interpreter = (Interpreter)codegenClass.newInstance();
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (interpreter == null) {
                throw new RuntimeException("Malformed optimizer package");
            }
        }
        this.errorCount = 0;
        IRFactory iRFactory = interpreter.createIRFactory(tokenStream, nameHelper);
        Parser parser = new Parser(iRFactory);
        Node node = (Node)parser.parse(tokenStream);
        if (node == null) {
            return null;
        }
        node = interpreter.transform(node, tokenStream);
        if (bl) {
            Node node2 = node.getFirstChild();
            if (node2 == null) {
                return null;
            }
            node = (Node)node2.getProp(5);
            if (node == null) {
                return null;
            }
        }
        return interpreter.compile(this, scriptable, node, object, this.securitySupport, nameHelper);
    }

    public Object[] getElements(Scriptable scriptable) {
        double d = NativeArray.getLengthProperty(scriptable);
        if (d != d) {
            return null;
        }
        int n = (int)d;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            Object object = scriptable.get(n2, scriptable);
            objectArray[n2] = object == Scriptable.NOT_FOUND ? Undefined.instance : object;
            ++n2;
        }
        return objectArray;
    }

    public static EvaluatorException reportRuntimeError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            ++context.errorCount;
            return context.getErrorReporter().runtimeError(string, string2, n, string3, n2);
        }
        throw new EvaluatorException(string);
    }

    public static EvaluatorException reportRuntimeError(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        return Context.reportRuntimeError(string, string2, nArray[0], null, 0);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int n) {
        this.version = n;
    }

    public Object evaluateReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException, JavaScriptException {
        Script script = this.compileReader(scriptable, reader, string, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    public static double toNumber(Object object) {
        return ScriptRuntime.toNumber(object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    public boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public synchronized boolean stringIsCompilableUnit(String string) {
        StringReader stringReader = new StringReader(string);
        TokenStream tokenStream = new TokenStream(stringReader, null, 1);
        DeepErrorReporterHook deepErrorReporterHook = this.setErrorReporterHook(null);
        ErrorReporter errorReporter = this.setErrorReporter(new DefaultErrorReporter());
        boolean bl = false;
        try {
            try {
                IRFactory iRFactory = new IRFactory(tokenStream);
                Parser parser = new Parser(iRFactory);
                parser.parse(tokenStream);
            }
            catch (IOException iOException) {
                bl = true;
            }
            catch (EvaluatorException evaluatorException) {
                bl = true;
            }
            Object var10_9 = null;
            this.setErrorReporter(errorReporter);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.setErrorReporter(errorReporter);
            this.setErrorReporterHook(deepErrorReporterHook);
            throw throwable;
        }
        this.setErrorReporterHook(deepErrorReporterHook);
        return !bl || !tokenStream.eof();
    }

    public DeepCallHook getCallHook() {
        return this.debug_callHook;
    }

    public DeepCallHook setCallHook(DeepCallHook deepCallHook) {
        DeepCallHook deepCallHook2 = this.debug_callHook;
        this.debug_callHook = deepCallHook;
        return deepCallHook2;
    }

    public DeepNewObjectHook getNewObjectHook() {
        return this.debug_newObjectHook;
    }

    public DeepNewObjectHook setNewObjectHook(DeepNewObjectHook deepNewObjectHook) {
        DeepNewObjectHook deepNewObjectHook2 = this.debug_newObjectHook;
        this.debug_newObjectHook = deepNewObjectHook;
        return deepNewObjectHook2;
    }

    public DeepBytecodeHook getBytecodeHook() {
        return this.debug_bytecodeHook;
    }

    public DeepBytecodeHook setBytecodeHook(DeepBytecodeHook deepBytecodeHook) {
        DeepBytecodeHook deepBytecodeHook2 = this.debug_bytecodeHook;
        this.debug_bytecodeHook = deepBytecodeHook;
        return deepBytecodeHook2;
    }

    public DeepErrorReporterHook getErrorReporterHook() {
        return this.debug_errorReporterHook;
    }

    public DeepErrorReporterHook setErrorReporterHook(DeepErrorReporterHook deepErrorReporterHook) {
        DeepErrorReporterHook deepErrorReporterHook2 = this.debug_errorReporterHook;
        this.debug_errorReporterHook = deepErrorReporterHook;
        return deepErrorReporterHook2;
    }

    public String getImplementationVersion() {
        return "JavaScript-Java 1.4 release 2 1998 12 18";
    }

    static String getSourcePositionFromStack(int[] nArray) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        RuntimeException runtimeException = new RuntimeException();
        runtimeException.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == ':') {
                n3 = n4;
            } else if (c == '(') {
                n = n4;
            } else if (c == ')') {
                n2 = n4;
            } else if (c == '\n' && n != -1 && n2 != -1 && n3 != -1) {
                String string2 = string.substring(n + 1, n3);
                if (string2.endsWith(".js")) {
                    String string3 = string.substring(n3 + 1, n2);
                    try {
                        nArray[0] = Integer.parseInt(string3);
                        return string2;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                n3 = -1;
                n2 = -1;
                n = -1;
            }
            ++n4;
        }
        return null;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int n) {
        if (n < 0) {
            n = -1;
        } else if (n > 9) {
            n = 9;
        }
        if (codegenClass == null) {
            n = -1;
        }
        this.optimizationLevel = n;
    }

    public SourceTextManager getSourceTextManager() {
        return this.debug_stm;
    }

    public SourceTextManager setSourceTextManager(SourceTextManager sourceTextManager) {
        SourceTextManager sourceTextManager2 = this.debug_stm;
        this.debug_stm = sourceTextManager;
        return sourceTextManager2;
    }

    public static boolean isSecurityDomainRequired() {
        return requireSecurityDomain;
    }

    public ErrorReporter getErrorReporter() {
        if (this.debug_errorReporterHook != null) {
            return this.debug_errorReporterHook;
        }
        if (this.errorReporter == null) {
            this.errorReporter = new DefaultErrorReporter();
        }
        return this.errorReporter;
    }

    public ErrorReporter setErrorReporter(ErrorReporter errorReporter) {
        if (this.debug_errorReporterHook != null) {
            return this.debug_errorReporterHook.setErrorReporter(errorReporter);
        }
        ErrorReporter errorReporter2 = this.errorReporter;
        this.errorReporter = errorReporter;
        return errorReporter2;
    }

    public DeepExecuteHook getExecuteHook() {
        return this.debug_executeHook;
    }

    public DeepExecuteHook setExecuteHook(DeepExecuteHook deepExecuteHook) {
        DeepExecuteHook deepExecuteHook2 = this.debug_executeHook;
        this.debug_executeHook = deepExecuteHook;
        return deepExecuteHook2;
    }

    public String decompileFunctionBody(Function function, int n) {
        if (function instanceof NativeFunction) {
            return ((NativeFunction)function).decompile(n, true, true);
        }
        return "[native code]\n";
    }

    public Script compileReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        return (Script)this.compile(scriptable, reader, string, n, object, false);
    }

    public String decompileFunction(Function function, int n) {
        if (function instanceof NativeFunction) {
            return ((NativeFunction)function).decompile(n, true, false);
        }
        return "function " + function.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public Context() {
        this.setLanguageVersion(0);
        this.generatingDebug = true;
        if (codegenClass != null) {
            this.optimizationLevel = 0;
            ReflectiveOperationException reflectiveOperationException = null;
            try {
                Class<?> clazz = Class.forName("com.netscape.javascript.optimizer.OptClassNameHelper");
                nameHelper = (ClassNameHelper)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                reflectiveOperationException = classNotFoundException;
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                reflectiveOperationException = instantiationException;
            }
            if (reflectiveOperationException != null) {
                throw new RuntimeException("Malformed optimizer package " + reflectiveOperationException);
            }
        } else {
            this.optimizationLevel = -1;
        }
    }

    public Context(SecuritySupport securitySupport) {
        this();
        this.securitySupport = securitySupport;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setGeneratingDebug(boolean bl) {
        if (bl) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = bl;
    }

    public int setDebugLevel(int n) {
        byte by = this.debugLevel;
        if (n < 0) {
            n = 0;
        } else if (n > 9) {
            n = 9;
        }
        if (n > 0) {
            this.setOptimizationLevel(0);
        }
        this.debugLevel = (byte)n;
        return by;
    }

    static {
        try {
            codegenClass = Class.forName("com.netscape.javascript.optimizer.Codegen");
        }
        catch (ClassNotFoundException classNotFoundException) {
            codegenClass = null;
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.netscape.javascript.resources.Security");
        try {
            String string = resourceBundle.getString("security.requireSecurityDomain");
            requireSecurityDomain = string.equals("true");
        }
        catch (MissingResourceException missingResourceException) {
            requireSecurityDomain = true;
        }
        threadContexts = new Hashtable(11);
    }

    public static Context getCurrentContext() {
        Thread thread = Thread.currentThread();
        return (Context)threadContexts.get(thread);
    }

    private void newArrayHelper(Scriptable scriptable, Scriptable scriptable2) {
        scriptable2.setParentScope(scriptable);
        Object object = scriptable.get("Array", scriptable);
        if (object != null && object instanceof Scriptable) {
            Scriptable scriptable3 = (Scriptable)object;
            scriptable2.setPrototype((Scriptable)scriptable3.get("prototype", scriptable3));
        }
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    public boolean isInterpreterClass(Class clazz) {
        return clazz == (class$com$netscape$javascript$Interpreter != null ? class$com$netscape$javascript$Interpreter : (class$com$netscape$javascript$Interpreter = Context.class$("com.netscape.javascript.Interpreter")));
    }

    static Context getContext() {
        Thread thread = Thread.currentThread();
        Context context = (Context)threadContexts.get(thread);
        if (context == null) {
            throw new WrappedException(new ThreadLinkException("No Context associated with current Thread"));
        }
        return context;
    }

    Object getSecurityDomainFromClass(Class clazz) {
        if (clazz == (class$com$netscape$javascript$Interpreter != null ? class$com$netscape$javascript$Interpreter : (class$com$netscape$javascript$Interpreter = Context.class$("com.netscape.javascript.Interpreter")))) {
            return this.interpreterSecurityDomain;
        }
        return this.securitySupport.getSecurityDomain(clazz);
    }
}

