/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.visualizers.Spline3;
import org.apache.jmeter.visualizers.Visualizer;

public class SplineVisualizer
extends JPanel
implements Visualizer {
    protected SampleCollection sampleCollection = null;
    protected Spline3 dataCurve = null;
    protected long sum = 0L;
    protected long average = 0L;
    protected long n = 0L;
    private SplineGraph graph = null;
    public final int DEFAULT_NUMBER_OF_NODES = 10;
    public final int DEFAULT_REFRESH_PERIOD = 1;
    protected int numberOfNodes = 10;
    protected int refreshPeriod = 1;
    protected final Color BACKGROUND_COLOR = this.getBackground();
    protected final Color MINIMUM_COLOR = new Color(0.0f, 0.5f, 0.0f);
    protected final Color MAXIMUM_COLOR = new Color(0.9f, 0.0f, 0.0f);
    protected final Color AVERAGE_COLOR = new Color(0.0f, 0.0f, 0.75f);
    protected final Color INCOMING_COLOR = Color.black;
    protected final boolean SHOW_INCOMING_SAMPLES = true;
    private JLabel minimumLabel = null;
    private JLabel maximumLabel = null;
    private JLabel averageLabel = null;
    private JLabel incomingLabel = null;
    private JLabel minimumNumberLabel = null;
    private JLabel maximumNumberLabel = null;
    private JLabel averageNumberLabel = null;
    private JLabel incomingNumberLabel = null;
    protected final int NUMBERS_TO_DISPLAY = 4;
    protected final boolean FILL_UP_WITH_ZEROS = false;

    public SplineVisualizer() {
        this.sampleCollection = new SampleCollection();
        this.setGUI();
    }

    public synchronized void add(long l) {
        ++this.n;
        this.sum += l;
        this.average = this.sum / this.n;
        this.setIncoming(l);
        this.sampleCollection.add(l);
        this.sampleCollection.add(l);
        int n = this.sampleCollection.getNumberOfCollectedSamples();
        if (n % (this.numberOfNodes * this.refreshPeriod) == 0) {
            float[] fArray = new float[this.numberOfNodes];
            long[] lArray = this.sampleCollection.getSamples();
            int n2 = n / this.numberOfNodes;
            long l2 = Integer.MAX_VALUE;
            long l3 = Integer.MIN_VALUE;
            int n3 = 0;
            while (n3 < this.numberOfNodes) {
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = n3;
                    fArray[n5] = fArray[n5] + (float)this.sampleCollection.getSample(n3 * n2 + n4);
                    ++n4;
                }
                fArray[n3] = fArray[n3] / (float)n2;
                if (fArray[n3] < (float)l2) {
                    l2 = Math.round(fArray[n3]);
                }
                if (fArray[n3] > (float)l3) {
                    l3 = Math.round(fArray[n3]);
                }
                ++n3;
            }
            this.setMinimum(l2);
            this.setMaximum(l3);
            this.setAverage(this.average);
            this.dataCurve = new Spline3(fArray);
            this.graph.reinterpolated = true;
        }
        this.repaint();
    }

    public synchronized void clear() {
        this.graph.clear();
        this.setMinimum(0L);
        this.setMaximum(0L);
        this.setAverage(0L);
        this.setIncoming(0L);
        this.n = 0L;
        this.sum = 0L;
        this.average = 0L;
        this.dataCurve = null;
        this.sampleCollection = new SampleCollection();
        this.repaint();
    }

    public String formatMeasureToDisplay(long l) {
        String string = String.valueOf(l);
        return string;
    }

    public void setAverage(long l) {
        String string = String.valueOf(this.formatMeasureToDisplay(l)) + " ms";
        this.averageNumberLabel.setText(string);
    }

    public void setGUI() {
        Color color = this.BACKGROUND_COLOR;
        this.setBackground(color);
        this.graph = new SplineGraph();
        this.maximumLabel = new JLabel("Maximum");
        this.maximumLabel.setForeground(this.MAXIMUM_COLOR);
        this.maximumLabel.setBackground(color);
        this.averageLabel = new JLabel("Average");
        this.averageLabel.setForeground(this.AVERAGE_COLOR);
        this.averageLabel.setBackground(color);
        this.incomingLabel = new JLabel("Incoming");
        this.incomingLabel.setForeground(this.INCOMING_COLOR);
        this.incomingLabel.setBackground(color);
        this.minimumLabel = new JLabel("Minimum");
        this.minimumLabel.setForeground(this.MINIMUM_COLOR);
        this.minimumLabel.setBackground(color);
        this.maximumNumberLabel = new JLabel("0 ms");
        this.maximumNumberLabel.setHorizontalAlignment(4);
        this.maximumNumberLabel.setForeground(this.MAXIMUM_COLOR);
        this.maximumNumberLabel.setBackground(color);
        this.averageNumberLabel = new JLabel("0 ms");
        this.averageNumberLabel.setHorizontalAlignment(4);
        this.averageNumberLabel.setForeground(this.AVERAGE_COLOR);
        this.averageNumberLabel.setBackground(color);
        this.incomingNumberLabel = new JLabel("0 ms");
        this.incomingNumberLabel.setHorizontalAlignment(4);
        this.incomingNumberLabel.setForeground(this.INCOMING_COLOR);
        this.incomingNumberLabel.setBackground(color);
        this.minimumNumberLabel = new JLabel("0 ms");
        this.minimumNumberLabel.setHorizontalAlignment(4);
        this.minimumNumberLabel.setForeground(this.MINIMUM_COLOR);
        this.minimumNumberLabel.setBackground(color);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        jPanel.setBackground(color);
        jPanel.add(this.maximumLabel);
        jPanel.add(this.averageLabel);
        jPanel.add(this.incomingLabel);
        jPanel.add(this.minimumLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        jPanel2.setBackground(color);
        jPanel2.add(this.maximumNumberLabel);
        jPanel2.add(this.averageNumberLabel);
        jPanel2.add(this.incomingNumberLabel);
        jPanel2.add(this.minimumNumberLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "East");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "West");
        this.add((Component)this.graph, "Center");
    }

    public void setIncoming(long l) {
        String string = String.valueOf(this.formatMeasureToDisplay(l)) + " ms";
        this.incomingNumberLabel.setText(string);
    }

    public void setMaximum(long l) {
        String string = String.valueOf(this.formatMeasureToDisplay(l)) + " ms";
        this.maximumNumberLabel.setText(string);
    }

    public void setMinimum(long l) {
        String string = String.valueOf(this.formatMeasureToDisplay(l)) + " ms";
        this.minimumNumberLabel.setText(string);
    }

    public String toString() {
        return "Show the samples analysis as a Spline curve";
    }

    public class SplineGraph
    extends JComponent {
        protected final Color WAITING_COLOR = Color.darkGray;
        protected int lastWidth = -1;
        protected int lastHeight = -1;
        protected int[] plot = null;
        public boolean reinterpolated = false;

        public void clear() {
            this.lastWidth = -1;
            this.lastHeight = -1;
            this.plot = null;
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (SplineVisualizer.this.dataCurve == null) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(this.WAITING_COLOR);
                graphics.drawString("Waiting for samples", (n - 120) / 2, n2 - (n2 - 12) / 2);
                return;
            }
            boolean bl = true;
            if (n == this.lastWidth && n2 == this.lastHeight) {
                bl = false;
            } else {
                bl = true;
                this.lastWidth = n;
                this.lastHeight = n2;
            }
            if (bl || this.reinterpolated) {
                this.plot = SplineVisualizer.this.dataCurve.getPlots(n, n2);
                this.reinterpolated = false;
            }
            int n3 = this.plot.length;
            int n4 = this.plot[0];
            int n5 = 1;
            while (n5 < n3) {
                graphics.setColor(Color.black);
                graphics.drawLine(n5 - 1, n2 - n4 - 1, n5, n2 - this.plot[n5] - 1);
                n4 = this.plot[n5];
                ++n5;
            }
        }
    }

    protected static interface SampleCollector {
        public void add(long var1);

        public void clear();

        public int getNumberOfCollectedSamples();

        public long getSample(int var1);

        public long[] getSamples();
    }

    protected class SampleCollection
    implements SampleCollector {
        protected Vector samples = new Vector(500, 500);

        public void add(long l) {
            this.samples.addElement(new Long(l));
        }

        public void clear() {
            this.samples.removeAllElements();
        }

        public int getNumberOfCollectedSamples() {
            return this.samples.size();
        }

        public long getSample(int n) {
            Long l = (Long)this.samples.elementAt(n);
            return l;
        }

        public long[] getSamples() {
            int n = this.samples.size();
            long[] lArray = new long[n];
            int n2 = 0;
            while (n2 < n) {
                lArray[n2] = (Long)this.samples.elementAt(n2);
                ++n2;
            }
            return lArray;
        }
    }
}

