/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import org.apache.jmeter.visualizers.Visualizer;

public class GraphVisualizer
extends JPanel
implements Visualizer,
ItemListener {
    private Graph graph;
    private JCheckBox data = new JCheckBox("data");
    private JCheckBox average;
    private JCheckBox deviation;
    private JTextField dataField;
    private JTextField averageField;
    private JTextField deviationField;

    public GraphVisualizer() {
        this.data.setSelected(true);
        this.data.addItemListener(this);
        this.data.setForeground(Color.black);
        this.average = new JCheckBox("average");
        this.average.setSelected(true);
        this.average.addItemListener(this);
        this.average.setForeground(Color.blue);
        this.deviation = new JCheckBox("deviation");
        this.deviation.setSelected(true);
        this.deviation.addItemListener(this);
        this.deviation.setForeground(Color.red);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.data);
        jPanel.add(this.average);
        jPanel.add(this.deviation);
        this.graph = new Graph();
        JScrollPane jScrollPane = new JScrollPane(this.graph);
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.dataField = new JTextField("0000");
        this.dataField.setEditable(false);
        this.dataField.setForeground(Color.black);
        this.dataField.setBackground(this.getBackground());
        this.averageField = new JTextField("0000");
        this.averageField.setEditable(false);
        this.averageField.setForeground(Color.blue);
        this.averageField.setBackground(this.getBackground());
        this.deviationField = new JTextField("0000");
        this.deviationField.setEditable(false);
        this.deviationField.setForeground(Color.red);
        this.deviationField.setBackground(this.getBackground());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel2.add(this.dataField);
        jPanel2.add(this.averageField);
        jPanel2.add(this.deviationField);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "West");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "East");
    }

    public synchronized void add(long l) {
        Sample sample = this.graph.add(l);
        this.dataField.setText(Long.toString(sample.data));
        this.averageField.setText(Long.toString(sample.average));
        this.deviationField.setText(Long.toString(sample.deviation));
        this.repaint();
    }

    public synchronized void clear() {
        this.graph.clear();
        this.dataField.setText("0000");
        this.averageField.setText("0000");
        this.deviationField.setText("0000");
        this.repaint();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItem() == this.data) {
            this.graph.enableData(itemEvent.getStateChange() == 1);
        } else if (itemEvent.getItem() == this.average) {
            this.graph.enableAverage(itemEvent.getStateChange() == 1);
        } else if (itemEvent.getItem() == this.deviation) {
            this.graph.enableDeviation(itemEvent.getStateChange() == 1);
        }
        this.graph.repaint();
    }

    public String toString() {
        return "Show the samples analysys as dot plots";
    }

    public class Sample {
        public long data;
        public long average;
        public long deviation;

        public Sample(long l, long l2, long l3) {
            this.data = l;
            this.average = l2;
            this.deviation = l3;
        }
    }

    public class Graph
    extends JComponent
    implements Scrollable {
        private boolean data = true;
        private boolean average = true;
        private boolean deviation = true;
        private long averageSum = 0L;
        private long variationSum = 0L;
        private long counter = 0L;
        private long previous = 0L;
        private long max = 1L;
        private Vector samples = new Vector(500);

        public Graph() {
            this.setPreferredSize(new Dimension(2000, 100));
        }

        public Sample add(long l) {
            ++this.counter;
            if (l > this.max) {
                this.max = l;
            }
            this.averageSum += l;
            long l2 = this.averageSum / this.counter;
            this.variationSum = (long)((double)this.variationSum + Math.pow(l - l2, 2.0));
            long l3 = (long)Math.pow(this.variationSum / this.counter, 0.5);
            Sample sample = new Sample(l, l2, l3);
            this.previous = l;
            this.samples.addElement(sample);
            return sample;
        }

        public void clear() {
            this.samples.removeAllElements();
            this.averageSum = 0L;
            this.variationSum = 0L;
            this.counter = 0L;
            this.previous = 0L;
            this.max = 1L;
        }

        public void enableAverage(boolean bl) {
            this.average = bl;
        }

        public void enableData(boolean bl) {
            this.data = bl;
        }

        public void enableDeviation(boolean bl) {
            this.deviation = bl;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(400, 100);
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 50;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 1;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = this.getSize();
            Enumeration enumeration = this.samples.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                int n2;
                Sample sample = (Sample)enumeration.nextElement();
                if (this.data) {
                    n2 = (int)(sample.data * (long)dimension.height / this.max);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n, dimension.height - n2, 1, 2);
                }
                if (this.average) {
                    n2 = (int)(sample.average * (long)dimension.height / this.max);
                    graphics.setColor(Color.blue);
                    graphics.fillRect(n, dimension.height - n2, 1, 2);
                }
                if (this.deviation) {
                    n2 = (int)(sample.deviation * (long)dimension.height / this.max);
                    graphics.setColor(Color.red);
                    graphics.fillRect(n, dimension.height - n2, 1, 2);
                }
                ++n;
            }
        }
    }
}

