/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.jmeter.samplers.Cookie;

public class CookieManager
implements Cloneable {
    private Vector cookies = new Vector();
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEEE, dd-MMM-yyyy HH:mm:ss zzz");

    public CookieManager(String string) throws IOException {
        String string2;
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string2 = bufferedReader.readLine()) != null) {
            try {
                if (string2.startsWith("#") || string2.trim().length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                boolean bl = new Boolean(stringTokenizer.nextToken());
                long l = new Long(stringTokenizer.nextToken());
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                Cookie cookie = new Cookie(string6, string7, string3, string5, bl, l);
                this.cookies.addElement(cookie);
            }
            catch (Exception exception) {
                throw new IOException("Error parsing cookie line\n\t'" + string2 + "'\n\t" + exception);
            }
        }
        bufferedReader.close();
    }

    public void addCookieFromHeader(String string, URL uRL) {
        Object object;
        Object object2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
        String string3 = stringTokenizer2.nextToken();
        String string4 = stringTokenizer2.nextToken();
        String string5 = uRL.getHost();
        String string6 = uRL.getFile();
        Cookie cookie = new Cookie(string3, string4, string5, string6, false, System.currentTimeMillis() + 86400000L);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            stringTokenizer2 = new StringTokenizer(string2 = string2.trim(), "=");
            object2 = stringTokenizer2.nextToken();
            if (((String)object2).equalsIgnoreCase("expires")) {
                try {
                    String string7 = stringTokenizer2.nextToken();
                    object = dateFormat.parse(string7);
                    cookie.setExpires(((Date)object).getTime());
                }
                catch (ParseException parseException) {}
                continue;
            }
            if (string3.equalsIgnoreCase("domain")) {
                cookie.setDomain(stringTokenizer2.nextToken());
                continue;
            }
            if (string3.equalsIgnoreCase("path")) {
                cookie.setPath(stringTokenizer2.nextToken());
                continue;
            }
            if (!string3.equalsIgnoreCase("secure")) continue;
            cookie.setSecure(true);
        }
        object2 = new Vector();
        int n = this.cookies.size() - 1;
        while (n > 0) {
            object = (Cookie)this.cookies.elementAt(n);
            if (object != null && ((Cookie)object).getPath().equals(cookie.getPath()) && ((Cookie)object).getDomain().equals(cookie.getDomain()) && ((Cookie)object).getName().equals(cookie.getName())) {
                ((Vector)object2).addElement(new Integer(n));
            }
            --n;
        }
        object = ((Vector)object2).elements();
        while (object.hasMoreElements()) {
            int n2 = (Integer)object.nextElement();
            this.cookies.removeElementAt(n2);
        }
        if (cookie.getExpires() >= System.currentTimeMillis()) {
            this.cookies.addElement(cookie);
        }
    }

    public String getCookieHeaderForURL(URL uRL) {
        if (!uRL.getProtocol().toUpperCase().equals("HTTP")) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.cookies.elements();
        while (enumeration.hasMoreElements()) {
            Cookie cookie = (Cookie)enumeration.nextElement();
            if (!uRL.getHost().endsWith(cookie.getDomain()) || !uRL.getFile().startsWith(cookie.getPath()) || System.currentTimeMillis() / 1000L > cookie.getExpires()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        if (stringBuffer.length() != 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public void removeCookieNamed(String string) {
        Object object;
        Vector<Integer> vector = new Vector<Integer>();
        int n = this.cookies.size() - 1;
        while (n > 0) {
            object = (Cookie)this.cookies.elementAt(n);
            if (object != null && ((Cookie)object).getName().equals(string)) {
                vector.addElement(new Integer(n));
            }
            --n;
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.cookies.removeElementAt((Integer)object.nextElement());
        }
    }
}

