/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.JMeterUtils;
import org.apache.jmeter.samplers.URLSampler;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.visualizers.Visualizer;

public class JMeter
extends JFrame
implements ActionListener,
ChangeListener {
    public static final String VERSION = "Apache JMeter 1.4";
    public static final String PROPERTIES = "org/apache/jmeter/jmeter.properties";
    public static final String IMAGES = "org/apache/jmeter/images/";
    public static final String URL_SEPARATOR = " ";
    int samplers;
    int maxSamplers;
    Vector sampler;
    Hashtable alias;
    Visualizer visualizer;
    Properties properties;
    Timer timer;
    String threadImage;
    String query;
    String cookieFile;
    String authFile;
    Vector urls;
    JButton start;
    JButton stop;
    JButton clear;
    JButton cookieButton;
    JButton authButton;
    JSlider slider;
    JCheckBox queryCheck;
    JCheckBox encodeCheck;
    JCheckBox aliasCheck;
    JCheckBox cookieCheck;
    JCheckBox authCheck;
    JComboBox urlList;
    JComboBox queryList;
    JComboBox cookieList;
    JComboBox authList;
    JComboBox timerList;
    JComboBox visualizerList;
    JFileChooser fileChooser;
    JDialog about;
    JPanel timers;
    JPanel visualizers;
    ImageIcon disabled;
    ImageIcon idle;

    JMeter(String string) {
        super(VERSION);
        this.init(string);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ((Component)this).setLocation(50, 50);
        this.draw();
        this.pack();
        ((Component)this).setVisible(true);
    }

    void about() {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        if (this.about == null) {
            this.about = new JDialog(this, "About Apache JMeter...", true);
            this.about.addMouseListener(new AboutListener());
            serializable3 = new JLabel(JMeterUtils.getImage("jmeter.jpg"));
            serializable2 = new JLabel("Copyright (c) 1998-99 The Java Apache Project", 0);
            serializable = new JLabel("All Rights Reserved.", 0);
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new GridLayout(0, 1));
            jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            jPanel.add((Component)serializable2);
            jPanel.add((Component)serializable);
            Container container = this.about.getContentPane();
            container.setLayout(new BorderLayout());
            container.setBackground(Color.white);
            container.add((Component)serializable3, "North");
            container.add((Component)jPanel, "South");
        }
        serializable3 = this.getLocationOnScreen();
        serializable2 = this.getSize();
        serializable = this.about.getSize();
        ((Component)this.about).setLocation(serializable3.x + (serializable2.width - serializable.width) / 2, serializable3.y + (serializable2.height - serializable.height) / 2);
        this.about.pack();
        ((Component)this.about).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("start")) {
            this.start();
        } else if (actionEvent.getActionCommand().equals("stop")) {
            this.stop();
        } else if (actionEvent.getActionCommand().equals("clear")) {
            this.visualizer.clear();
        } else if (actionEvent.getActionCommand().equals("timer")) {
            this.timer = (Timer)this.timerList.getSelectedItem();
            ((CardLayout)this.timers.getLayout()).show(this.timers, this.timer.toString());
        } else if (actionEvent.getActionCommand().equals("visualizer")) {
            this.visualizer = (Visualizer)this.visualizerList.getSelectedItem();
            ((CardLayout)this.visualizers.getLayout()).show(this.visualizers, this.visualizer.toString());
            int n = 0;
            while (n < this.samplers) {
                ((URLSampler)this.sampler.elementAt(n)).setVisualizer(this.visualizer);
                ++n;
            }
        } else if (actionEvent.getActionCommand().equals("post")) {
            if (this.queryCheck.isSelected()) {
                this.queryList.setEnabled(true);
                this.queryList.setBackground(((Component)this).getBackground());
                this.encodeCheck.setEnabled(true);
            } else {
                this.queryList.setEnabled(false);
                this.queryList.setBackground(this.urlList.getBackground());
                this.encodeCheck.setEnabled(false);
            }
        } else if (actionEvent.getActionCommand().equals("cookie")) {
            if (this.cookieCheck.isSelected()) {
                this.cookieList.setEnabled(true);
                this.cookieList.setBackground(((Component)this).getBackground());
                this.cookieButton.setEnabled(true);
            } else {
                this.cookieList.setEnabled(false);
                this.cookieList.setBackground(this.urlList.getBackground());
                this.cookieButton.setEnabled(false);
            }
        } else if (actionEvent.getActionCommand().equals("authorization")) {
            if (this.authCheck.isSelected()) {
                this.authList.setEnabled(true);
                this.authList.setBackground(((Component)this).getBackground());
                this.authButton.setEnabled(true);
            } else {
                this.authList.setEnabled(false);
                this.authList.setBackground(this.urlList.getBackground());
                this.authButton.setEnabled(false);
            }
        } else if (actionEvent.getActionCommand().equals("browse")) {
            int n = this.fileChooser.showOpenDialog(this);
            if (n == 0) {
                String string = this.fileChooser.getSelectedFile().toString();
                this.cookieList.removeItem(string);
                this.cookieList.addItem(string);
                this.cookieList.getEditor().setItem(string);
                this.cookieList.setSelectedItem(string);
                this.cookieFile = string;
            }
        } else if (actionEvent.getActionCommand().equals("browseauth")) {
            int n = this.fileChooser.showOpenDialog(this);
            if (n == 0) {
                String string = this.fileChooser.getSelectedFile().toString();
                this.authList.removeItem(string);
                this.authList.addItem(string);
                this.authList.getEditor().setItem(string);
                this.authList.setSelectedItem(string);
                this.authFile = string;
            }
        } else if (actionEvent.getActionCommand().equals("about")) {
            this.about();
        }
    }

    void draw() {
        JComponent jComponent;
        JComponent jComponent2;
        JComponent jComponent3;
        this.start = JMeterUtils.createButton("start", this);
        this.stop = JMeterUtils.createButton("stop", this);
        this.clear = JMeterUtils.createButton("clear", this);
        this.stop.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.start);
        jPanel.add(this.clear);
        jPanel.add(this.stop);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(JMeterUtils.createButton("about", this));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new BevelBorder(0));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jPanel2, "East");
        EtchedBorder etchedBorder = new EtchedBorder();
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new TitledBorder(etchedBorder, "URL"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        JLabel jLabel = new JLabel("URL:", 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel4.add(jLabel);
        this.urlList = new JComboBox();
        this.urlList.setEditable(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.urlList, gridBagConstraints);
        jPanel4.add(this.urlList);
        this.aliasCheck = new JCheckBox("Alias");
        this.aliasCheck.setFocusPainted(false);
        this.aliasCheck.setForeground(jLabel.getForeground());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.aliasCheck, gridBagConstraints);
        jPanel4.add(this.aliasCheck);
        this.queryCheck = new JCheckBox("Post:");
        this.queryCheck.setFocusPainted(false);
        this.queryCheck.setForeground(jLabel.getForeground());
        this.queryCheck.setActionCommand("post");
        this.queryCheck.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.queryCheck, gridBagConstraints);
        jPanel4.add(this.queryCheck);
        this.queryList = new JComboBox();
        this.queryList.setEnabled(false);
        this.queryList.setEditable(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.queryList, gridBagConstraints);
        jPanel4.add(this.queryList);
        this.encodeCheck = new JCheckBox("Encoded");
        this.encodeCheck.setFocusPainted(false);
        this.encodeCheck.setForeground(jLabel.getForeground());
        this.encodeCheck.setEnabled(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.encodeCheck, gridBagConstraints);
        jPanel4.add(this.encodeCheck);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder(etchedBorder, "Cookies"));
        gridBagLayout = new GridBagLayout();
        jPanel5.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.cookieCheck = new JCheckBox("Enable");
        this.cookieCheck.setFocusPainted(false);
        this.cookieCheck.setForeground(jLabel.getForeground());
        this.cookieCheck.setActionCommand("cookie");
        this.cookieCheck.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.cookieCheck, gridBagConstraints);
        jPanel5.add(this.cookieCheck);
        JLabel jLabel2 = new JLabel("File:");
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel5.add(jLabel2);
        this.cookieList = new JComboBox();
        this.cookieList.setEditable(true);
        if (this.cookieFile != null) {
            this.cookieList.addItem(this.cookieFile);
        }
        this.cookieList.setEnabled(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.cookieList, gridBagConstraints);
        jPanel5.add(this.cookieList);
        this.cookieButton = new JButton("Browse");
        this.cookieButton.setEnabled(false);
        this.cookieButton.setActionCommand("browse");
        this.cookieButton.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.cookieButton, gridBagConstraints);
        jPanel5.add(this.cookieButton);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new TitledBorder(etchedBorder, "Authorization"));
        gridBagLayout = new GridBagLayout();
        jPanel6.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.authCheck = new JCheckBox("Enable");
        this.authCheck.setFocusPainted(false);
        this.authCheck.setForeground(jLabel.getForeground());
        this.authCheck.setActionCommand("authorization");
        this.authCheck.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.authCheck, gridBagConstraints);
        jPanel6.add(this.authCheck);
        JLabel jLabel3 = new JLabel("File:");
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel6.add(jLabel3);
        this.authList = new JComboBox();
        this.authList.setEditable(true);
        if (this.authFile != null) {
            this.authList.addItem(this.authFile);
        }
        this.authList.setEnabled(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.authList, gridBagConstraints);
        jPanel6.add(this.authList);
        this.authButton = new JButton("Browse");
        this.authButton.setEnabled(false);
        this.authButton.setActionCommand("browseauth");
        this.authButton.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.authButton, gridBagConstraints);
        jPanel6.add(this.authButton);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(new TitledBorder(etchedBorder, "Threads"));
        jPanel7.setLayout(new BorderLayout());
        this.slider = new JSlider(0, 1, this.maxSamplers, this.samplers);
        this.slider.addChangeListener(this);
        this.slider.setMajorTickSpacing(2);
        this.slider.setMinorTickSpacing(1);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        jPanel7.add((Component)this.slider, "North");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout());
        jPanel8.setBorder(new BevelBorder(1));
        this.disabled = JMeterUtils.getImage(String.valueOf(this.threadImage) + ".disabled.gif");
        this.idle = JMeterUtils.getImage(String.valueOf(this.threadImage) + ".idle.gif");
        int n = 0;
        while (n < this.maxSamplers) {
            jComponent3 = new URLSampler(JMeterUtils.getImage(String.valueOf(this.threadImage) + ".enabled.gif"));
            if (n < this.samplers) {
                ((JLabel)jComponent3).setDisabledIcon(this.idle);
            } else {
                ((JLabel)jComponent3).setDisabledIcon(this.disabled);
            }
            jComponent3.setEnabled(false);
            this.sampler.addElement(jComponent3);
            jPanel8.add(jComponent3);
            ++n;
        }
        jPanel7.add((Component)jPanel8, "Center");
        jComponent3 = new JPanel();
        jComponent3.setBorder(new TitledBorder(etchedBorder, "Timers"));
        jComponent3.setLayout(new BorderLayout());
        Vector vector = JMeterUtils.getTimers(this.properties);
        this.timerList = new JComboBox(vector);
        this.timerList.setEditable(false);
        this.timerList.setSelectedIndex(0);
        this.timerList.addActionListener(this);
        this.timerList.setActionCommand("timer");
        jComponent3.add((Component)this.timerList, "North");
        this.timers = new JPanel();
        this.timers.setLayout(new CardLayout());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            jComponent2 = (JComponent)enumeration.nextElement();
            this.timers.add((Component)jComponent2, jComponent2.toString());
        }
        jComponent3.add((Component)this.timers, "Center");
        jComponent2 = new JPanel();
        jComponent2.setBorder(new TitledBorder(etchedBorder, "Actions"));
        jComponent2.setLayout(new BorderLayout());
        Vector vector2 = JMeterUtils.getVisualizers(this.properties);
        this.visualizerList = new JComboBox(vector2);
        this.visualizerList.setEditable(false);
        this.visualizerList.setSelectedIndex(0);
        this.visualizerList.addActionListener(this);
        this.visualizerList.setActionCommand("visualizer");
        jComponent2.add((Component)this.visualizerList, "North");
        this.visualizers = new JPanel();
        this.visualizers.setLayout(new CardLayout());
        Enumeration enumeration2 = vector2.elements();
        while (enumeration2.hasMoreElements()) {
            jComponent = (JComponent)enumeration2.nextElement();
            this.visualizers.add((Component)jComponent, jComponent.toString());
        }
        jComponent2.add((Component)this.visualizers, "Center");
        jComponent = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        jComponent.setLayout(gridBagLayout);
        jComponent.setBorder(new EmptyBorder(0, 5, 5, 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jComponent.add(jPanel4);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jComponent.add(jPanel5);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jComponent.add(jPanel6);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.65;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jComponent.add(jPanel7);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.35;
        gridBagLayout.setConstraints(jComponent3, gridBagConstraints);
        jComponent.add(jComponent3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jComponent.add(jComponent2);
        this.getContentPane().add((Component)jPanel3, "North");
        this.getContentPane().add((Component)jComponent, "Center");
        this.fileChooser = new JFileChooser();
    }

    public static void error(String string, Component component) {
        JOptionPane.showMessageDialog(component, string, "Error", 0);
    }

    public static void error(Throwable throwable, Component component) {
        JMeter.error(throwable, component);
    }

    public static void fail(String string) {
        System.err.println(string);
        System.exit(1);
    }

    String getAuth() {
        if (this.authCheck.isSelected()) {
            String string = (String)this.authList.getSelectedItem();
            if (string == null) {
                throw new RuntimeException("Please, specify an authentication file");
            }
            this.authList.removeItem(string);
            this.authList.addItem(string);
            this.authList.setSelectedItem(string);
            return string;
        }
        return null;
    }

    String getCookies() {
        if (this.cookieCheck.isSelected()) {
            String string = (String)this.cookieList.getSelectedItem();
            if (string == null) {
                throw new RuntimeException("Please, specify a Netscape cookie file");
            }
            this.cookieList.removeItem(string);
            this.cookieList.addItem(string);
            this.cookieList.setSelectedItem(string);
            return string;
        }
        return null;
    }

    String getQuery() {
        if (this.queryCheck.isSelected()) {
            String string = (String)this.queryList.getSelectedItem();
            if (string == null) {
                return null;
            }
            this.queryList.removeItem(string);
            this.queryList.addItem(string);
            this.queryList.setSelectedItem(string);
            if (this.encodeCheck.isSelected()) {
                return URLEncoder.encode(string);
            }
            return string;
        }
        return null;
    }

    Vector getURLs() throws IOException {
        String string = (String)this.urlList.getSelectedItem();
        if (string == null) {
            throw new RuntimeException("Cannot sample empty URL");
        }
        this.urlList.removeItem(string);
        this.urlList.addItem(string);
        this.urlList.setSelectedItem(string);
        String string2 = string = this.aliasCheck.isSelected() ? (String)this.alias.get(string) : string;
        if (string == null) {
            throw new RuntimeException("Alias not defined");
        }
        return URLSampler.tryURLs(JMeterUtils.tokenize(string, URL_SEPARATOR), this.query, this.queryCheck.isSelected(), this.getRootPane());
    }

    void init(String string) {
        this.properties = JMeterUtils.getProperties(string);
        this.samplers = Integer.valueOf(this.properties.getProperty("threads.start"));
        this.maxSamplers = Integer.valueOf(this.properties.getProperty("threads.max"));
        this.sampler = new Vector(this.samplers);
        this.alias = JMeterUtils.getAlias(this.properties);
        this.threadImage = this.properties.getProperty("threads.image");
        this.cookieFile = this.properties.getProperty("cookies");
        this.authFile = this.properties.getProperty("authorization");
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Couldn't use the Java look and feel: " + exception);
        }
        if (stringArray.length > 0) {
            new JMeter(stringArray[0]);
        } else {
            new JMeter(null);
        }
    }

    void start() {
        this.stop.setEnabled(true);
        this.start.setEnabled(false);
        this.slider.setEnabled(false);
        this.urlList.setEnabled(false);
        this.queryList.setEnabled(false);
        this.timerList.setEnabled(false);
        this.queryCheck.setEnabled(false);
        this.encodeCheck.setEnabled(false);
        this.aliasCheck.setEnabled(false);
        this.cookieCheck.setEnabled(false);
        this.cookieList.setEnabled(false);
        this.cookieButton.setEnabled(false);
        this.authCheck.setEnabled(false);
        this.authList.setEnabled(false);
        this.authButton.setEnabled(false);
        try {
            try {
                this.samplers = this.slider.getValue();
                this.timer = (Timer)this.timerList.getSelectedItem();
                this.visualizer = (Visualizer)this.visualizerList.getSelectedItem();
                this.query = this.getQuery();
                this.urls = this.getURLs();
                this.cookieFile = this.getCookies();
                this.authFile = this.getAuth();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("URL has an invalid format: " + malformedURLException.getMessage());
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error accessing URL: " + iOException.getMessage());
            }
            System.gc();
            System.runFinalization();
            if (this.urls.size() > 0) {
                int n = 0;
                while (n < this.samplers) {
                    URLSampler uRLSampler = (URLSampler)this.sampler.elementAt(n);
                    uRLSampler.init(this.timer, this.urls, this.query, this.cookieFile, this.authFile, this.queryCheck.isSelected());
                    uRLSampler.setVisualizer(this.visualizer);
                    new Thread(uRLSampler).start();
                    ++n;
                }
            } else {
                this.stop();
                JMeter.error("No valid or accessible URLs to sample.", (Component)this);
            }
        }
        catch (Exception exception) {
            this.stop();
            JMeter.error(exception.getMessage(), (Component)this);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.slider.getValueIsAdjusting()) {
            URLSampler uRLSampler;
            int n = 0;
            this.samplers = this.slider.getValue();
            while (n < this.samplers) {
                uRLSampler = (URLSampler)this.sampler.elementAt(n++);
                uRLSampler.setDisabledIcon(this.idle);
            }
            while (n < this.maxSamplers) {
                uRLSampler = (URLSampler)this.sampler.elementAt(n++);
                uRLSampler.setDisabledIcon(this.disabled);
            }
            this.repaint();
        }
    }

    void stop() {
        this.stop.setEnabled(false);
        this.start.setEnabled(true);
        this.slider.setEnabled(true);
        this.urlList.setEnabled(true);
        this.timerList.setEnabled(true);
        this.queryCheck.setEnabled(true);
        if (this.queryCheck.isSelected()) {
            this.encodeCheck.setEnabled(true);
        }
        if (this.queryCheck.isSelected()) {
            this.queryList.setEnabled(true);
        }
        this.aliasCheck.setEnabled(true);
        this.cookieCheck.setEnabled(true);
        if (this.cookieCheck.isSelected()) {
            this.cookieList.setEnabled(true);
        }
        if (this.cookieCheck.isSelected()) {
            this.cookieButton.setEnabled(true);
        }
        this.authCheck.setEnabled(true);
        if (this.authCheck.isSelected()) {
            this.authList.setEnabled(true);
        }
        if (this.authCheck.isSelected()) {
            this.authButton.setEnabled(true);
        }
        int n = 0;
        while (n < this.samplers) {
            ((URLSampler)this.sampler.elementAt(n)).die();
            ++n;
        }
    }

    class AboutListener
    extends MouseAdapter {
        AboutListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ((Component)JMeter.this.about).setVisible(false);
        }
    }
}

