/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpecNode;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.framework.XMLValidator;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.datatype.BooleanValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DecimalValidator;
import org.apache.xerces.validators.datatype.DoubleValidator;
import org.apache.xerces.validators.datatype.FloatValidator;
import org.apache.xerces.validators.datatype.IllegalFacetException;
import org.apache.xerces.validators.datatype.IllegalFacetValueException;
import org.apache.xerces.validators.datatype.IntegerValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StringValidator;
import org.apache.xerces.validators.datatype.UnknownFacetException;
import org.apache.xerces.validators.dtd.CMBinOp;
import org.apache.xerces.validators.dtd.CMException;
import org.apache.xerces.validators.dtd.CMLeaf;
import org.apache.xerces.validators.dtd.CMNode;
import org.apache.xerces.validators.dtd.CMUniOp;
import org.apache.xerces.validators.dtd.DFAContentModel;
import org.apache.xerces.validators.dtd.ElementDeclPool;
import org.apache.xerces.validators.dtd.EntityPool;
import org.apache.xerces.validators.dtd.InsertableElementsInfo;
import org.apache.xerces.validators.dtd.MixedContentModel;
import org.apache.xerces.validators.dtd.SimpleContentModel;
import org.apache.xerces.validators.dtd.XMLContentModel;
import org.apache.xerces.validators.schema.DatatypeContentModel;
import org.apache.xerces.validators.schema.XUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSchemaValidator
implements XMLValidator {
    private static final boolean PRINT_EXCEPTION_STACK_TRACE = false;
    private static final boolean DEBUG_PRINT_ATTRIBUTES = false;
    private static final boolean DEBUG_PRINT_CONTENT = false;
    private static final boolean DEBUG_PAREN_DEPTH = false;
    private static final boolean DEBUG_MARKUP_DEPTH = false;
    private boolean fValidationEnabled = false;
    private boolean fDynamicValidation = false;
    private boolean fValidationEnabledByDynamic = false;
    private boolean fDynamicDisabledByValidation = false;
    private boolean fValidating = false;
    private boolean fWarningOnDuplicateAttDef = false;
    private boolean fWarningOnUndeclaredElements = false;
    private EntityPool fEntityPool = null;
    private ElementDeclPool fElementDeclPool = null;
    private int fStandaloneReader = -1;
    private int[] fElementTypeStack = new int[8];
    private int[] fContentSpecTypeStack = new int[8];
    private int[] fElementChildCount = new int[8];
    private int[][] fElementChildren = new int[8][];
    private int fElementDepth = -1;
    private NamespacesScope fNamespacesScope = null;
    private boolean fNamespacesEnabled = false;
    private int fRootElementType = -1;
    private int fAttrIndex = -1;
    private XMLErrorReporter fErrorReporter = null;
    private XMLEntityHandler fEntityHandler = null;
    private StringPool fStringPool = null;
    private boolean fBufferDatatype = false;
    private StringBuffer fDatatypeBuffer = new StringBuffer();
    private DatatypeValidatorRegistry fDatatypeRegistry = new DatatypeValidatorRegistry();
    private int fTypeCount = 0;
    private int fGroupCount = 0;
    private int fModelGroupCount = 0;
    private int fAttributeGroupCount = 0;
    private Hashtable fForwardRefs = new Hashtable();
    private Hashtable fAttrGroupUses = new Hashtable();
    private static final String ELT_COMMENT = "comment";
    private static final String ELT_DATATYPEDECL = "datatype";
    private static final String ELT_ARCHETYPEDECL = "archetype";
    private static final String ELT_ELEMENTDECL = "element";
    private static final String ELT_GROUP = "group";
    private static final String ELT_ATTRGROUPDECL = "attrGroup";
    private static final String ELT_ATTRGROUPREF = "attrGroupRef";
    private static final String ELT_MODELGROUPDECL = "modelGroup";
    private static final String ELT_MODELGROUPREF = "modelGroupRef";
    private static final String ELT_TEXTENTITYDECL = "textEntity";
    private static final String ELT_EXTERNALENTITYDECL = "externalEntity";
    private static final String ELT_UNPARSEDENTITYDECL = "unparsedEntity";
    private static final String ELT_NOTATIONDECL = "notation";
    private static final String ELT_REFINES = "refines";
    private static final String ELT_ATTRIBUTEDECL = "attribute";
    private static final String ATT_NAME = "name";
    private static final String ATT_CONTENT = "content";
    private static final String ATT_MODEL = "model";
    private static final String ATT_ORDER = "order";
    private static final String ATT_TYPE = "type";
    private static final String ATT_DEFAULT = "default";
    private static final String ATT_FIXED = "fixed";
    private static final String ATT_COLLECTION = "collection";
    private static final String ATT_REF = "ref";
    private static final String ATT_ARCHREF = "archRef";
    private static final String ATT_SCHEMAABBREV = "schemaAbbrev";
    private static final String ATT_SCHEMANAME = "schemaName";
    private static final String ATT_MINOCCURS = "minOccurs";
    private static final String ATT_MAXOCCURS = "maxOccurs";
    private static final String ATT_EXPORT = "export";
    private static final String ATTVAL_ANY = "any";
    private static final String ATTVAL_MIXED = "mixed";
    private static final String ATTVAL_EMPTY = "empty";
    private static final String ATTVAL_CHOICE = "choice";
    private static final String ATTVAL_SEQ = "seq";
    private static final String ATTVAL_ALL = "all";
    private static final String ATTVAL_ELEMONLY = "elemOnly";
    private static final String ATTVAL_TEXTONLY = "textOnly";
    private Document fSchemaDocument;
    private int fLeafCount = 0;
    private int fEpsilonIndex = -1;
    private int fCount = 0;
    private int[] fContentList = new int[64];
    private static final int CONTENTSPECNODE_ZERO_TO_N = 6;
    private static final int CONTENTSPECNODE_M_TO_N = 7;
    private static final int CONTENTSPECNODE_M_OR_MORE = 8;
    private DOMParser fSchemaParser = null;

    public XSchemaValidator(StringPool stringPool, XMLErrorReporter xMLErrorReporter, XMLEntityHandler xMLEntityHandler) {
        this.fEntityPool = new EntityPool(stringPool, xMLErrorReporter, true);
        this.fElementDeclPool = new ElementDeclPool(stringPool, xMLErrorReporter);
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityHandler = xMLEntityHandler;
        this.fStringPool = stringPool;
        this.fDatatypeRegistry.initializeRegistry();
    }

    protected void addRequiredNotation(int n, Locator locator, int n2, int n3, Object[] objectArray) throws Exception {
        this.fEntityPool.addRequiredNotation(n, locator, n2, n3, objectArray);
    }

    private void addUse(int n, int n2) {
        this.addUse(n, new Integer(n2));
    }

    private void addUse(int n, Integer n2) {
        Vector<Integer> vector = (Vector<Integer>)this.fAttrGroupUses.get(new Integer(n));
        if (vector == null) {
            vector = new Vector<Integer>();
        }
        vector.addElement(n2);
    }

    public boolean attributeSpecified(int n, XMLAttrList xMLAttrList, int n2, Locator locator, int n3) throws Exception {
        int n4 = this.fElementDeclPool.getAttDef(n, n2);
        if (n4 == -1) {
            if (this.fValidating) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.fStringPool.toString(n2)};
                this.fErrorReporter.reportError(locator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, objectArray, 1);
            }
            int n5 = this.fStringPool.addSymbol("CDATA");
            if (this.fAttrIndex == -1) {
                this.fAttrIndex = xMLAttrList.startAttrList();
            }
            return xMLAttrList.addAttr(n2, n3, n5, true, true) != -1;
        }
        int n6 = this.fElementDeclPool.getAttType(n4);
        if (n6 != this.fStringPool.addSymbol("CDATA")) {
            int n7 = this.fElementDeclPool.getEnumeration(n4);
            n3 = this.normalizeAttributeValue(n, n2, n3, n6, n7);
        }
        if (this.fAttrIndex == -1) {
            this.fAttrIndex = xMLAttrList.startAttrList();
        }
        return xMLAttrList.addAttr(n2, n3, n6, true, true) != -1;
    }

    private int buildAllModel(int[] nArray, int n) throws Exception {
        if (n > 1) {
            XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
            xMLContentSpecNode.type = 4;
            xMLContentSpecNode.value = -1;
            xMLContentSpecNode.otherValue = -1;
            this.sort(nArray, 0, n);
            int n2 = this.buildAllModel(nArray, 0, xMLContentSpecNode);
            return n2;
        }
        if (n > 0) {
            return nArray[0];
        }
        return -1;
    }

    private int buildAllModel(int[] nArray, int n, XMLContentSpecNode xMLContentSpecNode) throws Exception {
        if (nArray.length - n == 2) {
            int n2 = this.createSeq(nArray);
            if (xMLContentSpecNode.value == -1) {
                xMLContentSpecNode.value = n2;
            } else {
                if (xMLContentSpecNode.otherValue != -1) {
                    xMLContentSpecNode.value = this.fElementDeclPool.addContentSpecNode(xMLContentSpecNode.type, xMLContentSpecNode.value, xMLContentSpecNode.otherValue, false);
                }
                xMLContentSpecNode.otherValue = n2;
            }
            this.swap(nArray, n, n + 1);
            n2 = this.createSeq(nArray);
            if (xMLContentSpecNode.value == -1) {
                xMLContentSpecNode.value = n2;
            } else {
                if (xMLContentSpecNode.otherValue != -1) {
                    xMLContentSpecNode.value = this.fElementDeclPool.addContentSpecNode(xMLContentSpecNode.type, xMLContentSpecNode.value, xMLContentSpecNode.otherValue, false);
                }
                xMLContentSpecNode.otherValue = n2;
            }
            return this.fElementDeclPool.addContentSpecNode(xMLContentSpecNode.type, xMLContentSpecNode.value, xMLContentSpecNode.otherValue, false);
        }
        int n3 = n;
        while (n3 < nArray.length - 1) {
            xMLContentSpecNode.value = this.buildAllModel(nArray, n + 1, xMLContentSpecNode);
            xMLContentSpecNode.otherValue = -1;
            this.sort(nArray, n, nArray.length - n);
            this.shift(nArray, n, n3 + 1);
            ++n3;
        }
        int n4 = this.buildAllModel(nArray, n + 1, xMLContentSpecNode);
        this.sort(nArray, n, nArray.length - n);
        return n4;
    }

    private final int buildContentList(int n, int n2, XMLContentSpecNode xMLContentSpecNode) throws CMException {
        this.fElementDeclPool.getContentSpecNode(n, xMLContentSpecNode);
        if (xMLContentSpecNode.type == 0) {
            this.fContentList[n2++] = xMLContentSpecNode.value;
            return n2;
        }
        int n3 = xMLContentSpecNode.value;
        int n4 = xMLContentSpecNode.otherValue;
        if (xMLContentSpecNode.type == 4 || xMLContentSpecNode.type == 5) {
            n2 = this.buildContentList(n3, n2, xMLContentSpecNode);
            n2 = this.buildContentList(n4, n2, xMLContentSpecNode);
        } else if (xMLContentSpecNode.type == 1 || xMLContentSpecNode.type == 2 || xMLContentSpecNode.type == 3) {
            n2 = this.buildContentList(n3, n2, xMLContentSpecNode);
        } else {
            throw new CMException(8);
        }
        return n2;
    }

    private final CMNode buildSyntaxTree(int n, XMLContentSpecNode xMLContentSpecNode) throws CMException {
        CMNode cMNode = null;
        this.getContentSpecNode(n, xMLContentSpecNode);
        if (xMLContentSpecNode.type == 0) {
            cMNode = new CMLeaf(xMLContentSpecNode.type, xMLContentSpecNode.value, this.fLeafCount++);
        } else {
            int n2 = xMLContentSpecNode.value;
            int n3 = xMLContentSpecNode.otherValue;
            if (xMLContentSpecNode.type == 4 || xMLContentSpecNode.type == 5) {
                cMNode = new CMBinOp(xMLContentSpecNode.type, this.buildSyntaxTree(n2, xMLContentSpecNode), this.buildSyntaxTree(n3, xMLContentSpecNode));
            } else if (xMLContentSpecNode.type == 2) {
                cMNode = new CMUniOp(xMLContentSpecNode.type, this.buildSyntaxTree(n2, xMLContentSpecNode));
            } else if (xMLContentSpecNode.type == 1) {
                cMNode = new CMBinOp(4, this.buildSyntaxTree(n2, xMLContentSpecNode), new CMLeaf(0, this.fEpsilonIndex));
            } else if (xMLContentSpecNode.type == 3) {
                cMNode = new CMBinOp(5, this.buildSyntaxTree(n2, xMLContentSpecNode), new CMUniOp(2, this.buildSyntaxTree(n2, xMLContentSpecNode)));
            } else {
                throw new CMException(8);
            }
        }
        return cMNode;
    }

    private void charDataInContent() {
        int[] nArray = this.fElementChildren[this.fElementDepth];
        int n = this.fElementChildCount[this.fElementDepth];
        if (nArray == null) {
            this.fElementChildren[this.fElementDepth] = new int[8];
            nArray = this.fElementChildren[this.fElementDepth];
            n = 0;
        } else if (n == nArray.length) {
            int[] nArray2 = new int[n * 2];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            this.fElementChildren[this.fElementDepth] = nArray2;
            nArray = nArray2;
        }
        nArray[n++] = -1;
        this.fElementChildCount[this.fElementDepth] = n;
    }

    public void characters(int n) throws Exception {
        if (this.fValidating) {
            this.charDataInContent();
            if (this.fBufferDatatype) {
                this.fDatatypeBuffer.append(this.fStringPool.toString(n));
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws Exception {
        if (this.fValidating) {
            this.charDataInContent();
            if (this.fBufferDatatype) {
                this.fDatatypeBuffer.append(cArray, n, n2);
            }
        }
    }

    private void checkAttributes(int n, XMLAttrList xMLAttrList, int n2) throws Exception {
    }

    public int checkContent(int n, int n2, int[] nArray) throws Exception {
        int n3 = this.fElementDeclPool.getElementType(n);
        int n4 = this.fElementDeclPool.getContentSpecType(n);
        if (n4 == this.fStringPool.addSymbol("EMPTY")) {
            if (n2 != 0) {
                return 0;
            }
        } else if (n4 != this.fStringPool.addSymbol("ANY")) {
            if (n4 == this.fStringPool.addSymbol("MIXED") || n4 == this.fStringPool.addSymbol("CHILDREN")) {
                XMLContentModel xMLContentModel = null;
                try {
                    xMLContentModel = this.getContentModel(n);
                    return xMLContentModel.validateContent(n2, nArray);
                }
                catch (CMException cMException) {
                    int n5 = cMException.getErrorCode();
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", n5, 0, null, 2);
                }
            } else if (n4 == -1) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 83, 79, objectArray, 1);
            } else if (n4 == this.fStringPool.addSymbol("DATATYPE")) {
                XMLContentModel xMLContentModel = null;
                try {
                    xMLContentModel = this.getContentModel(n);
                    return xMLContentModel.validateContent(1, new int[]{this.fStringPool.addString(this.fDatatypeBuffer.toString())});
                }
                catch (CMException cMException) {
                    System.out.println("Internal Error in datatype validation");
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError(21, new Object[]{invalidDatatypeValueException.getMessage()});
                }
            } else {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 8, 0, null, 2);
            }
        }
        return -1;
    }

    public void checkIDRefNames() throws Exception {
        this.fElementDeclPool.checkIdRefs();
    }

    private void cleanupForwardReferences() {
        Enumeration enumeration = this.fForwardRefs.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int n = (Integer)k;
            this.cleanupForwardReferencesTo(n);
        }
    }

    private void cleanupForwardReferencesTo(int n) {
        Vector vector = (Vector)this.fForwardRefs.get(new Integer(n));
        if (vector == null) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            int n3 = (Integer)vector.elementAt(n2);
            this.fElementDeclPool.copyAtts(n, (Integer)vector.elementAt(n2));
            ++n2;
        }
    }

    private final XMLContentModel createChildModel(int n) throws CMException {
        Object object;
        XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
        int n2 = this.fElementDeclPool.getContentSpec(n);
        this.fElementDeclPool.getContentSpecNode(n2, xMLContentSpecNode);
        if (xMLContentSpecNode.value == -1) {
            throw new CMException(11);
        }
        if (xMLContentSpecNode.type == 0) {
            return new SimpleContentModel(xMLContentSpecNode.value, -1, xMLContentSpecNode.type);
        }
        if (xMLContentSpecNode.type == 4 || xMLContentSpecNode.type == 5) {
            object = new XMLContentSpecNode();
            XMLContentSpecNode xMLContentSpecNode2 = new XMLContentSpecNode();
            this.fElementDeclPool.getContentSpecNode(xMLContentSpecNode.value, (XMLContentSpecNode)object);
            this.fElementDeclPool.getContentSpecNode(xMLContentSpecNode.otherValue, xMLContentSpecNode2);
            if (((XMLContentSpecNode)object).type == 0 && xMLContentSpecNode2.type == 0) {
                return new SimpleContentModel(((XMLContentSpecNode)object).value, xMLContentSpecNode2.value, xMLContentSpecNode.type);
            }
        } else if (xMLContentSpecNode.type == 1 || xMLContentSpecNode.type == 2 || xMLContentSpecNode.type == 3) {
            object = new XMLContentSpecNode();
            this.fElementDeclPool.getContentSpecNode(xMLContentSpecNode.value, (XMLContentSpecNode)object);
            if (((XMLContentSpecNode)object).type == 0) {
                return new SimpleContentModel(((XMLContentSpecNode)object).value, -1, xMLContentSpecNode.type);
            }
        } else {
            throw new CMException(8);
        }
        this.fLeafCount = 0;
        this.fEpsilonIndex = this.fStringPool.addSymbol("<<CMNODE_EPSILON>>");
        object = this.buildSyntaxTree(n2, xMLContentSpecNode);
        return new DFAContentModel(this.fStringPool, (CMNode)object, this.fLeafCount);
    }

    private int createSeq(int[] nArray) throws Exception {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = 2;
        while (n3 < nArray.length) {
            n = this.fElementDeclPool.addContentSpecNode(5, n, n2, false);
            n2 = nArray[n3];
            ++n3;
        }
        return this.fElementDeclPool.addContentSpecNode(5, n, n2, false);
    }

    public boolean endElement(int n) throws Exception {
        if (this.fValidating) {
            int n2;
            int n3;
            int n4 = this.fElementDeclPool.getElement(n);
            if (n4 != -1 && this.fElementDeclPool.getContentSpecType(n4) != -1 && (n3 = this.checkContent(n4, n2 = this.peekChildCount(), this.peekChildren())) != -1) {
                int n5 = n3 != n2 ? 87 : 88;
                this.reportRecoverableXMLError(n5, 0, this.fStringPool.toString(n), this.fElementDeclPool.getContentSpecAsString(n4));
            }
            this.fBufferDatatype = false;
        }
        this.popElement();
        return this.peekContentSpecType() == this.fStringPool.addSymbol("CHILDREN");
    }

    private int expandContentModel(int n, Element element) throws Exception {
        int n2 = this.getOccurrenceCount(element);
        int n3 = 1;
        int n4 = 1;
        if (!this.isSimpleOccurrenceCount(n2)) {
            try {
                n3 = Integer.parseInt(element.getAttribute(ATT_MINOCCURS));
            }
            catch (NumberFormatException numberFormatException) {
                this.reportSchemaError(20, new Object[]{ATT_MINOCCURS});
            }
            try {
                n4 = Integer.parseInt(element.getAttribute(ATT_MAXOCCURS));
            }
            catch (NumberFormatException numberFormatException) {
                this.reportSchemaError(20, new Object[]{ATT_MAXOCCURS});
            }
        }
        switch (n2) {
            case 3: {
                n = this.fElementDeclPool.addContentSpecNode(3, n, -1, false);
                break;
            }
            case 2: {
                n = this.fElementDeclPool.addContentSpecNode(2, n, -1, false);
                break;
            }
            case 1: {
                n = this.fElementDeclPool.addContentSpecNode(1, n, -1, false);
                break;
            }
            case 8: {
                int n5 = n;
                int n6 = -1;
                int n7 = 1;
                while (n7 < n3) {
                    if (n6 != -1) {
                        n5 = this.fElementDeclPool.addContentSpecNode(5, n5, n6, false);
                    }
                    n6 = n;
                    ++n7;
                }
                n = this.fElementDeclPool.addContentSpecNode(2, n, -1, false);
                if (n6 != -1) {
                    n5 = this.fElementDeclPool.addContentSpecNode(5, n5, n6, false);
                }
                n6 = n;
                n = this.fElementDeclPool.addContentSpecNode(5, n5, n6, false);
                break;
            }
            case 7: {
                int n8 = n;
                int n9 = -1;
                int n10 = 1;
                while (n10 < n3) {
                    if (n9 != -1) {
                        n8 = this.fElementDeclPool.addContentSpecNode(5, n8, n9, false);
                    }
                    n9 = n;
                    ++n10;
                }
                n = this.fElementDeclPool.addContentSpecNode(1, n, -1, false);
                int n11 = n4;
                while (n11 > n3) {
                    if (n9 != -1) {
                        n8 = this.fElementDeclPool.addContentSpecNode(5, n8, n9, false);
                    }
                    n9 = n;
                    --n11;
                }
                n = this.fElementDeclPool.addContentSpecNode(5, n8, n9, false);
                break;
            }
            case 6: {
                int n12 = n = this.fElementDeclPool.addContentSpecNode(1, n, -1, false);
                int n13 = -1;
                int n14 = 1;
                while (n14 < n4) {
                    if (n13 != -1) {
                        n12 = this.fElementDeclPool.addContentSpecNode(5, n12, n13, false);
                    }
                    n13 = n;
                    ++n14;
                }
                n = this.fElementDeclPool.addContentSpecNode(5, n12, n13, false);
                break;
            }
        }
        return n;
    }

    public boolean externalReferenceInContent(int n) throws Exception {
        boolean bl = this.fEntityPool.isExternalEntity(n);
        if (this.fStandaloneReader != -1 && this.fValidating) {
            if (bl) {
                this.reportRecoverableXMLError(102, 80, this.fEntityPool.getEntityName(n));
            } else if (this.fEntityPool.getEntityDeclIsExternal(n)) {
                this.reportRecoverableXMLError(132, 80, this.fEntityPool.getEntityName(n));
            }
        }
        return bl;
    }

    public int getAttName(int n) {
        int n2 = this.fElementDeclPool.getAttName(n);
        return n2;
    }

    public int getAttValue(int n) {
        int n2 = this.fElementDeclPool.getAttValue(n);
        return n2;
    }

    public XMLContentModel getContentModel(int n) throws CMException {
        XMLContentModel xMLContentModel = this.fElementDeclPool.getContentModel(n);
        if (xMLContentModel != null) {
            return xMLContentModel;
        }
        int n2 = this.fElementDeclPool.getContentSpecType(n);
        if (n2 == this.fStringPool.addSymbol("MIXED")) {
            XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
            int n3 = this.fElementDeclPool.getContentSpec(n);
            this.makeContentList(n3, xMLContentSpecNode);
            xMLContentModel = new MixedContentModel(this.fCount, this.fContentList);
        } else if (n2 == this.fStringPool.addSymbol("CHILDREN")) {
            xMLContentModel = this.createChildModel(n);
        } else if (n2 == this.fStringPool.addSymbol("DATATYPE")) {
            xMLContentModel = new DatatypeContentModel(this.fDatatypeRegistry, this.fElementDeclPool, this.fStringPool, n);
        } else {
            throw new CMException(8);
        }
        this.fElementDeclPool.setContentModel(n, xMLContentModel);
        return xMLContentModel;
    }

    public int getContentSpec(int n) {
        int n2 = this.fElementDeclPool.getContentSpec(n);
        return n2;
    }

    public String getContentSpecAsString(int n) {
        String string = this.fElementDeclPool.getContentSpecAsString(n);
        return string;
    }

    public void getContentSpecNode(int n, XMLContentSpecNode xMLContentSpecNode) {
        this.fElementDeclPool.getContentSpecNode(n, xMLContentSpecNode);
    }

    public int getContentSpecType(int n) {
        int n2 = this.fElementDeclPool.getContentSpecType(n);
        return n2;
    }

    public boolean getDynamicValidationEnabled() {
        return this.fDynamicValidation;
    }

    public int getElement(int n) {
        int n2 = this.fElementDeclPool.getElement(n);
        return n2;
    }

    public int getElementType(int n) throws Exception {
        int n2 = this.fElementDeclPool.getElementType(n);
        return n2;
    }

    public int getEntityName(int n) {
        int n2 = this.fEntityPool.getEntityName(n);
        return n2;
    }

    public int getEntityValue(int n) {
        int n2 = this.fEntityPool.getEntityValue(n);
        return n2;
    }

    public boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public int getNotationName(int n) {
        int n2 = this.fEntityPool.getNotationName(n);
        return n2;
    }

    private int getOccurrenceCount(Element element) {
        String string = element.getAttribute(ATT_MINOCCURS);
        String string2 = element.getAttribute(ATT_MAXOCCURS);
        if (string.equals("0")) {
            if (string2.equals("1") || string2.length() == 0) {
                return 1;
            }
            if (string2.equals("*")) {
                return 2;
            }
            return 6;
        }
        if (string.equals("1") || string.length() == 0) {
            if (string2.equals("*")) {
                return 3;
            }
            if (!string2.equals("1") && string2.length() > 0) {
                return 7;
            }
        } else {
            if (string2.equals("*")) {
                return 8;
            }
            return 7;
        }
        return -1;
    }

    public int getParameterEntityValue(int n) {
        throw new RuntimeException("cannot happen 28");
    }

    public int getPublicIdIndexOfEntity(int n) {
        int n2 = this.fEntityPool.getPublicId(n);
        return n2;
    }

    public String getPublicIdOfEntity(int n) {
        int n2 = this.fEntityPool.getPublicId(n);
        return this.fStringPool.toString(n2);
    }

    public String getPublicIdOfParameterEntity(int n) {
        throw new RuntimeException("cannot happen 29");
    }

    public Document getSchemaDocument() {
        return this.fSchemaDocument;
    }

    public int getSystemIdIndexOfEntity(int n) {
        int n2 = this.fEntityPool.getSystemId(n);
        return n2;
    }

    public String getSystemIdOfEntity(int n) {
        int n2 = this.fEntityPool.getSystemId(n);
        return this.fStringPool.toString(n2);
    }

    public String getSystemIdOfParameterEntity(int n) {
        throw new RuntimeException("cannot happen 30");
    }

    public boolean getValidationEnabled() {
        return this.fValidationEnabled;
    }

    public boolean getWarningOnDuplicateAttDef() {
        return this.fWarningOnDuplicateAttDef;
    }

    public boolean getWarningOnUndeclaredElements() {
        return this.fWarningOnUndeclaredElements;
    }

    public void ignorableWhitespace(int n) throws Exception {
        int n2;
        if (this.fStandaloneReader != -1 && this.fValidating && this.fElementDeclPool.getElementDeclIsExternal(n2 = this.getElement(this.peekElementType()))) {
            this.reportRecoverableXMLError(143, 80);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws Exception {
        int n3;
        if (this.fStandaloneReader != -1 && this.fValidating && this.fElementDeclPool.getElementDeclIsExternal(n3 = this.getElement(this.peekElementType()))) {
            this.reportRecoverableXMLError(143, 80);
        }
    }

    private boolean invalidStandaloneAttDef(int n, int n2) {
        if (this.fStandaloneReader == -1) {
            return false;
        }
        if (n == -1) {
            return false;
        }
        int n3 = this.fElementDeclPool.getAttDef(n, n2);
        return this.fElementDeclPool.getAttDefIsExternal(n3);
    }

    public boolean isExternalEntity(int n) {
        boolean bl = this.fEntityPool.isExternalEntity(n);
        return bl;
    }

    public boolean isExternalParameterEntity(int n) {
        throw new RuntimeException("cannot happen 27");
    }

    private boolean isSimpleOccurrenceCount(int n) {
        return n == -1 || n == 3 || n == 2 || n == 1;
    }

    public boolean isUnparsedEntity(int n) {
        boolean bl = this.fEntityPool.isUnparsedEntity(n);
        return bl;
    }

    public void loadSchema(String string) {
        String string2 = this.fEntityHandler.expandSystemId(string);
        if (this.fSchemaParser == null) {
            this.fSchemaParser = new DOMParser(){

                public void ignorableWhitespace(int n) {
                }

                public void ignorableWhitespace(char[] cArray, int n, int n2) {
                }
            };
            this.fSchemaParser.setEntityResolver(new Resolver());
            this.fSchemaParser.setErrorHandler(new ErrorHandler());
        }
        try {
            this.fSchemaParser.setFeature("http://xml.org/sax/features/validation", true);
            this.fSchemaParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.fSchemaParser.parse(string2);
        }
        catch (SAXException sAXException) {
            sAXException.getException().printStackTrace();
            System.err.println("error parsing schema file");
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("error parsing schema file");
            System.exit(1);
        }
        this.fSchemaDocument = this.fSchemaParser.getDocument();
        if (this.fSchemaDocument == null) {
            System.err.println("error: couldn't load schema file!");
            return;
        }
        try {
            Element element = this.fSchemaDocument.getDocumentElement();
            this.traverseSchema(element);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public int lookupEntity(int n) {
        int n2 = this.fEntityPool.lookupEntity(n);
        return n2;
    }

    public int lookupParameterEntity(int n) throws Exception {
        throw new RuntimeException("cannot happen 26");
    }

    private final void makeContentList(int n, XMLContentSpecNode xMLContentSpecNode) throws CMException {
        while (true) {
            this.fCount = 0;
            try {
                this.fCount = this.buildContentList(n, 0, xMLContentSpecNode);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.fContentList = new int[this.fContentList.length * 2];
                this.fCount = 0;
                continue;
            }
            break;
        }
    }

    private int normalizeAttributeValue(int n, int n2, int n3, int n4, int n5) throws Exception {
        block69: {
            String string = this.fStringPool.toString(n3);
            if (n4 == this.fStringPool.addSymbol("ID")) {
                String string2 = string.trim();
                if (this.fValidating) {
                    n3 = this.fStringPool.addSymbol(string2);
                    if (string2 != string && this.invalidStandaloneAttDef(n, n2)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(n2), string, string2);
                    }
                    if (!XMLCharacterProperties.validName(string2)) {
                        this.reportRecoverableXMLError(75, 76, this.fStringPool.toString(n2), string2);
                    }
                    if (n != -1 && !this.fElementDeclPool.addId(n3)) {
                        this.reportRecoverableXMLError(76, 76, this.fStringPool.toString(n2), string2);
                    }
                } else if (string2 != string) {
                    n3 = this.fStringPool.addSymbol(string2);
                }
            } else if (n4 == this.fStringPool.addSymbol("IDREF")) {
                String string3 = string.trim();
                if (this.fValidating) {
                    n3 = this.fStringPool.addSymbol(string3);
                    if (string3 != string && this.invalidStandaloneAttDef(n, n2)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(n2), string, string3);
                    }
                    if (!XMLCharacterProperties.validName(string3)) {
                        this.reportRecoverableXMLError(77, 2, this.fStringPool.toString(n2), string3);
                    }
                    if (n != -1) {
                        this.fElementDeclPool.addIdRef(n3);
                    }
                } else if (string3 != string) {
                    n3 = this.fStringPool.addSymbol(string3);
                }
            } else if (n4 == this.fStringPool.addSymbol("IDREFS")) {
                String string4;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                StringBuffer stringBuffer = new StringBuffer(string.length());
                boolean bl = true;
                if (stringTokenizer.hasMoreTokens()) {
                    while (true) {
                        string4 = stringTokenizer.nextToken();
                        if (this.fValidating) {
                            if (!XMLCharacterProperties.validName(string4)) {
                                bl = false;
                            }
                            if (n != -1) {
                                this.fElementDeclPool.addIdRef(this.fStringPool.addSymbol(string4));
                            }
                        }
                        stringBuffer.append(string4);
                        if (!stringTokenizer.hasMoreTokens()) break;
                        stringBuffer.append(' ');
                    }
                }
                string4 = stringBuffer.toString();
                if (this.fValidating && (!bl || string4.length() == 0)) {
                    this.reportRecoverableXMLError(4, 2, this.fStringPool.toString(n2), string4);
                }
                if (!string4.equals(string)) {
                    n3 = this.fStringPool.addString(string4);
                    if (this.fValidating && this.invalidStandaloneAttDef(n, n2)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(n2), string, string4);
                    }
                }
            } else if (n4 == this.fStringPool.addSymbol("ENTITY")) {
                String string5 = string.trim();
                if (this.fValidating) {
                    int n6;
                    n3 = this.fStringPool.addSymbol(string5);
                    if (string5 != string && this.invalidStandaloneAttDef(n, n2)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(n2), string, string5);
                    }
                    if ((n6 = this.fEntityPool.lookupEntity(n3)) == -1 || !this.fEntityPool.isUnparsedEntity(n6)) {
                        this.reportRecoverableXMLError(79, 77, this.fStringPool.toString(n2), string5);
                    }
                } else if (string5 != string) {
                    n3 = this.fStringPool.addSymbol(string5);
                }
            } else if (n4 == this.fStringPool.addSymbol("ENTITIES")) {
                String string6;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                StringBuffer stringBuffer = new StringBuffer(string.length());
                boolean bl = true;
                if (stringTokenizer.hasMoreTokens()) {
                    while (true) {
                        int n7;
                        string6 = stringTokenizer.nextToken();
                        if (this.fValidating && ((n7 = this.fEntityPool.lookupEntity(this.fStringPool.addSymbol(string6))) == -1 || !this.fEntityPool.isUnparsedEntity(n7))) {
                            bl = false;
                        }
                        stringBuffer.append(string6);
                        if (!stringTokenizer.hasMoreTokens()) break;
                        stringBuffer.append(' ');
                    }
                }
                string6 = stringBuffer.toString();
                if (this.fValidating && (!bl || string6.length() == 0)) {
                    this.reportRecoverableXMLError(80, 77, this.fStringPool.toString(n2), string6);
                }
                if (!string6.equals(string)) {
                    n3 = this.fStringPool.addString(string6);
                    if (this.fValidating && this.invalidStandaloneAttDef(n, n2)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(n2), string, string6);
                    }
                }
            } else if (n4 == this.fStringPool.addSymbol("NMTOKEN")) {
                String string7 = string.trim();
                if (this.fValidating) {
                    n3 = this.fStringPool.addSymbol(string7);
                    if (string7 != string && this.invalidStandaloneAttDef(n, n2)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(n2), string, string7);
                    }
                    if (!XMLCharacterProperties.validNmtoken(string7)) {
                        this.reportRecoverableXMLError(78, 3, this.fStringPool.toString(n2), string7);
                    }
                } else if (string7 != string) {
                    n3 = this.fStringPool.addSymbol(string7);
                }
            } else if (n4 == this.fStringPool.addSymbol("NMTOKENS")) {
                String string8;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                StringBuffer stringBuffer = new StringBuffer(string.length());
                boolean bl = true;
                if (stringTokenizer.hasMoreTokens()) {
                    while (true) {
                        string8 = stringTokenizer.nextToken();
                        if (this.fValidating && !XMLCharacterProperties.validNmtoken(string8)) {
                            bl = false;
                        }
                        stringBuffer.append(string8);
                        if (!stringTokenizer.hasMoreTokens()) break;
                        stringBuffer.append(' ');
                    }
                }
                string8 = stringBuffer.toString();
                if (this.fValidating && (!bl || string8.length() == 0)) {
                    this.reportRecoverableXMLError(5, 3, this.fStringPool.toString(n2), string8);
                }
                if (!string8.equals(string)) {
                    n3 = this.fStringPool.addString(string8);
                    if (this.fValidating && this.invalidStandaloneAttDef(n, n2)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(n2), string, string8);
                    }
                }
            } else if (n4 == this.fStringPool.addSymbol("NOTATION") || n4 == this.fStringPool.addSymbol("ENUMERATION")) {
                String string9 = string.trim();
                if (this.fValidating) {
                    n3 = this.fStringPool.addSymbol(string9);
                    if (string9 != string && this.invalidStandaloneAttDef(n, n2)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(n2), string, string9);
                    }
                    if (!this.fStringPool.stringInList(n5, n3)) {
                        this.reportRecoverableXMLError(90, n4 == this.fStringPool.addSymbol("NOTATION") ? 84 : 86, this.fStringPool.toString(n2), string9, this.fStringPool.stringListAsString(n5));
                    }
                } else if (string9 != string) {
                    n3 = this.fStringPool.addSymbol(string9);
                }
            } else if (n4 == this.fStringPool.addSymbol("DATATYPE")) {
                try {
                    String string10 = this.fStringPool.toString(n5);
                    DatatypeValidator datatypeValidator = this.fDatatypeRegistry.getValidatorFor(string10);
                    if (datatypeValidator != null) {
                        datatypeValidator.validate(string);
                        break block69;
                    }
                    this.reportSchemaError(2, new Object[]{string10});
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError(3, new Object[]{invalidDatatypeValueException.getMessage()});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Internal error in attribute datatype validation");
                }
            } else {
                throw new RuntimeException("cannot happen 1");
            }
        }
        return n3;
    }

    public boolean notationDeclared(int n) {
        return this.fEntityPool.lookupNotation(n) != -1;
    }

    private int peekChildCount() {
        return this.fElementChildCount[this.fElementDepth];
    }

    private int[] peekChildren() {
        return this.fElementChildren[this.fElementDepth];
    }

    private int peekContentSpecType() {
        if (this.fElementDepth < 0) {
            return -1;
        }
        return this.fContentSpecTypeStack[this.fElementDepth];
    }

    private int peekElementType() {
        return this.fElementTypeStack[this.fElementDepth];
    }

    private void popElement() throws Exception {
        if (this.fElementDepth < 0) {
            throw new RuntimeException("Element stack underflow");
        }
        if (--this.fElementDepth < 0 && this.fValidating) {
            this.checkIDRefNames();
        }
    }

    private void pushElement(int n, int n2) {
        int[] nArray;
        if (this.fElementDepth >= 0) {
            nArray = this.fElementChildren[this.fElementDepth];
            int n3 = this.fElementChildCount[this.fElementDepth];
            if (nArray == null) {
                this.fElementChildren[this.fElementDepth] = new int[8];
                nArray = this.fElementChildren[this.fElementDepth];
                n3 = 0;
            } else if (n3 == nArray.length) {
                int[] nArray2 = new int[n3 * 2];
                System.arraycopy(nArray, 0, nArray2, 0, n3);
                this.fElementChildren[this.fElementDepth] = nArray2;
                nArray = nArray2;
            }
            nArray[n3++] = n;
            this.fElementChildCount[this.fElementDepth] = n3;
        }
        ++this.fElementDepth;
        if (this.fElementDepth == this.fElementTypeStack.length) {
            nArray = new int[this.fElementDepth * 2];
            System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
            this.fElementTypeStack = nArray;
            nArray = new int[this.fElementDepth * 2];
            System.arraycopy(this.fContentSpecTypeStack, 0, nArray, 0, this.fElementDepth);
            this.fContentSpecTypeStack = nArray;
            nArray = new int[this.fElementDepth * 2];
            System.arraycopy(this.fElementChildCount, 0, nArray, 0, this.fElementDepth);
            this.fElementChildCount = nArray;
            int[][] nArray3 = new int[this.fElementDepth * 2][];
            System.arraycopy(this.fElementChildren, 0, nArray3, 0, this.fElementDepth);
            this.fElementChildren = nArray3;
        }
        this.fElementTypeStack[this.fElementDepth] = n;
        this.fContentSpecTypeStack[this.fElementDepth] = n2;
        this.fElementChildCount[this.fElementDepth] = 0;
    }

    protected void reportRecoverableXMLError(int n, int n2) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, null, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n4)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string, String string2) throws Exception {
        Object[] objectArray = new Object[]{string, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string, String string2, String string3) throws Exception {
        Object[] objectArray = new Object[]{string, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    private void reportSchemaError(int n, Object[] objectArray) {
        try {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", n, 0, objectArray, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void reset(StringPool stringPool, XMLErrorReporter xMLErrorReporter, XMLEntityHandler xMLEntityHandler) throws Exception {
        this.fEntityPool.reset(stringPool);
        this.fValidating = this.fValidationEnabled;
        this.fElementDeclPool.reset(stringPool);
        this.fRootElementType = -1;
        this.fAttrIndex = -1;
        this.fStandaloneReader = -1;
        this.fElementDepth = -1;
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityHandler = xMLEntityHandler;
        this.fStringPool = stringPool;
        this.fSchemaDocument = null;
    }

    public void rootElementSpecified(int n) throws Exception {
        if (this.fValidating) {
            this.fRootElementType = n;
            if (this.fRootElementType != -1 && n != this.fRootElementType) {
                this.reportRecoverableXMLError(3, 1, this.fRootElementType, n);
            }
        }
    }

    public void setDynamicValidationEnabled(boolean bl) {
        this.fDynamicValidation = bl;
        this.fDynamicDisabledByValidation = false;
        if (this.fDynamicValidation) {
            if (!this.fValidationEnabled) {
                this.fValidationEnabledByDynamic = true;
                this.fValidationEnabled = true;
            }
        } else if (this.fValidationEnabledByDynamic) {
            this.fValidationEnabled = false;
            this.fValidationEnabledByDynamic = false;
        }
    }

    public void setNamespacesEnabled(boolean bl) {
        this.fNamespacesEnabled = bl;
    }

    public void setValidationEnabled(boolean bl) {
        this.fValidationEnabled = bl;
        this.fValidationEnabledByDynamic = false;
        if (this.fValidationEnabled) {
            if (this.fDynamicDisabledByValidation) {
                this.fDynamicValidation = true;
                this.fDynamicDisabledByValidation = false;
            }
        } else if (this.fDynamicValidation) {
            this.fDynamicValidation = false;
            this.fDynamicDisabledByValidation = true;
        }
        this.fValidating = this.fValidationEnabled;
    }

    public void setWarningOnDuplicateAttDef(boolean bl) {
        this.fWarningOnDuplicateAttDef = bl;
    }

    public void setWarningOnUndeclaredElements(boolean bl) {
        this.fWarningOnUndeclaredElements = bl;
    }

    private void shift(int[] nArray, int n, int n2) {
        int n3 = nArray[n2];
        int n4 = n2;
        while (n4 > n) {
            nArray[n4] = nArray[n4 - 1];
            --n4;
        }
        nArray[n] = n3;
    }

    private void sort(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2 - 1) {
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n + n2) {
                if (nArray[n5] < nArray[n4]) {
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
            }
            ++n3;
        }
    }

    public boolean startElement(int n, XMLAttrList xMLAttrList) throws Exception {
        int n2;
        int n3 = this.fAttrIndex;
        this.fAttrIndex = -1;
        int n4 = this.fElementDeclPool.getElement(n);
        int n5 = n2 = n4 == -1 ? -1 : this.fElementDeclPool.getContentSpecType(n4);
        if (n2 == -1 && this.fValidating) {
            this.reportRecoverableXMLError(83, 79, n);
        }
        if (n4 != -1) {
            n3 = this.fElementDeclPool.addDefaultAttributes(n4, xMLAttrList, n3, this.fValidating, this.fStandaloneReader != -1);
        }
        this.checkAttributes(n4, xMLAttrList, n3);
        if (this.fValidating && n2 == this.fStringPool.addSymbol("DATATYPE")) {
            this.fBufferDatatype = true;
            this.fDatatypeBuffer.setLength(0);
        }
        this.pushElement(n, n2);
        return n2 == this.fStringPool.addSymbol("CHILDREN");
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private int traverseAttrGroup(Element element) throws Exception {
        String string = element.getAttribute(ATT_NAME);
        if (string.equals("")) {
            string = "http://www.apache.org/xml/xerces/internalGroup" + this.fGroupCount++;
        }
        Element element2 = XUtil.getFirstChildElement(element);
        int[] nArray = new int[((NodeImpl)((Object)element)).getLength()];
        int n = 0;
        while (element2 != null) {
            String string2 = element2.getNodeName();
            if (string2.equals(ELT_ATTRGROUPREF)) {
                nArray[n++] = this.traverseAttrGroupRef(element2);
                if (this.getContentSpec(this.getElement(nArray[n - 1])) == -1) {
                    this.reportSchemaError(7, new Object[]{"Forward reference to AttrGroup"});
                }
            } else if (!string2.equals(ELT_ATTRIBUTEDECL)) {
                this.reportSchemaError(19, new Object[]{string2});
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n2 = this.fStringPool.addSymbol(string);
        int n3 = this.fElementDeclPool.addElementDecl(n2, 0, 0, false);
        element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string3 = element2.getNodeName();
            if (string3.equals(ELT_ATTRIBUTEDECL)) {
                this.traverseAttributeDecl(element2, n3);
            } else if (string3.equals(ELT_ATTRGROUPDECL)) {
                int n4 = this.traverseAttrGroupRef(element2);
                if (this.getContentSpec(this.getElement(n4)) == -1) {
                    this.reportSchemaError(7, new Object[]{"Forward reference to AttrGroup"});
                    Vector<Integer> vector = null;
                    Integer n5 = new Integer(n4);
                    vector = (Vector<Integer>)this.fForwardRefs.get(n5);
                    if (vector == null) {
                        vector = new Vector<Integer>();
                    }
                    vector.addElement(new Integer(n2));
                    this.fForwardRefs.put(n5, vector);
                    this.addUse(n2, n4);
                } else {
                    nArray[n++] = this.getContentSpec(this.getElement(n4));
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n6 = 0;
        while (n6 < n) {
            this.fElementDeclPool.copyAtts(nArray[n6], n2);
            ++n6;
        }
        return n2;
    }

    private int traverseAttrGroupRef(Element element) {
        String string = element.getAttribute(ATT_NAME);
        int n = this.fStringPool.addSymbol(string);
        return n;
    }

    private void traverseAttributeDecl(Element element, int n) throws Exception {
        int n2;
        int n3 = this.fStringPool.addSymbol(element.getAttribute(ATT_NAME));
        int n4 = -1;
        int n5 = -1;
        String string = element.getAttribute(ATT_TYPE);
        if (string.equals("")) {
            n4 = this.fStringPool.addSymbol("CDATA");
        } else if (string.equals("string")) {
            n4 = this.fStringPool.addSymbol("CDATA");
        } else if (string.equals("ID")) {
            n4 = this.fStringPool.addSymbol("ID");
        } else if (string.equals("IDREF")) {
            n4 = this.fStringPool.addSymbol("IDREF");
        } else if (string.equals("IDREFS")) {
            n4 = this.fStringPool.addSymbol("IDREFS");
        } else if (string.equals("ENTITY")) {
            n4 = this.fStringPool.addSymbol("ENTITY");
        } else if (string.equals("ENTITIES")) {
            n4 = this.fStringPool.addSymbol("ENTITIES");
        } else if (string.equals("NMTOKEN")) {
            Element element2 = XUtil.getFirstChildElement((Node)element, "enumeration");
            if (element2 == null) {
                n4 = this.fStringPool.addSymbol("NMTOKEN");
            } else {
                n4 = this.fStringPool.addSymbol("ENUMERATION");
                n5 = this.fStringPool.startStringList();
                Element element3 = XUtil.getFirstChildElement((Node)element2, "literal");
                while (element3 != null) {
                    n2 = this.fStringPool.addSymbol(element3.getFirstChild().getNodeValue());
                    this.fStringPool.addStringToList(n5, n2);
                    element3 = XUtil.getNextSiblingElement((Node)element3, "literal");
                }
                this.fStringPool.finishStringList(n5);
            }
        } else if (string.equals("NMTOKENS")) {
            n4 = this.fStringPool.addSymbol("NMTOKENS");
        } else if (string.equals(ELT_NOTATIONDECL)) {
            n4 = this.fStringPool.addSymbol("NOTATION");
        } else {
            n4 = this.fStringPool.addSymbol("DATATYPE");
            n5 = this.fStringPool.addSymbol(string);
        }
        int n6 = -1;
        int n7 = -1;
        n2 = element.getAttribute("required").equals("true");
        if (n2 != 0) {
            n6 = this.fStringPool.addSymbol("#REQUIRED");
        } else {
            String string2;
            String string3 = element.getAttribute(ATT_FIXED);
            if (!string3.equals("")) {
                n6 = this.fStringPool.addSymbol("#FIXED");
                n7 = this.fStringPool.addString(string3);
            } else {
                string2 = element.getAttribute(ATT_DEFAULT);
                if (!string2.equals("")) {
                    n6 = this.fStringPool.addSymbol("");
                    n7 = this.fStringPool.addString(string2);
                } else {
                    n6 = this.fStringPool.addSymbol("#IMPLIED");
                }
            }
            if (n4 == this.fStringPool.addSymbol("DATATYPE") && n7 != -1) {
                try {
                    string2 = this.fStringPool.toString(n5);
                    DatatypeValidator datatypeValidator = this.fDatatypeRegistry.getValidatorFor(string2);
                    if (datatypeValidator != null) {
                        datatypeValidator.validate(this.fStringPool.toString(n7));
                    } else {
                        this.reportSchemaError(2, new Object[]{string2});
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError(18, new Object[]{element.getAttribute(ATT_NAME), invalidDatatypeValueException.getMessage()});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Internal error in attribute datatype validation");
                }
            }
        }
        this.fElementDeclPool.addAttDef(n, n3, n4, n5, n6, n7, true, true, true);
    }

    private void traverseComment(Element element) {
    }

    public int traverseDatatypeDecl(Element element) {
        Object object;
        int n = this.fStringPool.addSymbol(element.getAttribute(ATT_NAME));
        int n2 = this.fStringPool.addSymbol(element.getAttribute(ATT_EXPORT));
        Element element2 = XUtil.getFirstChildElement(element);
        int n3 = this.fStringPool.addSymbol(element2.getNodeName());
        DatatypeValidator datatypeValidator = this.fDatatypeRegistry.getValidatorFor(element2.getAttribute(ATT_NAME));
        if (datatypeValidator == null) {
            this.reportSchemaError(15, new Object[]{element2.getAttribute(ATT_NAME), element.getAttribute(ATT_NAME)});
            return -1;
        }
        int n4 = 0;
        int n5 = 0;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<String> vector = new Vector<String>();
        Node node = element2.getNextSibling();
        while (node != null) {
            if (node.getNodeType() == 1) {
                ++n4;
                if (node.getNodeName().equals("enumeration")) {
                    object = XUtil.getFirstChildElement(node);
                    while (object != null) {
                        ++n5;
                        vector.addElement(object.getFirstChild().getNodeValue());
                        object = XUtil.getNextSiblingElement((Node)object);
                    }
                } else {
                    hashtable.put(node.getNodeName(), node.getFirstChild().getNodeValue());
                }
            }
            node = node.getNextSibling();
        }
        if (n5 > 0) {
            hashtable.put("enumeration", vector);
        }
        try {
            object = (DatatypeValidator)datatypeValidator.getClass().newInstance();
            if (n4 > 0) {
                object.setFacets(hashtable);
            }
            this.fDatatypeRegistry.addValidator(this.fStringPool.toString(n), (DatatypeValidator)object);
        }
        catch (Exception exception) {
            this.reportSchemaError(21, new Object[]{exception.getMessage()});
        }
        return -1;
    }

    private int traverseElementDecl(Element element) throws Exception {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        String string = element.getAttribute(ATT_NAME);
        String string2 = element.getAttribute(ATT_REF);
        String string3 = element.getAttribute(ATT_ARCHREF);
        String string4 = element.getAttribute(ATT_TYPE);
        String string5 = element.getAttribute(ATT_SCHEMAABBREV);
        String string6 = element.getAttribute(ATT_SCHEMANAME);
        String string7 = element.getAttribute(ATT_MINOCCURS);
        String string8 = element.getAttribute(ATT_MAXOCCURS);
        String string9 = element.getAttribute(ATT_EXPORT);
        int n5 = 0;
        if (!string2.equals("")) {
            ++n5;
        }
        if (!string4.equals("")) {
            ++n5;
        }
        if (!string3.equals("")) {
            ++n5;
        }
        if (n5 > 1) {
            this.reportSchemaError(16, null);
        }
        if (!string2.equals("") || !string3.equals("")) {
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            int n6 = !string2.equals("") ? this.fStringPool.addSymbol(string2) : this.fStringPool.addSymbol(string3);
            n3 = this.getContentSpec(this.getElement(n6));
            n2 = this.getContentSpecType(this.getElement(n6));
            int n7 = this.fStringPool.addSymbol(string);
            int n8 = -1;
            if (n3 == -1) {
                n2 = 0;
                n3 = this.fElementDeclPool.addContentSpecNode(0, n7, -1, false);
                this.fElementDeclPool.addElementDecl(n7, n2, n3, true);
                this.reportSchemaError(7, new Object[]{"Forward references to archetypes"});
                Vector<Integer> vector = null;
                Integer n9 = new Integer(n6);
                vector = (Vector<Integer>)this.fForwardRefs.get(n9);
                if (vector == null) {
                    vector = new Vector<Integer>();
                }
                vector.addElement(new Integer(n7));
                this.fForwardRefs.put(n9, vector);
                this.addUse(n7, n6);
            } else {
                this.fElementDeclPool.addElementDecl(n7, n2, n3, true);
                this.fElementDeclPool.copyAtts(n6, n7);
            }
            return n7;
        }
        Element element2 = XUtil.getFirstChildElement(element);
        if (element2 != null) {
            String string10 = element2.getNodeName();
            if (string10.equals(ELT_ARCHETYPEDECL)) {
                n4 = this.traverseTypeDecl(element2);
                n3 = this.getContentSpec(this.getElement(n4));
                n2 = this.getContentSpecType(this.getElement(n4));
            } else if (string10.equals(ELT_DATATYPEDECL)) {
                this.reportSchemaError(7, new Object[]{"Nesting datatype declarations"});
            } else if (!string4.equals("")) {
                n2 = this.fStringPool.addSymbol("DATATYPE");
                n3 = this.fElementDeclPool.addContentSpecNode(0, this.fStringPool.addSymbol(element2.getAttribute(ATT_NAME)), -1, false);
                n3 = this.expandContentModel(n3, element2);
            } else if (string4.equals("")) {
                n2 = this.fStringPool.addSymbol("CHILDREN");
                n = this.fElementDeclPool.addContentSpecNode(0, this.fStringPool.addSymbol(element2.getAttribute(ATT_NAME)), -1, false);
                n3 = this.expandContentModel(n3, element2);
            } else {
                System.out.println("unhandled case in element decl code");
            }
        } else if (!string4.equals("")) {
            n2 = this.fStringPool.addSymbol("DATATYPE");
            n3 = this.fElementDeclPool.addContentSpecNode(0, this.fStringPool.addSymbol(string4), -1, false);
            n3 = this.expandContentModel(n3, element);
        }
        int n10 = this.fStringPool.addSymbol(element.getAttribute(ATT_NAME));
        n = this.fElementDeclPool.addElementDecl(n10, n2, n3, true);
        this.fElementDeclPool.copyAtts(n4, n10);
        return n10;
    }

    private int traverseElementRef(Element element) {
        String string = element.getAttribute(ATT_REF);
        int n = this.fStringPool.addSymbol(string);
        int n2 = 0;
        try {
            n2 = this.fElementDeclPool.addContentSpecNode(0, n, -1, false);
            n2 = this.expandContentModel(n2, element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    private int traverseGroup(Element element) throws Exception {
        int n;
        String string = element.getAttribute(ATT_NAME);
        String string2 = element.getAttribute(ATT_COLLECTION);
        String string3 = element.getAttribute(ATT_ORDER);
        if (string.equals("")) {
            string = "http://www.apache.org/xml/xerces/internalGroup" + this.fGroupCount++;
        }
        Element element2 = XUtil.getFirstChildElement(element);
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int[] nArray = null;
        int n4 = 0;
        if (string3.equals(ATTVAL_CHOICE)) {
            n3 = 4;
            n2 = this.fStringPool.addSymbol("CHILDREN");
        } else if (string3.equals(ATTVAL_SEQ)) {
            n3 = 5;
            n2 = this.fStringPool.addSymbol("CHILDREN");
        } else if (string3.equals(ATTVAL_ALL)) {
            bl = true;
            nArray = new int[((NodeImpl)((Object)element)).getLength()];
            n4 = 0;
        }
        int n5 = -2;
        int n6 = -2;
        boolean bl2 = false;
        int[] nArray2 = new int[((NodeImpl)((Object)element)).getLength()];
        int n7 = 0;
        while (element2 != null) {
            int n8;
            n = -2;
            bl2 = true;
            String string4 = element2.getNodeName();
            if (string4.equals(ELT_ELEMENTDECL)) {
                if (element2.getAttribute(ATT_REF).equals("")) {
                    this.reportSchemaError(7, new Object[]{"Nesting element declarations"});
                } else {
                    n = this.traverseElementRef(element2);
                }
            } else if (string4.equals(ELT_GROUP)) {
                if (!bl) {
                    n8 = this.traverseGroup(element2);
                    nArray2[n7++] = n8;
                    n = this.getContentSpec(this.getElement(n8));
                } else {
                    this.reportSchemaError(11, new Object[]{ELT_GROUP});
                }
            } else if (string4.equals(ELT_MODELGROUPREF)) {
                if (!bl) {
                    n8 = this.traverseModelGroupRef(element2);
                    n = this.getContentSpec(this.getElement(n8));
                    n = this.expandContentModel(n, element2);
                } else {
                    this.reportSchemaError(11, new Object[]{ELT_MODELGROUPREF});
                }
            } else {
                this.reportSchemaError(14, new Object[]{ELT_GROUP, string4});
            }
            if (bl) {
                nArray[n4++] = n;
            } else if (n5 == -2) {
                n5 = n;
            } else if (n6 == -2) {
                n6 = n;
            } else {
                n5 = this.fElementDeclPool.addContentSpecNode(n3, n5, n6, false);
                n6 = n;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl) {
            n5 = this.buildAllModel(nArray, n4);
        } else if (bl2 && n6 != -2) {
            n5 = this.fElementDeclPool.addContentSpecNode(n3, n5, n6, false);
        }
        n5 = this.expandContentModel(n5, element);
        n = this.fStringPool.addSymbol(string);
        int n9 = this.fElementDeclPool.addElementDecl(n, n2, n5, false);
        return n;
    }

    private int traverseModelGroup(Element element) throws Exception {
        int n;
        String string = element.getAttribute(ATT_NAME);
        String string2 = element.getAttribute(ATT_ORDER);
        if (string.equals("")) {
            string = "http://www.apache.org/xml/xerces/internalModelGroup" + this.fModelGroupCount++;
        }
        Element element2 = XUtil.getFirstChildElement(element);
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int[] nArray = null;
        int n4 = 0;
        if (string2.equals(ATTVAL_CHOICE)) {
            n3 = 4;
            n2 = this.fStringPool.addSymbol("CHILDREN");
        } else if (string2.equals(ATTVAL_SEQ)) {
            n3 = 5;
            n2 = this.fStringPool.addSymbol("CHILDREN");
        } else if (string2.equals(ATTVAL_ALL)) {
            bl = true;
            nArray = new int[((NodeImpl)((Object)element)).getLength()];
            n4 = 0;
        }
        int n5 = -2;
        int n6 = -2;
        boolean bl2 = false;
        while (element2 != null) {
            int n7;
            n = -2;
            bl2 = true;
            String string3 = element2.getNodeName();
            if (string3.equals(ELT_ELEMENTDECL)) {
                if (element2.getAttribute(ATT_REF).equals("")) {
                    this.reportSchemaError(7, new Object[]{"Nesting element declarations"});
                } else {
                    n = this.traverseElementRef(element2);
                }
            } else if (string3.equals(ELT_GROUP)) {
                n7 = this.traverseGroup(element2);
                n = this.getContentSpec(this.getElement(n7));
            } else if (string3.equals(ELT_MODELGROUPREF)) {
                n7 = this.traverseModelGroupRef(element2);
                n = this.getContentSpec(this.getElement(n7));
                n = this.expandContentModel(n, element2);
            } else {
                this.reportSchemaError(14, new Object[]{ELT_MODELGROUPDECL, string3});
            }
            if (bl) {
                nArray[n4++] = n;
            } else if (n5 == -2) {
                n5 = n;
            } else if (n6 == -2) {
                n6 = n;
            } else {
                n5 = this.fElementDeclPool.addContentSpecNode(n3, n5, n6, false);
                n6 = n;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl) {
            n5 = this.buildAllModel(nArray, n4);
        } else if (bl2 && n6 != -2) {
            n5 = this.fElementDeclPool.addContentSpecNode(n3, n5, n6, false);
        }
        n5 = this.expandContentModel(n5, element);
        n = this.fStringPool.addSymbol(string);
        int n8 = this.fElementDeclPool.addElementDecl(n, n2, n5, false);
        return n;
    }

    private int traverseModelGroupRef(Element element) {
        String string = element.getAttribute(ATT_NAME);
        int n = this.fStringPool.addSymbol(string);
        return n;
    }

    private void traverseSchema(Element element) throws Exception {
        if (element == null) {
            return;
        }
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            int n;
            int n2;
            int n3;
            String string = element2.getNodeName();
            if (string.equals(ELT_COMMENT)) {
                this.traverseComment(element2);
            } else if (string.equals(ELT_DATATYPEDECL)) {
                this.traverseDatatypeDecl(element2);
            } else if (string.equals(ELT_ARCHETYPEDECL)) {
                this.traverseTypeDecl(element2);
            } else if (string.equals(ELT_ELEMENTDECL)) {
                this.traverseElementDecl(element2);
            } else if (string.equals(ELT_ATTRGROUPDECL)) {
                this.traverseAttrGroup(element2);
            } else if (string.equals(ELT_MODELGROUPDECL)) {
                this.traverseModelGroup(element2);
            } else if (string.equals(ELT_TEXTENTITYDECL) || string.equals(ELT_EXTERNALENTITYDECL) || string.equals(ELT_UNPARSEDENTITYDECL)) {
                n3 = this.fStringPool.addSymbol(element2.getAttribute(ATT_NAME));
                if (string.equals(ELT_TEXTENTITYDECL)) {
                    n2 = this.fStringPool.addString(element2.getFirstChild().getFirstChild().getNodeValue());
                    this.fEntityPool.addEntityDecl(n3, n2, -1, -1, -1, -1, true);
                } else {
                    n2 = this.fStringPool.addString(element2.getAttribute("public"));
                    n = this.fStringPool.addString(element2.getAttribute("system"));
                    if (string.equals(ELT_EXTERNALENTITYDECL)) {
                        this.fEntityPool.addEntityDecl(n3, -1, -1, n2, n, -1, true);
                    } else {
                        int n4 = this.fStringPool.addSymbol(element2.getAttribute(ELT_NOTATIONDECL));
                        this.fEntityPool.addEntityDecl(n3, -1, -1, n2, n, n4, true);
                    }
                }
            } else if (string.equals(ELT_NOTATIONDECL)) {
                n3 = this.fStringPool.addSymbol(element2.getAttribute(ATT_NAME));
                n2 = this.fStringPool.addString(element2.getAttribute("public"));
                n = this.fStringPool.addString(element2.getAttribute("system"));
                this.fEntityPool.addNotationDecl(n3, n2, n, true);
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        this.cleanupForwardReferences();
    }

    private int traverseTypeDecl(Element element) throws Exception {
        int n;
        int n2;
        String string = element.getAttribute(ATT_NAME);
        String string2 = element.getAttribute(ATT_CONTENT);
        String string3 = element.getAttribute(ATT_MODEL);
        String string4 = element.getAttribute(ATT_ORDER);
        String string5 = element.getAttribute(ATT_TYPE);
        String string6 = element.getAttribute(ATT_DEFAULT);
        String string7 = element.getAttribute(ATT_FIXED);
        String string8 = element.getAttribute(ATT_SCHEMAABBREV);
        String string9 = element.getAttribute(ATT_SCHEMANAME);
        if (string.equals("")) {
            string = "http://www.apache.org/xml/xerces/internalType" + this.fTypeCount++;
        }
        if (string5.equals("")) {
            if (!string8.equals("")) {
                this.reportSchemaError(4, new Object[]{ATT_SCHEMAABBREV});
            }
            if (!string9.equals("")) {
                this.reportSchemaError(4, new Object[]{ATT_SCHEMANAME});
            }
            if (!string6.equals("")) {
                this.reportSchemaError(4, new Object[]{ATT_DEFAULT});
            }
            if (!string7.equals("")) {
                this.reportSchemaError(4, new Object[]{ATT_FIXED});
            }
        } else {
            if (this.fDatatypeRegistry.getValidatorFor(string5) != null) {
                this.reportSchemaError(5, new Object[]{string5});
            }
            if (!string2.equals(ATTVAL_TEXTONLY)) {
                this.reportSchemaError(6, null);
            }
        }
        Element element2 = XUtil.getFirstChildElement(element);
        Element element3 = null;
        if (element2 != null && element2.getNodeName().equals(ELT_REFINES)) {
            this.reportSchemaError(7, new Object[]{"Refinement"});
            element3 = element2;
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int[] nArray = null;
        int n5 = 0;
        int n6 = -2;
        int n7 = -2;
        boolean bl5 = false;
        if (string4.equals(ATTVAL_CHOICE)) {
            n4 = 4;
            n3 = this.fStringPool.addSymbol("CHILDREN");
        } else if (string4.equals(ATTVAL_SEQ)) {
            n4 = 5;
            n3 = this.fStringPool.addSymbol("CHILDREN");
        } else if (string4.equals(ATTVAL_ALL)) {
            bl4 = true;
            nArray = new int[((NodeImpl)((Object)element)).getLength()];
            n5 = 0;
        }
        if (string2.equals(ATTVAL_EMPTY)) {
            n3 = this.fStringPool.addSymbol("EMPTY");
            n6 = -1;
        } else if (string2.equals(ATTVAL_ANY)) {
            n3 = this.fStringPool.addSymbol("ANY");
            n6 = -1;
        } else if (string2.equals(ATTVAL_MIXED)) {
            n3 = this.fStringPool.addSymbol("MIXED");
            bl = true;
            n4 = 4;
        } else if (string2.equals(ATTVAL_ELEMONLY)) {
            bl2 = true;
        } else if (string2.equals(ATTVAL_TEXTONLY)) {
            bl3 = true;
        }
        if (bl) {
            n6 = this.fElementDeclPool.addContentSpecNode(0, -1, -1, false);
        }
        Vector<Integer> vector = new Vector<Integer>();
        while (element2 != null) {
            n2 = -2;
            bl5 = true;
            String string10 = element2.getNodeName();
            if (string10.equals(ELT_ELEMENTDECL)) {
                if (element2.getAttribute(ATT_REF).equals("")) {
                    if (bl2) {
                        this.reportSchemaError(7, new Object[]{"Nesting element declarations"});
                    } else {
                        this.reportSchemaError(8, null);
                    }
                } else if (bl || bl2) {
                    n2 = this.traverseElementRef(element2);
                } else {
                    this.reportSchemaError(9, null);
                }
            } else if (string10.equals(ELT_GROUP)) {
                if (bl2 && !bl4) {
                    n = this.traverseGroup(element2);
                    n2 = this.getContentSpec(this.getElement(n));
                } else if (!bl2) {
                    this.reportSchemaError(10, new Object[]{ELT_GROUP});
                } else {
                    this.reportSchemaError(11, new Object[]{ELT_GROUP});
                }
            } else if (string10.equals(ELT_MODELGROUPREF)) {
                if (bl2 && !bl4) {
                    n = this.traverseModelGroup(element2);
                    n2 = this.getContentSpec(this.getElement(n));
                    if (n2 == -1) {
                        this.reportSchemaError(7, new Object[]{"Forward reference to model group"});
                    }
                    n2 = this.expandContentModel(n2, element2);
                } else if (!bl2) {
                    this.reportSchemaError(10, new Object[]{ELT_MODELGROUPREF});
                } else {
                    this.reportSchemaError(11, new Object[]{ELT_MODELGROUPREF});
                }
            } else {
                if (string10.equals(ELT_ATTRIBUTEDECL) || string10.equals(ELT_ATTRGROUPREF)) break;
                if (string5.equals("")) {
                    this.reportSchemaError(12, null);
                } else {
                    this.reportSchemaError(13, new Object[]{string10});
                }
            }
            vector.addElement(new Integer(n2));
            if (bl4) {
                nArray[n5++] = n2;
            } else if (n6 == -2) {
                n6 = n2;
            } else if (n7 == -2) {
                n7 = n2;
            } else {
                n6 = this.fElementDeclPool.addContentSpecNode(n4, n6, n7, false);
                n7 = n2;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl4) {
            n6 = this.buildAllModel(nArray, n5);
        } else {
            if (bl5 && n7 != -2) {
                n6 = this.fElementDeclPool.addContentSpecNode(n4, n6, n7, false);
            }
            if (bl && bl5) {
                n6 = this.fElementDeclPool.addContentSpecNode(2, n6, -1, false);
            }
        }
        n2 = this.fStringPool.addSymbol(string);
        int n8 = this.fElementDeclPool.addElementDecl(n2, n3, n6, false);
        n = 0;
        while (n < vector.size()) {
            this.addUse(n2, (Integer)vector.elementAt(n));
            ++n;
        }
        while (element2 != null) {
            String string11 = element2.getNodeName();
            if (string11.equals(ELT_ATTRIBUTEDECL)) {
                this.traverseAttributeDecl(element2, n8);
            } else if (string11.equals(ELT_ATTRGROUPREF)) {
                int n9 = this.traverseAttrGroupRef(element2);
                if (this.getContentSpec(this.getElement(n9)) == -1) {
                    this.reportSchemaError(7, new Object[]{"Forward References to attrGroup"});
                    Vector<Integer> vector2 = null;
                    Integer n10 = new Integer(n9);
                    vector2 = (Vector<Integer>)this.fForwardRefs.get(n10);
                    if (vector2 == null) {
                        vector2 = new Vector<Integer>();
                    }
                    vector2.addElement(new Integer(n2));
                    this.fForwardRefs.put(n10, vector2);
                    this.addUse(n2, n9);
                } else {
                    this.fElementDeclPool.copyAtts(n9, n2);
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        return n2;
    }

    private boolean usingStandaloneReader() {
        return this.fStandaloneReader == -1 || this.fEntityHandler.getReaderId() == this.fStandaloneReader;
    }

    public int valueOfReferenceInAttValue(int n) throws Exception {
        if (this.fStandaloneReader != -1 && this.fValidating && this.fEntityPool.getEntityDeclIsExternal(n)) {
            this.reportRecoverableXMLError(132, 80, this.fEntityPool.getEntityName(n));
        }
        int n2 = this.fEntityPool.getEntityValue(n);
        return n2;
    }

    public int whatCanGoHere(int n, boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        if (insertableElementsInfo.insertAt > insertableElementsInfo.childCount || insertableElementsInfo.curChildren == null || insertableElementsInfo.childCount < 1 || insertableElementsInfo.childCount > insertableElementsInfo.curChildren.length) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 13, 0, null, 2);
        }
        int n2 = 0;
        try {
            XMLContentModel xMLContentModel = this.getContentModel(n);
            n2 = xMLContentModel.whatCanGoHere(bl, insertableElementsInfo);
        }
        catch (CMException cMException) {
            int n3 = cMException.getErrorCode();
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", n3, 0, null, 2);
        }
        return n2;
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/XML/Group/1999/09/23-xmlschema/structures/structures.dtd", "http://www.w3.org/XML/Group/1999/09/23-xmlschema/datatypes/datatypes.dtd"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd"};

        Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException {
            int n = 0;
            while (n < SYSTEM.length) {
                if (string2.equals(SYSTEM[n])) {
                    InputSource inputSource = new InputSource(this.getClass().getResourceAsStream(PATH[n]));
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                ++n;
            }
            return null;
        }
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }

    class DatatypeValidatorRegistry {
        Hashtable fRegistry = new Hashtable();
        String[][] integerSubtypeTable = new String[][]{{"non-negative-integer", "minInclusive", "0"}, {"postive-integer", "minInclusive", "1"}, {"non-positive-integer", "maxInclusive", "0"}, {"negative-integer", "maxInclusive", "-1"}};

        DatatypeValidatorRegistry() {
        }

        void addValidator(String string, DatatypeValidator datatypeValidator) {
            this.fRegistry.put(string, datatypeValidator);
        }

        DatatypeValidator getValidatorFor(String string) {
            return (DatatypeValidator)this.fRegistry.get(string);
        }

        void initializeRegistry() {
            Hashtable<String, String> hashtable = null;
            this.fRegistry.put("boolean", new BooleanValidator());
            IntegerValidator integerValidator = new IntegerValidator();
            this.fRegistry.put("integer", integerValidator);
            this.fRegistry.put("string", new StringValidator());
            this.fRegistry.put("decimal", new DecimalValidator());
            this.fRegistry.put("float", new FloatValidator());
            this.fRegistry.put("double", new DoubleValidator());
            IntegerValidator integerValidator2 = null;
            int n = 0;
            while (n < this.integerSubtypeTable.length) {
                integerValidator2 = new IntegerValidator();
                hashtable = new Hashtable<String, String>();
                hashtable.put(this.integerSubtypeTable[n][1], this.integerSubtypeTable[n][2]);
                integerValidator2.setBasetype(integerValidator);
                try {
                    integerValidator2.setFacets(hashtable);
                }
                catch (IllegalFacetException illegalFacetException) {
                    System.out.println("Internal error initializing registry - Illegal facet: " + this.integerSubtypeTable[n][0]);
                }
                catch (IllegalFacetValueException illegalFacetValueException) {
                    System.out.println("Internal error initializing registry - Illegal facet value: " + this.integerSubtypeTable[n][0]);
                }
                catch (UnknownFacetException unknownFacetException) {
                    System.out.println("Internal error initializing registry - Unknown facet: " + this.integerSubtypeTable[n][0]);
                }
                this.fRegistry.put(this.integerSubtypeTable[0], integerValidator2);
                ++n;
            }
        }
    }
}

