/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import org.apache.xerces.framework.XMLContentSpecNode;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.dtd.ElementDeclPool;
import org.apache.xerces.validators.dtd.InsertableElementsInfo;
import org.apache.xerces.validators.dtd.XMLContentModel;
import org.apache.xerces.validators.schema.XSchemaValidator;

public class DatatypeContentModel
implements XMLContentModel {
    XSchemaValidator.DatatypeValidatorRegistry fDatatypeRegistry = null;
    ElementDeclPool fElementDeclPool = null;
    StringPool fStringPool = null;
    int fChild = -1;

    public DatatypeContentModel(XSchemaValidator.DatatypeValidatorRegistry datatypeValidatorRegistry, ElementDeclPool elementDeclPool, StringPool stringPool, int n) {
        this.fDatatypeRegistry = datatypeValidatorRegistry;
        this.fElementDeclPool = elementDeclPool;
        this.fStringPool = stringPool;
        this.fChild = n;
    }

    public int validateContent(int n, int[] nArray) throws Exception {
        boolean bl = false;
        try {
            int n2 = this.fElementDeclPool.getContentSpec(this.fChild);
            XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
            this.fElementDeclPool.getContentSpecNode(n2, xMLContentSpecNode);
            String string = this.fStringPool.toString(xMLContentSpecNode.value);
            DatatypeValidator datatypeValidator = this.fDatatypeRegistry.getValidatorFor(string);
            if (datatypeValidator != null) {
                datatypeValidator.validate(this.fStringPool.toString(nArray[0]));
            } else {
                System.out.println("No validator for datatype " + string);
            }
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw invalidDatatypeValueException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Internal error in datatype validation");
        }
        return -1;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        return -1;
    }
}

