/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.dtd;

import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.dtd.CMBinOp;
import org.apache.xerces.validators.dtd.CMException;
import org.apache.xerces.validators.dtd.CMLeaf;
import org.apache.xerces.validators.dtd.CMNode;
import org.apache.xerces.validators.dtd.CMStateSet;
import org.apache.xerces.validators.dtd.CMUniOp;
import org.apache.xerces.validators.dtd.InsertableElementsInfo;
import org.apache.xerces.validators.dtd.XMLContentModel;

public class DFAContentModel
implements XMLContentModel {
    private static final String fEpsilonString = "<<CMNODE_EPSILON>>";
    private static final String fEOCString = "<<CMNODE_EOC>>";
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private int[] fElemMap = null;
    private int fElemMapSize = 0;
    private int fEOCIndex = 0;
    private int fEOCPos = 0;
    private int fEpsilonIndex = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private StringPool fStringPool = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;

    public DFAContentModel(StringPool stringPool, CMNode cMNode, int n) throws CMException {
        this.fStringPool = stringPool;
        this.fLeafCount = n;
        this.fEpsilonIndex = this.fStringPool.addSymbol(fEpsilonString);
        this.fEOCIndex = this.fStringPool.addSymbol(fEOCString);
        this.buildDFA(cMNode);
    }

    private void buildDFA(CMNode cMNode) throws CMException {
        int n;
        CMLeaf cMLeaf = new CMLeaf(0, this.fEOCIndex);
        this.fHeadNode = new CMBinOp(5, cMNode, cMLeaf);
        this.fEOCPos = this.fLeafCount;
        cMLeaf.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int n2 = 0;
        while (n2 < this.fLeafCount) {
            this.fFollowList[n2] = new CMStateSet(this.fLeafCount);
            ++n2;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int n3 = 0;
        while (n3 < this.fLeafCount) {
            n = this.fLeafList[n3].getElemIndex();
            int n4 = 0;
            while (n4 < this.fElemMapSize) {
                if (this.fElemMap[n4] == n) break;
                ++n4;
            }
            if (n4 == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize++] = n;
            }
            ++n3;
        }
        n = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n];
        this.fFinalStateFlags = new boolean[n];
        this.fTransTable = new int[n][];
        CMStateSet cMStateSet = this.fHeadNode.firstPos();
        int n5 = 0;
        int n6 = 0;
        this.fTransTable[n6] = this.makeDefStateList();
        cMStateSetArray[n6] = cMStateSet;
        ++n6;
        while (n5 < n6) {
            cMStateSet = cMStateSetArray[n5];
            int[] nArray = this.fTransTable[n5];
            this.fFinalStateFlags[n5] = cMStateSet.getBit(this.fEOCPos);
            ++n5;
            CMStateSet cMStateSet2 = null;
            int n7 = 0;
            while (n7 < this.fElemMapSize) {
                if (cMStateSet2 == null) {
                    cMStateSet2 = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet2.zeroBits();
                }
                int n8 = 0;
                while (n8 < this.fLeafCount) {
                    if (cMStateSet.getBit(n8) && this.fLeafList[n8].getElemIndex() == this.fElemMap[n7]) {
                        cMStateSet2.union(this.fFollowList[n8]);
                    }
                    ++n8;
                }
                if (!cMStateSet2.isEmpty()) {
                    int n9 = 0;
                    while (n9 < n6) {
                        if (cMStateSetArray[n9].isSameSet(cMStateSet2)) break;
                        ++n9;
                    }
                    if (n9 == n6) {
                        cMStateSetArray[n6] = cMStateSet2;
                        this.fTransTable[n6] = this.makeDefStateList();
                        ++n6;
                        cMStateSet2 = null;
                    }
                    nArray[n7] = n9;
                    if (n6 == n) {
                        int n10 = (int)((double)n * 1.5);
                        CMStateSet[] cMStateSetArray2 = new CMStateSet[n10];
                        boolean[] blArray = new boolean[n10];
                        int[][] nArray2 = new int[n10][];
                        int n11 = 0;
                        while (n11 < n) {
                            cMStateSetArray2[n11] = cMStateSetArray[n11];
                            blArray[n11] = this.fFinalStateFlags[n11];
                            nArray2[n11] = this.fTransTable[n11];
                            ++n11;
                        }
                        n = n10;
                        cMStateSetArray = cMStateSetArray2;
                        this.fFinalStateFlags = blArray;
                        this.fTransTable = nArray2;
                    }
                }
                ++n7;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode cMNode) throws CMException {
        if (cMNode.type() == 4) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((CMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((CMBinOp)cMNode).getRight().firstPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet2);
                }
                ++n;
            }
        } else if (cMNode.type() == 2) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet3.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet);
                }
                ++n;
            }
        } else if (cMNode.type() == 3 || cMNode.type() == 1) {
            throw new CMException(10);
        }
    }

    private void dumpTree(CMNode cMNode, int n) throws CMException {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("   ");
            ++n2;
        }
        int n3 = cMNode.type();
        if (n3 == 4 || n3 == 5) {
            if (n3 == 4) {
                System.out.print("Choice Node ");
            } else {
                System.out.print("Seq Node ");
            }
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMBinOp)cMNode).getLeft(), n + 1);
            this.dumpTree(((CMBinOp)cMNode).getRight(), n + 1);
        } else if (cMNode.type() == 2) {
            System.out.print("Rep Node ");
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMUniOp)cMNode).getChild(), n + 1);
        } else if (cMNode.type() == 0) {
            System.out.print("Leaf: (pos=" + ((CMLeaf)cMNode).getPosition() + "), " + this.fStringPool.toString(((CMLeaf)cMNode).getElemIndex()) + "(elemIndex=" + ((CMLeaf)cMNode).getElemIndex() + ") ");
            if (cMNode.isNullable()) {
                System.out.print(" Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
        } else {
            throw new CMException(10);
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        int n = 0;
        while (n < this.fElemMapSize) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    private int postTreeBuildInit(CMNode cMNode, int n) throws CMException {
        cMNode.setMaxStates(this.fLeafCount);
        if (cMNode.type() == 4 || cMNode.type() == 5) {
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getLeft(), n);
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getRight(), n);
        } else if (cMNode.type() == 2) {
            n = this.postTreeBuildInit(((CMUniOp)cMNode).getChild(), n);
        } else if (cMNode.type() == 0) {
            if (((CMLeaf)cMNode).getElemIndex() != this.fEpsilonIndex) {
                this.fLeafList[n++] = (CMLeaf)cMNode;
            }
        } else {
            throw new CMException(10);
        }
        return n;
    }

    public int validateContent(int n, int[] nArray) throws CMException {
        if (n == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            int n5 = 0;
            while (n5 < this.fElemMapSize) {
                if (this.fElemMap[n5] == n4) break;
                ++n5;
            }
            if (n5 == this.fElemMapSize) {
                return n3;
            }
            if ((n2 = this.fTransTable[n2][n5]) == -1) {
                return n3;
            }
            ++n3;
        }
        if (!this.fFinalStateFlags[n2]) {
            return n;
        }
        return -1;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws CMException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < insertableElementsInfo.insertAt) {
            n2 = insertableElementsInfo.curChildren[n4];
            n = 0;
            while (n < this.fElemMapSize) {
                if (this.fElemMap[n] == n2) break;
                ++n;
            }
            if (n == this.fElemMapSize) {
                return n4;
            }
            if ((n3 = this.fTransTable[n3][n]) == -1) {
                return n4;
            }
            ++n4;
        }
        n2 = n3;
        insertableElementsInfo.canHoldPCData = false;
        insertableElementsInfo.isValidEOC = this.fFinalStateFlags[n2];
        insertableElementsInfo.resultsCount = this.fElemMapSize;
        if (insertableElementsInfo.results == null || insertableElementsInfo.results.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.results = new boolean[insertableElementsInfo.resultsCount];
        }
        if (insertableElementsInfo.possibleChildren == null || insertableElementsInfo.possibleChildren.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.possibleChildren = new int[insertableElementsInfo.resultsCount];
        }
        n = 0;
        while (n < this.fElemMapSize) {
            insertableElementsInfo.possibleChildren[n] = this.fElemMap[n];
            insertableElementsInfo.results[n] = this.fTransTable[n2][n] != -1;
            ++n;
        }
        if (bl) {
            int n5 = 0;
            while (n5 < insertableElementsInfo.resultsCount) {
                if (insertableElementsInfo.results[n5]) {
                    insertableElementsInfo.curChildren[insertableElementsInfo.insertAt] = insertableElementsInfo.possibleChildren[n5];
                    if (this.validateContent(insertableElementsInfo.childCount, insertableElementsInfo.curChildren) != -1) {
                        insertableElementsInfo.results[n5] = false;
                    }
                }
                ++n5;
            }
        }
        return -1;
    }
}

