/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.StringPool;

public class UTF8DataChunk
implements StringPool.StringProducer {
    public static final int CHUNK_SHIFT = 14;
    public static final int CHUNK_SIZE = 16384;
    public static final int CHUNK_MASK = 16383;
    private StringPool fStringPool;
    private int fRefCount;
    private int fChunk;
    private byte[] fData = null;
    private UTF8DataChunk fNextChunk;
    private UTF8DataChunk fPreviousChunk;
    private static UTF8DataChunk fgFreeChunks = null;
    private char[] fTempBuffer = null;
    static /* synthetic */ Class class$org$apache$xerces$utils$UTF8DataChunk;

    private UTF8DataChunk(StringPool stringPool, UTF8DataChunk uTF8DataChunk) {
        this.init(stringPool, uTF8DataChunk);
    }

    private final void addRef() {
        ++this.fRefCount;
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = n >> 14;
        if (n3 != this.fChunk) {
            if (this.fPreviousChunk == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 15, 0, null));
            }
            return this.fPreviousChunk.addString(n, n2);
        }
        int n4 = n + n2 - 1 >> 14;
        if (n3 == n4) {
            this.addRef();
            return this.fStringPool.addString(this, n & 0x3FFF, n2);
        }
        String string = this.toString(n & 0x3FFF, n2);
        return this.fStringPool.addString(string);
    }

    public int addSymbol(int n, int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        int n4 = n >> 14;
        if (n4 != this.fChunk) {
            if (this.fPreviousChunk == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 15, 0, null));
            }
            return this.fPreviousChunk.addSymbol(n, n2, n3);
        }
        int n5 = n + n2 - 1 >> 14;
        int n6 = n & 0x3FFF;
        if (n4 == n5) {
            int n7;
            if (n3 == 0) {
                n3 = this.getHashcode(n6, n2);
            }
            if ((n7 = this.fStringPool.lookupSymbol(this, n6, n2, n3)) == -1) {
                String string = this.toString(n6, n2);
                n7 = this.fStringPool.addNewSymbol(string, n3);
            }
            return n7;
        }
        String string = this.toString(n6, n2);
        return this.fStringPool.addSymbol(string);
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        UTF8DataChunk uTF8DataChunk = this.chunkFor(n);
        int n3 = n + n2;
        int n4 = n & 0x3FFF;
        byte[] byArray = uTF8DataChunk.fData;
        boolean bl = false;
        while (n < n3) {
            int n5;
            int n6;
            int n7;
            int n8 = byArray[n4++] & 0xFF;
            if (n4 == 16384 && ++n < n3) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n4 = 0;
            }
            if (n8 < 128) {
                if (bl) {
                    bl = false;
                    if (n8 == 10) continue;
                }
                if (n8 == 13) {
                    n8 = 10;
                    bl = true;
                }
                charBuffer.append((char)n8);
                continue;
            }
            int n9 = byArray[n4++] & 0xFF;
            if (n4 == 16384 && ++n < n3) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n4 = 0;
            }
            if ((0xE0 & n8) == 192) {
                n7 = ((0x1F & n8) << 6) + (0x3F & n9);
                charBuffer.append((char)n7);
                continue;
            }
            n7 = byArray[n4++] & 0xFF;
            if (n4 == 16384 && ++n < n3) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n4 = 0;
            }
            if ((0xF0 & n8) == 224) {
                n6 = ((0xF & n8) << 12) + ((0x3F & n9) << 6) + (0x3F & n7);
                charBuffer.append((char)n6);
                continue;
            }
            n6 = byArray[n4++] & 0xFF;
            if (n4 == 16384 && ++n < n3) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n4 = 0;
            }
            if ((n5 = ((0xF & n8) << 18) + ((0x3F & n9) << 12) + ((0x3F & n7) << 6) + (0x3F & n6)) < 65536) {
                charBuffer.append((char)n5);
                continue;
            }
            charBuffer.append((char)((n5 - 65536 >> 10) + 55296));
            charBuffer.append((char)((n5 - 65536 & 0x3FF) + 56320));
        }
    }

    private final UTF8DataChunk chunkFor(int n) {
        if (n >> 14 == this.fChunk) {
            return this;
        }
        return this.slowChunkFor(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean clearPreviousChunk() {
        if (this.fPreviousChunk != null) {
            this.fPreviousChunk.setNextChunk(null);
            this.fPreviousChunk.removeRef();
            this.fPreviousChunk = null;
            return true;
        }
        return this.fChunk == 0;
    }

    public static UTF8DataChunk createChunk(StringPool stringPool, UTF8DataChunk uTF8DataChunk) {
        Class clazz = class$org$apache$xerces$utils$UTF8DataChunk != null ? class$org$apache$xerces$utils$UTF8DataChunk : (class$org$apache$xerces$utils$UTF8DataChunk = UTF8DataChunk.class$("org.apache.xerces.utils.UTF8DataChunk"));
        synchronized (clazz) {
            if (fgFreeChunks != null) {
                UTF8DataChunk uTF8DataChunk2 = fgFreeChunks;
                fgFreeChunks = uTF8DataChunk2.fNextChunk;
                uTF8DataChunk2.fNextChunk = null;
                uTF8DataChunk2.init(stringPool, uTF8DataChunk);
                UTF8DataChunk uTF8DataChunk3 = uTF8DataChunk2;
                Object var4_6 = null;
                return uTF8DataChunk3;
            }
        }
        UTF8DataChunk uTF8DataChunk4 = new UTF8DataChunk(stringPool, uTF8DataChunk);
        return uTF8DataChunk4;
    }

    public boolean equalsString(int n, int n2, char[] cArray, int n3, int n4) {
        UTF8DataChunk uTF8DataChunk = this;
        int n5 = n + n2;
        int n6 = n & 0x3FFF;
        byte[] byArray = this.fData;
        boolean bl = false;
        while (n < n5) {
            int n7;
            int n8;
            int n9;
            if (n4-- == 0) {
                return false;
            }
            int n10 = byArray[n6++] & 0xFF;
            if (n6 == 16384 && ++n < n5) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n6 = 0;
            }
            if (n10 < 128) {
                if (bl) {
                    bl = false;
                    if (n10 == 10) continue;
                }
                if (n10 == 13) {
                    n10 = 10;
                    bl = true;
                }
                if (n10 == cArray[n3++]) continue;
                return false;
            }
            int n11 = byArray[n6++] & 0xFF;
            if (n6 == 16384 && ++n < n5) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n6 = 0;
            }
            if ((0xE0 & n10) == 192) {
                n9 = ((0x1F & n10) << 6) + (0x3F & n11);
                if (n9 == cArray[n3++]) continue;
                return false;
            }
            n9 = byArray[n6++] & 0xFF;
            if (n6 == 16384 && ++n < n5) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n6 = 0;
            }
            if ((0xF0 & n10) == 224) {
                n8 = ((0xF & n10) << 12) + ((0x3F & n11) << 6) + (0x3F & n9);
                if (n8 == cArray[n3++]) continue;
                return false;
            }
            n8 = byArray[n6++] & 0xFF;
            if (n6 == 16384 && ++n < n5) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n6 = 0;
            }
            if ((n7 = ((0xF & n10) << 18) + ((0x3F & n11) << 12) + ((0x3F & n9) << 6) + (0x3F & n8)) < 65536) {
                if (n7 == cArray[n3++]) continue;
                return false;
            }
            if ((n7 - 65536 >> 10) + 55296 != cArray[n3++]) {
                return false;
            }
            if (n4-- == 0) {
                return false;
            }
            if ((n7 - 65536 & 0x3FF) + 56320 == cArray[n3++]) continue;
            return false;
        }
        return n4 == 0;
    }

    private int getHashcode(int n, int n2) {
        int n3 = n + n2;
        int n4 = 0;
        byte[] byArray = this.fData;
        while (n < n3) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (((n8 = byArray[n++] & 0xFF) & 0x80) == 0) {
                n4 = StringHasher.hashChar(n4, n8);
                continue;
            }
            int n9 = byArray[n++] & 0xFF;
            if ((0xE0 & n8) == 192) {
                n7 = ((0x1F & n8) << 6) + (0x3F & n9);
                n4 = StringHasher.hashChar(n4, n7);
                continue;
            }
            n7 = byArray[n++] & 0xFF;
            if ((0xF0 & n8) == 224) {
                n6 = ((0xF & n8) << 12) + ((0x3F & n9) << 6) + (0x3F & n7);
                n4 = StringHasher.hashChar(n4, n6);
                continue;
            }
            if ((n5 = ((0xF & n8) << 18) + ((0x3F & n9) << 12) + ((0x3F & n7) << 6) + (0x3F & (n6 = byArray[n++] & 0xFF))) < 65536) {
                n4 = StringHasher.hashChar(n4, n5);
                continue;
            }
            n4 = StringHasher.hashChar(n4, (n5 - 65536 >> 10) + 55296);
            n4 = StringHasher.hashChar(n4, (n5 - 65536 & 0x3FF) + 56320);
        }
        return StringHasher.finishHash(n4);
    }

    private void init(StringPool stringPool, UTF8DataChunk uTF8DataChunk) {
        this.fStringPool = stringPool;
        this.fRefCount = 1;
        this.fChunk = uTF8DataChunk == null ? 0 : uTF8DataChunk.fChunk + 1;
        this.fNextChunk = null;
        this.fPreviousChunk = uTF8DataChunk;
        if (uTF8DataChunk != null) {
            uTF8DataChunk.addRef();
            uTF8DataChunk.setNextChunk(this);
            uTF8DataChunk.removeRef();
        }
    }

    public UTF8DataChunk nextChunk() {
        return this.fNextChunk;
    }

    public void releaseChunk() {
        this.removeRef();
    }

    public void releaseString(int n, int n2) {
        this.removeRef();
    }

    private final void removeRef() {
        --this.fRefCount;
        if (this.fRefCount == 0) {
            this.fStringPool = null;
            this.fChunk = -1;
            this.fPreviousChunk = null;
            Class clazz = class$org$apache$xerces$utils$UTF8DataChunk != null ? class$org$apache$xerces$utils$UTF8DataChunk : (class$org$apache$xerces$utils$UTF8DataChunk = UTF8DataChunk.class$("org.apache.xerces.utils.UTF8DataChunk"));
            synchronized (clazz) {
                this.fNextChunk = null;
                fgFreeChunks = this;
            }
        }
    }

    public void setByteArray(byte[] byArray) {
        this.fData = byArray;
    }

    private void setNextChunk(UTF8DataChunk uTF8DataChunk) {
        if (uTF8DataChunk == null) {
            if (this.fNextChunk != null) {
                this.fNextChunk.removeRef();
            }
        } else if (this.fNextChunk == null) {
            uTF8DataChunk.addRef();
        } else {
            throw new RuntimeException("UTF8DataChunk::setNextChunk");
        }
        this.fNextChunk = uTF8DataChunk;
    }

    private UTF8DataChunk slowChunkFor(int n) {
        int n2 = n >> 14;
        UTF8DataChunk uTF8DataChunk = this;
        while (n2 != uTF8DataChunk.fChunk) {
            uTF8DataChunk = uTF8DataChunk.fPreviousChunk;
        }
        return uTF8DataChunk;
    }

    public final byte[] toByteArray() {
        return this.fData;
    }

    public String toString(int n, int n2) {
        int n3 = 0;
        UTF8DataChunk uTF8DataChunk = this;
        int n4 = n + n2;
        int n5 = n & 0x3FFF;
        byte[] byArray = this.fData;
        boolean bl = false;
        while (n < n4) {
            char[] cArray;
            int n6;
            int n7;
            int n8 = byArray[n5++] & 0xFF;
            if (n5 == 16384 && ++n < n4) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n5 = 0;
            }
            if (n8 < 128) {
                if (bl) {
                    bl = false;
                    if (n8 == 10) continue;
                }
                if (n8 == 13) {
                    n8 = 10;
                    bl = true;
                }
                try {
                    this.fTempBuffer[n3] = (char)n8;
                    ++n3;
                }
                catch (NullPointerException nullPointerException) {
                    this.fTempBuffer = new char[16384];
                    this.fTempBuffer[n3++] = (char)n8;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    char[] cArray2 = new char[n3 * 2];
                    System.arraycopy(this.fTempBuffer, 0, cArray2, 0, n3);
                    this.fTempBuffer = cArray2;
                    this.fTempBuffer[n3++] = (char)n8;
                }
                continue;
            }
            int n9 = byArray[n5++] & 0xFF;
            if (n5 == 16384 && ++n < n4) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n5 = 0;
            }
            if ((0xE0 & n8) == 192) {
                n7 = ((0x1F & n8) << 6) + (0x3F & n9);
                try {
                    this.fTempBuffer[n3] = (char)n7;
                    ++n3;
                }
                catch (NullPointerException nullPointerException) {
                    this.fTempBuffer = new char[16384];
                    this.fTempBuffer[n3++] = (char)n7;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    char[] cArray3 = new char[n3 * 2];
                    System.arraycopy(this.fTempBuffer, 0, cArray3, 0, n3);
                    this.fTempBuffer = cArray3;
                    this.fTempBuffer[n3++] = (char)n7;
                }
                continue;
            }
            n7 = byArray[n5++] & 0xFF;
            if (n5 == 16384 && ++n < n4) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n5 = 0;
            }
            if ((0xF0 & n8) == 224) {
                int n10 = ((0xF & n8) << 12) + ((0x3F & n9) << 6) + (0x3F & n7);
                try {
                    this.fTempBuffer[n3] = (char)n10;
                    ++n3;
                }
                catch (NullPointerException nullPointerException) {
                    this.fTempBuffer = new char[16384];
                    this.fTempBuffer[n3++] = (char)n10;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    char[] cArray4 = new char[n3 * 2];
                    System.arraycopy(this.fTempBuffer, 0, cArray4, 0, n3);
                    this.fTempBuffer = cArray4;
                    this.fTempBuffer[n3++] = (char)n10;
                }
                continue;
            }
            int n11 = byArray[n5++] & 0xFF;
            if (n5 == 16384 && ++n < n4) {
                uTF8DataChunk = uTF8DataChunk.fNextChunk;
                byArray = uTF8DataChunk.fData;
                n5 = 0;
            }
            if ((n6 = ((0xF & n8) << 18) + ((0x3F & n9) << 12) + ((0x3F & n7) << 6) + (0x3F & n11)) < 65536) {
                try {
                    this.fTempBuffer[n3] = (char)n6;
                    ++n3;
                }
                catch (NullPointerException nullPointerException) {
                    this.fTempBuffer = new char[16384];
                    this.fTempBuffer[n3++] = (char)n6;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    char[] cArray5 = new char[n3 * 2];
                    System.arraycopy(this.fTempBuffer, 0, cArray5, 0, n3);
                    this.fTempBuffer = cArray5;
                    this.fTempBuffer[n3++] = (char)n6;
                }
                continue;
            }
            char c = (char)((n6 - 65536 >> 10) + 55296);
            char c2 = (char)((n6 - 65536 & 0x3FF) + 56320);
            try {
                this.fTempBuffer[n3] = c;
                ++n3;
            }
            catch (NullPointerException nullPointerException) {
                this.fTempBuffer = new char[16384];
                this.fTempBuffer[n3++] = c;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                cArray = new char[n3 * 2];
                System.arraycopy(this.fTempBuffer, 0, cArray, 0, n3);
                this.fTempBuffer = cArray;
                this.fTempBuffer[n3++] = c;
            }
            try {
                this.fTempBuffer[n3] = c2;
                ++n3;
            }
            catch (NullPointerException nullPointerException) {
                this.fTempBuffer = new char[16384];
                this.fTempBuffer[n3++] = c2;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                cArray = new char[n3 * 2];
                System.arraycopy(this.fTempBuffer, 0, cArray, 0, n3);
                this.fTempBuffer = cArray;
                this.fTempBuffer[n3++] = c2;
            }
        }
        return new String(this.fTempBuffer, 0, n3);
    }
}

