/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.Reader;
import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.CharDataChunk;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;

public class StreamingCharReader
extends XMLEntityReader {
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    private StringPool fStringPool = null;
    private boolean fCallClearPreviousChunk = true;
    private Vector fDeferredErrors = null;
    private boolean seenCR = false;
    private int oweChar = -1;
    private char[] inBuffer = new char[2];
    protected Reader fCharacterStream = null;
    protected CharDataChunk fCurrentChunk = null;
    protected int fCurrentIndex = 0;
    protected int fFillIndex = 0;
    protected char[] fMostRecentData = null;
    protected int fMostRecentChar = 0;
    protected int fLength = 0;

    public StreamingCharReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, Reader reader, StringPool stringPool) throws Exception {
        super(xMLEntityHandler, xMLErrorReporter, bl);
        this.fStringPool = stringPool;
        this.fCharacterStream = reader;
        this.fCurrentChunk = CharDataChunk.createChunk(this.fStringPool, null);
        this.loadFirstChar();
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, 0);
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        this.fCurrentChunk.append(charBuffer, n, n2);
    }

    private boolean atEOF(int n) {
        return n > this.fLength;
    }

    private void callCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = n2 - n;
        if (!this.fSendCharDataAsCharArray) {
            int n4 = this.addString(n, n3);
            if (bl) {
                this.fEntityHandler.processWhitespace(n4);
            } else {
                this.fEntityHandler.processCharacters(n4);
            }
            return;
        }
        CharDataChunk charDataChunk = this.fCurrentChunk.chunkFor(n);
        int n5 = n & 0x3FFF;
        if (n5 + n3 <= 16384) {
            if (n3 != 0) {
                if (bl) {
                    this.fEntityHandler.processWhitespace(charDataChunk.toCharArray(), n5, n3);
                } else {
                    this.fEntityHandler.processCharacters(charDataChunk.toCharArray(), n5, n3);
                }
            }
            return;
        }
        int n6 = n3;
        int n7 = 16384 - n5;
        if (bl) {
            this.fEntityHandler.processWhitespace(charDataChunk.toCharArray(), n5, n7);
        } else {
            this.fEntityHandler.processCharacters(charDataChunk.toCharArray(), n5, n7);
        }
        n6 -= n7;
        do {
            if ((charDataChunk = charDataChunk.nextChunk()) == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 14, 0, null));
            }
            int n8 = n7 = n6 <= 16384 ? n6 : 16384;
            if (bl) {
                this.fEntityHandler.processWhitespace(charDataChunk.toCharArray(), 0, n7);
                continue;
            }
            this.fEntityHandler.processCharacters(charDataChunk.toCharArray(), 0, n7);
        } while ((n6 -= n7) > 0);
    }

    protected XMLEntityHandler.EntityReader changeReaders() throws Exception {
        XMLEntityHandler.EntityReader entityReader = super.changeReaders();
        this.fCurrentChunk.releaseChunk();
        this.fCurrentChunk = null;
        return entityReader;
    }

    protected void deferException(int n, Object[] objectArray, int n2) {
        if (this.fDeferredErrors == null) {
            this.fDeferredErrors = new Vector();
        }
        DeferredError deferredError = new DeferredError(n, objectArray, n2);
        this.fDeferredErrors.addElement(deferredError);
    }

    private void loadFirstChar() throws Exception {
        this.fMostRecentData = this.fCurrentChunk.toCharArray();
        if (this.fMostRecentData == null) {
            this.fMostRecentData = new char[16384];
            this.fCurrentChunk.setCharArray(this.fMostRecentData);
        }
        this.loadMoreChars();
    }

    /*
     * Exception decompiling
     */
    private int loadMoreChars() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int loadNextChar() throws Exception {
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            return this.slowLoadNextChar();
        }
        if (this.fCurrentIndex < this.fFillIndex) {
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
            return this.fMostRecentChar;
        }
        return this.loadMoreChars();
    }

    public boolean lookingAtChar(char c, boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n != c) {
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtChar(c, bl);
            }
            return false;
        }
        if (bl) {
            ++this.fCharacterCounter;
            this.loadNextChar();
        }
        return true;
    }

    public boolean lookingAtSpace(boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n > 32) {
            return false;
        }
        if (n == 32 || n == 9) {
            if (!bl) {
                return true;
            }
            ++this.fCharacterCounter;
        } else if (n == 10) {
            if (!bl) {
                return true;
            }
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else {
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtSpace(bl);
            }
            return false;
        }
        this.loadNextChar();
        return true;
    }

    public boolean lookingAtValidChar(boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 55296) {
            if (n >= 32 || n == 9) {
                if (bl) {
                    ++this.fCharacterCounter;
                    this.loadNextChar();
                }
                return true;
            }
            if (n == 10) {
                if (bl) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    this.loadNextChar();
                }
                return true;
            }
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtValidChar(bl);
            }
            return false;
        }
        if (n > 65533) {
            return false;
        }
        if (n < 56320) {
            boolean bl2;
            CharDataChunk charDataChunk = this.fCurrentChunk;
            int n2 = this.fCurrentIndex;
            int n3 = this.fCurrentOffset;
            n = this.loadNextChar();
            boolean bl3 = bl2 = n >= 56320 && n < 57344;
            if (!bl2 || !bl) {
                this.fCurrentChunk = charDataChunk;
                this.fCurrentIndex = n2;
                this.fCurrentOffset = n3;
                this.fMostRecentData = charDataChunk.toCharArray();
                this.fMostRecentChar = this.fMostRecentData[n2] & 0xFFFF;
                return bl2;
            }
        } else if (n < 57344) {
            return false;
        }
        if (bl) {
            ++this.fCharacterCounter;
            this.loadNextChar();
        }
        return true;
    }

    private int recognizeMarkup(int n) throws Exception {
        switch (n) {
            case 0: {
                return 11;
            }
            case 63: {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return 0;
            }
            case 33: {
                ++this.fCharacterCounter;
                n = this.loadNextChar();
                if (n == 0) {
                    --this.fCharacterCounter;
                    --this.fCurrentOffset;
                    return 11;
                }
                if (n == 45) {
                    ++this.fCharacterCounter;
                    n = this.loadNextChar();
                    if (n == 0) {
                        this.fCharacterCounter -= 2;
                        this.fCurrentOffset -= 2;
                        return 11;
                    }
                    if (n != 45) break;
                    ++this.fCharacterCounter;
                    this.loadNextChar();
                    return 1;
                }
                if (n != 91) break;
                int n2 = 0;
                while (n2 < 6) {
                    ++this.fCharacterCounter;
                    n = this.loadNextChar();
                    if (n == 0) {
                        this.fCharacterCounter -= 2 + n2;
                        this.fCurrentOffset -= 2 + n2;
                        return 11;
                    }
                    if (n != cdata_string[n2]) {
                        return 10;
                    }
                    ++n2;
                }
                ++this.fCharacterCounter;
                this.loadNextChar();
                return 2;
            }
            case 47: {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return 4;
            }
            default: {
                return 6;
            }
        }
        return 10;
    }

    private int recognizeReference(int n) throws Exception {
        if (n == 0) {
            return 12;
        }
        if (n == 35) {
            ++this.fCharacterCounter;
            this.loadNextChar();
            return 7;
        }
        return 8;
    }

    public int scanAttValue(char c, boolean bl) throws Exception {
        int n = this.fCurrentOffset;
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtChar(' ', true)) continue;
            if (this.lookingAtSpace(false)) {
                return -1;
            }
            if (this.lookingAtChar('&', false)) {
                return -1;
            }
            if (this.lookingAtChar('<', false)) {
                return -2;
            }
            if (this.lookingAtValidChar(true)) continue;
            return -3;
        }
        int n2 = bl ? this.addSymbol(n, this.fCurrentOffset - n) : this.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    public int scanCharRef(boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanCharRef(bl);
            }
            return -2;
        }
        int n2 = 0;
        if (bl) {
            if (n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0) {
                return -2;
            }
            n2 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
        } else {
            if (n < 48 || n > 57) {
                return -2;
            }
            n2 = n - 48;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        boolean bl2 = false;
        while ((n = this.fMostRecentChar) != 0 && !(bl ? n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0 : n < 48 || n > 57)) {
            int n3;
            ++this.fCharacterCounter;
            this.loadNextChar();
            if (bl) {
                n3 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
                n2 = (n2 << 4) + n3;
            } else {
                n3 = n - 48;
                n2 = n2 * 10 + n3;
            }
            if (n2 <= 0x10FFFF) continue;
            bl2 = true;
            n2 = 0;
        }
        if (n != 59) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        if (bl2) {
            return -3;
        }
        return n2;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public int scanContent(int var1_1) throws Exception {
        block41: {
            if (this.fCallClearPreviousChunk && this.fCurrentChunk.clearPreviousChunk()) {
                this.fCallClearPreviousChunk = false;
            }
            var2_2 = this.fCurrentOffset;
            var3_3 = this.fMostRecentChar;
            if (var3_3 >= 128) ** GOTO lbl47
            switch (XMLCharacterProperties.fgAsciiWSCharData[var3_3]) {
                case 0: {
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextChar();
                    ** break;
                }
                case 1: {
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextChar();
                    if (this.fInCDSect) ** break;
                    return this.recognizeMarkup(var3_3);
                }
                case 2: {
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextChar();
                    if (this.fInCDSect) ** break;
                    return this.recognizeReference(var3_3);
                }
                case 3: {
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextChar();
                    if (var3_3 != 93) ** break;
                    var4_4 = this.fCurrentChunk;
                    var5_7 = this.fCurrentIndex;
                    var6_10 = this.fCurrentOffset;
                    if (this.loadNextChar() == 62) {
                        this.loadNextChar();
                        this.fCharacterCounter += 2;
                        return 3;
                    }
                    this.fCurrentChunk = var4_4;
                    this.fCurrentIndex = var5_7;
                    this.fCurrentOffset = var6_10;
                    this.fMostRecentData = var4_4.toCharArray();
                    this.fMostRecentChar = 93;
                    ** break;
                }
                case 4: {
                    if (var3_3 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                        this.changeReaders();
                        return 9;
                    }
                    return 9;
                }
                case 5: {
                    break;
                }
lbl47:
                // 1 sources

                if (this.skipMultiByteCharData(var3_3)) ** break;
                return 9;
                default: {
                    break block41;
                }
            }
            do {
                if (var3_3 == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    continue;
                }
                ++this.fCharacterCounter;
            } while ((var3_3 = this.loadNextChar()) == 32 || var3_3 == 9 || var3_3 == 10);
            if (var3_3 >= 128) ** GOTO lbl111
            switch (XMLCharacterProperties.fgAsciiCharData[var3_3]) {
                case 0: {
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextChar();
                    break;
                }
                case 1: {
                    if (!this.fInCDSect) {
                        this.callCharDataHandler(var2_2, this.fCurrentOffset, true);
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextChar();
                        return this.recognizeMarkup(var3_3);
                    }
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextChar();
                    break;
                }
                case 2: {
                    if (!this.fInCDSect) {
                        this.callCharDataHandler(var2_2, this.fCurrentOffset, true);
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextChar();
                        return this.recognizeReference(var3_3);
                    }
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextChar();
                    break;
                }
                case 3: {
                    var4_5 = this.fCurrentOffset;
                    var3_3 = this.loadNextChar();
                    if (var3_3 != 93) {
                        ++this.fCharacterCounter;
                        break;
                    }
                    var5_8 = this.fCurrentChunk;
                    var6_10 = this.fCurrentIndex;
                    var7_11 = this.fCurrentOffset;
                    if (this.loadNextChar() == 62) {
                        this.loadNextChar();
                        this.callCharDataHandler(var2_2, var4_5, true);
                        this.fCharacterCounter += 3;
                        return 3;
                    }
                    this.fCurrentChunk = var5_8;
                    this.fCurrentIndex = var6_10;
                    this.fCurrentOffset = var7_11;
                    this.fMostRecentData = var5_8.toCharArray();
                    this.fMostRecentChar = 93;
                    ++this.fCharacterCounter;
                    break;
                }
                case 4: {
                    this.callCharDataHandler(var2_2, this.fCurrentOffset, true);
                    if (var3_3 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                        this.changeReaders();
                        return 9;
                    }
                    return 9;
                }
lbl111:
                // 1 sources

                if (this.skipMultiByteCharData(var3_3)) break;
                this.callCharDataHandler(var2_2, this.fCurrentOffset, true);
                return 9;
            }
        }
        var3_3 = this.skipAsciiCharData();
        while (true) {
            if (var3_3 < 128) {
                switch (XMLCharacterProperties.fgAsciiCharData[var3_3]) {
                    case 0: {
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextChar();
                        break;
                    }
                    case 1: {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(var2_2, this.fCurrentOffset, false);
                            ++this.fCharacterCounter;
                            var3_3 = this.loadNextChar();
                            return this.recognizeMarkup(var3_3);
                        }
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextChar();
                        break;
                    }
                    case 2: {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(var2_2, this.fCurrentOffset, false);
                            ++this.fCharacterCounter;
                            var3_3 = this.loadNextChar();
                            return this.recognizeReference(var3_3);
                        }
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextChar();
                        break;
                    }
                    case 3: {
                        var4_6 = this.fCurrentOffset;
                        var3_3 = this.loadNextChar();
                        if (var3_3 != 93) {
                            ++this.fCharacterCounter;
                            break;
                        }
                        var5_9 = this.fCurrentChunk;
                        var6_10 = this.fCurrentIndex;
                        var7_11 = this.fCurrentOffset;
                        if (this.loadNextChar() == 62) {
                            this.loadNextChar();
                            this.callCharDataHandler(var2_2, var4_6, false);
                            this.fCharacterCounter += 3;
                            return 3;
                        }
                        this.fCurrentChunk = var5_9;
                        this.fCurrentIndex = var6_10;
                        this.fCurrentOffset = var7_11;
                        this.fMostRecentData = var5_9.toCharArray();
                        this.fMostRecentChar = 93;
                        ++this.fCharacterCounter;
                        break;
                    }
                    case 4: {
                        if (var3_3 == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            var3_3 = this.loadNextChar();
                            break;
                        }
                        this.callCharDataHandler(var2_2, this.fCurrentOffset, false);
                        if (var3_3 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                            this.changeReaders();
                            return 9;
                        }
                        return 9;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(var3_3)) {
                this.callCharDataHandler(var2_2, this.fCurrentOffset, false);
                return 9;
            }
            var3_3 = this.fMostRecentChar;
        }
    }

    public int scanEntityValue(int n, boolean bl) throws Exception {
        int n2;
        block5: {
            n2 = this.fCurrentOffset;
            do {
                if (this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders();
                    return -5;
                }
                if (n != -1 && this.lookingAtChar((char)n, false)) {
                    if (!bl) {
                        return -1;
                    }
                    break block5;
                }
                if (this.lookingAtChar('&', false)) {
                    return -2;
                }
                if (!this.lookingAtChar('%', false)) continue;
                return -3;
            } while (this.lookingAtValidChar(true));
            return -4;
        }
        int n3 = this.addString(n2, this.fCurrentOffset - n2);
        this.lookingAtChar((char)n, true);
        return n3;
    }

    public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) throws Exception {
        char[] cArray = charArrayRange.chars;
        int n = charArrayRange.offset;
        int n2 = charArrayRange.length;
        int n3 = this.fMostRecentChar;
        int n4 = 0;
        while (n4 < n2) {
            if (n3 != cArray[n++]) {
                this.skipPastNmtoken(c);
                return false;
            }
            ++this.fCharacterCounter;
            n3 = this.loadNextChar();
            ++n4;
        }
        if (n3 == c) {
            return true;
        }
        if (n3 < 128 ? XMLCharacterProperties.fgAsciiNameChar[n3] == 0 : (XMLCharacterProperties.fgCharFlags[n3] & 4) == 0) {
            return true;
        }
        this.skipPastNmtoken(c);
        return false;
    }

    public int scanInvalidChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextChar();
        } else if (n == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanInvalidChar();
            }
            if (this.fDeferredErrors != null) {
                int n2 = 0;
                while (n2 < this.fDeferredErrors.size()) {
                    DeferredError deferredError = (DeferredError)this.fDeferredErrors.elementAt(n2);
                    if (deferredError.offset == this.fCurrentIndex) {
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", deferredError.errorCode, 0, deferredError.args, 2);
                        this.fDeferredErrors.removeElementAt(n2);
                        ++this.fCharacterCounter;
                        this.loadNextChar();
                        return -1;
                    }
                    ++n2;
                }
            }
            ++this.fCharacterCounter;
            this.loadNextChar();
        } else {
            ++this.fCharacterCounter;
            if (n >= 55296 && n < 56320) {
                int n3 = this.loadNextChar();
                if (n3 >= 56320 && n3 < 57344) {
                    n = (n - 55296 << 10) + (n3 - 56320) + 65536;
                    this.loadNextChar();
                }
            } else {
                this.loadNextChar();
            }
        }
        return n;
    }

    public int scanName(char c) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 128 ? XMLCharacterProperties.fgAsciiInitialNameChar[n] == 0 : (XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
            return -1;
        }
        int n2 = this.fCurrentOffset;
        ++this.fCharacterCounter;
        int n3 = 0;
        while (true) {
            n3 = StringHasher.hashChar(n3, n);
            n = this.loadNextChar();
            if (c == n || (n < 128 ? XMLCharacterProperties.fgAsciiNameChar[n] == 0 : (XMLCharacterProperties.fgCharFlags[n] & 4) == 0)) break;
            ++this.fCharacterCounter;
        }
        n3 = StringHasher.finishHash(n3);
        int n4 = this.fCurrentOffset - n2;
        int n5 = this.fCurrentChunk.addSymbol(n2, n4, n3);
        return n5;
    }

    public int scanQName(char c) throws Exception {
        int n;
        int n2;
        int n3;
        int n4 = this.fMostRecentChar;
        if (n4 < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[n4] == 0) {
                return -1;
            }
            if (n4 == 58) {
                return -1;
            }
        } else if ((XMLCharacterProperties.fgCharFlags[n4] & 2) == 0) {
            return -1;
        }
        int n5 = this.fCurrentOffset;
        ++this.fCharacterCounter;
        int n6 = 0;
        int n7 = -1;
        while (true) {
            n6 = StringHasher.hashChar(n6, n4);
            n4 = this.loadNextChar();
            if (c == n4) break;
            if (n4 < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[n4] == 0) break;
                if (n4 == 58) {
                    if (n7 != -1) break;
                    n7 = this.fCurrentOffset;
                    CharDataChunk charDataChunk = this.fCurrentChunk;
                    n3 = this.fCurrentOffset;
                    n2 = this.fCurrentIndex;
                    n4 = this.loadNextChar();
                    this.fCurrentChunk = charDataChunk;
                    this.fCurrentOffset = n3;
                    this.fCurrentIndex = n2;
                    this.fMostRecentData = charDataChunk.toCharArray();
                    n = 1;
                    if (n4 < 128) {
                        if (XMLCharacterProperties.fgAsciiInitialNameChar[n4] == 0 || n4 == 58) {
                            n = 0;
                        }
                    } else if ((XMLCharacterProperties.fgCharFlags[n4] & 2) == 0) {
                        n = 0;
                    }
                    n4 = 58;
                    if (n == 0) {
                        n7 = -1;
                        this.fMostRecentChar = n4;
                        break;
                    }
                }
            } else if ((XMLCharacterProperties.fgCharFlags[n4] & 4) == 0) break;
            ++this.fCharacterCounter;
        }
        n6 = StringHasher.finishHash(n6);
        int n8 = this.fCurrentOffset - n5;
        n3 = this.fCurrentChunk.addSymbol(n5, n8, n6);
        n2 = n7 == -1 ? -1 : this.addSymbol(n5, n7 - n5);
        n = n7 == -1 ? n3 : this.addSymbol(n7 + 1, this.fCurrentOffset - (n7 + 1));
        return this.fStringPool.addQName(n3, n2, n);
    }

    public int scanStringLiteral() throws Exception {
        boolean bl = this.lookingAtChar('\'', true);
        if (!bl && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int n = this.fCurrentOffset;
        char c = bl ? (char)'\'' : '\"';
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int n2 = this.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    private int skipAsciiCharData() throws Exception {
        int n = this.fMostRecentChar;
        while (n < 128) {
            if (XMLCharacterProperties.fgAsciiCharData[n] == 0) {
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else {
                return n;
            }
            n = this.loadNextChar();
        }
        return n;
    }

    private boolean skipMultiByteCharData(int n) throws Exception {
        if (n < 55296) {
            this.loadNextChar();
            return true;
        }
        if (n > 65533) {
            return false;
        }
        if (n >= 56320 && n < 57344) {
            return false;
        }
        if (n >= 55296 && n < 56320) {
            CharDataChunk charDataChunk = this.fCurrentChunk;
            int n2 = this.fCurrentIndex;
            int n3 = this.fCurrentOffset;
            n = this.loadNextChar();
            if (n < 56320 || n >= 57344) {
                this.fCurrentChunk = charDataChunk;
                this.fCurrentIndex = n2;
                this.fCurrentOffset = n3;
                this.fMostRecentData = charDataChunk.toCharArray();
                this.fMostRecentChar = this.fMostRecentData[n2] & 0xFFFF;
                return false;
            }
        }
        this.loadNextChar();
        return true;
    }

    public void skipPastName(char c) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 128 ? XMLCharacterProperties.fgAsciiInitialNameChar[n] == 0 : (XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
            return;
        }
        do {
            ++this.fCharacterCounter;
            n = this.loadNextChar();
            if (c != n) continue;
            return;
        } while (!(n < 128 ? XMLCharacterProperties.fgAsciiNameChar[n] == 0 : (XMLCharacterProperties.fgCharFlags[n] & 4) == 0));
    }

    public void skipPastNmtoken(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (c != n) {
            if (n < 128 ? XMLCharacterProperties.fgAsciiNameChar[n] == 0 : (XMLCharacterProperties.fgCharFlags[n] & 4) == 0) {
                return;
            }
            ++this.fCharacterCounter;
            n = this.loadNextChar();
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int n = this.fMostRecentChar;
        while (true) {
            if (n == 32 || n == 9) {
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else {
                if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipPastSpaces();
                }
                return;
            }
            n = this.loadNextChar();
        }
    }

    public void skipToChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (n != c) {
            if (n == 0) {
                if (this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipToChar(c);
                    return;
                }
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n >= 55296 && n < 56320) {
                ++this.fCharacterCounter;
                n = this.loadNextChar();
                if (n < 56320 || n >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            n = this.loadNextChar();
        }
        return;
    }

    public boolean skippedString(char[] cArray) throws Exception {
        int n = this.fMostRecentChar;
        if (n != cArray[0]) {
            return false;
        }
        int n2 = cArray.length;
        CharDataChunk charDataChunk = this.fCurrentChunk;
        int n3 = this.fCurrentOffset;
        int n4 = this.fCurrentIndex;
        n = this.loadNextChar();
        int n5 = 1;
        while (n5 < n2) {
            if (n != cArray[n5]) {
                this.fCurrentChunk = charDataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = charDataChunk.toCharArray();
                this.fMostRecentChar = this.fMostRecentData[n4] & 0xFFFF;
                return false;
            }
            n = this.loadNextChar();
            ++n5;
        }
        this.fCharacterCounter += n2;
        return true;
    }

    private int slowLoadNextChar() throws Exception {
        this.fCallClearPreviousChunk = true;
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toCharArray();
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
            return this.fMostRecentChar;
        }
        this.fCurrentChunk = CharDataChunk.createChunk(this.fStringPool, this.fCurrentChunk);
        this.fCurrentIndex = 0;
        this.fFillIndex = 0;
        this.loadFirstChar();
        return this.fMostRecentChar;
    }

    private class DeferredError {
        int errorCode;
        Object[] args;
        int offset;

        DeferredError(int n, Object[] objectArray, int n2) {
            this.errorCode = n;
            this.args = objectArray;
            this.offset = n2;
        }
    }
}

