/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpecNode;
import org.apache.xerces.framework.XMLParser;
import org.apache.xerces.framework.XMLValidator;
import org.apache.xerces.validators.schema.XUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DOMParser
extends XMLParser {
    public static final String DEFAULT_DOCUMENT_CLASS_NAME = "org.apache.xerces.dom.DocumentImpl";
    private static final boolean DEBUG_ATTLIST_DECL = false;
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/dom/defer-node-expansion", "http://apache.org/xml/features/dom/create-entity-ref-nodes", "http://apache.org/xml/features/domx/grammar-access"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/dom/document-class-name", "http://apache.org/xml/properties/dom/current-element-node"};
    private static final Hashtable TYPES = new Hashtable();
    protected Document fDocument;
    protected DeferredDocumentImpl fDeferredDocumentImpl;
    protected int fDocumentIndex;
    protected int fDocumentTypeIndex;
    protected int fCurrentNodeIndex;
    protected DocumentImpl fDocumentImpl;
    protected DocumentType fDocumentType;
    protected Node fCurrentElementNode;
    protected boolean fWithinElement;
    protected boolean fInCDATA;
    private boolean fGrammarAccess;
    private String fDocumentClassName;
    private boolean fDeferNodeExpansion;
    private boolean fCreateEntityReferenceNodes;
    protected int fAmpIndex;
    protected int fLtIndex;
    protected int fGtIndex;
    protected int fAposIndex;
    protected int fQuotIndex;
    private boolean fSeenRootElement;
    private XMLAttrList fAttrList;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    static {
        String[][] stringArrayArray = new String[][]{{"CDATA", "minOccurs", "maxOccurs"}, {"ENUMERATION", "collection", "order", "export"}, {"NMTOKEN", "name", "ref"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            String string = stringArrayArray[n][0];
            int n2 = 1;
            while (n2 < stringArrayArray[n].length) {
                TYPES.put(stringArrayArray[n][n2], string);
                ++n2;
            }
            ++n;
        }
    }

    public DOMParser() {
        this.init();
        try {
            this.setDocumentClassName(DEFAULT_DOCUMENT_CLASS_NAME);
            this.setCreateEntityReferenceNodes(true);
            this.setDeferNodeExpansion(true);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("fatal error constructing DOMParser");
        }
    }

    public void attlistDecl(int n, int n2, int n3, String string, int n4, int n5) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n6;
            if (n5 != -1) {
                n6 = this.fDeferredDocumentImpl.lookupElementDefinition(n);
                if (n6 == -1) {
                    n6 = this.fDeferredDocumentImpl.createElementDefinition(n);
                    this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n6);
                }
                int n7 = this.fDeferredDocumentImpl.createAttribute(n2, n5, false);
                this.fDeferredDocumentImpl.appendChild(n6, n7);
            }
            if (this.fGrammarAccess) {
                String string2;
                int n8;
                int n9;
                String string3;
                n6 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                int n10 = this.getFirstChildElement(n6, "element", "name", string3 = this.fStringPool.toString(n));
                if (n10 == -1) {
                    n9 = this.fAttrList.startAttrList();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string3), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("export"), this.fStringPool.addString("true"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                    this.fAttrList.endAttrList();
                    n10 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, n9);
                    this.fDeferredDocumentImpl.appendChild(n6, n10);
                }
                if ((n9 = this.getFirstChildElement(n10, "archetype")) == -1) {
                    n9 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("archetype"), null, -1);
                    this.fDeferredDocumentImpl.insertBefore(n10, n9, this.getFirstChildElement(n10));
                }
                if ((n8 = this.getFirstChildElement(n10, "attribute", "name", string2 = this.fStringPool.toString(n2))) == -1) {
                    int n11;
                    int n12;
                    int n13 = this.fAttrList.startAttrList();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string2), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), this.fStringPool.addSymbol("CDATA"), false, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("1"), this.fStringPool.addSymbol("CDATA"), false, false);
                    this.fAttrList.endAttrList();
                    n8 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("attribute"), this.fAttrList, n13);
                    this.fDeferredDocumentImpl.appendChild(n9, n8);
                    String string4 = this.fStringPool.toString(n3);
                    if (string4.equals("CDATA")) {
                        n12 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("type"), this.fStringPool.addString("string"), false);
                        this.fDeferredDocumentImpl.setAttributeNode(n8, n12);
                    } else if (string4.equals("ENUMERATION")) {
                        n12 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("type"), this.fStringPool.addString("NMTOKEN"), true);
                        this.fDeferredDocumentImpl.setAttributeNode(n8, n12);
                        n11 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("enumeration"), null, -1);
                        this.fDeferredDocumentImpl.appendChild(n8, n11);
                        String string5 = string.substring(1, string.length() - 1);
                        StringTokenizer stringTokenizer = new StringTokenizer(string5, "|");
                        while (stringTokenizer.hasMoreTokens()) {
                            int n14 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("literal"), null, -1);
                            int n15 = this.fDeferredDocumentImpl.createTextNode(this.fStringPool.addString(stringTokenizer.nextToken()), false);
                            this.fDeferredDocumentImpl.appendChild(n14, n15);
                            this.fDeferredDocumentImpl.appendChild(n11, n14);
                        }
                    } else {
                        n12 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("type"), this.fStringPool.addString(string4), true);
                        this.fDeferredDocumentImpl.setAttributeNode(n8, n12);
                    }
                    n12 = 0;
                    if (n4 != -1) {
                        String string6 = this.fStringPool.toString(n4);
                        if (string6.equals("#REQUIRED")) {
                            int n16 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("1"), true);
                            int n17 = this.fDeferredDocumentImpl.setAttributeNode(n8, n16);
                            this.fStringPool.releaseString(this.fDeferredDocumentImpl.getNodeValue(n17));
                        } else if (string6.equals("#FIXED")) {
                            n12 = 1;
                            int n18 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("fixed"), n5, true);
                            this.fDeferredDocumentImpl.setAttributeNode(n8, n18);
                        }
                    }
                    if (n12 == 0 && n5 != -1) {
                        n11 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("default"), n5, true);
                        this.fDeferredDocumentImpl.setAttributeNode(n8, n11);
                    }
                }
            }
        } else if (this.fDocumentImpl != null) {
            Node node;
            String string7;
            Object object;
            Node node2;
            Object object2;
            Object object3;
            if (n5 != -1) {
                object3 = this.fStringPool.toString(n);
                object2 = ((DocumentTypeImpl)this.fDocumentType).getElements();
                node2 = (ElementDefinitionImpl)object2.getNamedItem((String)object3);
                if (node2 == null) {
                    node2 = this.fDocumentImpl.createElementDefinition((String)object3);
                    ((DocumentTypeImpl)this.fDocumentType).getElements().setNamedItem(node2);
                }
                object = this.fStringPool.toString(n2);
                string7 = this.fStringPool.toString(n5);
                node = (AttrImpl)this.fDocumentImpl.createAttribute((String)object);
                ((AttrImpl)node).setValue(string7);
                ((AttrImpl)node).setSpecified(false);
                ((ElementDefinitionImpl)node2).getAttributes().setNamedItem(node);
            }
            if (this.fGrammarAccess) {
                object3 = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                node2 = XUtil.getFirstChildElement((Node)object3, "element", "name", (String)(object2 = this.fStringPool.toString(n)));
                if (node2 == null) {
                    node2 = this.fDocument.createElement("element");
                    node2.setAttribute("name", (String)object2);
                    node2.setAttribute("export", "true");
                    ((AttrImpl)node2.getAttributeNode("export")).setSpecified(false);
                    object3.appendChild(node2);
                }
                if ((object = XUtil.getFirstChildElement(node2, "archetype")) == null) {
                    object = this.fDocument.createElement("archetype");
                    node2.insertBefore((Node)object, XUtil.getFirstChildElement(node2));
                }
                if ((node = XUtil.getFirstChildElement(node2, "attribute", "name", string7 = this.fStringPool.toString(n2))) == null) {
                    Object object4;
                    String string8;
                    node = this.fDocument.createElement("attribute");
                    node.setAttribute("name", string7);
                    node.setAttribute("minOccurs", "0");
                    ((AttrImpl)node.getAttributeNode("minOccurs")).setSpecified(false);
                    node.setAttribute("maxOccurs", "1");
                    ((AttrImpl)node.getAttributeNode("maxOccurs")).setSpecified(false);
                    object.appendChild(node);
                    String string9 = this.fStringPool.toString(n3);
                    if (string9.equals("CDATA")) {
                        node.setAttribute("type", "string");
                        ((AttrImpl)node.getAttributeNode("type")).setSpecified(false);
                    } else if (string9.equals("ENUMERATION")) {
                        node.setAttribute("type", "NMTOKEN");
                        Element element = this.fDocument.createElement("enumeration");
                        node.appendChild(element);
                        string8 = string.substring(1, string.length() - 1);
                        object4 = new StringTokenizer(string8, "|");
                        while (((StringTokenizer)object4).hasMoreTokens()) {
                            Element element2 = this.fDocument.createElement("literal");
                            Text text = this.fDocument.createTextNode(((StringTokenizer)object4).nextToken());
                            element2.appendChild(text);
                            element.appendChild(element2);
                        }
                    } else {
                        node.setAttribute("type", string9);
                    }
                    boolean bl = false;
                    if (n4 != -1) {
                        string8 = this.fStringPool.toString(n4);
                        if (string8.equals("#REQUIRED")) {
                            node.setAttribute("minOccurs", "1");
                            ((AttrImpl)node.getAttributeNode("minOccurs")).setSpecified(true);
                        } else if (string8.equals("#FIXED")) {
                            bl = true;
                            object4 = this.fStringPool.toString(n5);
                            node.setAttribute("fixed", (String)object4);
                        }
                    }
                    if (!bl && n5 != -1) {
                        string8 = this.fStringPool.toString(n5);
                        node.setAttribute("default", string8);
                    }
                }
            }
        }
    }

    public void characters(int n) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n2 = this.fInCDATA ? this.fDeferredDocumentImpl.createCDATASection(n, false) : this.fDeferredDocumentImpl.createTextNode(n, false);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n2);
        } else {
            Text text;
            if (this.fInCDATA) {
                text = this.fDocument.createCDATASection(this.fStringPool.orphanString(n));
            } else {
                Node node;
                if (this.fWithinElement && this.fCurrentElementNode.getNodeType() == 1 && (node = this.fCurrentElementNode.getLastChild()) != null && node.getNodeType() == 3) {
                    ((Text)node).appendData(this.fStringPool.orphanString(n));
                    return;
                }
                text = this.fDocument.createTextNode(this.fStringPool.orphanString(n));
            }
            this.fCurrentElementNode.appendChild(text);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws Exception {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void comment(int n) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n2 = this.fDeferredDocumentImpl.createComment(n);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n2);
        } else {
            Comment comment = this.fDocument.createComment(this.fStringPool.orphanString(n));
            this.fCurrentElementNode.appendChild(comment);
        }
    }

    private void copyInto(Node node, int n) throws Exception {
        boolean bl = node != null && node instanceof DocumentImpl;
        Node node2 = node;
        Node node3 = node;
        Node node4 = node;
        while (node4 != null) {
            int n2 = -1;
            short s = node4.getNodeType();
            switch (s) {
                case 4: {
                    boolean bl2 = bl && ((TextImpl)node4).isIgnorableWhitespace();
                    n2 = this.fDeferredDocumentImpl.createCDATASection(this.fStringPool.addString(node4.getNodeValue()), bl2);
                    break;
                }
                case 8: {
                    n2 = this.fDeferredDocumentImpl.createComment(this.fStringPool.addString(node4.getNodeValue()));
                    break;
                }
                case 1: {
                    int n3;
                    XMLAttrList xMLAttrList = null;
                    int n4 = -1;
                    NamedNodeMap namedNodeMap = node4.getAttributes();
                    if (namedNodeMap != null && (n3 = namedNodeMap.getLength()) > 0) {
                        n4 = this.fAttrList.startAttrList();
                        int n5 = 0;
                        while (n5 < n3) {
                            Attr attr = (Attr)namedNodeMap.item(n5);
                            String string = attr.getNodeName();
                            String string2 = attr.getNodeValue();
                            this.fAttrList.addAttr(this.fStringPool.addSymbol(string), this.fStringPool.addString(string2), this.fStringPool.addSymbol("CDATA"), attr.getSpecified(), false);
                            ++n5;
                        }
                        this.fAttrList.endAttrList();
                        xMLAttrList = this.fAttrList;
                    }
                    n2 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol(node4.getNodeName()), xMLAttrList, n4);
                    break;
                }
                case 5: {
                    n2 = this.fDeferredDocumentImpl.createEntityReference(this.fStringPool.addSymbol(node4.getNodeName()));
                    break;
                }
                case 7: {
                    n2 = this.fDeferredDocumentImpl.createProcessingInstruction(this.fStringPool.addSymbol(node4.getNodeName()), this.fStringPool.addString(node4.getNodeValue()));
                    break;
                }
                case 3: {
                    boolean bl2 = bl && ((TextImpl)node4).isIgnorableWhitespace();
                    n2 = this.fDeferredDocumentImpl.createTextNode(this.fStringPool.addString(node4.getNodeValue()), bl2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("can't copy node type, " + s + " (" + node4.getNodeName() + ')');
                }
            }
            this.fDeferredDocumentImpl.appendChild(n, n2);
            if (node4.hasChildNodes()) {
                node3 = node4;
                node4 = node4.getFirstChild();
                n = n2;
                continue;
            }
            node4 = node4.getNextSibling();
            while (node4 == null && node3 != node2) {
                node4 = node3.getNextSibling();
                node3 = node3.getParentNode();
                n = this.fDeferredDocumentImpl.getParentNode(n);
            }
        }
    }

    private Element createContentModel(XMLValidator.ContentSpec contentSpec, XMLContentSpecNode xMLContentSpecNode) {
        Element element = this.createContentModel(contentSpec, xMLContentSpecNode, null);
        return element;
    }

    private Element createContentModel(XMLValidator.ContentSpec contentSpec, XMLContentSpecNode xMLContentSpecNode, Element element) {
        int n = 1;
        int n2 = 1;
        switch (xMLContentSpecNode.type) {
            case 3: {
                n = 1;
                n2 = -1;
                contentSpec.getNode(xMLContentSpecNode.value, xMLContentSpecNode);
                break;
            }
            case 2: {
                n = 0;
                n2 = -1;
                contentSpec.getNode(xMLContentSpecNode.value, xMLContentSpecNode);
                break;
            }
            case 1: {
                n = 0;
                n2 = 1;
                contentSpec.getNode(xMLContentSpecNode.value, xMLContentSpecNode);
                break;
            }
        }
        int n3 = xMLContentSpecNode.type;
        switch (n3) {
            case 4: 
            case 5: {
                int n4 = xMLContentSpecNode.value;
                int n5 = xMLContentSpecNode.otherValue;
                contentSpec.getNode(n4, xMLContentSpecNode);
                Element element2 = this.createContentModel(contentSpec, xMLContentSpecNode, element);
                contentSpec.getNode(n5, xMLContentSpecNode);
                Element element3 = this.createContentModel(contentSpec, xMLContentSpecNode, null);
                String string = n3 == 4 ? "choice" : "seq";
                Element element4 = element2;
                if (!element2.getAttribute("order").equals(string)) {
                    String string2 = element2.getAttribute("minOccurs");
                    String string3 = element2.getAttribute("maxOccurs");
                    if (element == null || (string2.equals("1") || string2.length() == 0) && (string3.equals("1") || string3.length() == 0)) {
                        element4 = this.fDocument.createElement("group");
                        element4.setAttribute("collection", "no");
                        ((AttrImpl)element4.getAttributeNode("collection")).setSpecified(false);
                        element4.setAttribute("order", string);
                        if (string.equals("seq")) {
                            ((AttrImpl)element4.getAttributeNode("order")).setSpecified(false);
                        }
                        element4.appendChild(element2);
                    } else {
                        element4 = element;
                    }
                }
                this.setOccurrenceCount(element4, n, n2);
                element4.appendChild(element3);
                return element4;
            }
            case 0: {
                String string = this.fStringPool.toString(xMLContentSpecNode.value);
                Element element5 = this.fDocument.createElement("element");
                element5.setAttribute("ref", string);
                this.setOccurrenceCount(element5, n, n2);
                return element5;
            }
        }
        return null;
    }

    private int createDeferredContentModel(Node node) throws Exception {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                Object object;
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = this.fAttrList.startAttrList();
                int n2 = namedNodeMap.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    Attr attr = (Attr)namedNodeMap.item(n3);
                    object = attr.getNodeName();
                    String string = attr.getNodeValue();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol((String)object), this.fStringPool.addString(string), this.fStringPool.addSymbol((String)TYPES.get(object)), attr.getSpecified(), false);
                    ++n3;
                }
                this.fAttrList.endAttrList();
                int n4 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol(node.getNodeName()), this.fAttrList, n);
                object = node.getFirstChild();
                while (object != null) {
                    int n5 = this.createDeferredContentModel((Node)object);
                    this.fDeferredDocumentImpl.appendChild(n4, n5);
                    object = object.getNextSibling();
                }
                return n4;
            }
            case 3: {
                return this.fDeferredDocumentImpl.createTextNode(this.fStringPool.addString(node.getNodeValue()), false);
            }
        }
        return -1;
    }

    public void elementDecl(int n, XMLValidator.ContentSpec contentSpec) throws Exception {
        if (this.fGrammarAccess) {
            if (this.fDeferredDocumentImpl != null) {
                int n2;
                String string;
                int n3;
                String string2;
                int n4 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                int n5 = this.getFirstChildElement(n4, "element", "name", string2 = this.fStringPool.toString(n));
                if (n5 == -1) {
                    n3 = this.fAttrList.startAttrList();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string2), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("export"), this.fStringPool.addString("true"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                    this.fAttrList.endAttrList();
                    n5 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, n3);
                    this.fDeferredDocumentImpl.appendChild(n4, n5);
                }
                if ((n3 = this.getFirstChildElement(n5, "archetype")) == -1) {
                    n3 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("archetype"), null, -1);
                    this.fDeferredDocumentImpl.insertBefore(n5, n3, this.getFirstChildElement(n5));
                }
                if ((string = this.fStringPool.toString(n2 = contentSpec.getType())).equals("EMPTY")) {
                    int n6 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("empty"), true);
                    this.fDeferredDocumentImpl.setAttributeNode(n3, n6);
                } else if (string.equals("ANY")) {
                    int n7 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("any"), true);
                    this.fDeferredDocumentImpl.setAttributeNode(n3, n7);
                } else if (string.equals("CHILDREN")) {
                    int n8 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("elemOnly"), false);
                    this.fDeferredDocumentImpl.setAttributeNode(n3, n8);
                    n8 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("order"), this.fStringPool.addString("seq"), false);
                    this.fDeferredDocumentImpl.setAttributeNode(n3, n8);
                    XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
                    int n9 = contentSpec.getHandle();
                    contentSpec.getNode(n9, xMLContentSpecNode);
                    Element element = this.createContentModel(contentSpec, xMLContentSpecNode);
                    int n10 = this.createDeferredContentModel(element);
                    int n11 = this.getFirstChildElement(n3);
                    this.fDeferredDocumentImpl.insertBefore(n3, n10, n11);
                } else {
                    int n12 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("mixed"), true);
                    this.fDeferredDocumentImpl.setAttributeNode(n3, n12);
                    XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
                    int n13 = contentSpec.getHandle();
                    contentSpec.getNode(n13, xMLContentSpecNode);
                    if (xMLContentSpecNode.type != 0) {
                        contentSpec.getNode(xMLContentSpecNode.value, xMLContentSpecNode);
                        do {
                            n13 = xMLContentSpecNode.value;
                            int n14 = this.fAttrList.startAttrList();
                            contentSpec.getNode(xMLContentSpecNode.otherValue, xMLContentSpecNode);
                            String string3 = this.fStringPool.toString(xMLContentSpecNode.value);
                            this.fAttrList.addAttr(this.fStringPool.addSymbol("ref"), this.fStringPool.addString(string3), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                            this.fAttrList.endAttrList();
                            int n15 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, n14);
                            this.fDeferredDocumentImpl.insertBefore(n3, n15, this.getFirstChildElement(n3, "element"));
                            contentSpec.getNode(n13, xMLContentSpecNode);
                        } while (xMLContentSpecNode.type != 0);
                    }
                }
            } else if (this.fDocumentImpl != null) {
                int n16;
                String string;
                Element element;
                String string4;
                Element element2 = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                Element element3 = XUtil.getFirstChildElement(element2, "element", "name", string4 = this.fStringPool.toString(n));
                if (element3 == null) {
                    element3 = this.fDocument.createElement("element");
                    element3.setAttribute("name", string4);
                    element3.setAttribute("export", "true");
                    ((AttrImpl)element3.getAttributeNode("export")).setSpecified(false);
                    element2.appendChild(element3);
                }
                if ((element = XUtil.getFirstChildElement((Node)element3, "archetype")) == null) {
                    element = this.fDocument.createElement("archetype");
                    element3.insertBefore(element, XUtil.getFirstChildElement(element3));
                }
                if ((string = this.fStringPool.toString(n16 = contentSpec.getType())).equals("EMPTY")) {
                    element.setAttribute("content", "empty");
                } else if (string.equals("ANY")) {
                    element.setAttribute("content", "any");
                } else if (string.equals("CHILDREN")) {
                    element.setAttribute("content", "elemOnly");
                    ((AttrImpl)element.getAttributeNode("content")).setSpecified(false);
                    element.setAttribute("order", "seq");
                    ((AttrImpl)element.getAttributeNode("order")).setSpecified(false);
                    XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
                    int n17 = contentSpec.getHandle();
                    contentSpec.getNode(n17, xMLContentSpecNode);
                    Element element4 = this.createContentModel(contentSpec, xMLContentSpecNode);
                    Element element5 = XUtil.getFirstChildElement(element);
                    element.insertBefore(element4, element5);
                } else {
                    element.setAttribute("content", "mixed");
                    XMLContentSpecNode xMLContentSpecNode = new XMLContentSpecNode();
                    int n18 = contentSpec.getHandle();
                    contentSpec.getNode(n18, xMLContentSpecNode);
                    if (xMLContentSpecNode.type != 0) {
                        contentSpec.getNode(xMLContentSpecNode.value, xMLContentSpecNode);
                        do {
                            n18 = xMLContentSpecNode.value;
                            Element element6 = this.fDocument.createElement("element");
                            contentSpec.getNode(xMLContentSpecNode.otherValue, xMLContentSpecNode);
                            String string5 = this.fStringPool.toString(xMLContentSpecNode.value);
                            element6.setAttribute("ref", string5);
                            element.insertBefore(element6, XUtil.getFirstChildElement((Node)element, "element"));
                            contentSpec.getNode(n18, xMLContentSpecNode);
                        } while (xMLContentSpecNode.type != 0);
                    }
                }
            }
        }
    }

    public void endCDATA() throws Exception {
        this.fInCDATA = false;
    }

    public void endDTD() throws Exception {
    }

    public void endDocument() throws Exception {
    }

    public void endElement(int n) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex);
            this.fWithinElement = false;
        } else {
            this.fCurrentElementNode = this.fCurrentElementNode.getParentNode();
            this.fWithinElement = false;
        }
    }

    public void endEntityReference(int n, int n2, int n3) throws Exception {
        block10: {
            block9: {
                if (!this.fCreateEntityReferenceNodes) {
                    return;
                }
                if (n == this.fAmpIndex || n == this.fGtIndex || n == this.fLtIndex || n == this.fAposIndex || n == this.fQuotIndex) {
                    return;
                }
                if (n3 != 2) {
                    return;
                }
                if (this.fDeferredDocumentImpl == null) break block9;
                String string = this.fStringPool.toString(n);
                int n4 = this.fCurrentNodeIndex;
                this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(n4);
                if (this.fDeferredDocumentImpl.getNodeType(n4) != 5) {
                    return;
                }
                n4 = this.fDeferredDocumentImpl.getFirstChild(n4);
                if (this.fDocumentTypeIndex == -1) break block10;
                int n5 = this.fDeferredDocumentImpl.getFirstChild(this.fDocumentTypeIndex);
                while (n5 != -1) {
                    if (this.fDeferredDocumentImpl.getNodeType(n5) == 6 && this.fDeferredDocumentImpl.getNodeNameString(n5).equals(string)) break;
                    n5 = this.fDeferredDocumentImpl.getNextSibling(n5);
                }
                if (n5 == -1 || this.fDeferredDocumentImpl.getFirstChild(n5) != -1) break block10;
                this.fDeferredDocumentImpl.setAsFirstChild(n5, n4);
                break block10;
            }
            Node node = this.fCurrentElementNode;
            this.fCurrentElementNode = node.getParentNode();
            if (this.fDocumentImpl != null) {
                String string;
                NamedNodeMap namedNodeMap = this.fDocumentType.getEntities();
                Node node2 = namedNodeMap.getNamedItem(string = this.fStringPool.toString(n));
                if (node2 == null || node2.hasChildNodes()) {
                    return;
                }
                Entity entity = (Entity)node2;
                if (node.hasChildNodes()) {
                    NodeList nodeList = node.getChildNodes();
                    int n6 = nodeList.getLength();
                    int n7 = 0;
                    while (n7 < n6) {
                        Node node3 = nodeList.item(n7).cloneNode(true);
                        entity.appendChild(node3);
                        ++n7;
                    }
                }
            }
        }
    }

    public void endNamespaceDeclScope(int n) throws Exception {
    }

    public void externalEntityDecl(int n, int n2, int n3) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            String string;
            int n4;
            int n5;
            int n6 = this.fDeferredDocumentImpl.createEntity(n, n2, n3, -1);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n6);
            if (this.fGrammarAccess && (n5 = this.getFirstChildElement(n4 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema"), "externalEntity", "name", string = this.fStringPool.toString(n))) == -1) {
                int n7 = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("export"), this.fStringPool.addString("true"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                if (n2 != -1) {
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("public"), n2, this.fStringPool.addSymbol("CDATA"), true, false);
                }
                this.fAttrList.addAttr(this.fStringPool.addSymbol("system"), n3, this.fStringPool.addSymbol("CDATA"), true, false);
                this.fAttrList.endAttrList();
                n5 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("externalEntity"), this.fAttrList, n7);
                this.fDeferredDocumentImpl.appendChild(n4, n5);
            }
        } else if (this.fDocumentImpl != null) {
            Element element;
            Element element2;
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            EntityImpl entityImpl = (EntityImpl)this.fDocumentImpl.createEntity(string);
            if (n2 != -1) {
                entityImpl.setPublicId(string2);
            }
            entityImpl.setSystemId(string3);
            this.fDocumentType.getEntities().setNamedItem(entityImpl);
            if (this.fGrammarAccess && (element2 = XUtil.getFirstChildElement(element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema"), "externalEntity", "name", string)) == null) {
                element2 = this.fDocument.createElement("externalEntity");
                element2.setAttribute("name", string);
                element2.setAttribute("export", "true");
                ((AttrImpl)element2.getAttributeNode("export")).setSpecified(false);
                if (n2 != -1) {
                    element2.setAttribute("public", string2);
                }
                element2.setAttribute("system", string3);
                element.appendChild(element2);
            }
        }
    }

    public void externalPEDecl(int n, int n2, int n3) throws Exception {
    }

    public boolean getCreateEntityReferenceNodes() throws SAXException {
        return this.fCreateEntityReferenceNodes;
    }

    protected Element getCurrentElementNode() throws SAXException {
        if (this.fCurrentElementNode != null && this.fCurrentElementNode.getNodeType() == 1) {
            return (Element)this.fCurrentElementNode;
        }
        return null;
    }

    protected boolean getDeferNodeExpansion() throws SAXException {
        return this.fDeferNodeExpansion;
    }

    public Document getDocument() {
        if (this.fDocumentImpl != null) {
            this.fDocumentImpl.setErrorChecking(true);
        }
        return this.fDocument;
    }

    protected String getDocumentClassName() throws SAXException {
        return this.fDocumentClassName;
    }

    public boolean getFeature(String string) throws SAXException {
        if (!string.startsWith("http://xml.org/sax/features/") && string.startsWith("http://apache.org/xml/features/")) {
            String string2 = string.substring("http://apache.org/xml/features/".length());
            if (string2.equals("dom/defer-node-expansion")) {
                return this.getDeferNodeExpansion();
            }
            if (string2.equals("dom/create-entity-ref-nodes")) {
                return this.getCreateEntityReferenceNodes();
            }
            if (string2.equals("domx/grammar-access")) {
                return this.fGrammarAccess;
            }
        }
        return super.getFeature(string);
    }

    public String[] getFeaturesRecognized() {
        String[] stringArray = super.getFeaturesRecognized();
        String[] stringArray2 = RECOGNIZED_FEATURES;
        int n = stringArray2.length;
        if (n == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2 + n];
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        System.arraycopy(stringArray2, 0, stringArray3, n2, n);
        return stringArray3;
    }

    private int getFirstChildElement(int n) {
        int n2 = this.fDeferredDocumentImpl.getFirstChild(n);
        while (n2 != -1) {
            if (this.fDeferredDocumentImpl.getNodeType(n2) == 1) {
                return n2;
            }
            n2 = this.fDeferredDocumentImpl.getNextSibling(n2);
        }
        return -1;
    }

    private int getFirstChildElement(int n, String string) {
        int n2 = this.getFirstChildElement(n);
        if (n2 != -1) {
            while (n2 != -1) {
                String string2 = this.fDeferredDocumentImpl.getNodeNameString(n2);
                if (this.fDeferredDocumentImpl.getNodeNameString(n2).equals(string)) {
                    return n2;
                }
                n2 = this.getNextSiblingElement(n2);
            }
        }
        return -1;
    }

    private int getFirstChildElement(int n, String string, String string2, String string3) {
        int n2 = this.getFirstChildElement(n, string);
        if (n2 != -1) {
            while (n2 != -1) {
                int n3 = this.fDeferredDocumentImpl.getNodeValue(n2);
                while (n3 != -1) {
                    int n4;
                    String string4;
                    String string5 = this.fDeferredDocumentImpl.getNodeNameString(n3);
                    if (string5.equals(string2) && (string4 = this.fDeferredDocumentImpl.getNodeValueString(n4 = this.fDeferredDocumentImpl.getFirstChild(n3))).equals(string3)) {
                        return n2;
                    }
                    n3 = this.fDeferredDocumentImpl.getNextSibling(n3);
                }
                n2 = this.getNextSiblingElement(n2, string);
            }
        }
        return -1;
    }

    private int getNextSiblingElement(int n) {
        int n2 = this.fDeferredDocumentImpl.getNextSibling(n);
        while (n2 != -1) {
            if (this.fDeferredDocumentImpl.getNodeType(n2) == 1) {
                return n2;
            }
            n2 = this.fDeferredDocumentImpl.getNextSibling(n2);
        }
        return -1;
    }

    private int getNextSiblingElement(int n, String string) {
        int n2 = this.getNextSiblingElement(n);
        if (n2 != -1) {
            while (n2 != -1) {
                String string2 = this.fDeferredDocumentImpl.getNodeNameString(n2);
                if (string2.equals(string)) {
                    return n2;
                }
                n2 = this.getNextSiblingElement(n2);
            }
        }
        return -1;
    }

    private int getNextSiblingElement(int n, String string, String string2, String string3) {
        int n2 = this.getNextSiblingElement(n, string);
        if (n2 != -1) {
            int n3 = this.fStringPool.addSymbol(string2);
            while (n2 != -1) {
                int n4 = this.fDeferredDocumentImpl.getNodeValue(n2);
                while (n4 != -1) {
                    int n5 = this.fDeferredDocumentImpl.getNodeValue(n4);
                    if (string3.equals(this.fStringPool.toString(n5))) {
                        return n2;
                    }
                    n4 = this.fDeferredDocumentImpl.getNextSibling(n4);
                }
                n2 = this.getNextSiblingElement(n2, string);
            }
        }
        return -1;
    }

    public String[] getPropertiesRecognized() {
        String[] stringArray = super.getPropertiesRecognized();
        String[] stringArray2 = RECOGNIZED_PROPERTIES;
        int n = stringArray2.length;
        if (n == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2 + n];
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        System.arraycopy(stringArray2, 0, stringArray3, n2, n);
        return stringArray3;
    }

    public Object getProperty(String string) throws SAXException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("dom/current-element-node")) {
                boolean bl = false;
                try {
                    bl = this.getFeature("http://apache.org/xml/features/dom/defer-node-expansion");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {}
                if (bl) {
                    throw new SAXNotSupportedException("Current element node cannot be queried when node expansion is deferred.");
                }
                return this.getCurrentElementNode();
            }
            if (string2.equals("dom/document-class-name")) {
                return this.getDocumentClassName();
            }
        }
        return super.getProperty(string);
    }

    public void ignorableWhitespace(int n) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n2 = this.fInCDATA ? this.fDeferredDocumentImpl.createCDATASection(n, true) : this.fDeferredDocumentImpl.createTextNode(n, true);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n2);
        } else {
            Text text;
            if (this.fInCDATA) {
                text = this.fDocument.createCDATASection(this.fStringPool.orphanString(n));
            } else {
                Node node;
                if (this.fWithinElement && this.fCurrentElementNode.getNodeType() == 1 && (node = this.fCurrentElementNode.getLastChild()) != null && node.getNodeType() == 3) {
                    ((Text)node).appendData(this.fStringPool.orphanString(n));
                    return;
                }
                text = this.fDocument.createTextNode(this.fStringPool.orphanString(n));
            }
            if (this.fDocumentImpl != null) {
                ((TextImpl)text).setIgnorableWhitespace(true);
            }
            this.fCurrentElementNode.appendChild(text);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws Exception {
    }

    protected void init() {
        this.fDocument = null;
        this.fDeferredDocumentImpl = null;
        this.fDocumentIndex = -1;
        this.fDocumentTypeIndex = -1;
        this.fCurrentNodeIndex = -1;
        this.fDocumentImpl = null;
        this.fDocumentType = null;
        this.fCurrentElementNode = null;
        this.fWithinElement = false;
        this.fInCDATA = false;
        this.fAmpIndex = this.fStringPool.addSymbol("amp");
        this.fLtIndex = this.fStringPool.addSymbol("lt");
        this.fGtIndex = this.fStringPool.addSymbol("gt");
        this.fAposIndex = this.fStringPool.addSymbol("apos");
        this.fQuotIndex = this.fStringPool.addSymbol("quot");
        this.setSendCharDataAsCharArray(false);
        this.fSeenRootElement = false;
        this.fAttrList = new XMLAttrList(this.fStringPool);
    }

    public void internalEntityDecl(int n, int n2) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            String string;
            int n3;
            int n4;
            if (this.fDocumentTypeIndex == -1) {
                return;
            }
            int n5 = this.fDeferredDocumentImpl.createEntity(n, -1, -1, -1);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n5);
            if (this.fGrammarAccess && (n4 = this.getFirstChildElement(n3 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema"), "textEntity", "name", string = this.fStringPool.toString(n))) == -1) {
                int n6 = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("export"), this.fStringPool.addString("true"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                this.fAttrList.endAttrList();
                n4 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("textEntity"), this.fAttrList, n6);
                this.fDeferredDocumentImpl.appendChild(n3, n4);
                int n7 = this.fDeferredDocumentImpl.createTextNode(n2, false);
                this.fDeferredDocumentImpl.appendChild(n4, n7);
            }
        } else if (this.fDocumentImpl != null) {
            Element element;
            Element element2;
            if (this.fDocumentType == null) {
                return;
            }
            String string = this.fStringPool.toString(n);
            Entity entity = this.fDocumentImpl.createEntity(string);
            this.fDocumentType.getEntities().setNamedItem(entity);
            if (this.fGrammarAccess && (element2 = XUtil.getFirstChildElement(element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema"), "textEntity", "name", string)) == null) {
                element2 = this.fDocument.createElement("textEntity");
                element2.setAttribute("name", string);
                element2.setAttribute("export", "true");
                ((AttrImpl)element2.getAttributeNode("export")).setSpecified(false);
                String string2 = this.fStringPool.toString(n2);
                Text text = this.fDocument.createTextNode(string2);
                element2.appendChild(text);
                element.appendChild(element2);
            }
        }
    }

    public void internalPEDecl(int n, int n2) throws Exception {
    }

    public void notationDecl(int n, int n2, int n3) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            String string;
            int n4;
            int n5;
            int n6 = this.fDeferredDocumentImpl.createNotation(n, n2, n3);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n6);
            if (this.fGrammarAccess && (n5 = this.getFirstChildElement(n4 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema"), "notation", "name", string = this.fStringPool.toString(n))) == -1) {
                int n7 = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("export"), this.fStringPool.addString("true"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                if (n2 == -1) {
                    n2 = 0;
                }
                this.fAttrList.addAttr(this.fStringPool.addSymbol("public"), n2, this.fStringPool.addSymbol("CDATA"), true, false);
                if (n3 != -1) {
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("system"), n3, this.fStringPool.addSymbol("CDATA"), true, false);
                }
                this.fAttrList.endAttrList();
                n5 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("notation"), this.fAttrList, n7);
                this.fDeferredDocumentImpl.appendChild(n4, n5);
            }
        } else if (this.fDocumentImpl != null) {
            Element element;
            Element element2;
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            NotationImpl notationImpl = (NotationImpl)this.fDocumentImpl.createNotation(string);
            notationImpl.setPublicId(string2);
            if (n3 != -1) {
                notationImpl.setSystemId(string3);
            }
            this.fDocumentType.getNotations().setNamedItem(notationImpl);
            if (this.fGrammarAccess && (element2 = XUtil.getFirstChildElement(element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema"), "notation", "name", string)) == null) {
                element2 = this.fDocument.createElement("notation");
                element2.setAttribute("name", string);
                element2.setAttribute("export", "true");
                ((AttrImpl)element2.getAttributeNode("export")).setSpecified(false);
                if (string2 == null) {
                    string2 = "";
                }
                element2.setAttribute("public", string2);
                if (n3 != -1) {
                    element2.setAttribute("system", string3);
                }
                element.appendChild(element2);
            }
        }
    }

    public void processingInstruction(int n, int n2) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n3 = this.fDeferredDocumentImpl.createProcessingInstruction(n, n2);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n3);
        } else {
            String string = this.fStringPool.orphanString(n);
            String string2 = this.fStringPool.orphanString(n2);
            ProcessingInstruction processingInstruction = this.fDocument.createProcessingInstruction(string, string2);
            this.fCurrentElementNode.appendChild(processingInstruction);
        }
    }

    public void reset() throws Exception {
        super.reset();
        this.init();
    }

    public void resetOrCopy() throws Exception {
        super.resetOrCopy();
        this.init();
    }

    protected void setCreateEntityReferenceNodes(boolean bl) throws SAXException {
        this.fCreateEntityReferenceNodes = bl;
    }

    protected void setDeferNodeExpansion(boolean bl) throws SAXException {
        this.fDeferNodeExpansion = bl;
    }

    protected void setDocumentClassName(String string) throws SAXException {
        if (string == null) {
            string = DEFAULT_DOCUMENT_CLASS_NAME;
        }
        try {
            Class<?> clazz = Class.forName(string);
            if (!(class$org$w3c$dom$Document != null ? class$org$w3c$dom$Document : (class$org$w3c$dom$Document = DOMParser.class$("org.w3c.dom.Document"))).isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class, \"" + string + "\", is not of type org.w3c.dom.Document.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Class, \"" + string + "\", not found.");
        }
        this.fDocumentClassName = string;
        if (!string.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
            this.setDeferNodeExpansion(false);
        }
    }

    public void setFeature(String string, boolean bl) throws SAXException {
        if (!string.startsWith("http://xml.org/sax/features/") && string.startsWith("http://apache.org/xml/features/")) {
            String string2 = string.substring("http://apache.org/xml/features/".length());
            if (string2.equals("dom/defer-node-expansion")) {
                if (this.fParseInProgress) {
                    throw new SAXNotSupportedException(String.valueOf(string) + ": parse is in progress");
                }
                this.setDeferNodeExpansion(bl);
                return;
            }
            if (string2.equals("dom/create-entity-ref-nodes")) {
                this.setCreateEntityReferenceNodes(bl);
                return;
            }
            if (string2.equals("domx/grammar-access")) {
                this.fGrammarAccess = bl;
                return;
            }
        }
        super.setFeature(string, bl);
    }

    private void setOccurrenceCount(Element element, int n, int n2) {
        element.setAttribute("minOccurs", Integer.toString(n));
        if (n == 1) {
            ((AttrImpl)element.getAttributeNode("minOccurs")).setSpecified(false);
        }
        if (n2 == -1) {
            element.setAttribute("maxOccurs", "*");
        } else if (n2 != 1) {
            element.setAttribute("maxOccurs", Integer.toString(n2));
        }
    }

    public void setProperty(String string, Object object) throws SAXException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("dom/current-element-node")) {
                throw new SAXNotSupportedException("Property, \"" + string + "\" is read-only.");
            }
            if (string2.equals("dom/document-class-name")) {
                if (object != null && !(object instanceof String)) {
                    throw new SAXNotSupportedException("Property value must be of type java.lang.String.");
                }
                this.setDocumentClassName((String)object);
                return;
            }
        }
        super.setProperty(string, object);
    }

    public void startCDATA() throws Exception {
        this.fInCDATA = true;
    }

    public void startDTD(int n, int n2, int n3) throws Exception {
        if (this.fDocumentImpl != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            this.fDocumentType = this.fDocumentImpl.createDocumentType(string, string2, string3);
            this.fDocumentImpl.appendChild(this.fDocumentType);
            if (this.fGrammarAccess) {
                Element element = this.fDocument.createElement("schema");
                element.setAttribute("xmlns", "http://www.w3.org/XML/Group/1999/09/23-xmlschema/");
                ((AttrImpl)element.getAttributeNode("xmlns")).setSpecified(false);
                element.setAttribute("model", "closed");
                ((AttrImpl)element.getAttributeNode("model")).setSpecified(false);
                this.fDocumentType.appendChild(element);
            }
        } else if (this.fDeferredDocumentImpl != null) {
            this.fDocumentTypeIndex = this.fDeferredDocumentImpl.createDocumentType(n, n2, n3);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentIndex, this.fDocumentTypeIndex);
            if (this.fGrammarAccess) {
                int n4 = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("xmlns"), this.fStringPool.addString("http://www.w3.org/XML/Group/1999/09/23-xmlschema/"), this.fStringPool.addSymbol("CDATA"), false, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("model"), this.fStringPool.addString("closed"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                this.fAttrList.endAttrList();
                int n5 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("schema"), this.fAttrList, n4);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n5);
            }
        }
    }

    public void startDocument(int n, int n2, int n3) {
        if (n != -1) {
            this.fStringPool.orphanString(n);
        }
        if (n2 != -1) {
            this.fStringPool.orphanString(n2);
        }
        if (n3 != -1) {
            this.fStringPool.orphanString(n3);
        }
        String string = null;
        try {
            string = this.getDocumentClassName();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("fatal error getting document factory");
        }
        boolean bl = true;
        try {
            bl = this.getDeferNodeExpansion();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("fatal error reading expansion mode");
        }
        if (string.equals(DEFAULT_DOCUMENT_CLASS_NAME) && bl) {
            boolean bl2 = false;
            try {
                bl2 = this.getNamespaces();
            }
            catch (SAXException sAXException) {}
            this.fDeferredDocumentImpl = new DeferredDocumentImpl(this.fStringPool, bl2, this.fGrammarAccess);
            this.fDocument = this.fDeferredDocumentImpl;
            this.fCurrentNodeIndex = this.fDocumentIndex = this.fDeferredDocumentImpl.createDocument();
        } else {
            if (string.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
                this.fDocumentImpl = new DocumentImpl(this.fGrammarAccess);
                this.fDocument = this.fDocumentImpl;
                this.fDocumentImpl.setErrorChecking(false);
            } else {
                try {
                    Class<?> clazz = Class.forName(string);
                    this.fDocument = (Document)clazz.newInstance();
                }
                catch (Exception exception) {}
            }
            this.fCurrentElementNode = this.fDocument;
        }
    }

    public void startElement(int n, XMLAttrList xMLAttrList, int n2) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n3 = this.fDeferredDocumentImpl.createElement(n, xMLAttrList, n2);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n3);
            this.fCurrentNodeIndex = n3;
            this.fWithinElement = true;
            int n4 = xMLAttrList.getFirstAttr(n2);
            while (n4 != -1) {
                if (xMLAttrList.getAttType(n4) == this.fStringPool.addSymbol("ID")) {
                    int n5 = xMLAttrList.getAttValue(n4);
                    this.fDeferredDocumentImpl.putIdentifier(n5, n3);
                }
                n4 = xMLAttrList.getNextAttr(n4);
            }
            if (!this.fSeenRootElement) {
                Document document;
                this.fSeenRootElement = true;
                if (this.fGrammarAccess && this.fValidator == this.fSchemaValidator && (document = this.fSchemaValidator.getSchemaDocument()) != null) {
                    if (this.fDocumentTypeIndex == -1) {
                        this.fDocumentTypeIndex = this.fDeferredDocumentImpl.createDocumentType(n, -1, -1);
                        this.fDeferredDocumentImpl.appendChild(0, this.fDocumentTypeIndex);
                    }
                    Element element = document.getDocumentElement();
                    this.copyInto(element, this.fDocumentTypeIndex);
                }
            }
        } else {
            Object object;
            int n6;
            boolean bl = false;
            try {
                bl = this.getNamespaces();
            }
            catch (SAXException sAXException) {}
            String string = this.fStringPool.toString(n);
            AttributeList attributeList = xMLAttrList.getAttributeList(n2);
            Element element = bl ? (ElementImpl)((DocumentImpl)this.fDocument).createElementNS(this.fStringPool.toString(this.fStringPool.getURIForQName(n)), this.fStringPool.toString(n)) : this.fDocument.createElement(string);
            int n7 = attributeList.getLength();
            int n8 = 0;
            while (n8 < n7) {
                if (bl) {
                    n6 = xMLAttrList.getAttrName(n8);
                    ((ElementImpl)element).setAttributeNS(this.fStringPool.toString(this.fStringPool.getURIForQName(n6)), this.fStringPool.toString(n6), attributeList.getValue(n8));
                } else {
                    String string2 = attributeList.getName(n8);
                    object = attributeList.getValue(n8);
                    element.setAttribute(string2, (String)object);
                    if (this.fDocumentImpl != null && !xMLAttrList.isSpecified(n8)) {
                        ((AttrImpl)element.getAttributeNode(string2)).setSpecified(false);
                    }
                }
                ++n8;
            }
            this.fCurrentElementNode.appendChild(element);
            this.fCurrentElementNode = element;
            this.fWithinElement = true;
            if (this.fDocumentImpl != null) {
                n6 = xMLAttrList.getFirstAttr(n2);
                while (n6 != -1) {
                    if (xMLAttrList.getAttType(n6) == this.fStringPool.addSymbol("ID")) {
                        object = this.fStringPool.toString(xMLAttrList.getAttValue(n6));
                        this.fDocumentImpl.putIdentifier((String)object, element);
                    }
                    n6 = xMLAttrList.getNextAttr(n6);
                }
            }
            xMLAttrList.releaseAttrList(n2);
            if (!this.fSeenRootElement) {
                Document document;
                this.fSeenRootElement = true;
                if (this.fDocumentImpl != null && this.fGrammarAccess && this.fValidator == this.fSchemaValidator && (document = this.fSchemaValidator.getSchemaDocument()) != null) {
                    if (this.fDocumentType == null) {
                        object = string;
                        String string3 = "";
                        String string4 = "";
                        this.fDocumentType = this.fDocumentImpl.createDocumentType((String)object, string4, string3);
                        this.fDocument.appendChild(this.fDocumentType);
                    }
                    object = document.getDocumentElement();
                    XUtil.copyInto((Node)object, this.fDocumentType);
                }
            }
        }
    }

    public void startEntityReference(int n, int n2, int n3) throws Exception {
        if (!this.fCreateEntityReferenceNodes) {
            return;
        }
        if (n == this.fAmpIndex || n == this.fGtIndex || n == this.fLtIndex || n == this.fAposIndex || n == this.fQuotIndex) {
            return;
        }
        if (n3 != 2) {
            return;
        }
        if (this.fDeferredDocumentImpl != null) {
            int n4 = this.fDeferredDocumentImpl.createEntityReference(n);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n4);
            this.fCurrentNodeIndex = n4;
        } else {
            EntityReference entityReference = this.fDocument.createEntityReference(this.fStringPool.toString(n));
            this.fCurrentElementNode.appendChild(entityReference);
            this.fCurrentElementNode = entityReference;
        }
    }

    public void startNamespaceDeclScope(int n, int n2) throws Exception {
    }

    public void unparsedEntityDecl(int n, int n2, int n3, int n4) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            String string;
            int n5;
            int n6;
            int n7 = this.fDeferredDocumentImpl.createEntity(n, n2, n3, n4);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n7);
            if (this.fGrammarAccess && (n6 = this.getFirstChildElement(n5 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema"), "unparsedEntity", "name", string = this.fStringPool.toString(n))) == -1) {
                int n8 = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("export"), this.fStringPool.addString("true"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                if (n2 != -1) {
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("public"), n2, this.fStringPool.addSymbol("CDATA"), true, false);
                }
                this.fAttrList.addAttr(this.fStringPool.addSymbol("system"), n3, this.fStringPool.addSymbol("CDATA"), true, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("notation"), this.fStringPool.addString(this.fStringPool.toString(n4)), this.fStringPool.addSymbol("CDATA"), true, false);
                this.fAttrList.endAttrList();
                n6 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("unparsedEntity"), this.fAttrList, n8);
                this.fDeferredDocumentImpl.appendChild(n5, n6);
            }
        } else if (this.fDocumentImpl != null) {
            Element element;
            Element element2;
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            String string4 = this.fStringPool.toString(n4);
            EntityImpl entityImpl = (EntityImpl)this.fDocumentImpl.createEntity(string);
            if (n2 != -1) {
                entityImpl.setPublicId(string2);
            }
            entityImpl.setSystemId(string3);
            entityImpl.setNotationName(string4);
            this.fDocumentType.getEntities().setNamedItem(entityImpl);
            if (this.fGrammarAccess && (element2 = XUtil.getFirstChildElement(element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema"), "unparsedEntity", "name", string)) == null) {
                element2 = this.fDocument.createElement("unparsedEntity");
                element2.setAttribute("name", string);
                element2.setAttribute("export", "true");
                ((AttrImpl)element2.getAttributeNode("export")).setSpecified(false);
                if (n2 != -1) {
                    element2.setAttribute("public", string2);
                }
                element2.setAttribute("system", string3);
                element2.setAttribute("notation", string4);
                element.appendChild(element2);
            }
        }
    }
}

