/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.apache.xerces.domx.events.Event;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap,
Serializable {
    static final long serialVersionUID = -7039242451046758020L;
    protected Vector nodes;
    protected Document ownerDocument;
    protected ElementImpl element;
    protected NamedNodeMapImpl defaults;
    protected int changes;
    protected int lastDefaultsChanges = -1;
    protected boolean readOnly = false;

    protected NamedNodeMapImpl(ElementImpl elementImpl, NamedNodeMapImpl namedNodeMapImpl) {
        this(elementImpl.getOwnerDocument(), namedNodeMapImpl);
        this.element = elementImpl;
    }

    protected NamedNodeMapImpl(Document document, NamedNodeMapImpl namedNodeMapImpl) {
        this.ownerDocument = document;
        this.defaults = namedNodeMapImpl;
    }

    public NamedNodeMapImpl cloneMap() {
        boolean bl = true;
        NamedNodeMapImpl namedNodeMapImpl = new NamedNodeMapImpl(this.ownerDocument, this.defaults);
        if (this.nodes != null) {
            namedNodeMapImpl.nodes = new Vector(this.nodes.size());
            int n = 0;
            while (n < this.nodes.size()) {
                NodeImpl nodeImpl = (NodeImpl)((Node)this.nodes.elementAt(n)).cloneNode(bl);
                nodeImpl.parentNode = this.element;
                namedNodeMapImpl.nodes.addElement(nodeImpl);
                ++n;
            }
        }
        namedNodeMapImpl.defaults = this.defaults;
        namedNodeMapImpl.lastDefaultsChanges = this.lastDefaultsChanges;
        return namedNodeMapImpl;
    }

    private int findNamePoint(String string) {
        return this.findNamePoint(null, string);
    }

    private int findNamePoint(String string, String string2) {
        this.reconcileDefaults();
        int n = 0;
        if (this.nodes != null) {
            int n2 = 0;
            int n3 = this.nodes.size() - 1;
            while (n2 <= n3) {
                int n4;
                n = (n2 + n3) / 2;
                String string3 = ((NodeImpl)this.nodes.elementAt(n)).getNamespaceURI();
                int n5 = string == null ? (string3 == null ? 0 : 1) : (string3 == null ? -1 : string.compareTo(string3));
                String string4 = ((NodeImpl)this.nodes.elementAt(n)).getLocalName();
                int n6 = string4 == null ? -1 : string2.compareTo(((NodeImpl)this.nodes.elementAt(n)).getLocalName());
                int n7 = n4 = n5 != 0 ? n5 : n6;
                if (n4 == 0) {
                    return n;
                }
                if (n4 < 0) {
                    n3 = n - 1;
                    continue;
                }
                n2 = n + 1;
            }
            if (n2 > n) {
                n = n2;
            }
        }
        return -1 - n;
    }

    public int getLength() {
        this.reconcileDefaults();
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public Node getNamedItem(String string) {
        int n = this.findNamePoint(string);
        return n < 0 ? null : (Node)this.nodes.elementAt(n);
    }

    public Node getNamedItemNS(String string, String string2) {
        int n = this.findNamePoint(string, string2);
        return n < 0 ? null : (Node)this.nodes.elementAt(n);
    }

    public Node item(int n) {
        this.reconcileDefaults();
        return this.nodes != null && n < this.nodes.size() ? (Node)this.nodes.elementAt(n) : null;
    }

    protected void reconcileDefaults() {
        if (this.defaults != null && this.lastDefaultsChanges != this.defaults.changes) {
            int n = 0;
            int n2 = 0;
            int n3 = this.nodes != null ? this.nodes.size() : 0;
            int n4 = this.defaults.nodes.size();
            AttrImpl attrImpl = n3 == 0 ? null : (AttrImpl)this.nodes.elementAt(0);
            AttrImpl attrImpl2 = n4 == 0 ? null : (AttrImpl)this.defaults.nodes.elementAt(0);
            while (n < n3 && n2 < n4) {
                NodeImpl nodeImpl;
                int n5;
                attrImpl = (AttrImpl)this.nodes.elementAt(n);
                attrImpl2 = (AttrImpl)this.defaults.nodes.elementAt(n2);
                String string = attrImpl.getNamespaceURI();
                String string2 = attrImpl2.getNamespaceURI();
                int n6 = string == null ? (string2 == null ? 0 : 1) : (string2 == null ? -1 : string.compareTo(string2));
                System.out.println("n,d" + attrImpl.getLocalName() + "," + attrImpl2.getLocalName());
                int n7 = attrImpl.getLocalName().compareTo(attrImpl2.getLocalName());
                int n8 = n5 = n6 != 0 ? n6 : n7;
                if (n5 == 0 && !attrImpl.getSpecified()) {
                    nodeImpl = (NodeImpl)attrImpl2.cloneNode(true);
                    nodeImpl.parentNode = this.element;
                    this.nodes.setElementAt(nodeImpl, n);
                    ++n;
                    ++n2;
                    continue;
                }
                if (n5 > 0) {
                    nodeImpl = (NodeImpl)attrImpl2.cloneNode(true);
                    nodeImpl.parentNode = this.element;
                    this.nodes.insertElementAt(nodeImpl, n);
                    ++n;
                    ++n2;
                    continue;
                }
                if (!attrImpl.getSpecified()) {
                    this.nodes.removeElementAt(n);
                    continue;
                }
                ++n;
            }
            if (n2 < n4) {
                this.nodes = new Vector();
                while (n2 < n4) {
                    attrImpl2 = (AttrImpl)this.defaults.nodes.elementAt(n2++);
                    NodeImpl nodeImpl = (NodeImpl)attrImpl2.cloneNode(true);
                    nodeImpl.parentNode = this.element;
                    this.nodes.addElement(nodeImpl);
                }
            }
            this.lastDefaultsChanges = this.defaults.changes;
        }
    }

    public Node removeNamedItem(String string) {
        return this.removeNamedItemNS(null, string);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        Object object;
        Node node;
        int n = this.findNamePoint(string, string2);
        if (n < 0) {
            throw new DOMExceptionImpl(8, "NOT_FOUND_ERR");
        }
        LCount lCount = null;
        String string3 = "";
        AttrImpl attrImpl = null;
        if (this.element != null) {
            lCount = LCount.lookup("DOMAttrModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                attrImpl = (AttrImpl)this.nodes.elementAt(n);
                string3 = attrImpl.getNodeValue();
            }
        }
        Node node2 = (Node)this.nodes.elementAt(n);
        if (this.defaults != null && (node = this.defaults.getNamedItemNS(string, string2)) != null) {
            object = (NodeImpl)node.cloneNode(true);
            ((NodeImpl)object).parentNode = this.element;
            this.nodes.setElementAt(object, n);
        } else {
            this.nodes.removeElementAt(n);
        }
        if (this.element != null) {
            object = (AttrImpl)node2;
            ((NodeImpl)object).parentNode = null;
            ((AttrImpl)object).owned = false;
        }
        ++this.changes;
        if (this.element != null) {
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                object = new MutationEventImpl();
                object.initMutationEvent("DOMAttrModified", true, false, null, node2.getNodeValue(), this.element.getAttribute(string2), string2);
                this.element.dispatchEvent((Event)object);
            }
            this.element.dispatchAggregateEvents(null, null);
        }
        return node2;
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (node.getOwnerDocument() != this.ownerDocument) {
            throw new DOMExceptionImpl(4, "WRONG_DOCUMENT_ERR");
        }
        if (node instanceof AttrImpl && ((AttrImpl)node).owned) {
            throw new DOMExceptionImpl(10, "INUSE_ATTRIBUTE_ERR");
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        int n = this.findNamePoint(node.getNodeName());
        Node node2 = null;
        if (n >= 0) {
            node2 = (Node)this.nodes.elementAt(n);
            if (this.element != null) {
                ((NodeImpl)node).parentNode = this.element;
            }
            this.nodes.setElementAt(node, n);
        } else {
            n = -1 - n;
            if (this.nodes == null) {
                this.nodes = new Vector(5, 10);
            }
            if (this.element != null) {
                ((NodeImpl)node).parentNode = this.element;
            }
            this.nodes.insertElementAt(node, n);
        }
        if (this.element != null) {
            ((NodeImpl)node).parentNode = this.element;
        }
        ++this.changes;
        if (this.element != null) {
            this.element.dispatchAggregateEvents((AttrImpl)node, node2 == null ? null : node2.getNodeValue());
        }
        return node2;
    }

    void setReadOnly(boolean bl, boolean bl2) {
        this.readOnly = bl;
        if (bl2 && this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((NodeImpl)enumeration.nextElement()).setReadOnly(bl, bl2);
            }
        }
    }
}

