/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.utils.StringPool;

public final class DeferredAttrImpl
extends AttrImpl
implements DeferredNode {
    static final long serialVersionUID = 8793967374959140933L;
    protected transient int fNodeIndex;

    DeferredAttrImpl(DeferredDocumentImpl deferredDocumentImpl, int n) {
        super(deferredDocumentImpl, null);
        this.fNodeIndex = n;
        this.syncData = true;
        this.syncChildren = true;
    }

    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected void synchronizeChildren() {
        this.syncChildren = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        NodeImpl nodeImpl = null;
        int n = deferredDocumentImpl.getFirstChild(this.fNodeIndex);
        while (n != -1) {
            NodeImpl nodeImpl2 = (NodeImpl)((Object)deferredDocumentImpl.getNodeObject(n));
            if (nodeImpl == null) {
                this.firstChild = nodeImpl2;
            } else {
                nodeImpl.nextSibling = nodeImpl2;
            }
            nodeImpl2.parentNode = this;
            nodeImpl2.previousSibling = nodeImpl;
            nodeImpl = nodeImpl2;
            n = deferredDocumentImpl.getNextSibling(n);
        }
        if (nodeImpl != null) {
            this.lastChild = nodeImpl;
        }
    }

    protected void synchronizeData() {
        this.syncData = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        int n = deferredDocumentImpl.getNodeName(this.fNodeIndex);
        StringPool stringPool = deferredDocumentImpl.getStringPool();
        this.name = stringPool.toString(n);
        boolean bl = this.specified = deferredDocumentImpl.getNodeValue(this.fNodeIndex) == 1;
        if (deferredDocumentImpl.fNamespacesEnabled) {
            this.prefix = stringPool.toString(stringPool.getPrefixForQName(n));
            this.namespaceURI = stringPool.toString(stringPool.getURIForQName(n));
            this.localName = stringPool.toString(stringPool.getLocalPartForQName(n));
        } else {
            this.localName = this.name;
        }
    }
}

