/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeepNodeListImpl
implements NodeList {
    protected NodeImpl rootNode;
    protected String tagName;
    protected int changes = 0;
    protected Vector nodes;
    protected String nsName;
    protected boolean enableNS = false;

    public DeepNodeListImpl(NodeImpl nodeImpl, String string) {
        this.rootNode = nodeImpl;
        this.tagName = string;
        this.nodes = new Vector();
    }

    public DeepNodeListImpl(NodeImpl nodeImpl, String string, String string2) {
        this(nodeImpl, string2);
        this.nsName = string;
        this.enableNS = string != null && !string.equals("") && !string.equals("*");
    }

    public int getLength() {
        this.item(Integer.MAX_VALUE);
        return this.nodes.size();
    }

    public Node item(int n) {
        if (this.rootNode.changes != this.changes) {
            this.nodes = new Vector();
            this.changes = this.rootNode.changes;
        }
        if (n < this.nodes.size()) {
            return (Node)this.nodes.elementAt(n);
        }
        Node node = this.nodes.size() == 0 ? this.rootNode : (NodeImpl)this.nodes.lastElement();
        while (node != null && n >= this.nodes.size()) {
            if ((node = this.nextMatchingElementAfter(node)) == null) continue;
            this.nodes.addElement(node);
        }
        return node;
    }

    private Node nextMatchingElementAfter(Node node) {
        while (node != null) {
            Node node2;
            if (node.hasChildNodes()) {
                node = node.getFirstChild();
            } else if (node != this.rootNode && (node2 = node.getNextSibling()) != null) {
                node = node2;
            } else {
                node2 = null;
                while (node != this.rootNode) {
                    node2 = node.getNextSibling();
                    if (node2 != null) break;
                    node = node.getParentNode();
                }
                node = node2;
            }
            if (node == this.rootNode || node == null || node.getNodeType() != 1 || !this.tagName.equals("*") && !((ElementImpl)node).getTagName().equals(this.tagName) || this.enableNS && (!this.enableNS || ((ElementImpl)node).getNamespaceURI() == null || !((ElementImpl)node).getNamespaceURI().equals(this.nsName))) continue;
            return node;
        }
        return null;
    }
}

