/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CharacterDataImpl
extends NodeImpl
implements CharacterData {
    static final long serialVersionUID = 7931170150428474230L;
    private static transient NodeList singletonNodeList = new NodeList(){

        public int getLength() {
            return 0;
        }

        public Node item(int n) {
            return null;
        }
    };

    protected CharacterDataImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, null, string);
    }

    public void appendData(String string) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        this.setNodeValue(String.valueOf(this.value) + string);
    }

    public void deleteData(int n, int n2) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (n2 < 0) {
            throw new DOMExceptionImpl(1, "INDEX_SIZE_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        int n3 = Math.max(this.value.length() - n2 - n, 0);
        try {
            this.setNodeValue(String.valueOf(this.value.substring(0, n)) + (n3 > 0 ? this.value.substring(n + n2, n + n2 + n3) : ""));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "INDEX_SIZE_ERR");
        }
    }

    public NodeList getChildNodes() {
        return singletonNodeList;
    }

    public String getData() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value;
    }

    public int getLength() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value.length();
    }

    public abstract String getNodeName();

    public void insertData(int n, String string) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        try {
            this.setNodeValue(new StringBuffer(this.value).insert(n, string).toString());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "INDEX_SIZE_ERR");
        }
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        this.deleteData(n, n2);
        this.insertData(n, string);
    }

    public void setData(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public String substringData(int n, int n2) throws DOMException {
        if (this.syncData) {
            this.synchronizeData();
        }
        int n3 = this.value.length();
        if (n2 < 0 || n < 0 || n > n3 - 1) {
            throw new DOMExceptionImpl(1, "INDEX_SIZE_ERR");
        }
        int n4 = Math.min(n + n2, n3);
        return this.value.substring(n, n4);
    }
}

