/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttrImpl
extends NodeImpl
implements Attr {
    static final long serialVersionUID = -4421396439224009670L;
    protected boolean owned;
    protected boolean specified = true;
    protected String namespaceURI;
    protected String prefix;
    protected String localName;

    protected AttrImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string, null);
        this.localName = string;
        this.syncData = true;
    }

    protected AttrImpl(DocumentImpl documentImpl, String string, String string2) {
        this.ownerDocument = documentImpl;
        this.name = string2;
        this.namespaceURI = string;
        int n = string2.indexOf(58);
        if (n < 0) {
            this.prefix = null;
            this.localName = string2;
        } else {
            this.prefix = string2.substring(0, n);
            this.localName = string2.substring(n + 1);
        }
        this.syncData = true;
    }

    public Element getElement() {
        return (Element)((Object)this.parentNode);
    }

    public String getLocalName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.localName;
    }

    public String getName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public String getNamespaceURI() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public Element getOwnerElement() {
        return (Element)((Object)this.parentNode);
    }

    public Node getParentNode() {
        return null;
    }

    public String getPrefix() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.prefix;
    }

    public boolean getSpecified() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.specified;
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            stringBuffer.append(nodeImpl.getNodeValue());
            nodeImpl = nodeImpl.nextSibling;
        }
        return stringBuffer.toString();
    }

    public void setNodeValue(String string) throws DOMException {
        this.setValue(string);
    }

    public void setPrefix(String string) throws DOMException {
        if (this.syncData) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "INVALID_CHARACTER_ERR");
        }
        this.prefix = string;
        this.name = String.valueOf(string) + ":" + this.localName;
    }

    public void setSpecified(boolean bl) {
        if (this.syncData) {
            this.synchronizeData();
        }
        this.specified = bl;
    }

    public void setValue(String string) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "NO_MODIFICATION_ALLOWED_ERR");
        }
        LCount lCount = null;
        String string2 = "";
        lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0 && this.parentNode != null) {
            string2 = this.getValue();
        }
        while (this.firstChild != null) {
            this.internalRemoveChild(this.firstChild, 1);
        }
        this.specified = true;
        if (string != null) {
            this.internalInsertBefore(this.ownerDocument.createTextNode(string), null, 1);
        }
        this.changed();
        this.dispatchAggregateEvents(this, string2);
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + "\"" + this.getValue() + "\"";
    }
}

