/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt.client;

import java.applet.Applet;
import java.awt.Graphics;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XSLTProcessorApplet
extends Applet {
    transient XMLParserLiaison m_liaison = null;
    XSLTProcessor m_processor = null;
    private String m_styleURL;
    private String m_documentURL;
    private final String PARAM_styleURL = "styleURL";
    private final String PARAM_documentURL = "documentURL";
    private final String PARAM_parser = "parser";
    private String whichParser = null;
    private String m_styleURLOfCached = null;
    private String m_documentURLOfCached = null;
    private URL m_codeBase = null;
    private URL m_documentBase = null;
    private Document m_docTree = null;
    private Document m_styleTree = null;
    private transient Thread m_callThread = null;
    private transient TrustedAgent m_trustedAgent = null;
    private transient Thread m_trustedWorker = null;
    private transient String m_htmlText = null;
    private transient String m_nameOfIDAttrOfElemToModify = null;
    private transient String m_elemIdToModify = null;
    private transient String m_attrNameToSet = null;
    private transient String m_attrValueToSet = null;
    transient String m_key;
    transient String m_expression;

    static /* synthetic */ Thread access$0(XSLTProcessorApplet $0) {
        return $0.m_trustedWorker;
    }

    static /* synthetic */ String access$1(XSLTProcessorApplet $0) {
        return $0.m_htmlText;
    }

    public void destroy() {
        if (this.m_trustedWorker != null) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    private String doTransformation(XMLParserLiaison xmlProcessorLiaison, XSLTProcessor processor) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        URL documentURL = null;
        URL styleURL = null;
        StringWriter osw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)osw, false);
        if (this.m_key != null) {
            processor.setStylesheetParam(this.m_key, this.m_expression);
        }
        this.showStatus("Begin Transformation...");
        try {
            documentURL = new URL(this.m_codeBase, this.m_documentURL);
            XSLTInputSource xmlSource = new XSLTInputSource(documentURL.toString());
            Node xmlNode = this.m_processor.getSourceTreeFromInput(xmlSource);
            styleURL = new URL(this.m_codeBase, this.m_styleURL);
            XSLTInputSource xslSource = new XSLTInputSource(styleURL.toString());
            Node xslNode = this.m_processor.getSourceTreeFromInput(xslSource);
            if (xmlNode == null) {
                System.out.println("XML Source Node is null");
            }
            if (xmlNode.getNodeType() == 9) {
                this.m_docTree = (Document)xmlNode;
            } else {
                System.out.println("XML source document node type is " + xmlNode.getNodeType());
            }
            if (xslNode.getNodeType() == 9) {
                this.m_styleTree = (Document)xslNode;
            } else {
                System.out.println("Stylesheet source document node type is " + xslNode.getNodeType());
            }
            processor.process(xmlSource, xslSource, new XSLTResultTarget(pw));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.showStatus("Transformation Done!");
        String htmlData = osw.toString();
        return htmlData;
    }

    public String escapeString(String s) {
        StringBuffer sb = new StringBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char ch = s.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
            } else if (ch == '>') {
                sb.append("&gt;");
            } else if (ch == '&') {
                sb.append("&amp;");
            } else if (ch >= '\ud800' && ch < '\udc00') {
                int next;
                if (i + 1 >= length) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " ?");
                }
                if ((next = s.charAt(++i)) < 56320 || next >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " " + Integer.toHexString(next));
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                sb.append("&#x");
                sb.append(Integer.toHexString(next));
                sb.append(";");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public void freeCache() {
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public String getAppletInfo() {
        return "Name: XSLTProcessorApplet\r\nAuthor: Scott Boag";
    }

    public String getHtmlText() {
        this.m_trustedAgent.m_getData = true;
        this.m_callThread = Thread.currentThread();
        try {
            Thread thread = this.m_callThread;
            synchronized (thread) {
                this.m_callThread.wait();
            }
        }
        catch (InterruptedException ie) {
            System.out.println(ie.getMessage());
        }
        return this.m_htmlText;
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"styleURL", "String", "URL to a XSL style sheet"}, {"documentURL", "String", "URL to a XML document"}, {"parser", "String", "Which parser to use: XML4J or ANY"}};
        return info;
    }

    public String getResultTreeAsText() throws Exception {
        return this.escapeString(this.getHtmlText());
    }

    public String getSourceTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_documentURL);
    }

    public String getStyleTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_styleURL);
    }

    public String getTreeAsText(String treeURL) throws IOException {
        String text = "";
        byte[] buffer = new byte[50000];
        try {
            int nun_chars;
            URL docURL = new URL(this.m_documentBase, treeURL);
            InputStream in = docURL.openStream();
            while ((nun_chars = in.read(buffer, 0, buffer.length)) != -1) {
                text = String.valueOf(text) + new String(buffer, 0, nun_chars);
            }
            in.close();
        }
        catch (Exception any_error) {
            any_error.printStackTrace();
        }
        return text;
    }

    public void init() {
        String param = this.getParameter("parser");
        this.whichParser = param != null ? param : "ANY";
        param = this.getParameter("styleURL");
        if (param != null) {
            this.setStyleURL(param);
        }
        if ((param = this.getParameter("documentURL")) != null) {
            this.setDocumentURL(param);
        }
        this.m_codeBase = this.getCodeBase();
        this.m_documentBase = this.getDocumentBase();
        this.resize(320, 240);
        this.initLiaison();
    }

    protected void initLiaison() {
        String parserName = "org.apache.xalan.xpath.dtm.DTMLiaison";
        try {
            Class<?> parserLiaisonClass = Class.forName(parserName);
            Constructor<?> parserLiaisonCtor = parserLiaisonClass.getConstructor(null);
            this.m_liaison = (XMLParserLiaison)parserLiaisonCtor.newInstance(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            this.m_processor = XSLTProcessorFactory.getProcessor();
            this.m_processor.setDiagnosticsOutput(System.out);
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new RuntimeException(se.getMessage());
        }
    }

    public void paint(Graphics g) {
    }

    private String processTransformation() throws XSLProcessorException, MalformedURLException, IOException, FileNotFoundException, SAXException {
        String htmlData;
        block6: {
            htmlData = null;
            try {
                if (this.whichParser.trim().equals("XML4J") || this.whichParser.trim().equals("ANY")) {
                    this.showStatus("Waiting for XSLT4J and XML4J to finish loading and JITing...");
                    XSLTProcessor xSLTProcessor = this.m_processor;
                    synchronized (xSLTProcessor) {
                        this.m_processor.reset();
                        htmlData = this.doTransformation(this.m_liaison, this.m_processor);
                        break block6;
                    }
                }
                System.out.println("XSLTProcessorApplet only works with XML4J at the moment!");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println("Can not find " + this.whichParser + " XML Processor!!");
            }
        }
        return htmlData;
    }

    public void setDocumentURL(String urlString) {
        this.m_documentURL = urlString;
    }

    public void setStyleSheetAttribute(String nameOfIDAttrOfElemToModify, String elemId, String attrName, String value) {
        this.m_nameOfIDAttrOfElemToModify = nameOfIDAttrOfElemToModify;
        this.m_elemIdToModify = elemId;
        this.m_attrNameToSet = attrName;
        this.m_attrValueToSet = value;
    }

    public void setStyleURL(String urlString) {
        this.m_styleURL = urlString;
    }

    public void setStylesheetParam(String key, String expr) {
        this.m_key = key;
        this.m_expression = expr;
    }

    public void start() {
        this.m_trustedAgent = new TrustedAgent();
        Thread currentThread = Thread.currentThread();
        this.m_trustedWorker = new Thread(currentThread.getThreadGroup(), this.m_trustedAgent);
        this.m_trustedWorker.start();
        try {
            this.showStatus("Causing XSLT4J and XML4J to Load and JIT...");
            StringReader xmlbuf = new StringReader("<?xml version='1.0'?><foo/>");
            StringReader xslbuf = new StringReader("<?xml version='1.0'?><xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform'><xsl:template match='foo'><out/></xsl:template></xsl:stylesheet>");
            PrintWriter pw = new PrintWriter(new StringWriter());
            XSLTProcessor xSLTProcessor = this.m_processor;
            synchronized (xSLTProcessor) {
                this.m_processor.process(new XSLTInputSource(xmlbuf), new XSLTInputSource(xslbuf), new XSLTResultTarget(pw));
                this.showStatus("PRIMED the pump!");
            }
            this.showStatus("Ready to click!");
        }
        catch (Exception e) {
            this.showStatus("Could not prime the pump!");
            System.out.println("Could not prime the pump!");
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.m_trustedWorker != null) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public String transformToHtml(String doc) {
        if (doc != null) {
            this.m_documentURL = doc;
        }
        this.m_styleURL = null;
        return this.getHtmlText();
    }

    public String transformToHtml(String doc, String style) {
        if (doc != null) {
            this.m_documentURL = doc;
        }
        if (style != null) {
            this.m_styleURL = style;
        }
        return this.getHtmlText();
    }

    class TrustedAgent
    implements Runnable {
        public boolean m_getData = false;

        TrustedAgent() {
        }

        public void run() {
            while (true) {
                Thread.yield();
                if (this.m_getData) {
                    Thread thread;
                    Object var2_3;
                    try {
                        try {
                            this.m_getData = false;
                            XSLTProcessorApplet.this.m_htmlText = null;
                            XSLTProcessorApplet.this.m_htmlText = XSLTProcessorApplet.this.processTransformation();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        var2_3 = null;
                    }
                    catch (Throwable throwable) {
                        var2_3 = null;
                        thread = XSLTProcessorApplet.this.m_callThread;
                        synchronized (thread) {
                            XSLTProcessorApplet.this.m_callThread.notify();
                        }
                        throw throwable;
                    }
                    thread = XSLTProcessorApplet.this.m_callThread;
                    synchronized (thread) {
                        XSLTProcessorApplet.this.m_callThread.notify();
                    }
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

