/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.TooManyListenersException;
import org.apache.xalan.xpath.XPathException;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.StylesheetRoot;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLProcessorVersion;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.apache.xalan.xslt.res.XSLTErrorResources;
import org.apache.xalan.xslt.trace.PrintTraceListener;
import org.apache.xalan.xslt.trace.TraceListener;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Process {
    public static void main(String[] argv) {
        block145: {
            Object var29_34;
            XMLParserLiaison xmlProcessorLiaison;
            XSLTErrorResources resbundle;
            PrintWriter dumpWriter;
            PrintWriter diagnosticsWriter;
            boolean setQuietMode;
            boolean doStackDumpOnError;
            block144: {
                Runtime.getRuntime().traceMethodCalls(false);
                doStackDumpOnError = false;
                setQuietMode = false;
                dumpWriter = diagnosticsWriter = new PrintWriter(System.err, true);
                resbundle = (XSLTErrorResources)XSLMessages.loadResourceBundle("org.apache.xalan.xslt.res.XSLTErrorResources");
                if (argv.length >= 1) break block144;
                Process.printArgOptions(resbundle);
                break block145;
            }
            String parserLiaisonClassName = "org.apache.xalan.xpath.dtm.DTMLiaison";
            try {
                boolean usingDefault = true;
                int i = 0;
                while (i < argv.length) {
                    if ("-PARSER".equalsIgnoreCase(argv[i])) {
                        parserLiaisonClassName = argv[++i];
                        usingDefault = false;
                    }
                    ++i;
                }
                Class<?> parserLiaisonClass = Class.forName(parserLiaisonClassName);
                Constructor<?> parserLiaisonCtor = parserLiaisonClass.getConstructor(null);
                xmlProcessorLiaison = (XMLParserLiaison)parserLiaisonCtor.newInstance(null);
            }
            catch (Exception exception) {
                System.err.println(XSLMessages.createMessage(25, new Object[]{parserLiaisonClassName}));
                return;
            }
            XSLTProcessor processor = XSLTProcessorFactory.getProcessor(xmlProcessorLiaison);
            boolean formatOutput = false;
            Object mode = null;
            String inFileName = null;
            String outFileName = null;
            String dumpFileName = null;
            String xslFileName = null;
            String compiledStylesheetFileNameOut = null;
            String compiledStylesheetFileNameIn = null;
            String treedumpFileName = null;
            boolean didSetCR = false;
            boolean didSetLF = false;
            boolean stripCData = false;
            boolean escapeCData = false;
            boolean useXercesSerializers = false;
            PrintTraceListener tracer = null;
            OutputStream compiledStylesheetOutputStream = null;
            ObjectOutputStream compiledStylesheetOutput = null;
            String outputType = null;
            int i = 0;
            while (i < argv.length) {
                if ("-TT".equalsIgnoreCase(argv[i])) {
                    if (tracer == null) {
                        tracer = new PrintTraceListener(diagnosticsWriter);
                    }
                    tracer.m_traceTemplates = true;
                } else if ("-TG".equalsIgnoreCase(argv[i])) {
                    if (tracer == null) {
                        tracer = new PrintTraceListener(diagnosticsWriter);
                    }
                    tracer.m_traceGeneration = true;
                }
                if ("-TS".equalsIgnoreCase(argv[i])) {
                    if (tracer == null) {
                        tracer = new PrintTraceListener(diagnosticsWriter);
                    }
                    tracer.m_traceSelection = true;
                } else if ("-TTC".equalsIgnoreCase(argv[i])) {
                    if (tracer == null) {
                        tracer = new PrintTraceListener(diagnosticsWriter);
                    }
                    tracer.m_traceElements = true;
                }
                if ("-TCLASS".equalsIgnoreCase(argv[i])) {
                    if (i + 1 < argv.length) {
                        String className = argv[++i];
                        try {
                            Class<?> traceClass = Class.forName(className);
                            Constructor<?> traceCtor = traceClass.getConstructor(null);
                            TraceListener traceL = (TraceListener)traceCtor.newInstance(null);
                            processor.addTraceListener(traceL);
                        }
                        catch (Exception exception) {
                            System.err.println(XSLMessages.createMessage(29, new Object[]{className}));
                        }
                    } else {
                        System.err.println(XSLMessages.createMessage(89, new Object[]{"-TCLASS"}));
                    }
                } else if ("-ESCAPE".equalsIgnoreCase(argv[i])) {
                    if (i + 1 < argv.length) {
                        xmlProcessorLiaison.setSpecialCharacters(argv[++i]);
                    } else {
                        System.err.println(XSLMessages.createMessage(89, new Object[]{"-ESCAPE"}));
                    }
                } else if ("-INDENT".equalsIgnoreCase(argv[i])) {
                    int indentAmount = i + 1 < argv.length && argv[i + 1].charAt(0) != '-' ? Integer.parseInt(argv[++i]) : 0;
                    xmlProcessorLiaison.setIndent(indentAmount);
                } else if ("-IN".equalsIgnoreCase(argv[i])) {
                    if (i + 1 < argv.length) {
                        inFileName = argv[++i];
                    } else {
                        System.err.println(XSLMessages.createMessage(89, new Object[]{"-IN"}));
                    }
                } else if ("-OUT".equalsIgnoreCase(argv[i])) {
                    if (i + 1 < argv.length) {
                        outFileName = argv[++i];
                    } else {
                        System.err.println(XSLMessages.createMessage(89, new Object[]{"-OUT"}));
                    }
                } else if ("-XSL".equalsIgnoreCase(argv[i])) {
                    if (i + 1 < argv.length) {
                        xslFileName = argv[++i];
                    } else {
                        System.err.println(XSLMessages.createMessage(89, new Object[]{"-XSL"}));
                    }
                } else if ("-LXCIN".equalsIgnoreCase(argv[i])) {
                    if (i + 1 < argv.length) {
                        compiledStylesheetFileNameIn = argv[++i];
                    } else {
                        System.err.println(XSLMessages.createMessage(89, new Object[]{"-LXCIN"}));
                    }
                } else if ("-LXCOUT".equalsIgnoreCase(argv[i])) {
                    if (i + 1 < argv.length) {
                        compiledStylesheetFileNameOut = argv[++i];
                    } else {
                        System.err.println(XSLMessages.createMessage(89, new Object[]{"-LXCOUT"}));
                    }
                } else if ("-PARAM".equalsIgnoreCase(argv[i])) {
                    if (i + 2 < argv.length) {
                        String name = argv[++i];
                        String expression = argv[++i];
                        processor.setStylesheetParam(name, expression);
                    } else {
                        System.err.println(XSLMessages.createMessage(89, new Object[]{"-PARAM"}));
                    }
                } else if ("-treedump".equalsIgnoreCase(argv[i])) {
                    if (i + 1 < argv.length) {
                        treedumpFileName = argv[++i];
                    } else {
                        System.err.println(XSLMessages.createMessage(89, new Object[]{"-treedump"}));
                    }
                } else if ("-F".equalsIgnoreCase(argv[i])) {
                    formatOutput = true;
                } else if ("-E".equalsIgnoreCase(argv[i])) {
                    xmlProcessorLiaison.SetShouldExpandEntityRefs(false);
                } else if ("-V".equalsIgnoreCase(argv[i])) {
                    diagnosticsWriter.println(String.valueOf(resbundle.getString("version")) + XSLProcessorVersion.S_VERSION + ", " + xmlProcessorLiaison.getParserDescription() + resbundle.getString("version2"));
                } else if ("-QC".equalsIgnoreCase(argv[i])) {
                    processor.setQuietConflictWarnings(true);
                } else if ("-Q".equalsIgnoreCase(argv[i])) {
                    setQuietMode = true;
                } else if ("-VALIDATE".equalsIgnoreCase(argv[i])) {
                    String shouldValidate = i + 1 < argv.length && argv[i + 1].charAt(0) != '-' ? argv[++i] : "yes";
                    xmlProcessorLiaison.setUseValidation(shouldValidate.equalsIgnoreCase("yes"));
                } else if ("-PARSER".equalsIgnoreCase(argv[i])) {
                    ++i;
                } else if ("-XML".equalsIgnoreCase(argv[i])) {
                    outputType = "xml";
                } else if ("-TEXT".equalsIgnoreCase(argv[i])) {
                    outputType = "text";
                } else if ("-HTML".equalsIgnoreCase(argv[i])) {
                    outputType = "html";
                } else if ("-STRIPCDATA".equalsIgnoreCase(argv[i])) {
                    stripCData = true;
                } else if ("-ESCAPECDATA".equalsIgnoreCase(argv[i])) {
                    escapeCData = true;
                } else if ("-ESCAPECDATA".equalsIgnoreCase(argv[i])) {
                    useXercesSerializers = true;
                } else if ("-EDUMP".equalsIgnoreCase(argv[i])) {
                    doStackDumpOnError = true;
                    if (i + 1 < argv.length && argv[i + 1].charAt(0) != '-') {
                        dumpFileName = argv[++i];
                    }
                } else {
                    System.err.println(XSLMessages.createMessage(90, new Object[]{argv[i]}));
                }
                ++i;
            }
            try {
                try {
                    processor.setDiagnosticsOutput(setQuietMode ? null : diagnosticsWriter);
                    if (dumpFileName != null) {
                        dumpWriter = new PrintWriter(new FileWriter(dumpFileName));
                    }
                    StylesheetRoot stylesheet = null;
                    if (compiledStylesheetFileNameIn != null) {
                        try {
                            FileInputStream fileInputStream = new FileInputStream(compiledStylesheetFileNameIn);
                            ObjectInputStream objectInput = new ObjectInputStream(fileInputStream);
                            stylesheet = (StylesheetRoot)objectInput.readObject();
                            objectInput.close();
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            stylesheet = null;
                            diagnosticsWriter.println(XSLMessages.createMessage(28, new Object[]{stylesheet.m_encoding}));
                            throw new XSLProcessorException(XSLMessages.createMessage(28, new Object[]{stylesheet.m_encoding}));
                        }
                    } else if (xslFileName != null) {
                        stylesheet = processor.processStylesheet(xslFileName);
                    }
                    Object mimeEncoding = null;
                    OutputStream outputStream = null;
                    if (outFileName != null) {
                        outputStream = new FileOutputStream(outFileName);
                    }
                    if (outputStream == null) {
                        outputStream = System.out;
                    }
                    if (stylesheet != null) {
                        if (outputType != null) {
                            stylesheet.setOutputMethod(outputType);
                        }
                        stylesheet.m_useXercesSerializers = useXercesSerializers;
                    }
                    if (tracer != null) {
                        processor.addTraceListener(tracer);
                    }
                    if (inFileName != null) {
                        if (stylesheet != null) {
                            Node sourceTree = processor.getSourceTreeFromInput(new XSLTInputSource(inFileName));
                            stylesheet.process(processor, sourceTree, new XSLTResultTarget(outputStream));
                        } else {
                            processor.process(new XSLTInputSource(inFileName), null, new XSLTResultTarget(outputStream));
                        }
                    } else if (stylesheet != null && compiledStylesheetFileNameOut == null) {
                        Document dummyDoc = xmlProcessorLiaison.createDocument();
                        stylesheet.process(processor, dummyDoc, new XSLTResultTarget(outputStream));
                    }
                    if (stylesheet != null && compiledStylesheetFileNameOut != null) {
                        compiledStylesheetOutputStream = new FileOutputStream(compiledStylesheetFileNameOut);
                        compiledStylesheetOutput = new ObjectOutputStream(compiledStylesheetOutputStream);
                        compiledStylesheetOutput.writeObject(stylesheet);
                    }
                }
                catch (TooManyListenersException tmle) {
                    if (doStackDumpOnError) {
                        tmle.printStackTrace(dumpWriter);
                    }
                    diagnosticsWriter.println(XSLMessages.createMessage(27, null));
                }
                catch (XPathException xpe) {
                    if (doStackDumpOnError) {
                        xpe.printStackTrace(dumpWriter);
                    }
                    if (xpe.m_styleNode != null && xpe.m_styleNode instanceof ElemTemplateElement) {
                        ElemTemplateElement elem = (ElemTemplateElement)xpe.m_styleNode;
                        diagnosticsWriter.println(String.valueOf(elem.m_stylesheet.m_baseIdent) + "; " + resbundle.getString("line") + elem.m_lineNumber + "; " + resbundle.getString("column") + elem.m_columnNumber + "; " + xpe.getMessage());
                    } else if (xpe instanceof XSLProcessorException) {
                        diagnosticsWriter.println("XSLT: " + xpe.getMessage());
                    } else {
                        diagnosticsWriter.println("XPATH: " + xpe.getMessage());
                    }
                    diagnosticsWriter.println(XSLMessages.createMessage(27, null));
                }
                catch (SAXException se) {
                    Exception containedException = se.getException();
                    if (containedException != null) {
                        if (doStackDumpOnError) {
                            containedException.printStackTrace(dumpWriter);
                        }
                        diagnosticsWriter.println(XSLMessages.createMessage(27, null));
                    } else {
                        if (doStackDumpOnError) {
                            se.printStackTrace(dumpWriter);
                        }
                        diagnosticsWriter.println(XSLMessages.createMessage(27, null));
                    }
                }
                catch (MalformedURLException mue) {
                    if (doStackDumpOnError) {
                        mue.printStackTrace(dumpWriter);
                    } else {
                        System.out.println("Error! " + mue.getMessage());
                    }
                    diagnosticsWriter.println(XSLMessages.createMessage(27, null));
                }
                catch (ClassNotFoundException cnfe) {
                    if (doStackDumpOnError) {
                        cnfe.printStackTrace(dumpWriter);
                    } else {
                        System.out.println("Error! " + cnfe.getMessage());
                    }
                    diagnosticsWriter.println(XSLMessages.createMessage(27, null));
                }
                catch (FileNotFoundException fne) {
                    if (doStackDumpOnError) {
                        fne.printStackTrace(dumpWriter);
                    } else {
                        System.out.println("Error! " + fne.getMessage());
                    }
                    diagnosticsWriter.println(XSLMessages.createMessage(27, null));
                }
                catch (IOException ioe) {
                    if (doStackDumpOnError) {
                        ioe.printStackTrace(dumpWriter);
                    } else {
                        System.out.println("Error! " + ioe.getMessage());
                    }
                    diagnosticsWriter.println(XSLMessages.createMessage(27, null));
                }
                catch (NoClassDefFoundError ncdfe) {
                    String msg = ncdfe.getMessage();
                    if (msg.indexOf("com/ibm/xml/parser/Parser") >= 0) {
                        diagnosticsWriter.println("==========================================");
                        diagnosticsWriter.println(resbundle.getString("noParsermsg1"));
                        diagnosticsWriter.println(resbundle.getString("noParsermsg2"));
                        diagnosticsWriter.println(resbundle.getString("noParsermsg3"));
                        diagnosticsWriter.println(resbundle.getString("noParsermsg4"));
                        diagnosticsWriter.println(resbundle.getString("noParsermsg5"));
                        diagnosticsWriter.println("==========================================");
                    }
                    if (doStackDumpOnError) {
                        ncdfe.printStackTrace(dumpWriter);
                    } else {
                        System.out.println("Error! " + ncdfe.getMessage());
                    }
                    diagnosticsWriter.println(XSLMessages.createMessage(27, null));
                }
                var29_34 = null;
            }
            catch (Throwable throwable) {
                var29_34 = null;
                try {
                    if (compiledStylesheetOutput != null) {
                        compiledStylesheetOutput.flush();
                        compiledStylesheetOutput.close();
                    }
                    if (compiledStylesheetOutputStream != null) {
                        compiledStylesheetOutputStream.flush();
                        ((FileOutputStream)compiledStylesheetOutputStream).close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (compiledStylesheetOutput != null) {
                    compiledStylesheetOutput.flush();
                    compiledStylesheetOutput.close();
                }
                if (compiledStylesheetOutputStream != null) {
                    compiledStylesheetOutputStream.flush();
                    ((FileOutputStream)compiledStylesheetOutputStream).close();
                }
            }
            catch (Exception exception) {}
            if (dumpFileName != null) {
                dumpWriter.close();
            }
            if (!setQuietMode) {
                diagnosticsWriter.println(resbundle.getString("xsldone"));
            } else {
                diagnosticsWriter.println("");
            }
        }
    }

    protected static void printArgOptions(XSLTErrorResources resbundle) {
        System.out.println(resbundle.getString("xslProc_option"));
        System.out.println(resbundle.getString("optionIN"));
        System.out.println(resbundle.getString("optionXSL"));
        System.out.println(resbundle.getString("optionOUT"));
        System.out.println(resbundle.getString("optionLXCIN"));
        System.out.println(resbundle.getString("optionLXCOUT"));
        System.out.println(resbundle.getString("optionPARSER"));
        System.out.println(resbundle.getString("optionE"));
        System.out.println(resbundle.getString("optionV"));
        System.out.println(resbundle.getString("optionQC"));
        System.out.println(resbundle.getString("optionQ"));
        System.out.println(resbundle.getString("optionLF"));
        System.out.println(resbundle.getString("optionCR"));
        System.out.println(resbundle.getString("optionESCAPE"));
        System.out.println(resbundle.getString("optionINDENT"));
        System.out.println(resbundle.getString("optionTT"));
        System.out.println(resbundle.getString("optionTG"));
        System.out.println(resbundle.getString("optionTS"));
        System.out.println(resbundle.getString("optionTTC"));
        System.out.println(resbundle.getString("optionTCLASS"));
        System.out.println(resbundle.getString("optionVALIDATE"));
        System.out.println(resbundle.getString("optionEDUMP"));
        System.out.println(resbundle.getString("optionXML"));
        System.out.println(resbundle.getString("optionTEXT"));
        System.out.println(resbundle.getString("optionHTML"));
        System.out.println(resbundle.getString("optionPARAM"));
        System.out.println("[-SX (User Xerces Serializers]");
    }
}

