/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.xalan.xslt.DecimalToRoman;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NumeratorFormatter {
    protected Element m_xslNumberElement;
    NumberFormatStringTokenizer m_formatTokenizer;
    Locale m_locale;
    NumberFormat m_formatter;
    XSLTEngineImpl m_processor;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};
    private static final char[] m_alphaCountTable = new char[]{'Z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};

    NumeratorFormatter(Element xslNumberElement, XSLTEngineImpl processor) {
        this.m_xslNumberElement = xslNumberElement;
        this.m_processor = processor;
    }

    /*
     * Unable to fully structure code
     */
    String formatNumberList(int[] list) {
        formattedNumber = "";
        nNumbers = list.length;
        numberType = 49;
        numberWidth = 1;
        sepString = "";
        lastSepString = null;
        padString = this.m_formatter.format(0L);
        lookahead = null;
        this.m_formatTokenizer.reset();
        i = 0;
        ** GOTO lbl63
        {
            block17: {
                if (lookahead != null) {
                    formatToken = lookahead;
                    lookahead = null;
                } else {
                    formatToken = this.m_formatTokenizer.nextToken();
                }
                if (!Character.isLetterOrDigit(formatToken.charAt(formatToken.length() - 1))) break block17;
                numberWidth = formatToken.length();
                numberType = formatToken.charAt(numberWidth - 1);
                ** GOTO lbl39
            }
            sepString = formatToken;
            while (this.m_formatTokenizer.hasMoreTokens()) {
                lookahead = this.m_formatTokenizer.nextToken();
                if (Character.isLetterOrDigit(lookahead.charAt(0))) break;
                sepString = String.valueOf(sepString) + lookahead;
                lookahead = null;
            }
            if (!this.m_formatTokenizer.hasMoreTokens()) {
                lastSepString = sepString;
                k = lastPos = sepString.length() - 1;
                while (k >= 0) {
                    if (!Character.isWhitespace(sepString.charAt(k))) break;
                    --k;
                }
                sepString = sepString.substring(0, k + 1);
            }
            do {
                if (this.m_formatTokenizer.hasMoreTokens()) continue block6;
lbl39:
                // 2 sources

                switch (numberType) {
                    case 65: {
                        formattedNumber = String.valueOf(formattedNumber) + sepString + this.int2alphaCount(list[i], NumeratorFormatter.m_alphaCountTable);
                        break;
                    }
                    case 97: {
                        formattedNumber = String.valueOf(formattedNumber) + sepString + this.int2alphaCount(list[i], NumeratorFormatter.m_alphaCountTable).toLowerCase(this.m_locale);
                        break;
                    }
                    case 73: {
                        formattedNumber = String.valueOf(formattedNumber) + sepString + this.long2roman(list[i], true);
                        break;
                    }
                    case 105: {
                        formattedNumber = String.valueOf(formattedNumber) + sepString + this.long2roman(list[i], true).toLowerCase(this.m_locale);
                        break;
                    }
                    default: {
                        numString = this.m_formatter.format(list[i]);
                        nPadding = numberWidth - numString.length();
                        formattedNumber = String.valueOf(formattedNumber) + sepString;
                        k = 0;
                        while (k < nPadding) {
                            formattedNumber = String.valueOf(formattedNumber) + padString;
                            ++k;
                        }
                        formattedNumber = String.valueOf(formattedNumber) + numString;
                    }
                }
                ++i;
lbl63:
                // 2 sources

            } while (i < nNumbers);
        }
        if (lastSepString == null) {
            lastSepString = "";
            while (this.m_formatTokenizer.hasMoreTokens()) {
                lookahead = this.m_formatTokenizer.nextToken();
                lastSepString = Character.isLetterOrDigit(lookahead.charAt(0)) == false ? String.valueOf(lastSepString) + lookahead : "";
            }
        }
        if (lastSepString != null) {
            formattedNumber = String.valueOf(formattedNumber) + lastSepString;
        }
        return formattedNumber;
    }

    protected String int2alphaCount(int val, char[] table) {
        int radix = table.length;
        char[] buf = new char[100];
        int charPos = buf.length - 1;
        int lookupIndex = 1;
        int correction = 0;
        while ((lookupIndex = (val + (correction = lookupIndex == 0 || correction != 0 && lookupIndex == radix - 1 ? radix - 1 : 0)) % radix) != 0 || (val /= radix) != 0) {
            buf[charPos--] = table[lookupIndex];
            if (val > 0) continue;
        }
        return new String(buf, charPos + 1, buf.length - charPos - 1);
    }

    protected String long2roman(long val, boolean prefixesAreOK) {
        if (val <= 0L) {
            return "#E(" + val + ")";
        }
        String roman = "";
        int place = 0;
        if (val <= 3999L) {
            while (true) {
                if (val >= NumeratorFormatter.m_romanConvertTable[place].m_postValue) {
                    roman = String.valueOf(roman) + NumeratorFormatter.m_romanConvertTable[place].m_postLetter;
                    val -= NumeratorFormatter.m_romanConvertTable[place].m_postValue;
                    continue;
                }
                if (prefixesAreOK && val >= NumeratorFormatter.m_romanConvertTable[place].m_preValue) {
                    roman = String.valueOf(roman) + NumeratorFormatter.m_romanConvertTable[place].m_preLetter;
                    val -= NumeratorFormatter.m_romanConvertTable[place].m_preValue;
                }
                ++place;
                if (val <= 0L) break;
            }
        } else {
            roman = "#error";
        }
        return roman;
    }

    void processAttributes(Node contextNode) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException {
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        public NumberFormatStringTokenizer(String str) {
            this.str = str;
            this.maxPosition = str.length();
        }

        public int countTokens() {
            int count = 0;
            int currpos = this.currentPosition;
            while (currpos < this.maxPosition) {
                int start = currpos;
                while (currpos < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(currpos))) {
                    ++currpos;
                }
                if (start == currpos && !Character.isLetterOrDigit(this.str.charAt(currpos))) {
                    ++currpos;
                }
                ++count;
            }
            return count;
        }

        public boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        public String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int start = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (start == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(start, this.currentPosition);
        }

        public void reset() {
            this.currentPosition = 0;
        }
    }
}

