/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Vector;
import org.apache.xalan.xpath.Function;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLProcessorException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FuncFormatNumb
extends Function {
    public XObject execute(XPath path, XPathSupport execContext, Node context, int opPos, Vector args) throws SAXException {
        ElemTemplateElement templElem = (ElemTemplateElement)execContext.getNamespaceContext();
        Stylesheet ss = templElem.m_stylesheet;
        NumberFormat formatter = null;
        DecimalFormatSymbols dfs = null;
        double num = ((XObject)args.elementAt(0)).num();
        String patternStr = ((XObject)args.elementAt(1)).str();
        if (patternStr.indexOf(164) > 0) {
            ss.error(82);
        }
        int nArgs = args.size();
        try {
            if (nArgs == 3) {
                String formatStr = ((XObject)args.elementAt(2)).str();
                dfs = ss.getDecimalFormatElem(formatStr);
                if (dfs == null) {
                    this.warn(execContext, 17, new Object[]{formatStr});
                } else {
                    formatter = new DecimalFormat();
                    ((DecimalFormat)formatter).setDecimalFormatSymbols(dfs);
                    ((DecimalFormat)formatter).applyLocalizedPattern(patternStr);
                }
            }
            if (formatter == null) {
                dfs = ss.getDecimalFormatElem("#default");
                formatter = dfs == null ? new DecimalFormat(patternStr) : new DecimalFormat();
                ((DecimalFormat)formatter).setDecimalFormatSymbols(dfs);
                ((DecimalFormat)formatter).applyLocalizedPattern(patternStr);
            }
            return new XString(formatter.format(num));
        }
        catch (Exception exception) {
            ss.error(91, new Object[]{patternStr});
            return new XString("");
        }
    }

    public void warn(XPathSupport execContext, int msg, Object[] args) throws SAXException {
        String formattedMsg = XSLMessages.createWarning(msg, args);
        XMLParserLiaison parserLiaison = (XMLParserLiaison)execContext;
        boolean shouldThrow = parserLiaison.getProblemListener().problem((short)2, (short)1, null, null, formattedMsg, null, 0, 0);
        if (shouldThrow) {
            throw new XSLProcessorException(formattedMsg);
        }
    }
}

