/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import com.ibm.bsf.BSFManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.xpath.ExtensionFunctionHandler;
import org.apache.xalan.xpath.XPathProcessorException;
import org.apache.xalan.xpath.dtm.DTMLiaison;
import org.apache.xalan.xpath.xdom.XercesLiaison;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLProcessorContext;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExtensionNSHandler
extends ExtensionFunctionHandler {
    XSLTEngineImpl xslp;
    Hashtable elements = new Hashtable();
    boolean componentDescLoaded;
    static /* synthetic */ Class class$com$ibm$bsf$BSFManager;

    public ExtensionNSHandler(XSLTEngineImpl xslp, String namespaceUri) {
        super(namespaceUri);
        this.xslp = xslp;
    }

    public ExtensionNSHandler(XSLTEngineImpl xslp, String namespaceUri, String elemNames, String funcNames, String lang, String srcURL, String src) {
        super(namespaceUri, funcNames, lang, srcURL, src);
        this.xslp = xslp;
        this.setElements(elemNames);
        this.componentDescLoaded = true;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private String getScriptString(Element elem) {
        StringBuffer strBuf = new StringBuffer();
        Node n = elem.getFirstChild();
        while (n != null) {
            switch (n.getNodeType()) {
                case 3: 
                case 4: {
                    strBuf.append(((CharacterData)n).getData());
                    break;
                }
            }
            n = n.getNextSibling();
        }
        return strBuf.toString();
    }

    public boolean isElementAvailable(String element) {
        return this.elements.get(element) != null;
    }

    private void loadComponentDescription() throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        try {
            String cname = this.namespaceUri.startsWith("class:") ? this.namespaceUri.substring(6) : this.namespaceUri;
            Class.forName(cname);
            this.setScript("javaclass", this.namespaceUri, null);
            this.componentDescLoaded = true;
            return;
        }
        catch (Exception exception) {
            URL url = this.xslp.getURLFromString(this.namespaceUri, this.xslp.m_stylesheetRoot.m_baseIdent);
            XMLParserLiaison liaison = this.xslp.m_parserLiaison;
            if (liaison instanceof DTMLiaison) {
                liaison = new XercesLiaison();
                liaison.setErrorHandler(new ExtErrorHandler(url.toString()));
            }
            Element componentElement = null;
            liaison.parse(new InputSource(url.toString()));
            Document compSpec = liaison.getDocument();
            componentElement = compSpec.getDocumentElement();
            this.setElements(componentElement.getAttribute("elements"));
            this.setFunctions(componentElement.getAttribute("functions"));
            NodeList nl = componentElement.getElementsByTagName("lxslt:script");
            switch (nl.getLength()) {
                case 1: {
                    Element scriptElem = (Element)nl.item(0);
                    String lang = scriptElem.getAttribute("lang");
                    Attr srcURLAttr = scriptElem.getAttributeNode("src");
                    String srcURL = srcURLAttr == null ? null : srcURLAttr.getValue();
                    String src = this.getScriptString(scriptElem);
                    this.setScript(lang, srcURL, src);
                    break;
                }
                default: {
                    throw new XSLProcessorException("too many <script>s in component");
                }
                case 0: 
            }
            this.componentDescLoaded = true;
            return;
        }
    }

    public void processElement(String localPart, Element element, XSLTEngineImpl processor, Stylesheet stylesheetTree, Node sourceTree, Node sourceNode, QName mode) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        if (!this.componentStarted) {
            try {
                this.startupComponent();
            }
            catch (XPathProcessorException e) {
                throw new XSLProcessorException(e.getMessage(), e);
            }
        }
        Object result = null;
        try {
            XSLProcessorContext xpc = new XSLProcessorContext(processor, stylesheetTree, sourceTree, sourceNode, mode);
            Vector<Object> argv = new Vector<Object>(2);
            argv.addElement(xpc);
            argv.addElement(element);
            result = super.callFunction(localPart, argv);
        }
        catch (XPathProcessorException e) {
            throw new XSLProcessorException(e.getMessage(), e);
        }
        if (result != null) {
            processor.outputToResultTree(stylesheetTree, result);
        }
    }

    public void setElements(String elemNames) {
        if (elemNames == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(elemNames, " \t\n\r", false);
        Object junk = new Object();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            this.elements.put(tok, junk);
        }
        this.componentDescLoaded = true;
    }

    public void setFunctions(String funcNames) {
        super.setFunctions(funcNames);
        this.componentDescLoaded = true;
    }

    public void setScript(String lang, String srcURL, String scriptSrc) {
        super.setScript(lang, srcURL, scriptSrc);
        this.componentDescLoaded = true;
    }

    protected void startupComponent() throws XPathProcessorException {
        if (!ExtensionFunctionHandler.bsfInitialized) {
            Class clazz = class$com$ibm$bsf$BSFManager != null ? class$com$ibm$bsf$BSFManager : (class$com$ibm$bsf$BSFManager = ExtensionNSHandler.class$("com.ibm.bsf.BSFManager"));
            synchronized (clazz) {
                ExtensionFunctionHandler.bsfInitialized = true;
                BSFManager.registerScriptingEngine((String)"xslt-javaclass", (String)"org.apache.xalan.xpath.XSLTJavaClassEngine", (String[])new String[0]);
            }
        }
        if (!this.componentDescLoaded) {
            try {
                this.loadComponentDescription();
            }
            catch (Exception e) {
                throw new XPathProcessorException(e.getMessage(), e);
            }
        }
        super.startupComponent();
    }

    class ExtErrorHandler
    implements ErrorHandler {
        String m_xmlID = null;

        public ExtErrorHandler(String identifier) {
            this.m_xmlID = identifier;
        }

        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Parser error: " + exception.getMessage());
        }

        public void fatalError(SAXParseException exception) throws SAXException {
        }

        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Parser warning: " + exception.getMessage());
        }
    }
}

