/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.xpath.xml.NameSpace;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.StringToStringTable;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xslt.AVT;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.ElemUse;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class ElemLiteralResult
extends ElemUse {
    public String[] m_extensionElementPrefixes = null;
    public Vector m_avts = null;
    public String m_qname;
    public StringToStringTable m_excludeResultPrefixes = null;

    ElemLiteralResult(XSLTEngineImpl processor, Stylesheet stylesheetTree, String name, AttributeList atts, int lineNumber, int columnNumber) throws SAXException {
        super(processor, stylesheetTree, name, atts, lineNumber, columnNumber);
        this.m_qname = name;
        int nAttrs = atts.getLength();
        int i = 0;
        while (i < nAttrs) {
            String ns;
            String prefix;
            String aname = atts.getName(i);
            boolean needToProcess = true;
            int indexOfNSSep = aname.indexOf(58);
            if (indexOfNSSep > 0 && !(prefix = aname.substring(0, indexOfNSSep)).equals("xmlns") && (ns = this.getNamespaceForPrefix(prefix)) != null && ns.equals(this.m_stylesheet.m_XSLNameSpaceURL)) {
                String localName = aname.substring(indexOfNSSep + 1);
                if (localName.equals("extension-element-prefixes")) {
                    needToProcess = false;
                    String qnames = atts.getValue(i);
                    StringTokenizer tokenizer = new StringTokenizer(qnames, " \t\n\r", false);
                    this.m_extensionElementPrefixes = new String[tokenizer.countTokens()];
                    int k = 0;
                    while (tokenizer.hasMoreTokens()) {
                        this.m_extensionElementPrefixes[k] = tokenizer.nextToken();
                        this.m_excludeResultPrefixes = this.m_stylesheet.processExcludeResultPrefixes(this.m_extensionElementPrefixes[k], null);
                        ++k;
                    }
                } else if (localName.equals("exclude-result-prefixes")) {
                    needToProcess = false;
                    this.m_excludeResultPrefixes = this.m_stylesheet.processExcludeResultPrefixes(atts.getValue(i), null);
                } else if (localName.equals("version")) {
                    String versionStr = atts.getValue(i);
                    this.m_stylesheet.m_XSLTVerDeclared = Double.valueOf(versionStr);
                }
            }
            if (needToProcess) {
                boolean _processUseAttributeSets = this.processUseAttributeSets(aname, atts, i);
                boolean _processSpaceAttr = this.processSpaceAttr(aname, atts, i);
                if (!_processUseAttributeSets && !_processSpaceAttr && this.isAttrOK(aname, atts, i)) {
                    if (this.m_avts == null) {
                        this.m_avts = new Vector(nAttrs);
                    }
                    this.m_avts.addElement(new AVT(aname, atts.getType(i), atts.getValue(i), this, this.m_stylesheet, processor));
                }
            }
            ++i;
        }
    }

    public void execute(XSLTEngineImpl processor, Node sourceTree, Node sourceNode, QName mode) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        processor.m_resultTreeHandler.startElement(this.m_qname);
        super.execute(processor, sourceTree, sourceNode, mode);
        if (this.m_avts != null) {
            int nAttrs = this.m_avts.size();
            int i = nAttrs - 1;
            while (i >= 0) {
                XMLParserLiaison execContext;
                AVT avt = (AVT)this.m_avts.elementAt(i);
                String stringedValue = avt.evaluate(execContext = processor.getXMLProcessorLiaison(), sourceNode, this, new StringBuffer());
                if (stringedValue != null) {
                    String nsprefix = null;
                    if (avt.m_name.startsWith("xmlns:")) {
                        nsprefix = avt.m_name.substring(avt.m_name.indexOf(":") + 1);
                    }
                    if (nsprefix == null || !this.m_stylesheet.shouldExcludeResultNamespaceNode(this, nsprefix, stringedValue)) {
                        processor.m_pendingAttributes.removeAttribute(avt.m_name);
                        processor.m_pendingAttributes.addAttribute(avt.m_name, avt.m_type, stringedValue);
                    }
                }
                --i;
            }
        }
        ElemTemplateElement[] elem = new ElemTemplateElement[]{this};
        NameSpace ns = elem[0].m_namespaces;
        if (ns == null) {
            ns = this.getNextNamespace(elem, ns);
        }
        while (ns != null) {
            if (ns.m_uri != null && ns.m_resultCandidate) {
                boolean hasPrefix = ns.m_prefix != null && ns.m_prefix.length() > 0;
                String prefix = hasPrefix ? ns.m_prefix : "";
                String desturi = processor.getResultNamespaceForPrefix(prefix);
                String attrName = hasPrefix ? "xmlns:" + prefix : "xmlns";
                String srcURI = ns.m_uri;
                String aliasURI = this.m_stylesheet.lookForAlias(srcURI);
                if (!aliasURI.equals(desturi)) {
                    if (this.m_stylesheet.shouldExcludeResultNamespaceNode(this, prefix, srcURI)) {
                        ns.m_resultCandidate = false;
                    } else {
                        this.addResultAttribute(processor.m_resultNameSpaces, processor.m_pendingAttributes, attrName, srcURI);
                    }
                }
            }
            ns = this.getNextNamespace(elem, ns);
        }
        this.executeChildren(processor, sourceTree, sourceNode, mode);
        processor.m_resultTreeHandler.endElement(this.m_qname);
    }

    private NameSpace getNextNamespace(ElemTemplateElement[] elem, NameSpace ns) {
        if (ns != null) {
            ns = ns.m_next;
        }
        if (ns == null && elem[0] != null) {
            elem[0] = elem[0].m_parentNode;
            while (elem[0] != null) {
                ns = elem[0].m_namespaces;
                if (ns != null) break;
                elem[0] = elem[0].m_parentNode;
            }
            if (ns == null) {
                ns = this.m_stylesheet.m_namespaceDecls;
            }
        }
        return ns;
    }

    public int getXSLToken() {
        return 77;
    }
}

