/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.xalan.xpath.xml.BoolStack;
import org.apache.xalan.xpath.xml.RawCharacterHandler;
import org.apache.xml.serialize.OutputFormat;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.misc.LexicalHandler;

public class FormatterToXML
implements DocumentHandler,
LexicalHandler,
RawCharacterHandler {
    protected Writer m_writer = null;
    protected OutputStream m_outputStream = null;
    private boolean m_bytesEqualChars = false;
    public boolean m_stripCData = false;
    public boolean m_escapeCData = false;
    protected String m_encoding = null;
    static boolean javaEncodingIsISO = false;
    public boolean m_shouldNotWriteXMLHeader = false;
    public String m_version = null;
    protected BoolStack m_elemStack = new BoolStack();
    protected final String m_lineSep = System.getProperty("line.separator");
    protected final int m_lineSepLen = this.m_lineSep.length();
    protected boolean m_ispreserve = false;
    protected BoolStack m_preserves = new BoolStack();
    protected boolean m_isprevtext = false;
    protected boolean m_doIndent = false;
    protected int m_currentIndent = 0;
    public int indent = 0;
    protected int level = 0;
    boolean m_startNewLine;
    boolean m_needToOutputDocTypeDecl = true;
    boolean m_nextIsRaw = false;
    String m_doctypeSystem;
    String m_doctypePublic;
    boolean m_standalone;
    String m_mediatype;
    public char[] m_attrSpecialChars = new char[]{'<', '>', '&', '\"'};
    static final int SPECIALSSIZE = 256;
    public char[] m_attrCharsMap = new char[256];
    public char[] m_charsMap = new char[256];
    boolean m_isUTF8;
    char m_maxCharacter = (char)127;
    public boolean m_spaceBeforeClose = false;
    static final String DEFAULT_MIME_ENCODING = "UTF-8";
    protected boolean m_inCData = false;
    static final int MAXCHARBUF = 8192;
    protected char[] m_charBuf = new char[8192];
    protected byte[] m_byteBuf = new byte[8192];
    protected int m_pos = 0;
    private static Hashtable s_enchash = null;
    private static Hashtable s_revhash = null;
    protected static Hashtable s_revsize = new Hashtable();

    public FormatterToXML() {
        FormatterToXML.initEncodings();
    }

    public FormatterToXML(Writer writer) {
        this.m_writer = writer;
        FormatterToXML.initEncodings();
    }

    public FormatterToXML(FormatterToXML xmlListener) {
        this.m_writer = xmlListener.m_writer;
        this.m_outputStream = xmlListener.m_outputStream;
        this.m_bytesEqualChars = xmlListener.m_bytesEqualChars;
        this.m_stripCData = xmlListener.m_stripCData;
        this.m_escapeCData = xmlListener.m_escapeCData;
        this.m_encoding = xmlListener.m_encoding;
        this.m_shouldNotWriteXMLHeader = xmlListener.m_shouldNotWriteXMLHeader;
        this.m_shouldNotWriteXMLHeader = xmlListener.m_shouldNotWriteXMLHeader;
        this.m_elemStack = xmlListener.m_elemStack;
        this.m_ispreserve = xmlListener.m_ispreserve;
        this.m_preserves = xmlListener.m_preserves;
        this.m_isprevtext = xmlListener.m_isprevtext;
        this.m_doIndent = xmlListener.m_doIndent;
        this.m_currentIndent = xmlListener.m_currentIndent;
        this.indent = xmlListener.indent;
        this.level = xmlListener.level;
        this.m_startNewLine = xmlListener.m_startNewLine;
        this.m_needToOutputDocTypeDecl = xmlListener.m_needToOutputDocTypeDecl;
        this.m_nextIsRaw = xmlListener.m_nextIsRaw;
        this.m_doctypeSystem = xmlListener.m_doctypeSystem;
        this.m_doctypePublic = xmlListener.m_doctypePublic;
        this.m_standalone = xmlListener.m_standalone;
        this.m_mediatype = xmlListener.m_mediatype;
        this.m_attrSpecialChars = xmlListener.m_attrSpecialChars;
        this.m_attrCharsMap = xmlListener.m_attrCharsMap;
        this.m_charsMap = xmlListener.m_charsMap;
        this.m_maxCharacter = xmlListener.m_maxCharacter;
        this.m_spaceBeforeClose = xmlListener.m_spaceBeforeClose;
        this.m_inCData = xmlListener.m_inCData;
        this.m_charBuf = xmlListener.m_charBuf;
        this.m_byteBuf = xmlListener.m_byteBuf;
        this.m_pos = 0;
        this.initCharsMap();
    }

    protected final void accum(byte b) throws SAXException {
        if (this.m_bytesEqualChars) {
            this.m_byteBuf[this.m_pos++] = b;
            if (this.m_pos >= 8192) {
                this.flushBytes();
            }
        } else {
            this.m_charBuf[this.m_pos++] = (char)b;
            if (this.m_pos >= 8192) {
                this.flushChars();
            }
        }
    }

    protected final void accum(char b) throws SAXException {
        if (this.m_bytesEqualChars) {
            this.m_byteBuf[this.m_pos++] = (byte)b;
            if (this.m_pos >= 8192) {
                this.flushBytes();
            }
        } else {
            this.m_charBuf[this.m_pos++] = b;
            if (this.m_pos >= 8192) {
                this.flushChars();
            }
        }
    }

    protected final void accum(String s) throws SAXException {
        int n = s.length();
        if (this.m_bytesEqualChars) {
            char[] chars = s.toCharArray();
            int i = 0;
            while (i < n) {
                this.m_byteBuf[this.m_pos++] = (byte)chars[i];
                if (this.m_pos >= 8192) {
                    this.flushBytes();
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                this.m_charBuf[this.m_pos++] = s.charAt(i);
                if (this.m_pos >= 8192) {
                    this.flushChars();
                }
                ++i;
            }
        }
    }

    protected final void accum(char[] chars, int start, int length) throws SAXException {
        int n = start + length;
        if (this.m_bytesEqualChars) {
            int i = start;
            while (i < n) {
                this.m_byteBuf[this.m_pos++] = (byte)chars[i];
                if (this.m_pos >= 8192) {
                    this.flushBytes();
                }
                ++i;
            }
        } else {
            int i = start;
            while (i < n) {
                this.m_charBuf[this.m_pos++] = chars[i];
                if (this.m_pos >= 8192) {
                    this.flushChars();
                }
                ++i;
            }
        }
    }

    final boolean accumDefaultEntity(char ch, int i, char[] chars, int len, boolean escLF) throws SAXException {
        if (!escLF && ch == '\r' && i + 1 < len && chars[i + 1] == '\n') {
            this.outputLineSep();
            ++i;
        } else if (!escLF && ch == '\n' && i + 1 < len && chars[i + 1] == '\r') {
            this.outputLineSep();
            ++i;
        } else if (!escLF && ch == '\r') {
            this.outputLineSep();
            ++i;
        } else if (!escLF && ch == '\n') {
            this.outputLineSep();
        } else if (ch == '<') {
            this.accum('&');
            this.accum('l');
            this.accum('t');
            this.accum(';');
        } else if (ch == '>') {
            this.accum('&');
            this.accum('g');
            this.accum('t');
            this.accum(';');
        } else if (ch == '&') {
            this.accum('&');
            this.accum('a');
            this.accum('m');
            this.accum('p');
            this.accum(';');
        } else if (ch == '\"') {
            this.accum('&');
            this.accum('q');
            this.accum('u');
            this.accum('o');
            this.accum('t');
            this.accum(';');
        } else if (ch == '\'') {
            this.accum('&');
            this.accum('a');
            this.accum('p');
            this.accum('o');
            this.accum('s');
            this.accum(';');
        } else {
            return false;
        }
        return true;
    }

    final void accumDefaultEscape(char ch, int i, char[] chars, int len, boolean escLF) throws SAXException {
        if (!this.accumDefaultEntity(ch, i, chars, len, escLF)) {
            if (ch >= '\ud800' && ch < '\udc00') {
                int next;
                if (i + 1 >= len) {
                    throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " ?");
                }
                if ((next = chars[++i]) < 56320 || next >= 57344) {
                    throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " " + Integer.toHexString(next));
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                this.accum("&#x");
                this.accum(Integer.toHexString(next));
                this.accum(";");
            } else {
                this.accum("&#");
                this.accum(Integer.toString(ch));
                this.accum(";");
            }
        }
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.m_nextIsRaw) {
                this.m_nextIsRaw = false;
                this.charactersRaw(ch, start, length);
                return;
            }
            if (this.m_escapeCData) {
                this.characters(ch, start, length);
            } else {
                this.writeParentTagEnd();
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                if (!this.m_stripCData && length >= 1 && ch[start] <= this.m_maxCharacter) {
                    this.accum("<![CDATA[");
                }
                this.writeNormalizedChars(ch, start, length, this.m_stripCData ^ true);
                if (!this.m_stripCData && length >= 1 && ch[start + length - 1] <= this.m_maxCharacter) {
                    this.accum("]]>");
                }
            }
        }
        catch (IOException ioe) {
            throw new SAXException("IO error", ioe);
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(chars, start, length);
            return;
        }
        if (this.m_nextIsRaw) {
            this.m_nextIsRaw = false;
            this.charactersRaw(chars, start, length);
            return;
        }
        this.writeParentTagEnd();
        this.m_ispreserve = true;
        boolean pos = false;
        int end = start + length;
        int i = start;
        while (i < end) {
            char ch = chars[i];
            if (ch < '\u0100' && this.m_charsMap[ch] != 'S') {
                this.accum(ch);
            } else {
                this.accumDefaultEscape(ch, i, chars, end, false);
            }
            ++i;
        }
        this.m_isprevtext = true;
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        this.writeParentTagEnd();
        this.m_ispreserve = true;
        this.accum(ch, start, length);
    }

    protected boolean childNodesWereAdded() {
        return this.m_elemStack.isEmpty() ? false : this.m_elemStack.pop();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        this.accum("<!--");
        this.accum(ch, start, length);
        this.accum("-->");
        this.m_startNewLine = true;
    }

    public static String convertJava2MimeEncoding(String encoding) {
        if (s_revhash == null) {
            FormatterToXML.initEncodings();
        }
        if (encoding == null) {
            return DEFAULT_MIME_ENCODING;
        }
        return javaEncodingIsISO ? encoding : (String)s_revhash.get(encoding.toUpperCase());
    }

    public static String convertMime2JavaEncoding(String mimeCharsetName) {
        if (s_enchash == null) {
            FormatterToXML.initEncodings();
        }
        if (mimeCharsetName == null) {
            return "UTF8";
        }
        return javaEncodingIsISO ? mimeCharsetName : (String)s_enchash.get(mimeCharsetName.toUpperCase());
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void endDTD() throws SAXException {
    }

    public void endDocument() throws SAXException {
        if (this.m_doIndent && !this.m_isprevtext) {
            this.outputLineSep();
        }
        this.flush();
    }

    public void endElement(String name) throws SAXException {
        this.m_currentIndent -= this.indent;
        boolean hasChildNodes = this.childNodesWereAdded();
        if (hasChildNodes) {
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum('<');
            this.accum('/');
            this.accum(name);
            this.accum('>');
        } else if (this.m_spaceBeforeClose) {
            this.accum(" />");
        } else {
            this.accum("/>");
        }
        if (hasChildNodes) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
    }

    public void endEntity(String name) throws SAXException {
    }

    public void entityReference(String name) throws SAXException {
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        this.accum("&");
        this.accum(name);
        this.accum(";");
    }

    protected final void flush() throws SAXException {
        if (this.m_bytesEqualChars) {
            this.flushBytes();
        } else {
            this.flushChars();
        }
    }

    private final void flushBytes() throws SAXException {
        try {
            this.m_outputStream.write(this.m_byteBuf, 0, this.m_pos);
            this.m_pos = 0;
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    private final void flushChars() throws SAXException {
        try {
            this.m_writer.write(this.m_charBuf, 0, this.m_pos);
            this.m_writer.flush();
            this.m_pos = 0;
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    String getMimeEncoding(String encoding) {
        block3: {
            if (encoding != null) break block3;
            try {
                encoding = System.getProperty("file.encoding");
                if (encoding != null) {
                    String jencoding;
                    String string = jencoding = encoding.equals("Cp1252") || encoding.equals("ISO8859_1") || encoding.equals("8859_1") || encoding.equals("UTF8") ? DEFAULT_MIME_ENCODING : FormatterToXML.convertJava2MimeEncoding(encoding);
                    if (jencoding == null) break block3;
                    encoding = jencoding;
                    break block3;
                }
                encoding = DEFAULT_MIME_ENCODING;
            }
            catch (SecurityException securityException) {
                encoding = DEFAULT_MIME_ENCODING;
            }
        }
        return encoding;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        this.characters(ch, start, length);
    }

    public void indent(int n) throws SAXException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_doIndent) {
            this.printSpace(n);
        }
    }

    public synchronized void init(OutputStream output, OutputFormat format) throws UnsupportedEncodingException {
        this.m_encoding = this.getMimeEncoding(format.getEncoding());
        if (this.m_encoding.equals(DEFAULT_MIME_ENCODING) || this.m_encoding.equals("WINDOWS-1250") || this.m_encoding.equals("US-ASCII") || this.m_encoding.equals("ASCII")) {
            this.m_bytesEqualChars = true;
            this.m_outputStream = output;
            this.init((Writer)null, format);
        } else {
            String javaEncoding = FormatterToXML.convertMime2JavaEncoding(this.m_encoding);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter(output, javaEncoding);
            }
            catch (Exception exception) {
                try {
                    if (javaEncoding.startsWith("ISO")) {
                        javaEncoding = javaEncoding.substring(3);
                        try {
                            osw = new OutputStreamWriter(output, javaEncoding);
                        }
                        catch (Exception exception2) {
                            osw = new OutputStreamWriter(output, this.m_encoding);
                        }
                    } else {
                        osw = new OutputStreamWriter(output, this.m_encoding);
                    }
                }
                catch (Exception exception3) {
                    System.out.print("Java VM does not support encoding: " + this.m_encoding);
                    if (javaEncoding != null) {
                        System.out.println(" or " + javaEncoding);
                    } else {
                        System.out.println();
                    }
                    osw = new OutputStreamWriter(output);
                }
            }
            this.init(osw, format);
        }
    }

    public synchronized void init(Writer writer, OutputFormat format) {
        this.m_writer = writer;
        this.m_doIndent = format.getIndenting();
        this.m_shouldNotWriteXMLHeader = format.getOmitXMLDeclaration();
        this.m_doctypeSystem = format.getDoctypeSystem();
        this.m_doctypePublic = format.getDoctypePublic();
        this.m_standalone = format.getStandalone();
        this.m_mediatype = format.getMediaType();
        if (this.m_doctypePublic != null && this.m_doctypePublic.startsWith("-//W3C//DTD XHTML")) {
            this.m_spaceBeforeClose = true;
        }
        this.m_maxCharacter = format.getLastPrintable();
        this.initCharsMap();
        if (this.m_encoding == null) {
            this.m_encoding = this.getMimeEncoding(format.getEncoding());
        }
        this.m_isUTF8 = this.m_encoding.equals(DEFAULT_MIME_ENCODING);
        Object maxCharObj = s_revsize.get(this.m_encoding.toUpperCase());
        if (maxCharObj != null) {
            Character maxChar = (Character)maxCharObj;
            this.m_maxCharacter = maxChar.charValue();
            this.initCharsMap();
        }
    }

    protected void initAttrCharsMap() {
        int n = this.m_maxCharacter > '\u0100' ? 256 : (int)this.m_maxCharacter;
        int i = 0;
        while (i < n) {
            this.m_attrCharsMap[i] = '\u0000';
            ++i;
        }
        int nSpecials = this.m_attrSpecialChars.length;
        int i2 = 0;
        while (i2 < nSpecials) {
            this.m_attrCharsMap[this.m_attrSpecialChars[i2]] = 83;
            ++i2;
        }
        this.m_attrCharsMap[10] = 83;
        this.m_attrCharsMap[13] = 83;
    }

    protected void initCharsMap() {
        this.initAttrCharsMap();
        int n = this.m_maxCharacter > '\u0100' ? 256 : (int)this.m_maxCharacter;
        int i = 0;
        while (i < n) {
            this.m_charsMap[i] = '\u0000';
            ++i;
        }
        this.m_charsMap[10] = 83;
        this.m_charsMap[60] = 83;
        this.m_charsMap[62] = 83;
        this.m_charsMap[38] = 83;
        int i2 = 0;
        while (i2 < 20) {
            this.m_charsMap[i2] = 83;
            ++i2;
        }
        this.m_charsMap[10] = 83;
        this.m_charsMap[13] = 83;
        this.m_charsMap[9] = '\u0000';
        int i3 = this.m_maxCharacter;
        while (i3 < 256) {
            this.m_charsMap[i3] = 83;
            ++i3;
        }
    }

    public static void initEncodings() {
        Hashtable hashtable = s_revsize;
        synchronized (hashtable) {
            if (s_enchash != null) {
                Object var1_1 = null;
                return;
            }
            boolean useISOPrefix = true;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                os.write(32);
                String s = os.toString("ISO8859_1");
                useISOPrefix = s != null;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                useISOPrefix = false;
            }
            try {
                String ISOprefix;
                int dashindex;
                String encoding = System.getProperty("file.encoding");
                int n = dashindex = encoding != null ? encoding.indexOf(45) : -1;
                if (dashindex == 3 && (ISOprefix = new String(encoding.toCharArray(), 0, 3)).equals("ISO")) {
                    javaEncodingIsISO = true;
                }
            }
            catch (SecurityException securityException) {}
            s_revsize.put("WINDOWS-1250", new Character('\u00ff'));
            s_revsize.put(DEFAULT_MIME_ENCODING, new Character('\uffff'));
            s_revsize.put("US-ASCII", new Character('\u007f'));
            s_revsize.put("ISO-8859-1", new Character('\u00ff'));
            s_revsize.put("ISO-8859-2", new Character('\u00ff'));
            s_revsize.put("ISO-8859-3", new Character('\u00ff'));
            s_revsize.put("ISO-8859-4", new Character('\u00ff'));
            s_revsize.put("ISO-8859-5", new Character('\u00ff'));
            s_revsize.put("ISO-8859-6", new Character('\u00ff'));
            s_revsize.put("ISO-8859-7", new Character('\u00ff'));
            s_revsize.put("ISO-8859-8", new Character('\u00ff'));
            s_revsize.put("ISO-8859-9", new Character('\u00ff'));
            s_revsize.put("ISO-2022-JP", new Character('\uffff'));
            s_revsize.put("SHIFT_JIS", new Character('\uffff'));
            s_revsize.put("EUC-JP", new Character('\uffff'));
            s_revsize.put("GB2312", new Character('\uffff'));
            s_revsize.put("BIG5", new Character('\uffff'));
            s_revsize.put("EUC-KR", new Character('\uffff'));
            s_revsize.put("ISO-2022-KR", new Character('\uffff'));
            s_revsize.put("KOI8-R", new Character('\uffff'));
            s_revsize.put("EBCDIC-CP-US", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-CA", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-NL", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-DK", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-NO", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-FI", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-SE", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-IT", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-ES", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-GB", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-FR", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-AR1", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-HE", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-CH", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-ROECE", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-YU", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-IS", new Character('\u00ff'));
            s_revsize.put("EBCDIC-CP-AR2", new Character('\u00ff'));
            s_enchash = new Hashtable();
            s_enchash.put("WINDOWS-1250", "CP1250");
            s_enchash.put(DEFAULT_MIME_ENCODING, "UTF8");
            if (useISOPrefix) {
                s_enchash.put("US-ASCII", "ISO8859_1");
                s_enchash.put("ISO-8859-1", "ISO8859_1");
                s_enchash.put("ISO-8859-2", "ISO8859_2");
                s_enchash.put("ISO-8859-3", "ISO8859_3");
                s_enchash.put("ISO-8859-4", "ISO8859_4");
                s_enchash.put("ISO-8859-5", "ISO8859_5");
                s_enchash.put("ISO-8859-6", "ISO8859_6");
                s_enchash.put("ISO-8859-7", "ISO8859_7");
                s_enchash.put("ISO-8859-8", "ISO8859_8");
                s_enchash.put("ISO-8859-9", "ISO8859_9");
            } else {
                s_enchash.put("US-ASCII", "8859_1");
                s_enchash.put("ISO-8859-1", "8859_1");
                s_enchash.put("ISO-8859-2", "8859_2");
                s_enchash.put("ISO-8859-3", "8859_3");
                s_enchash.put("ISO-8859-4", "8859_4");
                s_enchash.put("ISO-8859-5", "8859_5");
                s_enchash.put("ISO-8859-6", "8859_6");
                s_enchash.put("ISO-8859-7", "8859_7");
                s_enchash.put("ISO-8859-8", "8859_8");
                s_enchash.put("ISO-8859-9", "8859_9");
            }
            s_enchash.put("ISO-2022-JP", "JIS");
            s_enchash.put("SHIFT_JIS", "SJIS");
            s_enchash.put("EUC-JP", "EUCJIS");
            s_enchash.put("GB2312", "GB2312");
            s_enchash.put("BIG5", "Big5");
            s_enchash.put("EUC-KR", "KSC5601");
            s_enchash.put("ISO-2022-KR", "ISO2022KR");
            s_enchash.put("KOI8-R", "KOI8_R");
            s_enchash.put("EBCDIC-CP-US", "CP037");
            s_enchash.put("EBCDIC-CP-CA", "CP037");
            s_enchash.put("EBCDIC-CP-NL", "CP037");
            s_enchash.put("EBCDIC-CP-DK", "CP277");
            s_enchash.put("EBCDIC-CP-NO", "CP277");
            s_enchash.put("EBCDIC-CP-FI", "CP278");
            s_enchash.put("EBCDIC-CP-SE", "CP278");
            s_enchash.put("EBCDIC-CP-IT", "CP280");
            s_enchash.put("EBCDIC-CP-ES", "CP284");
            s_enchash.put("EBCDIC-CP-GB", "CP285");
            s_enchash.put("EBCDIC-CP-FR", "CP297");
            s_enchash.put("EBCDIC-CP-AR1", "CP420");
            s_enchash.put("EBCDIC-CP-HE", "CP424");
            s_enchash.put("EBCDIC-CP-CH", "CP500");
            s_enchash.put("EBCDIC-CP-ROECE", "CP870");
            s_enchash.put("EBCDIC-CP-YU", "CP870");
            s_enchash.put("EBCDIC-CP-IS", "CP871");
            s_enchash.put("EBCDIC-CP-AR2", "CP918");
            s_revhash = new Hashtable();
            s_revhash.put("CP1252", "ISO-8859-1");
            s_revhash.put("CP1250", "windows-1250");
            s_revhash.put("UTF8", DEFAULT_MIME_ENCODING);
            if (useISOPrefix) {
                s_revhash.put("ISO8859_1", "ISO-8859-1");
                s_revhash.put("ISO8859_2", "ISO-8859-2");
                s_revhash.put("ISO8859_3", "ISO-8859-3");
                s_revhash.put("ISO8859_4", "ISO-8859-4");
                s_revhash.put("ISO8859_5", "ISO-8859-5");
                s_revhash.put("ISO8859_6", "ISO-8859-6");
                s_revhash.put("ISO8859_7", "ISO-8859-7");
                s_revhash.put("ISO8859_8", "ISO-8859-8");
                s_revhash.put("ISO8859_9", "ISO-8859-9");
            } else {
                s_revhash.put("8859_1", "ISO-8859-1");
                s_revhash.put("8859_2", "ISO-8859-2");
                s_revhash.put("8859_3", "ISO-8859-3");
                s_revhash.put("8859_4", "ISO-8859-4");
                s_revhash.put("8859_5", "ISO-8859-5");
                s_revhash.put("8859_6", "ISO-8859-6");
                s_revhash.put("8859_7", "ISO-8859-7");
                s_revhash.put("8859_8", "ISO-8859-8");
                s_revhash.put("8859_9", "ISO-8859-9");
            }
            s_revhash.put("JIS", "ISO-2022-JP");
            s_revhash.put("SJIS", "Shift_JIS");
            s_revhash.put("EUCJIS", "EUC-JP");
            s_revhash.put("GB2312", "GB2312");
            s_revhash.put("BIG5", "Big5");
            s_revhash.put("KSC5601", "EUC-KR");
            s_revhash.put("ISO2022KR", "ISO-2022-KR");
            s_revhash.put("KOI8_R", "KOI8-R");
            s_revhash.put("CP037", "EBCDIC-CP-US");
            s_revhash.put("CP037", "EBCDIC-CP-CA");
            s_revhash.put("CP037", "EBCDIC-CP-NL");
            s_revhash.put("CP277", "EBCDIC-CP-DK");
            s_revhash.put("CP277", "EBCDIC-CP-NO");
            s_revhash.put("CP278", "EBCDIC-CP-FI");
            s_revhash.put("CP278", "EBCDIC-CP-SE");
            s_revhash.put("CP280", "EBCDIC-CP-IT");
            s_revhash.put("CP284", "EBCDIC-CP-ES");
            s_revhash.put("CP285", "EBCDIC-CP-GB");
            s_revhash.put("CP297", "EBCDIC-CP-FR");
            s_revhash.put("CP420", "EBCDIC-CP-AR1");
            s_revhash.put("CP424", "EBCDIC-CP-HE");
            s_revhash.put("CP500", "EBCDIC-CP-CH");
            s_revhash.put("CP870", "EBCDIC-CP-ROECE");
            s_revhash.put("CP870", "EBCDIC-CP-YU");
            s_revhash.put("CP871", "EBCDIC-CP-IS");
            s_revhash.put("CP918", "EBCDIC-CP-AR2");
        }
    }

    protected void openElementForChildren() {
        this.m_elemStack.push(false);
    }

    void outputDocTypeDecl(String name) throws SAXException {
        this.accum("<!DOCTYPE ");
        this.accum(name);
        if (this.m_doctypePublic != null) {
            this.accum(" PUBLIC \"");
            this.accum(this.m_doctypePublic);
            this.accum("\"");
        }
        if (this.m_doctypePublic == null) {
            this.accum(" SYSTEM \"");
        } else {
            this.accum(" \"");
        }
        this.accum(this.m_doctypeSystem);
        this.accum("\">");
        this.outputLineSep();
    }

    protected final void outputLineSep() throws SAXException {
        int z = 0;
        while (z < this.m_lineSepLen) {
            this.accum(this.m_lineSep.charAt(z));
            ++z;
        }
    }

    public void printSpace(int n) throws SAXException {
        int i = 0;
        while (i < n) {
            this.accum(' ');
            ++i;
        }
    }

    protected void processAttribute(String name, String value) throws SAXException {
        this.accum(' ');
        this.accum(name);
        this.accum("=\"");
        this.writeAttrString(value, this.m_encoding);
        this.accum('\"');
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target.equals("xslt-next-is-raw") && data.equals("formatter-to-dom")) {
            this.m_nextIsRaw = true;
        } else {
            this.writeParentTagEnd();
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            this.accum('<');
            this.accum('?');
            this.accum(target);
            if (data.length() > 0 && !Character.isSpaceChar(data.charAt(0))) {
                this.accum(' ');
            }
            this.accum(data);
            this.accum('?');
            this.accum('>');
            this.m_startNewLine = true;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext;
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        if (!this.m_shouldNotWriteXMLHeader) {
            String encoding = this.getMimeEncoding(this.m_encoding);
            String version = this.m_version == null ? "1.0" : this.m_version;
            this.accum("<?xml version=\"" + version + "\" encoding=\"" + encoding + "\"?>");
            this.outputLineSep();
        }
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        if (this.m_needToOutputDocTypeDecl && this.m_doctypeSystem != null) {
            this.outputDocTypeDecl(name);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.writeParentTagEnd();
        this.m_ispreserve = false;
        if (this.shouldIndent() && !this.m_elemStack.isEmpty()) {
            this.m_startNewLine = true;
            this.indent(this.m_currentIndent);
        }
        this.accum('<');
        this.accum(name);
        int nAttrs = atts.getLength();
        int i = 0;
        while (i < nAttrs) {
            this.processAttribute(atts.getName(i), atts.getValue(i));
            ++i;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.indent;
        this.m_isprevtext = false;
    }

    public void startEntity(String name) throws SAXException {
    }

    public void writeAttrString(String string, String encoding) throws SAXException {
        char[] stringChars = string.toCharArray();
        int len = stringChars.length;
        int i = 0;
        while (i < len) {
            char ch = stringChars[i];
            if (ch < '\u0100' && this.m_attrCharsMap[ch] != 'S') {
                this.accum(ch);
            } else {
                this.accumDefaultEscape(ch, i, stringChars, len, true);
            }
            ++i;
        }
    }

    void writeNormalizedChars(char[] ch, int start, int length, boolean isCData) throws IOException, SAXException {
        int end = start + length;
        int i = start;
        while (i < end) {
            char c = ch[i];
            if (c == '\r' && i + 1 < end && ch[i + 1] == '\n') {
                this.outputLineSep();
                ++i;
            } else if (c == '\n' && i + 1 < end && ch[i + 1] == '\r') {
                this.outputLineSep();
                ++i;
            } else if (c == '\n') {
                this.outputLineSep();
            } else if (isCData && c > this.m_maxCharacter) {
                if (i != 0) {
                    this.accum("]]>");
                }
                if (c >= '\ud800' && c < '\udc00') {
                    int next;
                    if (i + 1 >= end) {
                        throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " ?");
                    }
                    if ((next = ch[++i]) < 56320 || next >= 57344) {
                        throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " " + Integer.toHexString(next));
                    }
                    next = (c - 55296 << 10) + next - 56320 + 65536;
                    this.accum('&');
                    this.accum('#');
                    this.accum('x');
                    this.accum(Integer.toHexString(next));
                    this.accum(';');
                } else {
                    this.accum("&#");
                    String intStr = Integer.toString(c);
                    this.accum(intStr);
                    this.accum(';');
                }
                if (i != 0 && i < end - 1) {
                    this.accum("<![CDATA[");
                }
            } else if (isCData && i < end - 2 && c == ']' && ch[i + 1] == ']' && ch[i + 2] == '>') {
                this.accum("]]]]><![CDATA[>");
                i += 2;
            } else if (c <= this.m_maxCharacter) {
                this.accum(c);
            } else if (c >= '\ud800' && c < '\udc00') {
                int next;
                if (i + 1 >= end) {
                    throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " ?");
                }
                if ((next = ch[++i]) < 56320 || next >= 57344) {
                    throw new SAXException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " " + Integer.toHexString(next));
                }
                next = (c - 55296 << 10) + next - 56320 + 65536;
                this.accum("&#x");
                this.accum(Integer.toHexString(next));
                this.accum(";");
            } else {
                this.accum("&#");
                String intStr = Integer.toString(c);
                this.accum(intStr);
                this.accum(';');
            }
            ++i;
        }
    }

    protected void writeParentTagEnd() throws SAXException {
        if (!this.m_elemStack.isEmpty() && !this.m_elemStack.peek()) {
            this.accum('>');
            this.m_isprevtext = false;
            this.m_elemStack.pop();
            this.m_elemStack.push(true);
            this.m_preserves.push(this.m_ispreserve);
        }
    }
}

