/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.Writer;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.misc.LexicalHandler;

public class FormatterToDOM
implements DocumentHandler,
LexicalHandler {
    Document m_doc;
    Node m_currentNode = null;
    public DocumentFragment m_docFrag = null;
    Stack m_elemStack = new Stack();
    protected boolean m_inCData = false;

    public FormatterToDOM(Document doc) {
        this.m_doc = doc;
    }

    public FormatterToDOM(Document doc, DocumentFragment docFrag) {
        this.m_doc = doc;
        this.m_docFrag = docFrag;
    }

    public FormatterToDOM(Document doc, Element elem) {
        this.m_doc = doc;
        this.m_currentNode = elem;
    }

    private void append(Node newNode) throws SAXException {
        if (this.m_currentNode != null) {
            this.m_currentNode.appendChild(newNode);
        } else if (this.m_docFrag != null) {
            this.m_docFrag.appendChild(newNode);
        } else {
            boolean ok = true;
            short type = newNode.getNodeType();
            if (type == 3) {
                String data = newNode.getNodeValue();
                if (data != null && data.trim().length() > 0) {
                    throw new SAXException("Warning: can't output text before document element!  Ignoring...");
                }
                ok = false;
            } else if (type == 1 && this.m_doc.getDocumentElement() != null) {
                throw new SAXException("Can't have more than one root on a DOM!");
            }
            if (ok) {
                this.m_doc.appendChild(newNode);
            }
        }
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        this.append(this.m_doc.createCDATASection(s));
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_inCData) {
            this.cdata(ch, start, length);
            return;
        }
        String s = new String(ch, start, length);
        Text text = this.m_doc.createTextNode(s);
        this.append(text);
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(this.m_doc.createTextNode(s));
    }

    public void comment(String data) throws SAXException {
        this.append(this.m_doc.createComment(data));
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.append(this.m_doc.createComment(new String(ch, start, length)));
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void endDTD() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String name) throws SAXException {
        this.m_elemStack.pop();
        this.m_currentNode = !this.m_elemStack.isEmpty() ? (Element)this.m_elemStack.peek() : null;
    }

    public void endEntity(String name) throws SAXException {
    }

    public void entityReference(String name) throws SAXException {
        this.append(this.m_doc.createEntityReference(name));
    }

    public Node getRootNode() {
        return this.m_docFrag != null ? this.m_docFrag : this.m_doc;
    }

    public Writer getWriter() {
        return null;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        this.append(this.m_doc.createTextNode(s));
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.append(this.m_doc.createProcessingInstruction(target, data));
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        Element elem = this.m_doc.createElement(name);
        int nAtts = atts.getLength();
        int i = 0;
        while (i < nAtts) {
            elem.setAttribute(atts.getName(i), atts.getValue(i));
            ++i;
        }
        this.append(elem);
        this.m_elemStack.push(elem);
        this.m_currentNode = elem;
    }

    public void startEntity(String name) throws SAXException {
    }
}

