/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xalan.xpath.XNumber;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathProcessor;
import org.apache.xalan.xpath.XPathProcessorException;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XPathSupportDefault;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.ProblemListenerDefault;
import org.apache.xalan.xpath.xml.StringKey;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XPathProcessorImpl
implements XPathProcessor {
    private XPath m_xpath;
    private XPathSupport m_support;
    private String m_token;
    private char m_tokenChar = '\u0000';
    public int m_queueMark = 0;
    Hashtable m_durationsTable = new Hashtable();
    PrefixResolver m_namespaceContext;
    public static final boolean m_debug = false;
    public static final boolean m_trace = false;
    static final int TARGETEXTRA = 10000;
    public static final String PSEUDONAME_ANY = "*";
    public static final String PSEUDONAME_ROOT = "/";
    public static final String PSEUDONAME_TEXT = "#text";
    public static final String PSEUDONAME_COMMENT = "#comment";
    public static final String PSEUDONAME_PI = "#pi";
    public static final String PSEUDONAME_OTHER = "*";
    private static Hashtable m_keywords = new Hashtable();
    private static Hashtable m_axisnames = new Hashtable();
    static Hashtable m_functions = new Hashtable();
    private static Hashtable m_nodetypes = new Hashtable();
    private static final String FROM_ANCESTORS_STRING = "ancestor";
    private static final String FROM_ANCESTORS_OR_SELF_STRING = "ancestor-or-self";
    private static final String FROM_ATTRIBUTES_STRING = "attribute";
    private static final String FROM_CHILDREN_STRING = "child";
    private static final String FROM_DESCENDANTS_STRING = "descendant";
    private static final String FROM_DESCENDANTS_OR_SELF_STRING = "descendant-or-self";
    private static final String FROM_FOLLOWING_STRING = "following";
    private static final String FROM_FOLLOWING_SIBLINGS_STRING = "following-sibling";
    private static final String FROM_PARENT_STRING = "parent";
    private static final String FROM_PRECEDING_STRING = "preceding";
    private static final String FROM_PRECEDING_SIBLINGS_STRING = "preceding-sibling";
    private static final String FROM_SELF_STRING = "self";
    private static final String FROM_NAMESPACE_STRING = "namespace";
    private static final String FROM_SELF_ABBREVIATED_STRING = ".";
    private static final String NODETYPE_COMMENT_STRING = "comment";
    private static final String NODETYPE_TEXT_STRING = "text";
    private static final String NODETYPE_PI_STRING = "processing-instruction";
    private static final String NODETYPE_NODE_STRING = "node";
    private static final String FROM_ATTRIBUTE_STRING = "@";
    private static final String FROM_DOC_STRING = "document";
    private static final String FROM_DOCREF_STRING = "document";
    private static final String FROM_ID_STRING = "id";
    private static final String FROM_IDREF_STRING = "idref";
    private static final String NODETYPE_ANYELEMENT_STRING = "*";
    private static final String FUNC_CURRENT_STRING = "current";
    private static final String FUNC_LAST_STRING = "last";
    private static final String FUNC_POSITION_STRING = "position";
    private static final String FUNC_COUNT_STRING = "count";
    private static final String FUNC_ID_STRING = "id";
    private static final String FUNC_IDREF_STRING = "idref";
    private static final String FUNC_KEY_STRING = "key";
    private static final String FUNC_KEYREF_STRING = "keyref";
    private static final String FUNC_DOC_STRING = "doc";
    private static final String FUNC_DOCUMENT_STRING = "document";
    private static final String FUNC_DOCREF_STRING = "docref";
    private static final String FUNC_LOCAL_PART_STRING = "local-name";
    private static final String FUNC_NAMESPACE_STRING = "namespace-uri";
    private static final String FUNC_NAME_STRING = "name";
    private static final String FUNC_GENERATE_ID_STRING = "generate-id";
    private static final String FUNC_NOT_STRING = "not";
    private static final String FUNC_TRUE_STRING = "true";
    private static final String FUNC_FALSE_STRING = "false";
    private static final String FUNC_BOOLEAN_STRING = "boolean";
    private static final String FUNC_LANG_STRING = "lang";
    private static final String FUNC_NUMBER_STRING = "number";
    private static final String FUNC_FLOOR_STRING = "floor";
    private static final String FUNC_CEILING_STRING = "ceiling";
    private static final String FUNC_ROUND_STRING = "round";
    private static final String FUNC_SUM_STRING = "sum";
    private static final String FUNC_STRING_STRING = "string";
    private static final String FUNC_STARTS_WITH_STRING = "starts-with";
    private static final String FUNC_CONTAINS_STRING = "contains";
    private static final String FUNC_SUBSTRING_BEFORE_STRING = "substring-before";
    private static final String FUNC_SUBSTRING_AFTER_STRING = "substring-after";
    private static final String FUNC_NORMALIZE_SPACE_STRING = "normalize-space";
    private static final String FUNC_TRANSLATE_STRING = "translate";
    private static final String FUNC_CONCAT_STRING = "concat";
    private static final String FUNC_SYSTEM_PROPERTY_STRING = "system-property";
    private static final String FUNC_EXT_FUNCTION_AVAILABLE_STRING = "function-available";
    private static final String FUNC_EXT_ELEM_AVAILABLE_STRING = "element-available";
    private static final String FUNC_SUBSTRING_STRING = "substring";
    private static final String FUNC_STRING_LENGTH_STRING = "string-length";
    private static final String FUNC_UNPARSED_ENTITY_URI_STRING = "unparsed-entity-uri";
    private static final String FUNC_DOCLOCATION_STRING = "document-location";
    private static String m_opLabel;
    private static String m_lenLabel;
    private static String m_arglenLabel;
    private static String m_noLabel;
    private static String m_nTestLabel;
    private static String m_open;
    private static String m_close;

    static {
        m_axisnames.put(new StringKey(FROM_ANCESTORS_STRING), new Integer(37));
        m_axisnames.put(new StringKey(FROM_ANCESTORS_OR_SELF_STRING), new Integer(38));
        m_axisnames.put(new StringKey(FROM_ATTRIBUTES_STRING), new Integer(39));
        m_axisnames.put(new StringKey(FROM_CHILDREN_STRING), new Integer(40));
        m_axisnames.put(new StringKey(FROM_DESCENDANTS_STRING), new Integer(41));
        m_axisnames.put(new StringKey(FROM_DESCENDANTS_OR_SELF_STRING), new Integer(42));
        m_axisnames.put(new StringKey(FROM_FOLLOWING_STRING), new Integer(43));
        m_axisnames.put(new StringKey(FROM_FOLLOWING_SIBLINGS_STRING), new Integer(44));
        m_axisnames.put(new StringKey(FROM_PARENT_STRING), new Integer(45));
        m_axisnames.put(new StringKey(FROM_PRECEDING_STRING), new Integer(46));
        m_axisnames.put(new StringKey(FROM_PRECEDING_SIBLINGS_STRING), new Integer(47));
        m_axisnames.put(new StringKey(FROM_SELF_STRING), new Integer(48));
        m_axisnames.put(new StringKey(FROM_NAMESPACE_STRING), new Integer(49));
        m_nodetypes.put(new StringKey(NODETYPE_COMMENT_STRING), new Integer(1030));
        m_nodetypes.put(new StringKey(NODETYPE_TEXT_STRING), new Integer(1031));
        m_nodetypes.put(new StringKey(NODETYPE_PI_STRING), new Integer(1032));
        m_nodetypes.put(new StringKey(NODETYPE_NODE_STRING), new Integer(1033));
        m_nodetypes.put(new StringKey("*"), new Integer(36));
        m_keywords.put(new StringKey(FROM_SELF_ABBREVIATED_STRING), new Integer(48));
        m_keywords.put(new StringKey("id"), new Integer(4));
        m_keywords.put(new StringKey(FUNC_KEY_STRING), new Integer(5));
        m_functions.put(new StringKey(FUNC_CURRENT_STRING), new Integer(0));
        m_functions.put(new StringKey(FUNC_LAST_STRING), new Integer(1));
        m_functions.put(new StringKey(FUNC_POSITION_STRING), new Integer(2));
        m_functions.put(new StringKey(FUNC_COUNT_STRING), new Integer(3));
        m_functions.put(new StringKey("id"), new Integer(4));
        m_functions.put(new StringKey(FUNC_KEY_STRING), new Integer(5));
        m_functions.put(new StringKey(FUNC_LOCAL_PART_STRING), new Integer(7));
        m_functions.put(new StringKey(FUNC_NAMESPACE_STRING), new Integer(8));
        m_functions.put(new StringKey(FUNC_NAME_STRING), new Integer(9));
        m_functions.put(new StringKey(FUNC_GENERATE_ID_STRING), new Integer(10));
        m_functions.put(new StringKey(FUNC_NOT_STRING), new Integer(11));
        m_functions.put(new StringKey(FUNC_TRUE_STRING), new Integer(12));
        m_functions.put(new StringKey(FUNC_FALSE_STRING), new Integer(13));
        m_functions.put(new StringKey(FUNC_BOOLEAN_STRING), new Integer(14));
        m_functions.put(new StringKey(FUNC_LANG_STRING), new Integer(32));
        m_functions.put(new StringKey(FUNC_NUMBER_STRING), new Integer(15));
        m_functions.put(new StringKey(FUNC_FLOOR_STRING), new Integer(16));
        m_functions.put(new StringKey(FUNC_CEILING_STRING), new Integer(17));
        m_functions.put(new StringKey(FUNC_ROUND_STRING), new Integer(18));
        m_functions.put(new StringKey(FUNC_SUM_STRING), new Integer(19));
        m_functions.put(new StringKey(FUNC_STRING_STRING), new Integer(20));
        m_functions.put(new StringKey(FUNC_STARTS_WITH_STRING), new Integer(21));
        m_functions.put(new StringKey(FUNC_CONTAINS_STRING), new Integer(22));
        m_functions.put(new StringKey(FUNC_SUBSTRING_BEFORE_STRING), new Integer(23));
        m_functions.put(new StringKey(FUNC_SUBSTRING_AFTER_STRING), new Integer(24));
        m_functions.put(new StringKey(FUNC_NORMALIZE_SPACE_STRING), new Integer(25));
        m_functions.put(new StringKey(FUNC_TRANSLATE_STRING), new Integer(26));
        m_functions.put(new StringKey(FUNC_CONCAT_STRING), new Integer(27));
        m_functions.put(new StringKey(FUNC_SYSTEM_PROPERTY_STRING), new Integer(31));
        m_functions.put(new StringKey(FUNC_EXT_FUNCTION_AVAILABLE_STRING), new Integer(33));
        m_functions.put(new StringKey(FUNC_EXT_ELEM_AVAILABLE_STRING), new Integer(34));
        m_functions.put(new StringKey(FUNC_SUBSTRING_STRING), new Integer(29));
        m_functions.put(new StringKey(FUNC_STRING_LENGTH_STRING), new Integer(30));
        m_functions.put(new StringKey(FUNC_UNPARSED_ENTITY_URI_STRING), new Integer(36));
        m_functions.put(new StringKey(NODETYPE_COMMENT_STRING), new Integer(1030));
        m_functions.put(new StringKey(NODETYPE_TEXT_STRING), new Integer(1031));
        m_functions.put(new StringKey(NODETYPE_PI_STRING), new Integer(1032));
        m_functions.put(new StringKey(NODETYPE_NODE_STRING), new Integer(1033));
        m_functions.put(new StringKey(FUNC_DOCLOCATION_STRING), new Integer(35));
        m_opLabel = "[";
        m_lenLabel = "[";
        m_arglenLabel = "[";
        m_noLabel = "[";
        m_nTestLabel = "[";
        m_open = "[";
        m_close = "]";
    }

    public XPathProcessorImpl() {
        this.m_support = new XPathSupportDefault();
    }

    public XPathProcessorImpl(XPathSupport callbacks) {
        this.m_support = callbacks;
    }

    protected void AbbreviatedNodeTestStep() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        int matchTypePos = -1;
        if (this.tokenIs('@')) {
            this.appendOp(2, 94);
            this.nextToken();
        } else if (this.tokenIs('/')) {
            this.appendOp(2, 95);
            this.nextToken();
        } else {
            if (this.tokenIs('/')) {
                this.nextToken();
            }
            matchTypePos = this.m_xpath.m_opMap[1];
            this.appendOp(2, 96);
        }
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.NodeTest();
        this.m_xpath.m_opMap[opPos + 1 + 1] = this.m_xpath.m_opMap[1] - opPos;
        while (this.tokenIs('[')) {
            this.Predicate();
        }
        if (matchTypePos > -1 && this.tokenIs('/') && this.lookahead('/', 1)) {
            this.m_xpath.m_opMap[matchTypePos] = 95;
            this.nextToken();
        }
        this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    protected int AdditiveExpr(int addPos) throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        if (addPos == -1) {
            addPos = opPos;
        }
        this.MultiplicativeExpr(-1);
        if (this.m_token != null) {
            if (this.tokenIs('+')) {
                this.nextToken();
                this.insertOp(addPos, 2, 10);
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.AdditiveExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            } else if (this.tokenIs('-')) {
                this.nextToken();
                this.insertOp(addPos, 2, 11);
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.AdditiveExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            }
        }
        return addPos;
    }

    protected void AndExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.EqualityExpr(-1);
        if (this.m_token != null && this.tokenIs("and")) {
            this.nextToken();
            this.insertOp(opPos, 2, 3);
            this.AndExpr();
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        }
    }

    protected void Argument() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.appendOp(2, 25);
        this.Expr();
        this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    protected void AxisName() throws SAXException {
        Object val = m_axisnames.get(this.m_token);
        if (val == null) {
            this.error(35, new Object[]{this.m_token});
        }
        this.appendOp(2, (Integer)val);
    }

    protected void Basis() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        if (this.lookahead("::", 1)) {
            this.AxisName();
            this.nextToken();
            this.nextToken();
        } else if (this.tokenIs('@')) {
            this.appendOp(2, 39);
            this.nextToken();
        } else {
            if (this.tokenIs('/')) {
                this.appendOp(2, 42);
                this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
                this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = 1033;
                this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
                this.m_xpath.m_opMap[opPos + 1 + 1] = this.m_xpath.m_opMap[1] - opPos;
                return;
            }
            this.appendOp(2, 40);
        }
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.NodeTest();
        this.m_xpath.m_opMap[opPos + 1 + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    protected void BooleanExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.appendOp(2, 18);
        this.Expr();
        int opLen = this.m_xpath.m_opMap[1] - opPos;
        if (opLen == 2) {
            this.error(31);
        }
        this.m_xpath.m_opMap[opPos + 1] = opLen;
    }

    protected int EqualityExpr(int addPos) throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        if (addPos == -1) {
            addPos = opPos;
        }
        this.RelationalExpr(-1);
        if (this.m_token != null) {
            if (this.tokenIs('!') && this.lookahead('=', 1)) {
                this.nextToken();
                this.nextToken();
                this.insertOp(addPos, 2, 4);
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.EqualityExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            } else if (this.tokenIs('=')) {
                this.nextToken();
                this.insertOp(addPos, 2, 5);
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.EqualityExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            }
        }
        return addPos;
    }

    protected void Expr() throws SAXException {
        this.OrExpr();
    }

    protected void FilterExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.PrimaryExpr();
        if (this.tokenIs('[')) {
            this.insertOp(opPos, 2, 28);
            while (this.tokenIs('[')) {
                this.Predicate();
            }
            if (this.tokenIs('/')) {
                this.nextToken();
                this.RelativeLocationPath();
            }
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        }
    }

    protected void FunctionCall() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        if (this.lookahead(':', 1)) {
            this.appendOp(4, 26);
            this.m_xpath.m_opMap[opPos + 1 + 1] = this.m_queueMark - 1;
            this.nextToken();
            this.consumeExpected(':');
            this.m_xpath.m_opMap[opPos + 1 + 2] = this.m_queueMark - 1;
            this.nextToken();
        } else {
            int funcTok = this.getFunctionToken(this.m_token);
            if (funcTok == -1) {
                this.warn(9, new Object[]{this.m_token});
            }
            switch (funcTok) {
                case 1030: 
                case 1031: 
                case 1032: 
                case 1033: {
                    this.LocationPath();
                    return;
                }
            }
            this.appendOp(3, 27);
            this.m_xpath.m_opMap[opPos + 1 + 1] = funcTok;
            this.nextToken();
        }
        this.consumeExpected('(');
        while (!this.tokenIs(')')) {
            if (this.tokenIs(',')) {
                this.error(32);
            }
            this.Argument();
            if (this.tokenIs(')')) continue;
            this.consumeExpected(',');
            if (!this.tokenIs(')')) continue;
            this.error(33);
        }
        this.consumeExpected(')');
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    protected void IdKeyPattern() throws SAXException {
        this.FunctionCall();
    }

    protected void Literal() throws SAXException {
        int last = this.m_token.length() - 1;
        char c0 = this.m_tokenChar;
        char cX = this.m_token.charAt(last);
        if (c0 == '\"' && cX == '\"' || c0 == '\'' && cX == '\'') {
            int tokenQueuePos = this.m_queueMark - 1;
            this.m_xpath.m_tokenQueue[tokenQueuePos] = null;
            XString obj = new XString(this.m_token.substring(1, last));
            this.m_xpath.m_tokenQueue[tokenQueuePos] = obj;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = tokenQueuePos;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.nextToken();
        } else {
            this.error(37, new Object[]{this.m_token});
        }
    }

    protected void LocationPath() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.appendOp(2, 28);
        if (this.tokenIs('/')) {
            this.appendOp(4, 55);
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 2] = 4;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 1] = 35;
            this.nextToken();
        }
        if (this.m_token != null) {
            this.RelativeLocationPath();
        }
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    protected void LocationPathPattern() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.appendOp(2, 93);
        if (this.lookahead('(', 1) && this.tokenIs("id") || this.tokenIs(FUNC_KEY_STRING)) {
            this.IdKeyPattern();
        }
        if (this.tokenIs('/')) {
            if (this.lookahead('/', 1)) {
                this.appendOp(4, 95);
            } else {
                this.appendOp(4, 55);
            }
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 2] = 4;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 1] = 35;
            this.nextToken();
        }
        if (!this.tokenIs('|') && this.m_token != null) {
            this.RelativePathPattern();
        }
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    protected int MultiplicativeExpr(int addPos) throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        if (addPos == -1) {
            addPos = opPos;
        }
        this.UnaryExpr();
        if (this.m_token != null) {
            if (this.tokenIs('*')) {
                this.nextToken();
                this.insertOp(opPos, 2, 12);
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.MultiplicativeExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            } else if (this.tokenIs("div")) {
                this.nextToken();
                this.insertOp(opPos, 2, 13);
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.MultiplicativeExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            } else if (this.tokenIs("mod")) {
                this.nextToken();
                this.insertOp(opPos, 2, 14);
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.MultiplicativeExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            } else if (this.tokenIs("quo")) {
                this.nextToken();
                this.insertOp(opPos, 2, 15);
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.MultiplicativeExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            }
        }
        return addPos;
    }

    protected void NCName() {
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.m_queueMark - 1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.nextToken();
    }

    protected void NodeTest() throws SAXException {
        if (this.lookahead('(', 1)) {
            Object nodeTestOp = m_nodetypes.get(this.m_token);
            if (nodeTestOp == null) {
                this.error(36, new Object[]{this.m_token});
            } else {
                int nt;
                this.nextToken();
                this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = nt = ((Integer)nodeTestOp).intValue();
                this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
                this.consumeExpected('(');
                if (nt == 1032 && !this.tokenIs(')')) {
                    this.Literal();
                }
                this.consumeExpected(')');
            }
        } else {
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = 34;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            if (this.lookahead(':', 1)) {
                this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.tokenIs('*') ? -3 : this.m_queueMark - 1;
                this.nextToken();
                this.consumeExpected(':');
            } else {
                this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -2;
            }
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.tokenIs('*') ? -3 : this.m_queueMark - 1;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.nextToken();
        }
    }

    protected void Number() throws SAXException {
        if (this.m_token != null) {
            double num;
            try {
                num = Double.valueOf(this.m_token);
            }
            catch (NumberFormatException numberFormatException) {
                num = 0.0;
                this.error(38, new Object[]{this.m_token});
            }
            this.m_xpath.m_tokenQueue[this.m_queueMark - 1] = new XNumber(num);
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.m_queueMark - 1;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.nextToken();
        }
    }

    protected void NumberExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.appendOp(2, 19);
        this.Expr();
        this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    protected void OrExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.AndExpr();
        if (this.m_token != null && this.tokenIs("or")) {
            this.nextToken();
            this.insertOp(opPos, 2, 2);
            this.OrExpr();
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        }
    }

    protected void PathExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.FilterExpr();
        if (this.tokenIs('/')) {
            this.nextToken();
            this.insertOp(opPos, 2, 28);
            this.RelativeLocationPath();
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
            this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        }
    }

    protected void Pattern() throws SAXException {
        while (true) {
            this.LocationPathPattern();
            if (!this.tokenIs('|')) break;
            this.nextToken();
        }
    }

    protected void Predicate() throws SAXException {
        if (this.tokenIs('[')) {
            this.nextToken();
            this.PredicateExpr();
            this.consumeExpected(']');
        }
    }

    protected void PredicateExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.appendOp(2, 29);
        this.Expr();
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    protected void PrimaryExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        if (this.m_tokenChar == '\'' || this.m_tokenChar == '\"') {
            this.appendOp(2, 21);
            this.Literal();
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        } else if (this.m_tokenChar == '$') {
            this.nextToken();
            this.appendOp(2, 22);
            this.NCName();
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        } else if (this.m_tokenChar == '(') {
            this.nextToken();
            this.appendOp(2, 23);
            this.Expr();
            this.consumeExpected(')');
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        } else if (this.m_token != null && (this.m_tokenChar == '.' && this.m_token.length() > 1 && Character.isDigit(this.m_token.charAt(1)) || Character.isDigit(this.m_tokenChar))) {
            this.appendOp(2, 24);
            this.Number();
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        } else if (this.lookahead('(', 1) || this.lookahead(':', 1) && this.lookahead('(', 3)) {
            this.FunctionCall();
        } else {
            this.LocationPath();
        }
    }

    protected void QName() throws SAXException {
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.m_queueMark - 1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.nextToken();
        this.consumeExpected(':');
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = this.m_queueMark - 1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
        this.nextToken();
    }

    protected int RelationalExpr(int addPos) throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        if (addPos == -1) {
            addPos = opPos;
        }
        this.AdditiveExpr(-1);
        if (this.m_token != null) {
            if (this.tokenIs('<')) {
                this.nextToken();
                if (this.tokenIs('=')) {
                    this.nextToken();
                    this.insertOp(addPos, 2, 6);
                } else {
                    this.insertOp(addPos, 2, 7);
                }
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.RelationalExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            } else if (this.tokenIs('>')) {
                this.nextToken();
                if (this.tokenIs('=')) {
                    this.nextToken();
                    this.insertOp(addPos, 2, 8);
                } else {
                    this.insertOp(addPos, 2, 9);
                }
                int opPlusLeftHandLen = this.m_xpath.m_opMap[1] - addPos;
                addPos = this.RelationalExpr(addPos);
                this.m_xpath.m_opMap[addPos + 1] = this.m_xpath.m_opMap[addPos + opPlusLeftHandLen + 1] + opPlusLeftHandLen;
                addPos += 2;
            }
        }
        return addPos;
    }

    protected void RelativeLocationPath() throws SAXException {
        this.Step();
        while (this.tokenIs('/')) {
            this.nextToken();
            this.Step();
        }
    }

    protected void RelativePathPattern() throws SAXException {
        this.StepPattern();
        while (this.tokenIs('/')) {
            this.nextToken();
            this.StepPattern();
        }
    }

    protected void Step() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        if (this.tokenIs(FROM_SELF_ABBREVIATED_STRING)) {
            this.nextToken();
            if (this.tokenIs('[')) {
                this.error(34);
            }
            this.appendOp(4, 48);
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 2] = 4;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 1] = 1033;
        } else if (this.tokenIs("..")) {
            this.nextToken();
            this.appendOp(4, 45);
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 2] = 4;
            this.m_xpath.m_opMap[this.m_xpath.m_opMap[1] - 1] = 1033;
        } else {
            this.Basis();
            while (this.tokenIs('[')) {
                this.Predicate();
            }
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        }
    }

    protected void StepPattern() throws SAXException {
        this.AbbreviatedNodeTestStep();
    }

    protected void StringExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        this.appendOp(2, 17);
        this.Expr();
        this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    protected void UnaryExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        boolean isNeg = false;
        if (this.m_tokenChar == '-') {
            this.nextToken();
            this.appendOp(2, 16);
            isNeg = true;
        }
        this.UnionExpr();
        if (isNeg) {
            this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
        }
    }

    protected void UnionExpr() throws SAXException {
        int opPos = this.m_xpath.m_opMap[1];
        boolean continueOrLoop = true;
        boolean foundUnion = false;
        do {
            this.PathExpr();
            if (!this.tokenIs('|')) break;
            if (!foundUnion) {
                foundUnion = true;
                this.insertOp(opPos, 2, 20);
            }
            this.nextToken();
        } while (continueOrLoop);
        this.m_xpath.m_opMap[opPos + 1] = this.m_xpath.m_opMap[1] - opPos;
    }

    private void ____DIAGNOSTICS_AND_ERRORS____() {
    }

    private void ____DIAGNOSTIC_FUNCTIONS____() {
    }

    private void ____EXPRESSIONS____() {
    }

    private void ____LOCATION_PATHS____() {
    }

    private void ____PATTERNS____() {
    }

    private void ____TOKENIZATION_FUNCTIONS____() {
    }

    private void ____TOKEN_ACCESS_AND_MANIPULATION____() {
    }

    private void ___________LEXICAL_ANALYSIS___________() {
    }

    private void ___________PARSER___________() {
    }

    private final void addToTokenQueue(String s) {
        this.m_xpath.m_tokenQueue[this.m_xpath.m_tokenQueueSize++] = s;
    }

    void appendOp(int length, int op) {
        int totalLen = this.m_xpath.m_opMap[1];
        this.m_xpath.m_opMap[totalLen] = op;
        this.m_xpath.m_opMap[totalLen + 1] = length;
        this.m_xpath.m_opMap[1] = totalLen + length;
    }

    private void assert(boolean b, String msg) throws XPathProcessorException {
        if (!b) {
            this.error(null, 30, new Object[]{msg});
        }
    }

    private final void consumeExpected(char expected) throws SAXException {
        if (this.tokenIs(expected)) {
            this.nextToken();
        } else {
            this.error(29, new Object[]{String.valueOf(expected), this.m_token});
        }
    }

    private final void consumeExpected(String expected) throws SAXException {
        if (this.tokenIs(expected)) {
            this.nextToken();
        } else {
            this.error(29, new Object[]{expected, this.m_token});
        }
    }

    private static void diagnoseNodeTest2(int opPos, String op) {
        System.out.print(String.valueOf(m_nTestLabel) + op + m_close);
    }

    private static void diagnoseOp2(String op, XPath xpath, int opPos) {
        System.out.print(String.valueOf(m_opLabel) + op + m_close);
        int opLen = xpath.m_opMap[opPos + 1];
        System.out.println(String.valueOf(m_open) + opLen + m_close);
    }

    private static void diagnoseOp2SameLine(String op, XPath xpath, int opPos) {
        System.out.print(String.valueOf(m_opLabel) + op + m_close);
        int opLen = xpath.m_opMap[opPos + 1];
        System.out.print(String.valueOf(m_open) + opLen + m_close);
    }

    private static void diagnoseOpNoLable2(int opPos, String op) {
        System.out.println(String.valueOf(m_noLabel) + op + m_close);
    }

    private static void diagnoseOpOnly2(int opPos, String op) {
        System.out.println(String.valueOf(m_opLabel) + op + m_close);
    }

    static int diagnoseToken(XPath xpath, int opPos) {
        System.out.print("{");
        System.out.print(xpath.m_tokenQueue[xpath.m_opMap[opPos]]);
        System.out.print("}");
        return opPos + 1;
    }

    static int diagnoseToken2(XPath xpath, int opPos) {
        int tokenPos = xpath.m_opMap[opPos];
        String token = tokenPos >= 0 ? xpath.m_tokenQueue[tokenPos].toString() : (tokenPos == -3 ? "*" : (tokenPos == -2 ? "EMPTY" : "UNKNOWN"));
        System.out.println(String.valueOf(m_noLabel) + token + m_close);
        return opPos + 1;
    }

    static int diagnoseToken2SameLine(XPath xpath, int opPos) {
        System.out.print(String.valueOf(m_noLabel) + xpath.m_tokenQueue[xpath.m_opMap[opPos]] + m_close);
        return opPos + 1;
    }

    static int diagnoseXPath(XPath xpath, int opPos, int indent) {
        XPathProcessorImpl.indent(indent);
        switch (xpath.m_opMap[opPos]) {
            case 1: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_XPATH", xpath, opPos, indent);
                break;
            }
            case -2: {
                System.out.println("{EMPTY}");
                ++opPos;
                break;
            }
            case 2: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_OR", xpath, opPos, indent);
                break;
            }
            case 3: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_AND", xpath, opPos, indent);
                break;
            }
            case 4: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_NOTEQUALS", xpath, opPos, indent);
                break;
            }
            case 5: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_EQUALS", xpath, opPos, indent);
                break;
            }
            case 6: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_LTE", xpath, opPos, indent);
                break;
            }
            case 7: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_LT", xpath, opPos, indent);
                break;
            }
            case 8: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_GTE", xpath, opPos, indent);
                break;
            }
            case 9: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_GT", xpath, opPos, indent);
                break;
            }
            case 10: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_PLUS", xpath, opPos, indent);
                break;
            }
            case 11: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_MINUS", xpath, opPos, indent);
                break;
            }
            case 12: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_MULT", xpath, opPos, indent);
                break;
            }
            case 13: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_DIV", xpath, opPos, indent);
                break;
            }
            case 14: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_MOD", xpath, opPos, indent);
                break;
            }
            case 15: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation("OP_QUO", xpath, opPos, indent);
                break;
            }
            case 16: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_NEG", xpath, opPos, indent);
                break;
            }
            case 17: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_STRING", xpath, opPos, indent);
                break;
            }
            case 18: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_BOOL", xpath, opPos, indent);
                break;
            }
            case 19: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_NUMBER", xpath, opPos, indent);
                break;
            }
            case 20: {
                opPos = XPathProcessorImpl.diagnoseXPathMultiOperation("OP_UNION", 28, xpath, opPos, indent);
                break;
            }
            case 21: {
                opPos = XPathProcessorImpl.diagnoseXPathSimpleOperation("OP_LITERAL", xpath, opPos, indent);
                break;
            }
            case 22: {
                opPos = XPathProcessorImpl.diagnoseXPathSimpleOperation("OP_VARIABLE", xpath, opPos, indent);
                break;
            }
            case 23: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_GROUP", xpath, opPos, indent);
                break;
            }
            case 24: {
                opPos = XPathProcessorImpl.diagnoseXPathSimpleOperation("OP_NUMBERLIT", xpath, opPos, indent);
                break;
            }
            case 25: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_ARGUMENT", xpath, opPos, indent);
                break;
            }
            case 26: {
                System.out.println("OP_EXTFUNCTION {");
                int endExtFunc = opPos + xpath.m_opMap[opPos + 1] - 1;
                opPos += 2;
                XPathProcessorImpl.indent(indent + 1);
                opPos = XPathProcessorImpl.diagnoseToken(xpath, opPos);
                System.out.print(":");
                opPos = XPathProcessorImpl.diagnoseToken(xpath, opPos);
                System.out.println("");
                while (opPos < endExtFunc) {
                    XPathProcessorImpl.indent(indent + 1);
                    System.out.println("{");
                    opPos = XPathProcessorImpl.diagnoseXPath(xpath, opPos, indent + 2);
                    XPathProcessorImpl.indent(indent + 1);
                    System.out.println("}");
                }
                XPathProcessorImpl.indent(indent);
                System.out.println("}");
                if (xpath.m_opMap[opPos] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                ++opPos;
                break;
            }
            case 27: {
                System.out.println("OP_FUNCTION {");
                int endFunc = opPos + xpath.m_opMap[opPos + 1] - 1;
                XPathProcessorImpl.indent(indent + 1);
                int funcID = xpath.m_opMap[opPos += 2];
                switch (funcID) {
                    case 1: {
                        System.out.print("FUNC_LAST");
                        break;
                    }
                    case 2: {
                        System.out.print("FUNC_POSITION");
                        break;
                    }
                    case 3: {
                        System.out.print("FUNC_COUNT");
                        break;
                    }
                    case 4: {
                        System.out.print("FUNC_ID");
                        break;
                    }
                    case 5: {
                        System.out.print("FUNC_KEY");
                        break;
                    }
                    case 7: {
                        System.out.print("FUNC_LOCAL_PART");
                        break;
                    }
                    case 8: {
                        System.out.print("FUNC_NAMESPACE");
                        break;
                    }
                    case 9: {
                        System.out.print("FUNC_QNAME");
                        break;
                    }
                    case 10: {
                        System.out.print("FUNC_GENERATE_ID");
                        break;
                    }
                    case 11: {
                        System.out.print("FUNC_NOT");
                        break;
                    }
                    case 12: {
                        System.out.print("FUNC_TRUE");
                        break;
                    }
                    case 13: {
                        System.out.print("FUNC_FALSE");
                        break;
                    }
                    case 14: {
                        System.out.print("FUNC_BOOLEAN");
                        break;
                    }
                    case 32: {
                        System.out.print("FUNC_LANG");
                        break;
                    }
                    case 15: {
                        System.out.print("FUNC_NUMBER");
                        break;
                    }
                    case 16: {
                        System.out.print("FUNC_FLOOR");
                        break;
                    }
                    case 17: {
                        System.out.print("FUNC_CEILING");
                        break;
                    }
                    case 18: {
                        System.out.print("FUNC_ROUND");
                        break;
                    }
                    case 19: {
                        System.out.print("FUNC_SUM");
                        break;
                    }
                    case 20: {
                        System.out.print("FUNC_STRING");
                        break;
                    }
                    case 21: {
                        System.out.print("FUNC_STARTS_WITH");
                        break;
                    }
                    case 22: {
                        System.out.print("FUNC_CONTAINS");
                        break;
                    }
                    case 23: {
                        System.out.print("FUNC_SUBSTRING_BEFORE");
                        break;
                    }
                    case 24: {
                        System.out.print("FUNC_SUBSTRING_AFTER");
                        break;
                    }
                    case 25: {
                        System.out.print("FUNC_NORMALIZE_SPACE");
                        break;
                    }
                    case 26: {
                        System.out.print("FUNC_TRANSLATE");
                        break;
                    }
                    case 27: {
                        System.out.print("FUNC_CONCAT");
                        break;
                    }
                    case 31: {
                        System.out.print("FUNC_SYSTEM_PROPERTY");
                        break;
                    }
                    case 33: {
                        System.out.print("FUNC_EXT_FUNCTION_AVAILABLE");
                        break;
                    }
                    case 34: {
                        System.out.print("FUNC_EXT_ELEM_AVAILABLE");
                        break;
                    }
                    case 29: {
                        System.out.print("FUNC_SUBSTRING");
                        break;
                    }
                    case 30: {
                        System.out.print("FUNC_STRING_LENGTH");
                        break;
                    }
                    case 35: {
                        System.out.print("FUNC_DOCLOCATION");
                        break;
                    }
                }
                ++opPos;
                System.out.println("");
                while (opPos < endFunc) {
                    XPathProcessorImpl.indent(indent + 1);
                    System.out.println("{");
                    opPos = XPathProcessorImpl.diagnoseXPath(xpath, opPos, indent + 2);
                    XPathProcessorImpl.indent(indent + 1);
                    System.out.println("}");
                }
                XPathProcessorImpl.indent(indent);
                System.out.println("}");
                if (xpath.m_opMap[opPos] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                ++opPos;
                break;
            }
            case 28: {
                System.out.println("OP_LOCATIONPATH {");
                int endPath = opPos + xpath.m_opMap[opPos + 1] - 1;
                opPos += 2;
                while (opPos < endPath) {
                    opPos = XPathProcessorImpl.diagnoseXPath(xpath, opPos, indent + 1);
                }
                XPathProcessorImpl.indent(indent);
                System.out.println("}");
                if (xpath.m_opMap[opPos] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                ++opPos;
                break;
            }
            case 29: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation("OP_PREDICATE", xpath, opPos, indent);
                if (xpath.m_opMap[opPos] != -1) {
                    System.out.println("ERROR! Could not find ENDOP after OP_LOCATIONPATH");
                }
                ++opPos;
                break;
            }
            case 37: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_ANCESTORS", xpath, opPos, 1);
                break;
            }
            case 38: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_ANCESTORS_OR_SELF", xpath, opPos, 1);
                break;
            }
            case 39: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_ATTRIBUTES", xpath, opPos, 1);
                break;
            }
            case 40: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_CHILDREN", xpath, opPos, 1);
                break;
            }
            case 41: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_DESCENDANTS", xpath, opPos, 1);
                break;
            }
            case 42: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_DESCENDANTS_OR_SELF", xpath, opPos, 1);
                break;
            }
            case 43: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_FOLLOWING", xpath, opPos, indent);
                break;
            }
            case 44: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_FOLLOWING_SIBLINGS", xpath, opPos, indent);
                break;
            }
            case 45: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_PARENT", xpath, opPos, indent);
                break;
            }
            case 46: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_PRECEDING", xpath, opPos, indent);
                break;
            }
            case 47: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_PRECEDING_SIBLINGS", xpath, opPos, indent);
                break;
            }
            case 48: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_SELF", xpath, opPos, indent);
                break;
            }
            case 49: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_NAMESPACE", xpath, opPos, indent);
                break;
            }
            case 55: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep("FROM_ROOT", xpath, opPos, indent);
                break;
            }
            case 1030: {
                System.out.println("{NODETYPE_COMMENT}");
                ++opPos;
                break;
            }
            case 1031: {
                System.out.println("{NODETYPE_TEXT}");
                ++opPos;
                break;
            }
            case 1032: {
                int piLen = xpath.m_opMap[opPos - 1];
                System.out.println("{NODETYPE_PI ");
                ++opPos;
                if (piLen <= 3) break;
                opPos = XPathProcessorImpl.diagnoseToken(xpath, opPos);
                break;
            }
            case 1033: {
                System.out.println("{NODETYPE_NODE}");
                ++opPos;
                break;
            }
            case 35: {
                System.out.println("{NODETYPE_ROOT}");
                ++opPos;
                break;
            }
            case 36: {
                System.out.println("{NODETYPE_ANYELEMENT}");
                ++opPos;
                break;
            }
            case 34: {
                System.out.print("{NODENAME ");
                if (xpath.m_opMap[++opPos] < 0) {
                    System.out.print("{EMPTY}");
                    ++opPos;
                } else {
                    opPos = XPathProcessorImpl.diagnoseToken(xpath, opPos);
                }
                System.out.print(":");
                opPos = XPathProcessorImpl.diagnoseToken(xpath, opPos);
                break;
            }
            default: {
                System.out.println(XSLMessages.createXPATHMessage(24, new Object[]{Integer.toString(xpath.m_opMap[opPos])}));
            }
        }
        return opPos;
    }

    static int diagnoseXPath2(XPath xpath, int opPos, int indent) {
        XPathProcessorImpl.indent(indent);
        switch (xpath.m_opMap[opPos]) {
            case 1: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_XPATH", xpath, opPos, indent);
                break;
            }
            case -2: {
                XPathProcessorImpl.diagnoseOpOnly2(opPos, "EMPTY");
                ++opPos;
                break;
            }
            case 2: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_OR", xpath, opPos, indent);
                break;
            }
            case 3: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_AND", xpath, opPos, indent);
                break;
            }
            case 4: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_NOTEQUALS", xpath, opPos, indent);
                break;
            }
            case 5: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_EQUALS", xpath, opPos, indent);
                break;
            }
            case 6: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_LTE", xpath, opPos, indent);
                break;
            }
            case 7: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_LT", xpath, opPos, indent);
                break;
            }
            case 8: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_GTE", xpath, opPos, indent);
                break;
            }
            case 9: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_GT", xpath, opPos, indent);
                break;
            }
            case 10: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_PLUS", xpath, opPos, indent);
                break;
            }
            case 11: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_MINUS", xpath, opPos, indent);
                break;
            }
            case 12: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_MULT", xpath, opPos, indent);
                break;
            }
            case 13: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_DIV", xpath, opPos, indent);
                break;
            }
            case 14: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_MOD", xpath, opPos, indent);
                break;
            }
            case 15: {
                opPos = XPathProcessorImpl.diagnoseXPathBinaryOperation2("OP_QUO", xpath, opPos, indent);
                break;
            }
            case 16: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_NEG", xpath, opPos, indent);
                break;
            }
            case 17: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_STRING", xpath, opPos, indent);
                break;
            }
            case 18: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_BOOL", xpath, opPos, indent);
                break;
            }
            case 19: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_NUMBER", xpath, opPos, indent);
                break;
            }
            case 20: {
                opPos = XPathProcessorImpl.diagnoseXPathMultiOperation2("OP_UNION", 28, xpath, opPos, indent);
                break;
            }
            case 21: {
                opPos = XPathProcessorImpl.diagnoseXPathSimpleOperation2("OP_LITERAL", xpath, opPos, indent);
                break;
            }
            case 22: {
                opPos = XPathProcessorImpl.diagnoseXPathSimpleOperation2("OP_VARIABLE", xpath, opPos, indent);
                break;
            }
            case 23: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_GROUP", xpath, opPos, indent);
                break;
            }
            case 24: {
                opPos = XPathProcessorImpl.diagnoseXPathSimpleOperation2("OP_NUMBERLIT", xpath, opPos, indent);
                break;
            }
            case 25: {
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_ARGUMENT", xpath, opPos, indent);
                break;
            }
            case 26: {
                XPathProcessorImpl.diagnoseOp2SameLine("OP_EXTFUNCTION", xpath, opPos);
                int endExtFunc = opPos + xpath.m_opMap[opPos + 1] - 1;
                opPos += 2;
                opPos = XPathProcessorImpl.diagnoseToken2SameLine(xpath, opPos);
                opPos = XPathProcessorImpl.diagnoseToken2(xpath, opPos);
                while (opPos < endExtFunc) {
                    opPos = XPathProcessorImpl.diagnoseXPath2(xpath, opPos, indent + 2);
                }
                if (xpath.m_opMap[opPos] != -1) {
                    System.out.println("ERROR! Could not find ENDOP after OP_LOCATIONPATH");
                }
                XPathProcessorImpl.indent(indent + 1);
                XPathProcessorImpl.diagnoseOpOnly2(opPos, "ENDOP");
                ++opPos;
                break;
            }
            case 27: {
                XPathProcessorImpl.diagnoseOp2SameLine("OP_FUNCTION", xpath, opPos);
                int endFunc = opPos + xpath.m_opMap[opPos + 1] - 1;
                int funcID = xpath.m_opMap[opPos += 2];
                switch (funcID) {
                    case 1: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_LAST");
                        break;
                    }
                    case 2: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_POSITION");
                        break;
                    }
                    case 3: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_COUNT");
                        break;
                    }
                    case 4: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_ID");
                        break;
                    }
                    case 5: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_KEY");
                        break;
                    }
                    case 7: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_LOCAL_PART");
                        break;
                    }
                    case 8: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_NAMESPACE");
                        break;
                    }
                    case 9: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_QNAME");
                        break;
                    }
                    case 10: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_GENERATE_ID");
                        break;
                    }
                    case 11: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_NOT");
                        break;
                    }
                    case 12: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_TRUE");
                        break;
                    }
                    case 13: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_FALSE");
                        break;
                    }
                    case 14: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_BOOLEAN");
                        break;
                    }
                    case 32: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_LANG");
                        break;
                    }
                    case 15: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_NUMBER");
                        break;
                    }
                    case 16: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_FLOOR");
                        break;
                    }
                    case 17: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_CEILING");
                        break;
                    }
                    case 18: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_ROUND");
                        break;
                    }
                    case 19: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_SUM");
                        break;
                    }
                    case 20: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_STRING");
                        break;
                    }
                    case 21: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_STARTS_WITH");
                        break;
                    }
                    case 22: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_CONTAINS");
                        break;
                    }
                    case 23: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_SUBSTRING_BEFORE");
                        break;
                    }
                    case 24: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_SUBSTRING_AFTER");
                        break;
                    }
                    case 25: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_NORMALIZE_SPACE");
                        break;
                    }
                    case 26: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_TRANSLATE");
                        break;
                    }
                    case 27: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_CONCAT");
                        break;
                    }
                    case 31: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_SYSTEM_PROPERTY");
                        break;
                    }
                    case 33: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_EXT_FUNCTION_AVAILABLE");
                        break;
                    }
                    case 34: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_EXT_ELEM_AVAILABLE");
                        break;
                    }
                    case 29: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_SUBSTRING");
                        break;
                    }
                    case 30: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_STRING_LENGTH");
                        break;
                    }
                    case 35: {
                        XPathProcessorImpl.diagnoseOpNoLable2(opPos, "FUNC_DOCLOCATION");
                        break;
                    }
                }
                ++opPos;
                while (opPos < endFunc) {
                    opPos = XPathProcessorImpl.diagnoseXPath2(xpath, opPos, indent + 2);
                }
                XPathProcessorImpl.indent(indent);
                if (xpath.m_opMap[opPos] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                XPathProcessorImpl.indent(indent + 1);
                XPathProcessorImpl.diagnoseOpOnly2(opPos, "ENDOP");
                ++opPos;
                break;
            }
            case 28: {
                XPathProcessorImpl.diagnoseOp2("OP_LOCATIONPATH", xpath, opPos);
                int endPath = opPos + xpath.m_opMap[opPos + 1] - 1;
                opPos += 2;
                while (opPos < endPath) {
                    opPos = XPathProcessorImpl.diagnoseXPath2(xpath, opPos, indent + 1);
                }
                if (xpath.m_opMap[opPos] != -1) {
                    System.out.println(XSLMessages.createXPATHMessage(41, null));
                }
                XPathProcessorImpl.indent(indent + 1);
                XPathProcessorImpl.diagnoseOpOnly2(opPos, "ENDOP");
                ++opPos;
                break;
            }
            case 29: {
                XPathProcessorImpl.indent(1);
                opPos = XPathProcessorImpl.diagnoseXPathUnaryOperation2("OP_PREDICATE", xpath, opPos, indent + 1);
                if (xpath.m_opMap[opPos] != -1) {
                    System.out.println("ERROR! Could not find ENDOP after OP_LOCATIONPATH");
                }
                XPathProcessorImpl.indent(indent + 2);
                XPathProcessorImpl.diagnoseOpOnly2(opPos, "ENDOP");
                ++opPos;
                break;
            }
            case 37: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_ANCESTORS", xpath, opPos, 1);
                break;
            }
            case 38: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_ANCESTORS_OR_SELF", xpath, opPos, 1);
                break;
            }
            case 39: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_ATTRIBUTES", xpath, opPos, 1);
                break;
            }
            case 40: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_CHILDREN", xpath, opPos, 1);
                break;
            }
            case 41: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_DESCENDANTS", xpath, opPos, 1);
                break;
            }
            case 42: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_DESCENDANTS_OR_SELF", xpath, opPos, 1);
                break;
            }
            case 43: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_FOLLOWING", xpath, opPos, indent);
                break;
            }
            case 44: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_FOLLOWING_SIBLINGS", xpath, opPos, indent);
                break;
            }
            case 45: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_PARENT", xpath, opPos, indent);
                break;
            }
            case 46: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_PRECEDING", xpath, opPos, indent);
                break;
            }
            case 47: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_PRECEDING_SIBLINGS", xpath, opPos, indent);
                break;
            }
            case 48: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_SELF", xpath, opPos, indent);
                break;
            }
            case 49: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_NAMESPACE", xpath, opPos, indent);
                break;
            }
            case 55: {
                opPos = XPathProcessorImpl.diagnoseXPathLocationStep2("FROM_ROOT", xpath, opPos, indent);
                break;
            }
            case 1030: {
                XPathProcessorImpl.diagnoseNodeTest2(opPos, "NODETYPE_COMMENT");
                System.out.println();
                ++opPos;
                break;
            }
            case 1031: {
                XPathProcessorImpl.diagnoseNodeTest2(opPos, "NODETYPE_TEXT");
                System.out.println();
                ++opPos;
                break;
            }
            case 1032: {
                int piLen = xpath.m_opMap[opPos - 1];
                XPathProcessorImpl.diagnoseNodeTest2(opPos, "NODETYPE_PI");
                ++opPos;
                if (piLen <= 3) break;
                opPos = XPathProcessorImpl.diagnoseToken(xpath, opPos);
                break;
            }
            case 1033: {
                XPathProcessorImpl.diagnoseNodeTest2(opPos, "NODETYPE_NODE");
                System.out.println();
                ++opPos;
                break;
            }
            case 35: {
                XPathProcessorImpl.diagnoseNodeTest2(opPos, "NODETYPE_ROOT");
                System.out.println();
                ++opPos;
                break;
            }
            case 36: {
                XPathProcessorImpl.diagnoseNodeTest2(opPos, "NODETYPE_ANYELEMENT");
                System.out.println();
                ++opPos;
                break;
            }
            case 34: {
                XPathProcessorImpl.diagnoseNodeTest2(opPos, "NODENAME");
                if (xpath.m_opMap[++opPos] < 0) {
                    System.out.print(String.valueOf(m_noLabel) + "EMPTY" + m_close);
                    ++opPos;
                } else {
                    opPos = XPathProcessorImpl.diagnoseToken2(xpath, opPos);
                }
                opPos = XPathProcessorImpl.diagnoseToken2(xpath, opPos);
                break;
            }
            default: {
                System.out.println(XSLMessages.createXPATHMessage(24, new Object[]{Integer.toString(xpath.m_opMap[opPos])}));
            }
        }
        return opPos;
    }

    static int diagnoseXPathBinaryOperation(String op, XPath xpath, int opPos, int indent) {
        System.out.println(String.valueOf(op) + " {");
        opPos += 2;
        opPos = XPathProcessorImpl.diagnoseXPath(xpath, opPos, indent + 1);
        opPos = XPathProcessorImpl.diagnoseXPath(xpath, opPos, indent + 1);
        XPathProcessorImpl.indent(indent);
        System.out.println("}");
        return opPos;
    }

    static int diagnoseXPathBinaryOperation2(String op, XPath xpath, int opPos, int indent) {
        XPathProcessorImpl.diagnoseOp2(op, xpath, opPos);
        opPos += 2;
        opPos = XPathProcessorImpl.diagnoseXPath2(xpath, opPos, indent + 1);
        opPos = XPathProcessorImpl.diagnoseXPath2(xpath, opPos, indent + 1);
        return opPos;
    }

    static int diagnoseXPathLocationStep(String op, XPath xpath, int opPos, int indent) {
        int stepLen = xpath.m_opMap[opPos + 1 + 1];
        opPos += 3;
        System.out.print(op);
        if (stepLen > 3) {
            opPos = XPathProcessorImpl.diagnoseXPath(xpath, opPos, 1);
        }
        System.out.println("");
        return opPos;
    }

    static int diagnoseXPathLocationStep2(String op, XPath xpath, int opPos, int indent) {
        int opLen = xpath.m_opMap[opPos + 1];
        int stepLen = xpath.m_opMap[opPos + 1 + 1];
        System.out.print(String.valueOf(m_opLabel) + op + m_close);
        System.out.print(String.valueOf(m_open) + opLen + m_close);
        System.out.print(String.valueOf(m_open) + stepLen + m_close);
        opPos += 3;
        if (stepLen > 3) {
            opPos = XPathProcessorImpl.diagnoseXPath2(xpath, opPos, 0);
        }
        return opPos;
    }

    static int diagnoseXPathMultiOperation(String op, int multiOp, XPath xpath, int opPos, int indent) {
        System.out.println(String.valueOf(op) + " {");
        opPos += 2;
        while (xpath.m_opMap[opPos] == multiOp) {
            XPathProcessorImpl.indent(indent + 1);
            System.out.println("{");
            opPos = XPathProcessorImpl.diagnoseXPath(xpath, opPos, indent + 2);
            XPathProcessorImpl.indent(indent + 1);
            System.out.println("}");
        }
        XPathProcessorImpl.indent(indent);
        System.out.println("}");
        return opPos;
    }

    static int diagnoseXPathMultiOperation2(String op, int multiOp, XPath xpath, int opPos, int indent) {
        XPathProcessorImpl.diagnoseOp2(op, xpath, opPos);
        opPos += 2;
        while (xpath.m_opMap[opPos] == multiOp) {
            opPos = XPathProcessorImpl.diagnoseXPath2(xpath, opPos, indent + 2);
        }
        return opPos;
    }

    static int diagnoseXPathSimpleOperation(String op, XPath xpath, int opPos, int indent) {
        opPos += 2;
        System.out.print(op);
        opPos = XPathProcessorImpl.diagnoseToken(xpath, opPos);
        System.out.println("");
        return opPos;
    }

    static int diagnoseXPathSimpleOperation2(String op, XPath xpath, int opPos, int indent) {
        XPathProcessorImpl.diagnoseOp2SameLine(op, xpath, opPos);
        opPos += 2;
        opPos = XPathProcessorImpl.diagnoseToken2(xpath, opPos);
        return opPos;
    }

    public static void diagnoseXPathString(String str) throws SAXException {
        XPathSupportDefault callbacks = new XPathSupportDefault();
        XPathProcessorImpl processor = new XPathProcessorImpl(callbacks);
        XPath xpath = new XPath(callbacks, new ProblemListenerDefault());
        processor.initXPath(xpath, str, null);
        XPathProcessorImpl.diagnoseXPath(xpath, 0, 0);
    }

    public static void diagnoseXPathString2(String str) throws SAXException {
        XPathSupportDefault callbacks = new XPathSupportDefault();
        XPathProcessorImpl processor = new XPathProcessorImpl(callbacks);
        XPath xpath = new XPath(callbacks, new ProblemListenerDefault());
        processor.initXPath(xpath, str, null);
        XPathProcessorImpl.diagnoseXPath2(xpath, 0, 0);
    }

    public static void diagnoseXPathString3(String str) throws SAXException {
        XPathSupportDefault callbacks = new XPathSupportDefault();
        XPathProcessorImpl processor = new XPathProcessorImpl(callbacks);
        XPath xpath = new XPath(callbacks, new ProblemListenerDefault());
        processor.initXPath(xpath, str, null);
        int len = xpath.m_opMap[1];
        int i = 0;
        while (i < len) {
            System.out.println("[" + xpath.m_opMap[i] + "]");
            ++i;
        }
    }

    static int diagnoseXPathUnaryOperation(String op, XPath xpath, int opPos, int indent) {
        System.out.println(String.valueOf(op) + " {");
        opPos += 2;
        opPos = XPathProcessorImpl.diagnoseXPath(xpath, opPos, indent + 1);
        XPathProcessorImpl.indent(indent);
        System.out.println("}");
        return opPos;
    }

    static int diagnoseXPathUnaryOperation2(String op, XPath xpath, int opPos, int indent) {
        XPathProcessorImpl.diagnoseOp2(op, xpath, opPos);
        opPos += 2;
        opPos = XPathProcessorImpl.diagnoseXPath2(xpath, opPos, indent + 1);
        return opPos;
    }

    public void displayDuration(String info, Object key) {
        long millisecondsDuration = 0L;
        if (key != null) {
            Date date1 = (Date)this.m_durationsTable.get(key);
            Date date2 = new Date();
            millisecondsDuration = date2.getTime() - date1.getTime();
            System.out.println(String.valueOf(info) + " took " + millisecondsDuration + " milliseconds");
            this.m_durationsTable.remove(key);
        }
    }

    protected String dumpRemainingTokenQueue() {
        String returnMsg;
        int q = this.m_queueMark;
        if (q < this.m_xpath.m_tokenQueueSize) {
            String msg = "\n Remaining tokens: (";
            while (q < this.m_xpath.m_tokenQueueSize) {
                String t = (String)this.m_xpath.m_tokenQueue[q++];
                msg = String.valueOf(msg) + " '" + t + "'";
            }
            returnMsg = String.valueOf(msg) + ")";
        } else {
            returnMsg = "";
        }
        return returnMsg;
    }

    public void error(int msg) throws XPathProcessorException {
        this.error(null, msg, null);
    }

    public void error(int msg, Object[] args) throws XPathProcessorException {
        this.error(null, msg, args);
    }

    public void error(Node sourceNode, int msg) throws XPathProcessorException {
        this.error(sourceNode, msg, null);
    }

    public void error(Node sourceNode, int msg, Object[] args) throws XPathProcessorException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        String emsg = String.valueOf(this.m_xpath.m_currentPattern != null ? "pattern = '" + this.m_xpath.m_currentPattern + "'\n" : "") + fmsg + this.dumpRemainingTokenQueue();
        boolean shouldThrow = this.m_xpath.getProblemListener().problem((short)5, (short)2, this.m_namespaceContext, sourceNode, emsg, null, 0, 0);
        if (shouldThrow) {
            throw new XPathProcessorException(emsg);
        }
    }

    final int getFunctionToken(String key) {
        int tok;
        try {
            tok = (Integer)m_functions.get(key);
        }
        catch (NullPointerException nullPointerException) {
            tok = -1;
        }
        catch (ClassCastException classCastException) {
            tok = -1;
        }
        return tok;
    }

    final int getKeywordToken(String key) {
        int tok;
        try {
            Integer itok = (Integer)m_keywords.get(key);
            tok = itok != null ? itok : 0;
        }
        catch (NullPointerException nullPointerException) {
            tok = 0;
        }
        catch (ClassCastException classCastException) {
            tok = 0;
        }
        return tok;
    }

    int getNextIndexInMap(int i) {
        int next = this.m_xpath.m_patternMap[i] >= 10000 ? -1 : (i + 1 < this.m_xpath.m_patternMapSize ? i + 1 : -1);
        return next;
    }

    int getNextPatternPos(int i) {
        int next = -1;
        int k = i + 1;
        int nElems = this.m_xpath.m_patternMapSize;
        if (k < nElems) {
            int prevPos;
            int n = prevPos = i >= 0 ? this.m_xpath.m_patternMap[i] : 0;
            if (prevPos != 10000) {
                next = this.m_xpath.m_patternMap[k];
            }
        }
        return next;
    }

    int getNextSubpatternStartIndexInMap(int i) {
        int next = -1;
        if (i == -1) {
            next = 0;
        } else {
            int k = i;
            while (k < this.m_xpath.m_patternMapSize) {
                int pos = this.m_xpath.m_patternMap[k];
                if (pos >= 10000) {
                    if (k + 1 >= this.m_xpath.m_patternMapSize) break;
                    next = k + 1;
                    break;
                }
                ++k;
            }
        }
        return next;
    }

    int getNextTargetIndexInMap(int i) {
        int next = -1;
        int k = i + 1;
        while (k < this.m_xpath.m_patternMapSize) {
            int pos = this.m_xpath.m_patternMap[k];
            if (pos >= 10000) {
                next = k;
                break;
            }
            ++k;
        }
        return next;
    }

    int getPrevMapIndex(int i) {
        int pos;
        int prev = -1;
        int k = i - 1;
        if (k >= 0 && (pos = this.m_xpath.m_patternMap[k]) < 10000) {
            prev = k;
        }
        return prev;
    }

    int getTokenQueuePosFromMap(int i) {
        int pos = this.m_xpath.m_patternMap[i];
        return pos >= 10000 ? pos - 10000 : pos;
    }

    private final String getTokenRelative(int i) {
        int relative = this.m_queueMark + i;
        String tok = relative > 0 && relative < this.m_xpath.m_tokenQueueSize ? (String)this.m_xpath.m_tokenQueue[relative] : null;
        return tok;
    }

    static void indent(int amount) {
        int n = amount * 3;
        int i = 0;
        while (i < n) {
            System.out.print(" ");
            ++i;
        }
    }

    public void initMatchPattern(XPath pathObj, String expression, PrefixResolver namespaceContext) throws SAXException {
        this.m_xpath = pathObj;
        this.m_namespaceContext = namespaceContext;
        this.tokenize(expression);
        this.m_xpath.m_opMap[0] = 92;
        this.m_xpath.m_opMap[1] = 2;
        this.nextToken();
        this.Pattern();
        if (this.m_token != null) {
            String extraTokens = "";
            while (this.m_token != null) {
                extraTokens = String.valueOf(extraTokens) + "'" + this.m_token + "'";
                this.nextToken();
                if (this.m_token == null) continue;
                extraTokens = String.valueOf(extraTokens) + ", ";
            }
            this.error(25, new Object[]{extraTokens});
        }
        this.m_xpath.m_opMap[this.m_xpath.m_opMap[1]] = -1;
        this.m_xpath.m_opMap[1] = this.m_xpath.m_opMap[1] + 1;
    }

    public void initXPath(XPath pathObj, String expression, PrefixResolver namespaceContext) throws SAXException {
        this.m_xpath = pathObj;
        this.m_namespaceContext = namespaceContext;
        this.tokenize(expression);
        this.m_xpath.m_opMap[0] = 1;
        this.m_xpath.m_opMap[1] = 2;
        this.nextToken();
        this.Expr();
        if (this.m_token != null) {
            String extraTokens = "";
            while (this.m_token != null) {
                extraTokens = String.valueOf(extraTokens) + "'" + this.m_token + "'";
                this.nextToken();
                if (this.m_token == null) continue;
                extraTokens = String.valueOf(extraTokens) + ", ";
            }
            this.error(25, new Object[]{extraTokens});
        }
    }

    void insertOp(int pos, int length, int op) {
        int totalLen = this.m_xpath.m_opMap[1];
        int i = totalLen - 1;
        while (i >= pos) {
            this.m_xpath.m_opMap[i + length] = this.m_xpath.m_opMap[i];
            --i;
        }
        this.m_xpath.m_opMap[pos] = op;
        this.m_xpath.m_opMap[1] = totalLen + length;
    }

    private final boolean lookahead(char c, int n) {
        String tok;
        int pos = this.m_queueMark + n;
        boolean b = pos <= this.m_xpath.m_tokenQueueSize && pos > 0 && this.m_xpath.m_tokenQueueSize != 0 ? ((tok = (String)this.m_xpath.m_tokenQueue[pos - 1]).length() == 1 ? tok.charAt(0) == c : false) : false;
        return b;
    }

    private final boolean lookahead(String s, int n) {
        String lookahead;
        boolean isToken = this.m_queueMark + n <= this.m_xpath.m_tokenQueueSize ? ((lookahead = (String)this.m_xpath.m_tokenQueue[this.m_queueMark + (n - 1)]) != null ? lookahead.equals(s) : s == null) : s == null;
        return isToken;
    }

    private final boolean lookbehind(char c, int n) {
        boolean isToken;
        int lookBehindPos = this.m_queueMark - (n + 1);
        if (lookBehindPos >= 0) {
            String lookbehind = (String)this.m_xpath.m_tokenQueue[lookBehindPos];
            if (lookbehind.length() == 1) {
                char c0;
                char c2 = c0 = lookbehind == null ? (char)'|' : (char)lookbehind.charAt(0);
                isToken = c0 == '|' ? false : c0 == c;
            } else {
                isToken = false;
            }
        } else {
            isToken = false;
        }
        return isToken;
    }

    private final boolean lookbehindHasToken(int n) {
        boolean hasToken;
        if (this.m_queueMark - n > 0) {
            String lookbehind = (String)this.m_xpath.m_tokenQueue[this.m_queueMark - (n - 1)];
            int c0 = lookbehind == null ? 124 : (int)lookbehind.charAt(0);
            hasToken = c0 != 124;
        } else {
            hasToken = false;
        }
        return hasToken;
    }

    private int mapNSTokens(String pat, int startSubstring, int posOfNSSep, int posOfScan) {
        String uName;
        String prefix = pat.substring(startSubstring, posOfNSSep);
        if (this.m_namespaceContext != null) {
            try {
                uName = this.m_namespaceContext.getNamespaceForPrefix(prefix);
            }
            catch (ClassCastException classCastException) {
                uName = this.m_namespaceContext.getNamespaceForPrefix(prefix);
            }
        } else {
            uName = prefix;
        }
        if (uName != null && uName.length() > 0) {
            this.addToTokenQueue(uName);
            this.addToTokenQueue(":");
            String s = pat.substring(posOfNSSep + 1, posOfScan);
            if (s.length() > 0) {
                this.addToTokenQueue(s);
            }
        } else {
            this.addToTokenQueue(prefix);
            this.addToTokenQueue(":");
            String s = pat.substring(posOfNSSep + 1, posOfScan);
            if (s.length() > 0) {
                this.addToTokenQueue(s);
            }
        }
        return -1;
    }

    private boolean mapPatternElemPos(int nesting, boolean isStart, boolean isAttrName) {
        if (nesting == 0) {
            if (!isStart) {
                int n = this.m_xpath.m_patternMapSize - 1;
                this.m_xpath.m_patternMap[n] = this.m_xpath.m_patternMap[n] - 10000;
            }
            this.m_xpath.m_patternMap[this.m_xpath.m_patternMapSize] = this.m_xpath.m_tokenQueueSize - (isAttrName ? 1 : 0) + 10000;
            ++this.m_xpath.m_patternMapSize;
            isStart = false;
        }
        return isStart;
    }

    private final void nextToken() {
        if (this.m_queueMark < this.m_xpath.m_tokenQueueSize) {
            this.m_token = (String)this.m_xpath.m_tokenQueue[this.m_queueMark++];
            this.m_tokenChar = this.m_token.charAt(0);
        } else {
            this.m_token = null;
            this.m_tokenChar = '\u0000';
        }
    }

    public long popDuration(Object key) {
        long millisecondsDuration = 0L;
        if (key != null) {
            Date date1 = (Date)this.m_durationsTable.get(key);
            Date date2 = new Date();
            millisecondsDuration = date2.getTime() - date1.getTime();
            this.m_durationsTable.remove(key);
        }
        return millisecondsDuration;
    }

    private final void prevToken() {
        if (this.m_queueMark > 0) {
            --this.m_queueMark;
            this.m_token = (String)this.m_xpath.m_tokenQueue[this.m_queueMark];
            this.m_tokenChar = this.m_token.charAt(0);
        } else {
            this.m_token = null;
            this.m_tokenChar = '\u0000';
        }
    }

    public void pushTime(Object key) {
        if (key != null) {
            this.m_durationsTable.put(key, new Date());
        }
    }

    private void recordTokenString(Vector targetStrings) {
        int tokPos = this.getTokenQueuePosFromMap(this.m_xpath.m_patternMapSize - 1);
        this.resetTokenMark(tokPos + 1);
        if (this.lookahead('(', 1)) {
            int tok = this.getKeywordToken(this.m_token);
            switch (tok) {
                case 1030: {
                    targetStrings.addElement(PSEUDONAME_COMMENT);
                    break;
                }
                case 1031: {
                    targetStrings.addElement(PSEUDONAME_TEXT);
                    break;
                }
                case 1033: {
                    targetStrings.addElement("*");
                    break;
                }
                case 35: {
                    targetStrings.addElement(PSEUDONAME_ROOT);
                    break;
                }
                case 36: {
                    targetStrings.addElement("*");
                    break;
                }
                case 1032: {
                    targetStrings.addElement("*");
                    break;
                }
                default: {
                    targetStrings.addElement("*");
                    break;
                }
            }
        } else {
            if (this.tokenIs('@')) {
                this.resetTokenMark(++tokPos + 1);
            }
            if (this.lookahead(':', 1)) {
                tokPos += 2;
            }
            targetStrings.addElement(this.m_xpath.m_tokenQueue[tokPos]);
        }
    }

    private final void resetTokenMark(int mark) {
        int qsz = this.m_xpath.m_tokenQueueSize;
        int n = mark > 0 ? (mark <= qsz ? mark - 1 : mark) : (this.m_queueMark = 0);
        if (this.m_queueMark < qsz) {
            this.m_token = (String)this.m_xpath.m_tokenQueue[this.m_queueMark++];
            this.m_tokenChar = this.m_token.charAt(0);
        } else {
            this.m_token = null;
            this.m_tokenChar = '\u0000';
        }
    }

    private final boolean tokenIs(char c) {
        return this.m_token != null ? this.m_tokenChar == c : false;
    }

    private final boolean tokenIs(String s) {
        return this.m_token != null ? this.m_token.equals(s) : s == null;
    }

    private void tokenize(String pat) throws SAXException {
        this.tokenize(pat, null);
    }

    private void tokenize(String pat, Vector targetStrings) throws SAXException {
        this.m_xpath.m_tokenQueueSize = 0;
        this.m_xpath.m_currentPattern = pat;
        this.m_xpath.m_patternMapSize = 0;
        int nChars = pat.length();
        int startSubstring = -1;
        int posOfNSSep = -1;
        boolean isStartOfPat = true;
        boolean isAttrName = false;
        boolean isNum = false;
        int nesting = 0;
        int i = 0;
        while (i < nChars) {
            char c = pat.charAt(i);
            switch (c) {
                case '\"': {
                    if (startSubstring != -1) {
                        isNum = false;
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                        isAttrName = false;
                        if (posOfNSSep != -1) {
                            posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, i);
                        } else {
                            this.addToTokenQueue(pat.substring(startSubstring, i));
                        }
                    }
                    startSubstring = i++;
                    while (i < nChars && (c = pat.charAt(i)) != '\"') {
                        ++i;
                    }
                    if (c == '\"') {
                        this.addToTokenQueue(pat.substring(startSubstring, i + 1));
                        startSubstring = -1;
                        break;
                    }
                    this.error(26);
                    break;
                }
                case '\'': {
                    if (startSubstring != -1) {
                        isNum = false;
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                        isAttrName = false;
                        if (posOfNSSep != -1) {
                            posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, i);
                        } else {
                            this.addToTokenQueue(pat.substring(startSubstring, i));
                        }
                    }
                    startSubstring = i++;
                    while (i < nChars && (c = pat.charAt(i)) != '\'') {
                        ++i;
                    }
                    if (c == '\'') {
                        this.addToTokenQueue(pat.substring(startSubstring, i + 1));
                        startSubstring = -1;
                        break;
                    }
                    this.error(27);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (startSubstring == -1) break;
                    isNum = false;
                    isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                    isAttrName = false;
                    if (posOfNSSep != -1) {
                        posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, i);
                    } else {
                        this.addToTokenQueue(pat.substring(startSubstring, i));
                    }
                    startSubstring = -1;
                    break;
                }
                case '@': {
                    isAttrName = true;
                }
                case '-': {
                    if (c == '-') {
                        if (!isNum && startSubstring != -1) break;
                        isNum = false;
                    }
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    if (startSubstring != -1) {
                        isNum = false;
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                        isAttrName = false;
                        if (posOfNSSep != -1) {
                            posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, i);
                        } else {
                            this.addToTokenQueue(pat.substring(startSubstring, i));
                        }
                        startSubstring = -1;
                    } else if (c == '/' && isStartOfPat) {
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                    } else if (c == '*') {
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                        isAttrName = false;
                    }
                    if (nesting == 0 && c == '|') {
                        if (targetStrings != null) {
                            this.recordTokenString(targetStrings);
                        }
                        isStartOfPat = true;
                    }
                    if (c == ')' || c == ']') {
                        --nesting;
                    } else if (c == '(' || c == '[') {
                        ++nesting;
                    }
                    this.addToTokenQueue(pat.substring(i, i + 1));
                    break;
                }
                case ':': {
                    if (posOfNSSep == i - 1) {
                        if (startSubstring != -1 && startSubstring < i - 1) {
                            this.addToTokenQueue(pat.substring(startSubstring, i - 1));
                        }
                        isNum = false;
                        isAttrName = false;
                        startSubstring = -1;
                        posOfNSSep = -1;
                        this.addToTokenQueue(pat.substring(i - 1, i + 1));
                        break;
                    }
                    posOfNSSep = i;
                }
                default: {
                    if (startSubstring == -1) {
                        startSubstring = i;
                        isNum = Character.isDigit(c);
                        break;
                    }
                    if (!isNum) break;
                    isNum = Character.isDigit(c);
                }
            }
            ++i;
        }
        if (startSubstring != -1) {
            isNum = false;
            isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
            if (posOfNSSep != -1) {
                posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, nChars);
            } else {
                this.addToTokenQueue(pat.substring(startSubstring, nChars));
            }
        }
        if (this.m_xpath.m_tokenQueueSize == 0) {
            this.error(28);
        } else if (targetStrings != null) {
            this.recordTokenString(targetStrings);
        }
        this.m_queueMark = 0;
    }

    private final void trace(String s) {
        System.out.println(s);
    }

    public void warn(int msg) throws XPathProcessorException {
        this.warn(null, msg, null);
    }

    public void warn(int msg, Object[] args) throws XPathProcessorException {
        this.warn(null, msg, args);
    }

    public void warn(Node sourceNode, int msg) throws XPathProcessorException {
        this.warn(sourceNode, msg, null);
    }

    public void warn(Node sourceNode, int msg, Object[] args) throws XPathProcessorException {
        String fmsg = XSLMessages.createXPATHWarning(msg, args);
        boolean shouldThrow = this.m_xpath.getProblemListener().problem((short)5, (short)1, this.m_namespaceContext, sourceNode, fmsg, null, 0, 0);
        if (shouldThrow) {
            throw new XPathProcessorException(fmsg);
        }
    }
}

