/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.text.NumberFormat;
import org.apache.xalan.xpath.XObject;
import org.xml.sax.SAXException;

public class XNumber
extends XObject {
    double m_val;

    public XNumber(double d) {
        this.m_val = d;
    }

    public boolean bool() {
        return !Double.isNaN(this.m_val) && this.m_val != 0.0;
    }

    public boolean equals(XObject obj2) throws SAXException {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        return this.m_val == obj2.num();
    }

    public int getType() {
        return 2;
    }

    private String getTypeString() {
        return "#NUMBER";
    }

    public double num() {
        return this.m_val;
    }

    public Object object() {
        return new Double(this.m_val);
    }

    public String str() {
        if (Double.isNaN(this.m_val)) {
            return "NaN";
        }
        if (Double.isInfinite(this.m_val)) {
            if (this.m_val > 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        NumberFormat formatter = NumberFormat.getNumberInstance();
        String s = formatter.format(this.m_val);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }
}

