/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.xml.IntStack;

public class UnionContext {
    static final int MAXPATHS = 32;
    IntStack[] m_stacks = new IntStack[32];
    IntStack[] m_posStacks = new IntStack[32];
    int m_stackCount;
    public static final int PSUEDO_POS_FOUNDNODE = -10000;
    public static final int PSUEDO_OP_FOUNDNODE = -10000;

    UnionContext(int[] opMap, int opPos) {
        int op = opMap[opPos];
        if (op == 20) {
            this.pushUnionPath(opMap, opPos);
        } else if (op == 28) {
            this.pushLocationPath(0, opMap, opPos);
        } else {
            System.out.println("Programmers Error! Op must be OP_UNION or OP_LOCATIONPATH");
        }
    }

    private final void addNewLocationPath(int which) {
        this.m_stacks[which] = new IntStack();
        this.m_posStacks[which] = new IntStack();
        this.setLocationPathCount(which + 1);
    }

    public boolean empty() {
        int n = this.m_stackCount;
        int i = 0;
        while (i < n) {
            if (!this.empty(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean empty(int which) {
        return this.m_stacks[which].empty();
    }

    public final int getLocationPathCount() {
        return this.m_stackCount;
    }

    int getNodePosition(int which) {
        return this.m_posStacks[which].peek();
    }

    void incrementNodePosition(int which) {
        this.m_posStacks[which].setTop(this.getNodePosition(which) + 1);
    }

    public int peek(int which) {
        return this.m_stacks[which].peek();
    }

    public void pop() {
        int n = this.m_stackCount;
        int i = 0;
        while (i < n) {
            this.pop(i);
            ++i;
        }
    }

    public int pop(int which) {
        this.m_posStacks[which].pop();
        return this.m_stacks[which].pop();
    }

    public int push(int which, int opCodePos, int nodePos) {
        this.m_posStacks[which].push(nodePos);
        return this.m_stacks[which].push(opCodePos);
    }

    void pushLocationPath(int which, int[] opMap, int opPos) {
        this.addNewLocationPath(which);
        opPos = XPath.getFirstChildPos(opPos);
        this.push(which, opPos, 1);
    }

    private void pushUnionPath(int[] opMap, int opPos) {
        opPos += 2;
        int i = 0;
        while (opMap[opPos] == 28) {
            int nextOpPos = XPath.getNextOpPos(opMap, opPos);
            this.pushLocationPath(i, opMap, opPos);
            opPos = nextOpPos;
            ++i;
        }
    }

    private final void setLocationPathCount(int i) {
        this.m_stackCount = i;
    }

    void setNodePosition(int which, int nodePos) {
        this.m_posStacks[which].setTop(nodePos);
    }
}

