/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.xpath.XNull;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathException;
import org.apache.xalan.xpath.XPathProcessorException;

public class ExtensionFunctionHandler {
    protected String namespaceUri;
    protected String scriptLang = "javaclass";
    protected String scriptSrc;
    protected String scriptSrcURL;
    protected Object javaObject = null;
    protected boolean hasCalledCTor = false;
    protected Class classObject = null;
    protected Hashtable functions = new Hashtable();
    protected BSFManager mgr = null;
    protected boolean componentStarted;
    protected static boolean bsfInitialized = false;
    static /* synthetic */ Class class$com$ibm$bsf$BSFManager;

    public ExtensionFunctionHandler(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public ExtensionFunctionHandler(String namespaceUri, String funcNames, String lang, String srcURL, String src) {
        this(namespaceUri);
        this.setFunctions(funcNames);
        this.setScript(lang, srcURL, src);
    }

    public Object callFunction(String funcName, Vector args) throws XPathException {
        if (!this.componentStarted) {
            this.startupComponent();
        }
        try {
            int argStart;
            Object[] argArray;
            BSFEngine e;
            if (this.mgr == null) {
                this.mgr = new BSFManager();
            }
            boolean isCTorCall = false;
            if (this.scriptLang.equals("javaclass")) {
                isCTorCall = funcName.equals("new");
                e = this.mgr.loadScriptingEngine("xslt-javaclass");
                if (isCTorCall) {
                    argArray = new Object[args.size()];
                    argStart = 0;
                    funcName = String.valueOf(this.classObject.getName()) + ".new";
                    this.javaObject = null;
                    this.hasCalledCTor = true;
                } else if (!this.hasCalledCTor) {
                    if (this.javaObject == null) {
                        this.javaObject = this.classObject.newInstance();
                    }
                    argArray = new Object[args.size() + 1];
                    argArray[0] = this.javaObject;
                    argStart = 1;
                } else {
                    argArray = new Object[args.size()];
                    argStart = 0;
                }
            } else {
                e = this.mgr.loadScriptingEngine(this.scriptLang);
                argArray = new Object[args.size()];
                argStart = 0;
            }
            int i = 0;
            while (i < args.size()) {
                Object o = args.elementAt(i);
                argArray[i + argStart] = o instanceof XObject ? ((XObject)o).object() : o;
                ++i;
            }
            return e.call(null, funcName, argArray);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null) {
                if (msg.startsWith("Stopping after fatal error:")) {
                    msg = msg.substring("Stopping after fatal error:".length());
                }
                System.out.println("Call to extension function failed: " + msg);
            }
            return new XNull();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public boolean isFunctionAvailable(String function) {
        return this.functions.get(function) != null;
    }

    public void setFunctions(String funcNames) {
        if (funcNames == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(funcNames, " \t\n\r", false);
        Object junk = new Object();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            this.functions.put(tok, junk);
        }
    }

    public void setScript(String lang, String srcURL, String scriptSrc) {
        this.scriptLang = lang;
        this.scriptSrcURL = srcURL;
        this.scriptSrc = scriptSrc;
    }

    protected void startupComponent() throws XPathProcessorException {
        if (!bsfInitialized) {
            Class clazz = class$com$ibm$bsf$BSFManager != null ? class$com$ibm$bsf$BSFManager : (class$com$ibm$bsf$BSFManager = ExtensionFunctionHandler.class$("com.ibm.bsf.BSFManager"));
            synchronized (clazz) {
                bsfInitialized = true;
                BSFManager.registerScriptingEngine((String)"xslt-javaclass", (String)"org.apache.xalan.xpath.XSLTJavaClassEngine", (String[])new String[0]);
            }
        }
        if (this.scriptLang.equals("javaclass") && this.scriptSrcURL != null) {
            try {
                String cname = this.scriptSrcURL;
                boolean isClass = false;
                if (this.scriptSrcURL.startsWith("class:")) {
                    cname = this.scriptSrcURL.substring(6);
                    isClass = true;
                }
                this.classObject = Class.forName(cname);
                if (isClass) {
                    this.javaObject = this.classObject;
                }
                this.componentStarted = true;
                return;
            }
            catch (Exception e) {
                throw new XPathProcessorException(e.getMessage(), e);
            }
        }
        if (this.scriptSrcURL != null) {
            throw new XPathProcessorException("src attr not supported (yet)");
        }
        if (this.scriptSrc == null) {
            return;
        }
        if (this.mgr == null) {
            this.mgr = new BSFManager();
        }
        try {
            this.mgr.exec(this.scriptLang, "LotusXSLScript", -1, -1, (Object)this.scriptSrc);
        }
        catch (BSFException bsfe) {
            throw new XPathProcessorException(bsfe.getMessage(), (Exception)((Object)bsfe));
        }
        this.componentStarted = true;
    }
}

